-- $Id: proc_formal3.vhdl 4327 2009-01-27 14:41:18Z potyra $ 

-- generating implicit formals for procedure parameters.

-- Copyright (C) 2008-2009 FAUmachine Team <info@faumachine.org>.
-- This program is free software. You can redistribute it and/or modify it
-- under the terms of the GNU General Public License, either version 2 of
-- the License, or (at your option) any later version. See COPYING.


package t is 
	type byte is array(integer range <>) of bit;
	procedure foo(constant a : in byte; variable b : out byte);
end package t;

package body t is
	procedure foo(constant a : in byte; variable b : out byte) is
	begin
		b := a;
	end;
end t;

entity test_bench is
end entity test_bench;

use t.all;
architecture test_bench_impl of test_bench is
begin
	p : process
		variable x : bit;
		variable b : byte(11 to 18);
	begin
		b := "00000000";
		foo("11111111", b);
		for i in b'range loop
			assert(b(i) = '1') 
			report "foo(a, b) should set b(i) to '1'."
			severity failure;
		end loop;
		assert false report "simulation finished" severity note;
		wait;
	end process;
end test_bench_impl;
