C Copyright 1981-2012 ECMWF.
C
C This software is licensed under the terms of the Apache Licence 
C Version 2.0 which can be obtained at http://www.apache.org/licenses/LICENSE-2.0.
C
C In applying this licence, ECMWF does not waive the privileges and immunities 
C granted to it by virtue of its status as an intergovernmental organisation 
C nor does it submit to any jurisdiction.
C

      INTEGER FUNCTION INTIN( HPARN, INTV, REALV, CHARV)
C  
C---->
C**** INTIN
C  
C     Purpose
C     -------
C
C     Change input field parameters in common block.
C  
C     Interface
C     ---------
C
C     Input
C     -----
C
C     HPARN - MARS parameter name.
C     INTV  - MARS parameter value(s) (Integer).
C     REALV - MARS parameter value(s) (Real).
C     CHARV - MARS parameter value(s) (Character).
C  
C  
C     Method
C     ------
C
C     Recognise MARS paramter and reset appropriate common
C     variable value(s).
C
C     Uses environment variable ISLSCP_OLD_LSM to locate old
C     land-sea mask GRIB product file. If the variable is not set,
C     uses /home/ma/emos/data/islscp_old_lsm.
C  
C
C     Externals
C     ---------
C
C     JDEBUG   - Check if debug switched on.
C     IBASINI  - Check basic initialisation of common blocks is done
C     CHEQUAL  - Compare two ASCII strings without regard to case.
C     INTLOG   - Log error message.
C     JMALLOC  - Dynamically allocate memory
C     JFREE    - Free dynamically allocated memory
C     GETENV   - Get value of an environment variable
C  
C  
C     Author
C     ------
C
C     J.D.Chambers       ECMWF        August 1994.
C  
C----<
C
      IMPLICIT NONE
C
C     Parameters
C
      INTEGER JPROUTINE
      PARAMETER (JPROUTINE = 28100)
C
C     Function arguments
C
      CHARACTER*(*) HPARN
      CHARACTER*(*) CHARV
      REAL REALV(*)
      INTEGER INTV(*)
C
#include "parim.h"
#include "nifld.common"
#include "nofld.common"
#include "grfixed.h"
#include "current.h"
#include "intf.h"
C
C     Local variables
C
      INTEGER ITEMP, I, IRET, ILOOP, ILAST, IGSIZE, IASIZE, IBLANK
      INTEGER NEWGRIB(1), OLDGRIB(1)
      POINTER( NIPNGRB, NEWGRIB )
      POINTER( NIPOGRB, OLDGRIB )
      LOGICAL LFOUND
      CHARACTER*256 OLDLSM, ISLDEFL
      CHARACTER*3 NUMBER
C
C     Externals
C
#ifdef POINTER_64
      INTEGER*8 JMALLOC
#else
      INTEGER JMALLOC
#endif
      LOGICAL CHEQUAL
      EXTERNAL CHEQUAL, JMALLOC
C
      DATA ISLDEFL/'/home/ma/emos/data/islscp_old_lsm'/
      SAVE ISLDEFL
C
C     -----------------------------------------------------------------|
C*    Section 1.   Initialise
C     -----------------------------------------------------------------|
C
  100 CONTINUE
C
      INTIN = 0
      LFOUND = .FALSE.
C
C     Check if debug turned on
      CALL JDEBUG()
C
C     Ensures basic initialisation of common blocks is done
      CALL IBASINI(0)
C
      CALL INTLOG(JP_DEBUG, 'INTIN: option = ' // HPARN ,JPQUIET)
C
C     -----------------------------------------------------------------|
C*    Section 2.   Decode request
C     -----------------------------------------------------------------|
C
  200 CONTINUE
C
C     Request ISLSCP processing
C
      IF( CHEQUAL( HPARN, 1, 6, 'islscp') ) THEN
        LFOUND = .TRUE.
        CALL INTLOG(JP_DEBUG, 'INTIN: islscp = ' // CHARV ,JPQUIET)
C
        IF( CHEQUAL( CHARV, 1, 3, 'off' ) ) THEN
          IF( LNIISCL ) THEN
            CALL JFREE(NIPOGRB)
            CALL JFREE(NIPNGRB) 
            NIPOGRS = 0
            NIPNGRS = 0
          ENDIF
          LNIISCL = .FALSE.
          GOTO 900
        ENDIF
C
        LNIISCL = .TRUE.
C
C       Pick up the old land-sea mask GRIB product
C
        CALL GETENV('ISLSCP_OLD_LSM',OLDLSM)
        IBLANK = INDEX(OLDLSM, ' ')
        IF( IBLANK.LT.2 ) THEN
          IBLANK = INDEX(ISLDEFL, ' ') - 1
          OLDLSM(1:IBLANK) = ISLDEFL(1:IBLANK)
          IF( INTV(1).GT.0 ) THEN
            OLDLSM(IBLANK+1:IBLANK+2) = '_n'
            WRITE(NUMBER,'(I3.3)') INTV(1)
            OLDLSM(IBLANK+3:IBLANK+5) = NUMBER(1:3)
            IBLANK = IBLANK + 5
          ENDIF
        ENDIF
        CALL INTLOG(JP_DEBUG,
     X    'INTIN: old land-sea mask file name:',JPQUIET)
        CALL INTLOG(JP_DEBUG,'INTIN: ' // OLDLSM(1:IBLANK),JPQUIET)
C
        CALL PBOPEN(NISLSCP,OLDLSM,'r',IRET)
        IF( IRET.NE.0 ) THEN
          CALL INTLOG(JP_ERROR,
     X      'INTIN: Problem processing islscp option',JPQUIET)
          CALL INTLOG(JP_ERROR,
     X      'INTIN: PBOPEN fail for old land-sea mask file',IRET)
          CALL INTLOG(JP_ERROR,'INTIN: ' // OLDLSM(1:IBLANK),JPQUIET)
          INTIN = IRET
          GOTO 900
        ENDIF
C
        CALL PBSIZE(NISLSCP,IGSIZE)
        IF( IGSIZE.LE.0 ) THEN
          CALL INTLOG(JP_ERROR,
     X      'INTIN: Problem processing islscp option',JPQUIET)
          CALL INTLOG(JP_ERROR,
     X      'INTIN: PBSIZE fail new land-sea mask GRIB product',IGSIZE)
          INTIN = IGSIZE
          GOTO 900
        ENDIF
C
        IF( NIPOGRS.LT.IGSIZE ) THEN
          IF( NIPOGRB.NE.0 ) CALL JFREE(NIPOGRB)
          NIPOGRS = IGSIZE 
          NIPOGRB = JMALLOC(NIPOGRS)
#ifdef hpR64
          NIPOGRB = NIPOGRB/(1024*1024*1024*4)
#endif
          IF( NIPOGRB.EQ.0 ) THEN
            CALL INTLOG(JP_ERROR,
     X        'INTIN: Problem processing islscp option',JPQUIET)
            CALL INTLOG(JP_ERROR,
     X        'INTIN: JMALLOC fail old land-sea mask GRIB',JPQUIET)
            INTIN = JPROUTINE + 3
            GOTO 900
          ENDIF
        ENDIF
C
        CALL PBGRIB(NISLSCP, OLDGRIB, IGSIZE, IASIZE, IRET)
        IF( (IRET.NE.0).OR.(IGSIZE.NE.IASIZE) ) THEN
          CALL INTLOG(JP_ERROR,
     X      'INTIN: Problem processing islscp option',JPQUIET)
          CALL INTLOG(JP_ERROR,
     X      'INTIN: PBREAD fail old land-sea mask GRIB',IRET)
          INTIN = IRET
          GOTO 900
        ENDIF
C
        CALL PBCLOSE(NISLSCP, IRET)
C
C       Pick up the new land-sea mask GRIB product
C
        IBLANK = INDEX(CHARV, ' ') - 1
        CALL INTLOG(JP_DEBUG,
     X    'INTIN: new land-sea mask file name:',JPQUIET)
        CALL INTLOG(JP_DEBUG,'INTIN: ' // CHARV,JPQUIET)
C
        CALL PBOPEN(NISLSCP,CHARV,'r',IRET)
        IF( IRET.NE.0 ) THEN
          CALL INTLOG(JP_ERROR,
     X      'INTIN: Problem processing islscp option',JPQUIET)
          CALL INTLOG(JP_ERROR,
     X      'INTIN: PBOPEN fail for new land-sea mask file',IRET)
          CALL INTLOG(JP_ERROR,'INTIN: ' // CHARV,JPQUIET)
          INTIN = IRET
          GOTO 900
        ENDIF
C
        CALL PBSIZE(NISLSCP,IGSIZE)
        IF( IGSIZE.LE.0 ) THEN
          CALL INTLOG(JP_ERROR,
     X      'INTIN: Problem processing islscp option',JPQUIET)
          CALL INTLOG(JP_ERROR,
     X      'INTIN: PBSIZE fail new land-sea mask GRIB product',IGSIZE)
          INTIN = IGSIZE
          GOTO 900
        ENDIF
C
        IF( NIPNGRS.LT.IGSIZE ) THEN
          IF( NIPNGRB.NE.0 ) CALL JFREE(NIPNGRB)
          NIPNGRS = IGSIZE
          NIPNGRB = JMALLOC(NIPNGRS)
#ifdef hpR64
          NIPNGRB = NIPNGRB/(1024*1024*1024*4)
#endif
          IF( NIPNGRB.EQ.0 ) THEN
            CALL INTLOG(JP_ERROR,
     X        'INTIN: Problem processing islscp option',JPQUIET)
            CALL INTLOG(JP_ERROR,
     X        'INTIN: JMALLOC fail new land-sea mask GRIB',JPQUIET)
            INTIN = JPROUTINE + 3
            GOTO 900
          ENDIF
        ENDIF
C
        CALL PBGRIB(NISLSCP, NEWGRIB, IGSIZE, IASIZE, IRET)
        IF( (IRET.NE.0).OR.(IGSIZE.NE.IASIZE) ) THEN
          CALL INTLOG(JP_ERROR,
     X      'INTIN: Problem processing islscp option',JPQUIET)
          CALL INTLOG(JP_ERROR,
     X      'INTIN: PBREAD fail new land-sea mask GRIB',IRET)
          INTIN = IRET
          GOTO 900
        ENDIF
C
        CALL PBCLOSE(NISLSCP, IRET)
        GOTO 900
C
      ENDIF
C
C     Input or reset value used for missing points in bitmapped field.
C
      IF( CHEQUAL( HPARN, 1, 12, 'missingvalue') ) THEN
        LFOUND = .TRUE.
        CALL INTLOG(JP_DEBUG,'INTIN: missingvalue = ' // CHARV ,JPQUIET)
        IF( CHEQUAL( CHARV, 1, 2, 'no') ) THEN
          IF( LIMISSV ) LCHANGE = .TRUE.
          LIMISSV = .FALSE.
          RMISSGV   = -55555.0
        ELSE
          IF( .NOT.LIMISSV ) LCHANGE = .TRUE.
          LIMISSV = .TRUE.
          RMISSGV = REALV(1)
        ENDIF
        CALL INTLOGR(JP_DEBUG,'INTIN: missingvalue = ',RMISSGV)
        GOTO 900
      ENDIF

C     missingval because can not be applied in Emos lib everywhere... 
C
      IF( CHEQUAL( HPARN, 1, 10, 'missingval') ) THEN
        LFOUND = .TRUE.
        LIMISSV = .FALSE.
        CALL INTLOG(JP_DEBUG,'INTIN: missingval = ' // CHARV ,JPQUIET)
        IF( CHEQUAL( CHARV, 1, 2, 'no') ) THEN
          IF( LIMISSV ) LCHANGE = .TRUE.
          RMISSGV   = -55555.0
          LIMISSA = .FALSE.
        ELSE
          IF( .NOT.LIMISSV ) LCHANGE = .TRUE.
          LIMISSA = .TRUE.
          RMISSGV = REALV(1)
        ENDIF
        CALL INTLOGR(JP_DEBUG,'INTIN: missingval = ',RMISSGV)
        ISEC1(5) = 192
        GOTO 900
      ENDIF
C
C     Input uselsm.
C
      IF ( CHEQUAL( HPARN, 1, 6, 'uselsm') ) THEN
        LFOUND = .TRUE.
        CALL INTLOG(JP_DEBUG,'INTIN: uselsm = ' // CHARV ,JPQUIET)
        IF ( CHEQUAL( CHARV, 1, 2, 'no') ) THEN
          IF ( LSM ) THEN
            LCHANGE = .TRUE.
            LSMCHNG = .TRUE.
          ENDIF
          LSM = .FALSE.
        ELSE
          IF ( .NOT. LSM ) THEN
            LCHANGE = .TRUE.
            LSMCHNG = .TRUE.
          ENDIF
          LSM = .TRUE.
        ENDIF
        LSMSET = .TRUE.
        GOTO 900
      ENDIF
C
C     Input useprecip.
C
      IF ( CHEQUAL( HPARN, 1, 9, 'useprecip') ) THEN
        LFOUND = .TRUE.
        CALL INTLOG(JP_DEBUG,'INTIN: useprecip = ' // CHARV ,JPQUIET)
        IF ( CHEQUAL( CHARV, 1, 3, 'yes') ) THEN
          IF ( .NOT. LPREC ) LCHANGE = .TRUE.
          LPREC = .TRUE.
        ELSE
          IF ( LPREC ) LCHANGE = .TRUE.
          LPREC = .FALSE.
        ENDIF
        LPRECSET = .TRUE.
        GOTO 900
      ENDIF
C
C     Input usewind.
C
      IF ( CHEQUAL( HPARN, 1, 7, 'usewind') ) THEN
        LFOUND = .TRUE.
        CALL INTLOG(JP_DEBUG,'INTIN: usewind = ' // CHARV ,JPQUIET)
        IF ( CHEQUAL( CHARV, 1, 3, 'yes') ) THEN
          IF ( .NOT. LWIND ) LCHANGE = .TRUE.
          LWIND = .TRUE.
        ELSE
          IF ( LWIND ) LCHANGE = .TRUE.
          LWIND = .FALSE.
        ENDIF
        LWINDSET = .TRUE.
        GOTO 900
      ENDIF
C
C     Input parameter.
C
      IF ( CHEQUAL( HPARN, 1, 9, 'parameter') ) THEN
        LFOUND = .TRUE.
        CALL INTLOG(JP_DEBUG, 'INTIN: parameter = ',INTV(1))
        IF ( NIPARAM .NE. INTV(1) ) LCHANGE = .TRUE.
        NIPARAM = INTV(1)
        GOTO 900
      ENDIF
C
C     Input truncation.
C
      IF ( CHEQUAL( HPARN, 1, 10, 'truncation') ) THEN
        LFOUND = .TRUE.
        CALL INTLOG(JP_DEBUG, 'INTIN: truncation = ',INTV(1))
        IF ( NIREPR .NE. JPSPHERE)  THEN
          LCHANGE = .TRUE.
          NIGAUSS = 0
          NIGRID(1) = 0
          NIGRID(2) = 0
          NIAREA(1) = 0
          NIAREA(2) = 0
          NIAREA(3) = 0
          NIAREA(4) = 0
        ENDIF
        NIREPR = JPSPHERE
        IF ( NIRESO .NE. INTV(1) ) LCHANGE = .TRUE.
        NIRESO = INTV(1)
        GOTO 900
      ENDIF
C
C     Input reduced.
C
      IF ( CHEQUAL( HPARN, 1, 7, 'reduced') ) THEN
        LFOUND = .TRUE.
        CALL INTLOG(JP_DEBUG, 'INTIN: reduced = ',INTV(1))
        IF ( NIGAUSS .NE. INTV(1) ) LCHANGE = .TRUE.
        NIGAUSS = INTV(1)
        LNIGAUS = .TRUE.
        IF ( NIREPR .NE. JPQUASI ) THEN
          LCHANGE = .TRUE.
          NIRESO = 0
          NIGRID(1) = 0
          NIGRID(2) = 0
        ENDIF
        NIREPR = JPQUASI
        IF( (NIGAUSO.NE.NIGAUSS).OR.(HIGAUST.NE.'R') ) THEN
          CALL JGETGG( NIGAUSS, 'R', RIGAUSS, MILLEN, IRET)
          IF ( IRET .NE. 0 ) THEN
            CALL INTLOG(JP_ERROR,'INTIN: JGETGG fail - NIGAUSS',JPQUIET)
            INTIN = IRET
            GOTO 900
          ENDIF
          NIGAUSO = NIGAUSS
          HIGAUST = 'R'
        ENDIF
C
        NIAREA(1) = INT( RIGAUSS(1) * PPMULT )
        NIAREA(2) = 0
        NIAREA(3) = INT( RIGAUSS(NIGAUSS*2) * PPMULT )
c this gives differnt result from one in the grib header
        NIAREA(4) = JP360 - JP360/MILLEN(NIGAUSS)
C
        NIPCNT = 0
        Nins = NIGAUSS*2 ! Added by D. Jokic Mar-2005;
        DO 230 ILOOP = 1, NIGAUSS*2
          NIPCNT = NIPCNT + MILLEN(ILOOP)
 230    CONTINUE
        GOTO 900
      ENDIF
C
C     Input grid.
C
      IF ( CHEQUAL( HPARN, 1, 4, 'grid') ) THEN
        LFOUND = .TRUE.
        CALL INTLOGR(JP_DEBUG, 'INTIN: grid e-w = ',REALV(1))
        CALL INTLOGR(JP_DEBUG, 'INTIN: grid n-s = ',REALV(2))
        IF ( NIREPR .NE. JPREGULAR) THEN
          LCHANGE = .TRUE.
          NIGAUSS = 0
          NIRESO = 0
        ENDIF
        NIREPR = JPREGULAR
        DO 210 I = 1, 2
          ITEMP = INT( REALV(I)*PPMULT)
          IF ( NIGRID(I) .NE. ITEMP ) LCHANGE = .TRUE.
          NIGRID(I) = ITEMP
 210    CONTINUE
        GOTO 900
      ENDIF
C
C     Reduced lat-lon Input grid.
C
      IF ( CHEQUAL( HPARN, 1, 7, 'redu_ll') ) THEN
        LFOUND = .TRUE.
cs        CALL INTLOGR(JP_DEBUG, 'INTIN: reduced_ll e-w = ',REALV(1))
        CALL INTLOGR(JP_DEBUG, 'INTIN: reduced_ll n-s = ',REALV(2))
        IF ( NIREPR .NE. JPREGULAR) THEN
          LCHANGE = .TRUE.
          NIGAUSS = 0
          NIRESO = 0
        ENDIF
        NIREPR = JPREDLL
        NINS = INTV(1)
        DO 217 I = 1, 2
          ITEMP = INT( REALV(I)*PPMULT)
          IF ( NIGRID(I) .NE. ITEMP ) LCHANGE = .TRUE.
          NIGRID(I) = ITEMP
 217    CONTINUE
        GOTO 900
      ENDIF
C
      IF ( CHEQUAL( HPARN, 1, 5, 'ocean') ) THEN
        LFOUND = .TRUE.
        LOCEAN = .TRUE.
        CALL INTLOGR(JP_DEBUG, 'INTIN: Ocean field',JPQUIET)
        NIOCO3  = INTV(1)
        NIOCO4  = INTV(2)
        NIOCO4F = INTV(3)
        NIOCO3F = INTV(4)
        NIOCO4L = INTV(5)
        NIOCO3L = INTV(6)
        NIOIINC = INTV(7)
        NIOJINC = INTV(8)
        NIOIRGR = INTV(9)
        NIONOST = INTV(10)
        NICOORN = INTV(11)
        NIVCDEF = INTV(12)
        NILOCAL = 4
        GOTO 900
      ENDIF

      IF ( CHEQUAL( HPARN, 1, 5, 'local') ) THEN
        LFOUND = .TRUE.
        NILOCAL = INTV(1)
        CALL INTLOGR(JP_DEBUG, 'INTIN: Local settings',NILOCAL)
        GOTO 900
      ENDIF
c	  
      IF ( CHEQUAL( HPARN, 1, 6, 'matrix') ) THEN
        LFOUND = .TRUE.
        NIMATR = INTV(1)
        CALL INTLOGR(JP_DEBUG, 'INTIN: Matrix values',NIMATR)
        GOTO 900
      ENDIF
C
      IF ( CHEQUAL( HPARN, 1, 11, 'coord_ocean') ) THEN
        LFOUND = .TRUE.
        CALL INTLOGR(JP_DEBUG, 'INTIN: Ocean field grid Coordinate'
     X     ,JPQUIET)
        DO 249 ILOOP = 1, NICOORN
          OCCOOR(ILOOP) = INTV(ILOOP)
 249    CONTINUE
        GOTO 900
      ENDIF
C
      IF ( CHEQUAL( HPARN, 1, 6, 'l_npts') ) THEN
        LFOUND = .TRUE.
C
        DO 247 ILOOP = 1, NINS
          MILLEN(ILOOP) = INTV(ILOOP)
 247    CONTINUE
        GOTO 900
      ENDIF
C
C     Input data format.
C
      IF ( CHEQUAL( HPARN, 1, 4, 'form') ) THEN
        LFOUND = .TRUE.
        CALL INTLOG(JP_DEBUG, 'INTIN: form = ' // CHARV ,JPQUIET)
        IF ( CHEQUAL( CHARV, 1, 4, 'grib') ) THEN
          IF ( NIFORM .EQ. 0 ) LCHANGE = .TRUE.
          NIFORM = 1
        ELSE
          IF ( NIFORM .EQ. 1 ) LCHANGE = .TRUE.
          NIFORM = 0
        ENDIF
        GOTO 900
      ENDIF
C
C     Number of points along latitude and longitude
C
      IF ( CHEQUAL( HPARN, 1, 4, 'npts') ) THEN
        LFOUND = .TRUE.
        CALL INTLOG(JP_DEBUG, 'INTIN: pts along latitude = ',INTV(1))
        CALL INTLOG(JP_DEBUG, 'INTIN: pts along longitude = ',INTV(2))
        NIWE = INTV(1)
        NINS = INTV(2)
        GOTO 900
      ENDIF

      IF( CHEQUAL( HPARN, 1, 8, 'accuracy') ) THEN
        LFOUND = .TRUE.
        CALL INTLOG(JP_DEBUG, 'INTIN: Inpu accuracy = ',INTV(1))
        NIACC = INTV(1)
        GOTO 900
      ENDIF
C
C     Input level.
C
      IF ( CHEQUAL( HPARN, 1, 5, 'level') ) THEN
        LFOUND = .TRUE.
        CALL INTLOG(JP_DEBUG, 'INTIN: level = ',INTV(1))
        IF ( NILEVEL .NE. INTV(1) ) LCHANGE = .TRUE.
        NILEVEL = INTV(1)
        GOTO 900
      ENDIF
C
C     Input Date.
C
      IF ( CHEQUAL( HPARN, 1, 4, 'date') ) THEN
        LFOUND = .TRUE.
        CALL INTLOG(JP_DEBUG, 'INTIN: Date = ',INTV(1))
        IF ( NIDATE .NE. INTV(1) ) LCHANGE = .TRUE.
        NIDATE = INTV(1)
        GOTO 900
      ENDIF
C
C     Input level type.
C
      IF ( CHEQUAL( HPARN, 1, 7, 'levtype') ) THEN
        LFOUND = .TRUE.
        CALL INTLOG(JP_DEBUG, 'INTIN: levtype = ',INTV(1))
        IF ( NILEVT .NE. INTV(1) ) LCHANGE = .TRUE.
        NILEVT  = INTV(1)
        GOTO 900
      ENDIF
C
C     Input table.
C
      IF ( CHEQUAL( HPARN, 1, 5, 'table') ) THEN
        LFOUND = .TRUE.
        CALL INTLOG(JP_DEBUG, 'INTIN: table = ',INTV(1))
        IF ( NITABLE .NE. INTV(1) ) LCHANGE = .TRUE.
        NITABLE = INTV(1)
        GOTO 900
      ENDIF
C
C     Input regular (gaussian).
C
      IF ( CHEQUAL( HPARN, 1, 7, 'regular') ) THEN
        LFOUND = .TRUE.
        CALL INTLOG(JP_DEBUG, 'INTIN: regular = ',INTV(1))
        NIREPR = JPGAUSSIAN
        IF ( NIGAUSS .NE. INTV(1) ) LCHANGE = .TRUE.
        NIGAUSS = INTV(1)
        LNIGAUS = .TRUE.
        IF ( NIREPR .NE. JPGAUSSIAN) THEN
          LCHANGE = .TRUE.
          NIRESO = 0
          NIGRID(1) = 0
          NIGRID(2) = 0
        ENDIF
        NIREPR = JPGAUSSIAN
        IF( (NIGAUSO.NE.NIGAUSS).OR.(HIGAUST.NE.'F') ) THEN
          CALL JGETGG( NIGAUSS, 'F', RIGAUSS, MILLEN, IRET)
          IF ( IRET .NE. 0 ) THEN
            CALL INTLOG(JP_ERROR,'INTIN: JGETGG fail - NIGAUSS',JPQUIET)
            INTIN = IRET
            GOTO 900
          ENDIF
          NIGAUSO = NIGAUSS
          HIGAUST = 'F'
        ENDIF
C
        NIAREA(1) = INT( RIGAUSS(1) * PPMULT )
        NIAREA(2) = 0
        NIAREA(3) = INT( RIGAUSS(NIGAUSS*2) * PPMULT )
        NIAREA(4) = JP360 - JP360/MILLEN(NIGAUSS)
C
        NIPCNT = 0
        DO ILOOP = 1, NIGAUSS*2
          NIPCNT = NIPCNT + MILLEN(ILOOP)
        ENDDO
        GOTO 900
      ENDIF
C
C     Input area.
C
      IF ( CHEQUAL( HPARN, 1, 4, 'area') ) THEN
        LFOUND = .TRUE.
        CALL INTLOGR(JP_DEBUG, 'INTIN: north = ',REALV(1))
        CALL INTLOGR(JP_DEBUG, 'INTIN: west  = ',REALV(2))
        CALL INTLOGR(JP_DEBUG, 'INTIN: south = ',REALV(3))
        CALL INTLOGR(JP_DEBUG, 'INTIN: east  = ',REALV(4))
        DO 220 I = 1, 4
          ITEMP = INT( REALV(I)*PPMULT)
          IF ( NIAREA(I) .NE. ITEMP ) LCHANGE = .TRUE.
          NIAREA(I) = ITEMP
 220    CONTINUE
        GOTO 900
      ENDIF
C
C     Input scan.
C
      IF ( CHEQUAL( HPARN, 1, 4, 'scan') ) THEN
        LFOUND = .TRUE.
        CALL INTLOG(JP_DEBUG, 'INTIN: scan = ',INTV(1))
        IF ( NISCNM .NE. INTV(1) ) LCHANGE = .TRUE.
        NISCNM = INTV(1)
        GOTO 900
      ENDIF
C
C     Input lsm_param.
C
      IF ( CHEQUAL( HPARN, 1, 9, 'lsm_param') ) THEN
        LFOUND = .TRUE.
        CALL INTLOG(JP_DEBUG,'INTIN: lsm_param = ' // CHARV ,JPQUIET)
        IF ( CHEQUAL( CHARV, 1, 3, 'yes') ) THEN
          IF ( .NOT. LSMPAR ) LCHANGE = .TRUE.
          LSMPAR = .TRUE.
        ELSE
          IF ( LSMPAR ) LCHANGE = .TRUE.
          LSMPAR = .FALSE.
        ENDIF
        LSMPARSET = .TRUE.
        GOTO 900
      ENDIF
C
C     Set of LSM - merging with grib_api
      IF ( CHEQUAL( HPARN, 1, 6, 'lsmset') ) THEN
        LFOUND = .TRUE.
        CALL INTLOG(JP_DEBUG,'INTIN: lsmset = ' // CHARV ,JPQUIET)
        IF ( CHEQUAL( CHARV, 1, 2, 'no') ) THEN
          IF ( LSM ) THEN
            LCHANGE = .TRUE.
            LSMCHNG = .TRUE.
          ENDIF
          LSM = .FALSE.
          LSMSET = .TRUE.
        ELSE
          IF ( .NOT. LSM ) THEN
            LCHANGE = .TRUE.
            LSMCHNG = .TRUE.
          ENDIF
          LSM = .TRUE.
          LSMSET = .FALSE.
        ENDIF
        GOTO 900
      ENDIF
C
C
C     Input user_regular_gaussian
C
C     (Ignore the call if the user_regular_gaussian value = 0.)
      IF ( CHEQUAL( HPARN, 1, 21, 'user_regular_gaussian') ) THEN
        LFOUND = .TRUE.
        IF ( NIREPR .NE. JPGAUSSIAN) THEN
          LCHANGE = .TRUE.
          NIRESO = 0
          NIGRID(1) = 0
          NIGRID(2) = 0
        ENDIF
        CALL INTLOG(JP_DEBUG,'INTIN: user_regular_gaussian = ',INTV(1))
        IF ( NIGAUSS .NE. INTV(1) ) LCHANGE = .TRUE.
        NIGAUSS = INTV(1)
        NIREPR  = JPGAUSSIAN
C
        ILAST = NIGAUSS*2
        DO 235 ILOOP = 1, ILAST
          MILLEN(ILOOP) = NOGAUSS*4
 235    CONTINUE
        NIGAUSO = NIGAUSS
        HIGAUST = 'U'
        LIGIVEP   = .TRUE.
C
        GOTO 900
      ENDIF
C
C     Input user_reduced_gaussian
C     (Ignore the call if the user_reduced_gaussian value = 0.)
C
      IF ( CHEQUAL( HPARN, 1, 21, 'user_reduced_gaussian') ) THEN
        LFOUND = .TRUE.
        IF ( NIREPR .NE. JPQUASI ) THEN
          LCHANGE = .TRUE.
          NIRESO = 0
          NIGRID(1) = 0
          NIGRID(2) = 0
        ENDIF
        IF ( INTV(1) .EQ. 0 ) GOTO 900
        CALL INTLOG(JP_DEBUG,'INTIN: user_reduced_gaussian = ',INTV(1))
        IF ( NIGAUSS .NE. INTV(1) ) LCHANGE = .TRUE.
        NIGAUSS = INTV(1)
        NIREPR  = JPQUASI
        NIGAUSO = NIGAUSS
        HIGAUST = 'U'
        GOTO 900
      ENDIF
C
C     Input g_pnts loading from grib_api.
C
      IF ( CHEQUAL( HPARN, 1, 7, 'ga_pnts') ) THEN
        LFOUND = .TRUE.
        IF ( NIGAUSS .LE. 0 ) THEN
          IRET = JPROUTINE + 1
          CALL INTLOG(JP_ERROR,
     X      'INTIN: Impossible number of gaussian latitudes.',NIGAUSS)
          INTIN = IRET
          GOTO 900
        ENDIF
          CALL INTLOG(JP_DEBUG,
     X      'INTIN: Reduced Gaussian - grib_api ',NIGAUSS)
C
cs        ILAST = NIGAUSS*2 + 1
        ILAST = NIGAUSS*2
        DO 241 ILOOP = 1, ILAST
          MILLEN(ILOOP) = INTV(ILOOP)
 241    CONTINUE
C
        NIAREA(4) = JP360 - INT( JP360/MILLEN(NIGAUSS) )
C
        NIPCNT = 0
        DO 251 ILOOP = 1, ILAST
          NIPCNT = NIPCNT + MILLEN(ILOOP)
 251    CONTINUE
        NIGAUSO = NIGAUSS
        HIGAUST = 'U'
        LIGIVEP = .TRUE.
        GOTO 900
      ENDIF
cs end ga

      IF ( CHEQUAL( HPARN, 1, 6, 'g_pnts') ) THEN
        LFOUND = .TRUE.
        IF ( NIGAUSS .LE. 0 ) THEN
          IRET = JPROUTINE + 1
          CALL INTLOG(JP_ERROR,
     X      'INTIN: Impossible number of gaussian latitudes.',NIGAUSS)
          INTIN = IRET
          GOTO 900
        ENDIF
C
        ILAST = NIGAUSS*2 + 1
        DO 240 ILOOP = 1, NIGAUSS
          MILLEN(ILOOP) = INTV(ILOOP)
          ILAST = ILAST - 1
          MILLEN(ILAST) = INTV(ILOOP)
 240    CONTINUE
C
        NIAREA(4) = JP360 - INT( JP360/MILLEN(NIGAUSS) )
C
        NIPCNT = 0
        DO 250 ILOOP = 1, NIGAUSS*2
          NIPCNT = NIPCNT + MILLEN(ILOOP)
 250    CONTINUE
        NIGAUSO = NIGAUSS
        HIGAUST = 'U'
        LIGIVEP = .TRUE.
        GOTO 900
      ENDIF
C
C     Input g_lats.
C
      IF ( CHEQUAL( HPARN, 1, 6, 'g_lats') ) THEN
        LFOUND = .TRUE.
        IF ( NIGAUSS .LE. 0 ) THEN
          IRET  = JPROUTINE + 1
          CALL INTLOG(JP_ERROR,
     X      'INTIN: Impossible number of gaussian latitudes.',NIGAUSS)
          INTIN = IRET
          GOTO 900
        ENDIF
C
        ILAST = NIGAUSS*2 + 1
        DO 260 ILOOP = 1, NIGAUSS
          RIGAUSS(ILOOP) = REALV(ILOOP)
          ILAST = ILAST - 1
          RIGAUSS(ILAST) = -REALV(ILOOP)
 260    CONTINUE
C
        NIAREA(1) = INT( RIGAUSS(1) * PPMULT )
        NIAREA(2) = 0
        NIAREA(3) = INT( RIGAUSS(NIGAUSS*2) * PPMULT )
        NIAREA(4) = JP360 - JP360/MILLEN(NIGAUSS)
        NIGAUSO = NIGAUSS
        HIGAUST = 'U'
        LIGIVEL   = .TRUE.
        GOTO 900
      ENDIF
C
C     ------------------------------------------------------------------
C*     Section 9.   Closedown.
C     ------------------------------------------------------------------
C
  900 CONTINUE
      IF( .NOT. LFOUND ) THEN
        CALL INTLOG(JP_ERROR, 'INTIN: Unknown keyword used:', JPQUIET)
        CALL INTLOG(JP_ERROR, HPARN, JPQUIET)
        INTIN = JPROUTINE + 2
      ENDIF
      RETURN
      END
