/*
 * Decompiled with CFR 0.152.
 */
package jalview.io;

import jalview.datamodel.SequenceI;
import jalview.io.FileParse;
import jalview.io.MSFfile;
import jalview.util.Format;
import java.io.IOException;

public class PileUpfile
extends MSFfile {
    public PileUpfile() {
    }

    public PileUpfile(String inFile, String type) throws IOException {
        super(inFile, type);
    }

    public PileUpfile(FileParse source) throws IOException {
        super(source);
    }

    public String print() {
        return this.print(this.getSeqsAsArray());
    }

    public String print(SequenceI[] s) {
        int i;
        StringBuffer out = new StringBuffer("PileUp\n\n");
        int max = 0;
        int maxid = 0;
        int bigChecksum = 0;
        int[] checksums = new int[s.length];
        for (i = 0; i < s.length; ++i) {
            checksums[i] = this.checkSum(s[i].getSequenceAsString());
            bigChecksum += checksums[i];
        }
        out.append("   MSF: " + s[0].getSequence().length + "   Type: P    Check:  " + bigChecksum % 10000 + "   ..\n\n\n");
        for (i = 0; i < s.length && s[i] != null; ++i) {
            String seq = s[i].getSequenceAsString();
            out.append(" Name: " + this.printId(s[i]) + " oo  Len:  " + seq.length() + "  Check:  " + checksums[i] + "  Weight:  1.00\n");
            if (seq.length() > max) {
                max = seq.length();
            }
            if (s[i].getName().length() <= maxid) continue;
            maxid = s[i].getName().length();
        }
        if (maxid < 10) {
            maxid = 10;
        }
        ++maxid;
        out.append("\n\n//\n\n");
        int len = 50;
        int nochunks = max / len + 1;
        if (max % len == 0) {
            --nochunks;
        }
        for (i = 0; i < nochunks; ++i) {
            for (int j = 0; j < s.length && s[j] != null; ++j) {
                String name = this.printId(s[j]);
                out.append(new Format("%-" + maxid + "s").form(name + " "));
                for (int k = 0; k < 5; ++k) {
                    int start = i * 50 + k * 10;
                    int end = start + 10;
                    if (end < s[j].getSequence().length && start < s[j].getSequence().length) {
                        out.append(s[j].getSequence(start, end));
                        if (k < 4) {
                            out.append(" ");
                            continue;
                        }
                        out.append("\n");
                        continue;
                    }
                    if (start < s[j].getSequence().length) {
                        out.append(s[j].getSequenceAsString().substring(start));
                        out.append("\n");
                        continue;
                    }
                    if (k != 0) continue;
                    out.append("\n");
                }
            }
            out.append("\n");
        }
        return out.toString();
    }
}

