/*
 * Decompiled with CFR 0.152.
 */
package jalview.util;

import java.util.Vector;

public class ShiftList {
    public Vector shifts = new Vector();

    public void addShift(int pos, int shift) {
        int sidx;
        int[] rshift = null;
        for (sidx = 0; sidx < this.shifts.size() && (rshift = (int[])this.shifts.elementAt(sidx))[0] < pos; ++sidx) {
        }
        if (sidx == this.shifts.size()) {
            this.shifts.insertElementAt(new int[]{pos, shift}, sidx);
        } else {
            rshift[1] = rshift[1] + shift;
        }
    }

    public int shift(int pos) {
        int[] rshift;
        if (this.shifts.size() == 0) {
            return pos;
        }
        int shifted = pos;
        int sidx = 0;
        while (sidx < this.shifts.size() && (rshift = (int[])this.shifts.elementAt(sidx++))[0] <= pos) {
            shifted += rshift[1];
        }
        return shifted;
    }

    public void clear() {
        this.shifts.removeAllElements();
    }

    public ShiftList getInverse() {
        ShiftList inverse = new ShiftList();
        if (this.shifts != null) {
            int j = this.shifts.size();
            for (int i = 0; i < j; ++i) {
                int[] sh = (int[])this.shifts.elementAt(i);
                if (sh == null) continue;
                inverse.shifts.addElement(new int[]{sh[0], -sh[1]});
            }
        }
        return inverse;
    }

    public static ShiftList parseMap(int[] gapMap) {
        ShiftList shiftList = null;
        if (gapMap != null && gapMap.length > 0) {
            shiftList = new ShiftList();
            int p = 0;
            for (int i = 0; i < gapMap.length; ++i) {
                if (p != gapMap[i]) {
                    shiftList.addShift(p, gapMap[i] - p);
                    p = gapMap[i];
                }
                ++p;
            }
        }
        return shiftList;
    }
}

