/*******************************************************************************
** 
** Filename:  ServletProxy.java
**
** File Description: This class encapsulates communication between the API 
**                   Adapter applet and the LMS CMI Servlet
**    
** Author: ADL Technical Team
**
** Contract Number:
** Company Name: CTC
**
** Module/Package Name: org.adl.lms.client
** Module/Package Description: Client side Sample RTE classes
**
** Design Issues:
**
** Implementation Issues:
** Known Problems:
** Side Effects:
**
** References: ADL SCORM
**
/*******************************************************************************
**
** Concurrent Technologies Corporation (CTC) grants you ("Licensee") a non-
** exclusive, royalty free, license to use, modify and redistribute this
** software in source and binary code form, provided that i) this copyright
** notice and license appear on all copies of the software; and ii) Licensee
** does not utilize the software in a manner which is disparaging to CTC.
**
** This software is provided "AS IS," without a warranty of any kind.  ALL
** EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND WARRANTIES, INCLUDING ANY
** IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NON-
** INFRINGEMENT, ARE HEREBY EXCLUDED.  CTC AND ITS LICENSORS SHALL NOT BE LIABLE
** FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
** DISTRIBUTING THE SOFTWARE OR ITS DERIVATIVES.  IN NO EVENT WILL CTC  OR ITS
** LICENSORS BE LIABLE FOR ANY LOST REVENUE, PROFIT OR DATA, OR FOR DIRECT,
** INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR PUNITIVE DAMAGES, HOWEVER
** CAUSED AND REGARDLESS OF THE THEORY OF LIABILITY, ARISING OUT OF THE USE OF
** OR INABILITY TO USE SOFTWARE, EVEN IF CTC  HAS BEEN ADVISED OF THE
** POSSIBILITY OF SUCH DAMAGES.
**
*******************************************************************************/

package org.adl.samplerte.client;

import java.net.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import org.adl.datamodels.*;
import org.adl.datamodels.cmi.*;
import org.adl.util.debug.DebugIndicator;
import org.adl.samplerte.client.*;

public class ServletProxy
{
   private static boolean _Debug = DebugIndicator.ON;

   private URL servletURL;
   private String sessionid;
  

   /****************************************************************************
   **
   ** Method:  ServletProxy(URL url)
   ** Input:   URL url  - the url of the LMS CMI Servlet
   ** Output:  none
   **
   ** Description:
   ** Constructor
   **
   ****************************************************************************/
   public ServletProxy(  URL url, String sessionid ) 
   {
      this.servletURL = url;
      this.sessionid = sessionid;
   }

   /****************************************************************************
   **
   ** Method:  GetSCOData()
   ** Input:   none
   ** Output:  SCOData - an SCODataManager object containing all of the CMI data
   **                    elements relevant for the current user (student) and
   **                    current SCO.
   **
   ** Description:
   ** Reads from the LMS Server via the LMSCMI Servlet, the SCODataManager
   ** object containing all of the CMI datamodel elements relevant for the
   ** current user (student) and current SCO.
   **
   ****************************************************************************/
   //public SCODataManager GetSCOData()
   public String GetSCOData()
   
   {
      if(_Debug)
      {
         System.out.println( "In ServletProxy::GetSCOData()" );
      }

      try
      {
          //MICHELE adds function
         String servletCommand = "cmigetcat";

         Serializable[] data = {servletCommand};

         if(_Debug)
         {
            System.out.println("Before postObjects()");
            System.out.println("In ServletProxy::PutSCOData() PASSING sessionid"+sessionid);
         }

         //ObjectInputStream in =
         String result=ServletWriter.postObjects(this.servletURL, data, sessionid );

         System.out.println("Within Servlet Proxy - result is (this was cmigetcat)" + result );
         
         
         if(_Debug)
         {
            System.out.println( "Back In ServletProxy::GetSCOData()" );
            System.out.println( "Attempting to read servlet response now..." );
         }
         // Read the SCODataManager off of the Object Input Stream
         //SCODataManager scoData = (SCODataManager) result.readObject();
        

         if(_Debug)
         {
            System.out.println( "Read servlet response successfully." );
            System.out.println( "Closing input stream" );
         }

         //next 2 lines added for experiments by michele
         //SCODataManager empty = new SCODataManager();
         
         return result;
         //return scoData;
      }
      catch(Exception e)
      {
         if(_Debug)
         {
            System.out.println(
                    "Exception caught In ServletProxy::GetSCODataData()" );
            System.out.println( e.getMessage() );
         }

         e.printStackTrace();
         //SCODataManager empty = new SCODataManager();
         return "";
      }
   }

   /****************************************************************************
   **
   ** Method:  PutSCOData( SCODataManager scoData)
   ** Input:   SCODataManager scoData
   ** Output:  String "OK" if successful
   **                              "FAILED" if failed
   **
   ** Description:
   ** Writes to the LMS Server via the LMSCMI Servlet, the SCODataManager
   ** object containing all of the CMI datamodel elements relevant for SCO to 
   ** LMS communication.
   ****************************************************************************/
   public String PutSCOData( SCODataManager scoData )
   {
      try
      {
         if(_Debug)
         {
            System.out.println("In ServletProxy::PutSCOData()");
         }

          //MICHELE adds function
         String servletCommand = "cmiputcat";

         if (APIAdapterApplet.arewefinishing==true) {
             System.out.println("**********************************");
             System.out.println("***LMSFinish                   ***");
             System.out.println("**********************************");
             servletCommand = "cmiputcatONFINISH";
         }
         
         Serializable[] data = {servletCommand, scoData};

         System.out.println("In ServletProxy::PutSCOData() PASSING sessionid"+sessionid);
                  
         String result = ServletWriter.postObjects(this.servletURL,data,sessionid);
         
         //ObjectInputStream in =
         //ServletWriter.postObjects(this.servletURL, data, sessionid );

         //String result = (String)in.readObject();  //doesn't return anything.
         //in.close();
         
         System.out.println("Within Servlet Proxy - result is (this was cmigetput)" + result );
         
         //here we should check result to mean we submitted data ok
         
         if (!result.startsWith("ERROR")) {
             result="OK";
         }
         return result;
      }
      catch(Exception e)
      {
         if(_Debug)
         {
            System.out.println(
                              "Exception caught In ServletProxy::PutSCOData()" );
            System.out.println( e.getMessage() );
         }

         e.printStackTrace();
         return "FAILED";
      }
   }

   
   public String KeepAlive()
      {
      try {
         if(_Debug) {  System.out.println("In ServletProxy::KeepAlive()");}

         String servletCommand = "keepalive";
         Serializable[] data = {servletCommand};
         String result = ServletWriter.postObjects(this.servletURL,data,sessionid);
         System.out.println("Within Servlet Proxy - (this was keepalive)" + result );
         
         if (!result.startsWith("ERROR")) { result="OK"; }
         return result;
      }
      catch(Exception e)
      {
         if(_Debug) { System.out.println("Exception caught In ServletProxy::KeepAlive()" );
            System.out.println( e.getMessage() );
         }
         e.printStackTrace();
         return "FAILED";
      }
   }
}
