/*
**  Copyright (c) 2004, 2006 Sendmail, Inc. and its suppliers.
**    All rights reserved.
*/

#ifndef lint
static char util_c_id[] = "@(#)$Id: util.c,v 1.16 2006/06/01 17:55:48 msk Exp $";
#endif /* !lint */

/* system includes */
#include <sys/types.h>
#include <string.h>
#include <assert.h>
#include <ctype.h>

/* libsm includes */
#include <sm/gen.h>

/* libdk includes */
#include <dk.h>

#ifndef FALSE
# define FALSE 0
#endif /* ! FALSE */
#ifndef TRUE
# define TRUE 1
#endif /* ! TRUE */

/*
**  DK_STERILIZE -- sterilize a variable that's used as part of a path
**
**  Parameters:
**  	str -- string to sterilize
**
**  Return value:
**  	str if the string was OK, otherwise a pointer to a location in
**  	the string after which data is safe, or NULL if no such point
**  	could be determined.
*/

char *
dk_sterilize(char *str)
{
	char *p;
	char *ret;

	assert(str != NULL);

	ret = str;

	p = strrchr(str, '/');
	if (p != NULL)
		ret = p + 1;

	return (*ret == '\0' ? NULL : ret);
}

/*
**  DK_LOWERCASE -- convert a string to lowercase
**
**  Parameters:
**  	str -- string to convert
**
**  Return value:
**  	None.
*/

void
dk_lowercase(char *str)
{
	char *p;

	assert(str != NULL);

	for (p = str; *p != '\0'; p++)
	{
		if (isascii(*p) && isupper(*p))
			*p = tolower(*p);
	}
}
