/*
 * This file is part of din.
 *
 * din is copyright (c) 2006 - 2012 S Jagannathan <jag@dinisnoise.org>
 * For more information, please visit http://dinisnoise.org
 *
 * din is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * din is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with din.  If not, see <http://www.gnu.org/licenses/>.
 *
*/
#ifndef __phrasor
#define __phrasor

#include <vector>
#include "box.h"
#include "point.h"

struct phrasor {

  static int JOG;

  std::vector < point<int> > data;
  int sz, lst;

  int state;
  enum {stopped, recording, playing, paused};

  int cur;

  int cue;

  int recl;

  phrasor () {
    clear ();
  }

  void get (int& win_mousex, int& win_mousey) {
    point<int>& pt = data[cur];
    win_mousex = pt.x;
    win_mousey = pt.y;
  }

  void next () {
    int c = cur + 1;
    if (c >= sz) cur = 0; else cur = c;
  }

  void clear () {
    state = stopped;
    data.clear ();
    cur = cue = 0;
    sz = 0; lst = -1;
  }

  void jog (int j) {
    int c = cur + j;
    if (c >= sz) cur = 0; else if (c < 0) cur = lst; else cur = c;
  }

  void play () {
    if (cur < sz) state = playing;
  }

  void set_cue () {
    cue = cur;
  }

  void goto_cue () {
    cur = cue;
  }

  void validate () {
    sz = data.size ();
    lst = sz - 1;
  }

  void rec () {
    state = phrasor::recording;
    recl = cur = sz;
  }

  void draw (unsigned int i, float r, float g, float b);
  void draw_marker (int x, int y);

};

#endif
