/*
 * This file is part of din.
 *
 * din is copyright (c) 2006 - 2012 S Jagannathan <jag@dinisnoise.org>
 * For more information, please visit http://dinisnoise.org
 *
 * din is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * din is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with din.  If not, see <http://www.gnu.org/licenses/>.
 *
*/

#ifndef __AUDIO
#define __AUDIO

#include <jack/jack.h>
#include <jack/midiport.h>
#include <jack/ringbuffer.h>
#include <vector>
#include "console.h"

typedef jack_default_audio_sample_t sample_t;

struct audio_out {

  static int AUTO_CONNECT_OUTPUTS; // auto connect din to system audio outputs?

  sample_t sample_rate;
  static const int num_channels = 2;
  int samples_per_buffer; // has 2 channels
  int samples_channel_size, samples_buffer_size;
  int samples_per_channel;

  // written by the main thread
  //
  // a multi buffer scheme
  //
  // main thread writes a buffer, while audio thread streams another to audio card
  //

  sample_t * samples_buffers; // a bunch of sample buffers
  int num_samples_buffers;
  int* available; // buffer available for streaming?
  sample_t *readp, *writep;
  int readi, writei;
  inline int can_write () {return !available [writei];}

  // reuseable buffers
  sample_t *result, *ams, *fms, *gatr, *vol; // result, AM & FM, gater, volume

  //
  // jack
  //

  jack_client_t *client;

  // L and R connections
  int lcons, rcons; // l and r connected?
  jack_port_t *out_left, *out_right;
  const char **con_left, **con_right;

  // midi input
  jack_port_t *midi_in;
  jack_ringbuffer_t *midi_rb;
  int num_midi_con;

  // jack preferences
  std::string prefs_name;
  void load_prefs ();
  void save_prefs ();
  void defaults ();

  audio_out ();
  ~audio_out ();

  void alloc ();
  int open ();
  int close ();
  int start ();
  void set_callbacks ();

  void set_sample_rate (int s);

  void stream (float* lbuf, float* rbuf, float* sbuf);

  static int audio_wanted (jack_nframes_t nsamples, void *arg);

};

int buffer_size_changed (jack_nframes_t nframes, void *arg);
int sample_rate_changed (jack_nframes_t nframes, void *arg);
void midi ();

void applyfx (float* out0, float* out1, int delay = 1, int compress = 1);
void update_audio ();

console& operator<< (console& c, const audio_out& ao);

void run_midi_cmd (const std::string& c, size_t length, jack_midi_data_t *buffer, std::vector<unsigned char>& args);
void connection_changed (jack_port_id_t a, jack_port_id_t b, int connect, void *arg);

#endif
