/*
    Copyright (C) 2008-2010 Stefan Haller

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef MODULE_H_
#define MODULE_H_

#include <glib.h>

struct library_entry
{
	void * lib;								/* pointer to library          */
	gchar * filename;						/* filename of the library     */
	gboolean active;						/* Should module be used?      */
	const gchar * (*name)(void);			/* get name of module          */
	const gchar * (*version)(void);			/* get version of module       */
	const gchar * (*author)(void);			/* get author how wrote module */
	const gchar * (*homepage)(void);		/* get homepage                */
	const gchar * (*description)(void);		/* get (a longer) description  */
	void (*change_wallpaper)(const gchar * filename); /* only for daemon   */
	void (*hook_list_files)(const GPtrArray * files); /* see README        */
};

struct library_entry * load_module(const gchar * filename);

#endif /*MODULE_H_*/
