﻿/* Copyright (C) 2004 - 2009  Versant Corporation http://www.versant.com */
using System;
using Db4objects.Db4o;
using Db4objects.Db4o.Config;

namespace Db4odoc.Storage
{
    class StorageExample
    {
        private const String Db4oFileName = "reference.db4o";

        public static void Main(string[] args)
        {
            StorePilot();
            DeletePilot();
        }

        public static void StorePilot()
        {
            IObjectContainer db = Db4oEmbedded.OpenFile(GetLoggingStorage(), Db4oFileName);
            Pilot p = new Pilot("Michael Schumacher", 100);
            db.Store(p);
            db.Close();
        }

        public static void DeletePilot()
        {
            IObjectContainer db = Db4oEmbedded.OpenFile(GetLoggingStorage(), Db4oFileName);
            IObjectSet pilots = db.QueryByExample(new Pilot(null, 0));
            Pilot pilot = (Pilot)pilots[0];
            System.Console.WriteLine(pilot);
            System.Console.WriteLine();

            db.Delete(pilot);
            db.Close();
        }

        public static IEmbeddedConfiguration GetLoggingStorage()
        {
            IEmbeddedConfiguration config = Db4oEmbedded.NewConfiguration();
            config.File.Storage = new LoggingStorage();
            return config;
        }

    }
}
