/*
 * Copyright (c) 2003-2012
 * Distributed Systems Software.  All rights reserved.
 * See the file LICENSE for redistribution information.
 *
 * $Id: cgiparse.h 2594 2012-10-19 17:28:49Z brachman $
 */

#ifndef _CGIPARSE_H_
#define _CGIPARSE_H_

#include <stdio.h>

#include "kwv.h"

typedef struct CGI_input {
  Http_method method;
  FILE *fp;					/* If non-NULL, the input stream */
  char *buf;				/* If no input stream, the input buffer... */
  char *ptr;				/* ... and a pointer into the input buffer */
  unsigned long length;		/* The length of the input, if known, in bytes */
  unsigned long rem;		/* Bytes remaining in input, if known */
  int have_length;			/* Non-zero if length is unavailable */
  int got_peeked_char;		/* Non-zero if there's a peeked character */
  char peeked_char;			/* The peeked character */
  int split_textarea;		/* See cgiparse.c */
#ifdef NOTDEF
  FILE *debug_fp;			/* If non-NULL, copy input stream here */
#endif
} CGI_input;

typedef struct CGI_options {
  int split_textarea;
} CGI_options;

typedef struct Entity_body {
  char *content_type;
  char *request_method;
  unsigned long content_length;
  unsigned long length;
  void *body;
} Entity_body;

/* Must follow previous definitions */
#include "mime.h"

#ifdef __cplusplus
extern "C" {
#endif

extern int cgiparse(FILE *fp, char *query_string, Kwv *kwv, Mime **mp);
extern Kwv *cgiparse_string(char *query_string, Kwv *k, CGI_options *options);
extern int cgiparse_urlencoded(CGI_input *in, Kwv *kwv);
extern int cgiparse_next_char(CGI_input *in, char *ch);
extern int cgiparse_peek_next_char(CGI_input *in, char *ch);
extern int cgiparse_is_end(CGI_input *in);
extern CGI_input *cgiparse_set_input(Http_method method, FILE *fp, char *buf,
									 unsigned long len, int have_length,
									 CGI_options *options);
extern int cgiparse_get_content_length(unsigned long *clen);
extern Entity_body *cgiparse_get_entity_body(void);

#ifdef __cplusplus
}
#endif

#endif
