/*********************                                                        */
/*! \file module_template.h
 ** \verbatim
 ** Top contributors (to current version):
 **   Mathias Preiner
 ** This file is part of the CVC4 project.
 ** Copyright (c) 2009-2018 by the authors listed in the file AUTHORS
 ** in the top-level source directory) and their institutional affiliations.
 ** All rights reserved.  See the file COPYING in the top-level source
 ** directory for licensing information.\endverbatim
 **
 ** \brief Contains code for handling command-line options.
 **
 ** For each <module>_options.toml configuration file, mkoptions.py
 ** expands this template and generates a <module>_options.h file.
 **/

#include "cvc4_private.h"

#ifndef __CVC4__OPTIONS__SMT_H
#define __CVC4__OPTIONS__SMT_H

#include "options/options.h"

#include "options/simplification_mode.h"
#include "options/sygus_out_mode.h"


#define CVC4_OPTIONS__SMT__FOR_OPTION_HOLDER \
  abstractValues__option_t::type abstractValues;\
  bool abstractValues__setByUser__; \
  bitblastStep__option_t::type bitblastStep;\
  bool bitblastStep__setByUser__; \
  bvSatConflictStep__option_t::type bvSatConflictStep;\
  bool bvSatConflictStep__setByUser__; \
  checkModels__option_t::type checkModels;\
  bool checkModels__setByUser__; \
  checkProofs__option_t::type checkProofs;\
  bool checkProofs__setByUser__; \
  checkSynthSol__option_t::type checkSynthSol;\
  bool checkSynthSol__setByUser__; \
  checkUnsatCores__option_t::type checkUnsatCores;\
  bool checkUnsatCores__setByUser__; \
  cnfStep__option_t::type cnfStep;\
  bool cnfStep__setByUser__; \
  cpuTime__option_t::type cpuTime;\
  bool cpuTime__setByUser__; \
  decisionStep__option_t::type decisionStep;\
  bool decisionStep__setByUser__; \
  diagnosticChannelName__option_t::type diagnosticChannelName;\
  bool diagnosticChannelName__setByUser__; \
  dumpInstantiations__option_t::type dumpInstantiations;\
  bool dumpInstantiations__setByUser__; \
  dumpModels__option_t::type dumpModels;\
  bool dumpModels__setByUser__; \
  dumpProofs__option_t::type dumpProofs;\
  bool dumpProofs__setByUser__; \
  dumpSynth__option_t::type dumpSynth;\
  bool dumpSynth__setByUser__; \
  dumpToFileName__option_t::type dumpToFileName;\
  bool dumpToFileName__setByUser__; \
  dumpUnsatCores__option_t::type dumpUnsatCores;\
  bool dumpUnsatCores__setByUser__; \
  dumpUnsatCoresFull__option_t::type dumpUnsatCoresFull;\
  bool dumpUnsatCoresFull__setByUser__; \
  dumpModeString__option_t::type dumpModeString;\
  bool dumpModeString__setByUser__; \
  expandDefinitions__option_t::type expandDefinitions;\
  bool expandDefinitions__setByUser__; \
  extRewPrep__option_t::type extRewPrep;\
  bool extRewPrep__setByUser__; \
  extRewPrepAgg__option_t::type extRewPrepAgg;\
  bool extRewPrepAgg__setByUser__; \
  forceLogicString__option_t::type forceLogicString;\
  bool forceLogicString__setByUser__; \
  forceNoLimitCpuWhileDump__option_t::type forceNoLimitCpuWhileDump;\
  bool forceNoLimitCpuWhileDump__setByUser__; \
  hardLimit__option_t::type hardLimit;\
  bool hardLimit__setByUser__; \
  incrementalSolving__option_t::type incrementalSolving;\
  bool incrementalSolving__setByUser__; \
  interactiveMode__option_t::type interactiveMode;\
  bool interactiveMode__setByUser__; \
  doITESimp__option_t::type doITESimp;\
  bool doITESimp__setByUser__; \
  lemmaStep__option_t::type lemmaStep;\
  bool lemmaStep__setByUser__; \
  modelUninterpDtEnum__option_t::type modelUninterpDtEnum;\
  bool modelUninterpDtEnum__setByUser__; \
  omitDontCares__option_t::type omitDontCares;\
  bool omitDontCares__setByUser__; \
  doITESimpOnRepeat__option_t::type doITESimpOnRepeat;\
  bool doITESimpOnRepeat__setByUser__; \
  parseStep__option_t::type parseStep;\
  bool parseStep__setByUser__; \
  preprocessStep__option_t::type preprocessStep;\
  bool preprocessStep__setByUser__; \
  produceAssertions__option_t::type produceAssertions;\
  bool produceAssertions__setByUser__; \
  produceAssignments__option_t::type produceAssignments;\
  bool produceAssignments__setByUser__; \
  produceModels__option_t::type produceModels;\
  bool produceModels__setByUser__; \
  unsatAssumptions__option_t::type unsatAssumptions;\
  bool unsatAssumptions__setByUser__; \
  unsatCores__option_t::type unsatCores;\
  bool unsatCores__setByUser__; \
  proof__option_t::type proof;\
  bool proof__setByUser__; \
  quantifierStep__option_t::type quantifierStep;\
  bool quantifierStep__setByUser__; \
  regularChannelName__option_t::type regularChannelName;\
  bool regularChannelName__setByUser__; \
  repeatSimp__option_t::type repeatSimp;\
  bool repeatSimp__setByUser__; \
  replayLogFilename__option_t::type replayLogFilename;\
  bool replayLogFilename__setByUser__; \
  replayInputFilename__option_t::type replayInputFilename;\
  bool replayInputFilename__setByUser__; \
  restartStep__option_t::type restartStep;\
  bool restartStep__setByUser__; \
  rewriteApplyToConst__option_t::type rewriteApplyToConst;\
  bool rewriteApplyToConst__setByUser__; \
  rewriteStep__option_t::type rewriteStep;\
  bool rewriteStep__setByUser__; \
  perCallResourceLimit__option_t::type perCallResourceLimit;\
  bool perCallResourceLimit__setByUser__; \
  cumulativeResourceLimit__option_t::type cumulativeResourceLimit;\
  bool cumulativeResourceLimit__setByUser__; \
  satConflictStep__option_t::type satConflictStep;\
  bool satConflictStep__setByUser__; \
  compressItes__option_t::type compressItes;\
  bool compressItes__setByUser__; \
  zombieHuntThreshold__option_t::type zombieHuntThreshold;\
  bool zombieHuntThreshold__setByUser__; \
  simplifyWithCareEnabled__option_t::type simplifyWithCareEnabled;\
  bool simplifyWithCareEnabled__setByUser__; \
  simplificationMode__option_t::type simplificationMode;\
  bool simplificationMode__setByUser__; \
  solveIntAsBV__option_t::type solveIntAsBV;\
  bool solveIntAsBV__setByUser__; \
  solveRealAsInt__option_t::type solveRealAsInt;\
  bool solveRealAsInt__setByUser__; \
  sortInference__option_t::type sortInference;\
  bool sortInference__setByUser__; \
  doStaticLearning__option_t::type doStaticLearning;\
  bool doStaticLearning__setByUser__; \
  sygusOut__option_t::type sygusOut;\
  bool sygusOut__setByUser__; \
  sygusPrintCallbacks__option_t::type sygusPrintCallbacks;\
  bool sygusPrintCallbacks__setByUser__; \
  symmetryBreakerExp__option_t::type symmetryBreakerExp;\
  bool symmetryBreakerExp__setByUser__; \
  theoryCheckStep__option_t::type theoryCheckStep;\
  bool theoryCheckStep__setByUser__; \
  perCallMillisecondLimit__option_t::type perCallMillisecondLimit;\
  bool perCallMillisecondLimit__setByUser__; \
  cumulativeMillisecondLimit__option_t::type cumulativeMillisecondLimit;\
  bool cumulativeMillisecondLimit__setByUser__; \
  unconstrainedSimp__option_t::type unconstrainedSimp;\
  bool unconstrainedSimp__setByUser__;


namespace CVC4 {

namespace options {

extern struct CVC4_PUBLIC abstractValues__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} abstractValues CVC4_PUBLIC;
extern struct CVC4_PUBLIC bitblastStep__option_t
{
  typedef unsigned type;
  type operator()() const;
  bool wasSetByUser() const;
} bitblastStep CVC4_PUBLIC;
extern struct CVC4_PUBLIC bvSatConflictStep__option_t
{
  typedef unsigned type;
  type operator()() const;
  bool wasSetByUser() const;
} bvSatConflictStep CVC4_PUBLIC;
extern struct CVC4_PUBLIC checkModels__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} checkModels CVC4_PUBLIC;
extern struct CVC4_PUBLIC checkProofs__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} checkProofs CVC4_PUBLIC;
extern struct CVC4_PUBLIC checkSynthSol__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} checkSynthSol CVC4_PUBLIC;
extern struct CVC4_PUBLIC checkUnsatCores__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} checkUnsatCores CVC4_PUBLIC;
extern struct CVC4_PUBLIC cnfStep__option_t
{
  typedef unsigned type;
  type operator()() const;
  bool wasSetByUser() const;
} cnfStep CVC4_PUBLIC;
extern struct CVC4_PUBLIC cpuTime__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} cpuTime CVC4_PUBLIC;
extern struct CVC4_PUBLIC decisionStep__option_t
{
  typedef unsigned type;
  type operator()() const;
  bool wasSetByUser() const;
} decisionStep CVC4_PUBLIC;
extern struct CVC4_PUBLIC diagnosticChannelName__option_t
{
  typedef std::string type;
  type operator()() const;
  bool wasSetByUser() const;
} diagnosticChannelName CVC4_PUBLIC;
extern struct CVC4_PUBLIC dumpInstantiations__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} dumpInstantiations CVC4_PUBLIC;
extern struct CVC4_PUBLIC dumpModels__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} dumpModels CVC4_PUBLIC;
extern struct CVC4_PUBLIC dumpProofs__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} dumpProofs CVC4_PUBLIC;
extern struct CVC4_PUBLIC dumpSynth__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} dumpSynth CVC4_PUBLIC;
extern struct CVC4_PUBLIC dumpToFileName__option_t
{
  typedef std::string type;
  type operator()() const;
  bool wasSetByUser() const;
} dumpToFileName CVC4_PUBLIC;
extern struct CVC4_PUBLIC dumpUnsatCores__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} dumpUnsatCores CVC4_PUBLIC;
extern struct CVC4_PUBLIC dumpUnsatCoresFull__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} dumpUnsatCoresFull CVC4_PUBLIC;
extern struct CVC4_PUBLIC dumpModeString__option_t
{
  typedef std::string type;
  type operator()() const;
  bool wasSetByUser() const;
} dumpModeString CVC4_PUBLIC;
extern struct CVC4_PUBLIC expandDefinitions__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} expandDefinitions CVC4_PUBLIC;
extern struct CVC4_PUBLIC extRewPrep__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} extRewPrep CVC4_PUBLIC;
extern struct CVC4_PUBLIC extRewPrepAgg__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} extRewPrepAgg CVC4_PUBLIC;
extern struct CVC4_PUBLIC forceLogicString__option_t
{
  typedef std::string type;
  type operator()() const;
  bool wasSetByUser() const;
} forceLogicString CVC4_PUBLIC;
extern struct CVC4_PUBLIC forceNoLimitCpuWhileDump__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} forceNoLimitCpuWhileDump CVC4_PUBLIC;
extern struct CVC4_PUBLIC hardLimit__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} hardLimit CVC4_PUBLIC;
extern struct CVC4_PUBLIC incrementalSolving__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} incrementalSolving CVC4_PUBLIC;
extern struct CVC4_PUBLIC interactiveMode__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} interactiveMode CVC4_PUBLIC;
extern struct CVC4_PUBLIC doITESimp__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} doITESimp CVC4_PUBLIC;
extern struct CVC4_PUBLIC lemmaStep__option_t
{
  typedef unsigned type;
  type operator()() const;
  bool wasSetByUser() const;
} lemmaStep CVC4_PUBLIC;
extern struct CVC4_PUBLIC modelUninterpDtEnum__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} modelUninterpDtEnum CVC4_PUBLIC;
extern struct CVC4_PUBLIC omitDontCares__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} omitDontCares CVC4_PUBLIC;
extern struct CVC4_PUBLIC doITESimpOnRepeat__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} doITESimpOnRepeat CVC4_PUBLIC;
extern struct CVC4_PUBLIC parseStep__option_t
{
  typedef unsigned type;
  type operator()() const;
  bool wasSetByUser() const;
} parseStep CVC4_PUBLIC;
extern struct CVC4_PUBLIC preprocessStep__option_t
{
  typedef unsigned type;
  type operator()() const;
  bool wasSetByUser() const;
} preprocessStep CVC4_PUBLIC;
extern struct CVC4_PUBLIC produceAssertions__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} produceAssertions CVC4_PUBLIC;
extern struct CVC4_PUBLIC produceAssignments__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} produceAssignments CVC4_PUBLIC;
extern struct CVC4_PUBLIC produceModels__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} produceModels CVC4_PUBLIC;
extern struct CVC4_PUBLIC unsatAssumptions__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} unsatAssumptions CVC4_PUBLIC;
extern struct CVC4_PUBLIC unsatCores__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} unsatCores CVC4_PUBLIC;
extern struct CVC4_PUBLIC proof__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} proof CVC4_PUBLIC;
extern struct CVC4_PUBLIC quantifierStep__option_t
{
  typedef unsigned type;
  type operator()() const;
  bool wasSetByUser() const;
} quantifierStep CVC4_PUBLIC;
extern struct CVC4_PUBLIC regularChannelName__option_t
{
  typedef std::string type;
  type operator()() const;
  bool wasSetByUser() const;
} regularChannelName CVC4_PUBLIC;
extern struct CVC4_PUBLIC repeatSimp__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} repeatSimp CVC4_PUBLIC;
extern struct CVC4_PUBLIC replayLogFilename__option_t
{
  typedef std::string type;
  type operator()() const;
  bool wasSetByUser() const;
} replayLogFilename CVC4_PUBLIC;
extern struct CVC4_PUBLIC replayInputFilename__option_t
{
  typedef std::string type;
  type operator()() const;
  bool wasSetByUser() const;
} replayInputFilename CVC4_PUBLIC;
extern struct CVC4_PUBLIC restartStep__option_t
{
  typedef unsigned type;
  type operator()() const;
  bool wasSetByUser() const;
} restartStep CVC4_PUBLIC;
extern struct CVC4_PUBLIC rewriteApplyToConst__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} rewriteApplyToConst CVC4_PUBLIC;
extern struct CVC4_PUBLIC rewriteStep__option_t
{
  typedef unsigned type;
  type operator()() const;
  bool wasSetByUser() const;
} rewriteStep CVC4_PUBLIC;
extern struct CVC4_PUBLIC perCallResourceLimit__option_t
{
  typedef unsigned long type;
  type operator()() const;
  bool wasSetByUser() const;
} perCallResourceLimit CVC4_PUBLIC;
extern struct CVC4_PUBLIC cumulativeResourceLimit__option_t
{
  typedef unsigned long type;
  type operator()() const;
  bool wasSetByUser() const;
} cumulativeResourceLimit CVC4_PUBLIC;
extern struct CVC4_PUBLIC satConflictStep__option_t
{
  typedef unsigned type;
  type operator()() const;
  bool wasSetByUser() const;
} satConflictStep CVC4_PUBLIC;
extern struct CVC4_PUBLIC compressItes__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} compressItes CVC4_PUBLIC;
extern struct CVC4_PUBLIC zombieHuntThreshold__option_t
{
  typedef uint32_t type;
  type operator()() const;
  bool wasSetByUser() const;
} zombieHuntThreshold CVC4_PUBLIC;
extern struct CVC4_PUBLIC simplifyWithCareEnabled__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} simplifyWithCareEnabled CVC4_PUBLIC;
extern struct CVC4_PUBLIC simplificationMode__option_t
{
  typedef SimplificationMode type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} simplificationMode CVC4_PUBLIC;
extern struct CVC4_PUBLIC solveIntAsBV__option_t
{
  typedef uint32_t type;
  type operator()() const;
  bool wasSetByUser() const;
} solveIntAsBV CVC4_PUBLIC;
extern struct CVC4_PUBLIC solveRealAsInt__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} solveRealAsInt CVC4_PUBLIC;
extern struct CVC4_PUBLIC sortInference__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} sortInference CVC4_PUBLIC;
extern struct CVC4_PUBLIC doStaticLearning__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} doStaticLearning CVC4_PUBLIC;
extern struct CVC4_PUBLIC sygusOut__option_t
{
  typedef SygusSolutionOutMode type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} sygusOut CVC4_PUBLIC;
extern struct CVC4_PUBLIC sygusPrintCallbacks__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} sygusPrintCallbacks CVC4_PUBLIC;
extern struct CVC4_PUBLIC symmetryBreakerExp__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} symmetryBreakerExp CVC4_PUBLIC;
extern struct CVC4_PUBLIC theoryCheckStep__option_t
{
  typedef unsigned type;
  type operator()() const;
  bool wasSetByUser() const;
} theoryCheckStep CVC4_PUBLIC;
extern struct CVC4_PUBLIC perCallMillisecondLimit__option_t
{
  typedef unsigned long type;
  type operator()() const;
  bool wasSetByUser() const;
} perCallMillisecondLimit CVC4_PUBLIC;
extern struct CVC4_PUBLIC cumulativeMillisecondLimit__option_t
{
  typedef unsigned long type;
  type operator()() const;
  bool wasSetByUser() const;
} cumulativeMillisecondLimit CVC4_PUBLIC;
extern struct CVC4_PUBLIC unconstrainedSimp__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} unconstrainedSimp CVC4_PUBLIC;


}  // namespace options

template <> const options::abstractValues__option_t::type& Options::operator[](
    options::abstractValues__option_t) const;
template <> bool Options::wasSetByUser(options::abstractValues__option_t) const;
template <> void Options::assignBool(
    options::abstractValues__option_t,
    std::string option,
    bool value);
template <> const options::bitblastStep__option_t::type& Options::operator[](
    options::bitblastStep__option_t) const;
template <> bool Options::wasSetByUser(options::bitblastStep__option_t) const;
template <> void Options::assign(
    options::bitblastStep__option_t,
    std::string option,
    std::string value);
template <> const options::bvSatConflictStep__option_t::type& Options::operator[](
    options::bvSatConflictStep__option_t) const;
template <> bool Options::wasSetByUser(options::bvSatConflictStep__option_t) const;
template <> void Options::assign(
    options::bvSatConflictStep__option_t,
    std::string option,
    std::string value);
template <> const options::checkModels__option_t::type& Options::operator[](
    options::checkModels__option_t) const;
template <> bool Options::wasSetByUser(options::checkModels__option_t) const;
template <> void Options::assignBool(
    options::checkModels__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::checkProofs__option_t,
    const options::checkProofs__option_t::type& x);
template <> const options::checkProofs__option_t::type& Options::operator[](
    options::checkProofs__option_t) const;
template <> bool Options::wasSetByUser(options::checkProofs__option_t) const;
template <> void Options::assignBool(
    options::checkProofs__option_t,
    std::string option,
    bool value);
template <> const options::checkSynthSol__option_t::type& Options::operator[](
    options::checkSynthSol__option_t) const;
template <> bool Options::wasSetByUser(options::checkSynthSol__option_t) const;
template <> void Options::assignBool(
    options::checkSynthSol__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::checkUnsatCores__option_t,
    const options::checkUnsatCores__option_t::type& x);
template <> const options::checkUnsatCores__option_t::type& Options::operator[](
    options::checkUnsatCores__option_t) const;
template <> bool Options::wasSetByUser(options::checkUnsatCores__option_t) const;
template <> void Options::assignBool(
    options::checkUnsatCores__option_t,
    std::string option,
    bool value);
template <> const options::cnfStep__option_t::type& Options::operator[](
    options::cnfStep__option_t) const;
template <> bool Options::wasSetByUser(options::cnfStep__option_t) const;
template <> void Options::assign(
    options::cnfStep__option_t,
    std::string option,
    std::string value);
template <> const options::cpuTime__option_t::type& Options::operator[](
    options::cpuTime__option_t) const;
template <> bool Options::wasSetByUser(options::cpuTime__option_t) const;
template <> void Options::assignBool(
    options::cpuTime__option_t,
    std::string option,
    bool value);
template <> const options::decisionStep__option_t::type& Options::operator[](
    options::decisionStep__option_t) const;
template <> bool Options::wasSetByUser(options::decisionStep__option_t) const;
template <> void Options::assign(
    options::decisionStep__option_t,
    std::string option,
    std::string value);
template <> const options::diagnosticChannelName__option_t::type& Options::operator[](
    options::diagnosticChannelName__option_t) const;
template <> bool Options::wasSetByUser(options::diagnosticChannelName__option_t) const;
template <> void Options::assign(
    options::diagnosticChannelName__option_t,
    std::string option,
    std::string value);
template <> const options::dumpInstantiations__option_t::type& Options::operator[](
    options::dumpInstantiations__option_t) const;
template <> bool Options::wasSetByUser(options::dumpInstantiations__option_t) const;
template <> void Options::assignBool(
    options::dumpInstantiations__option_t,
    std::string option,
    bool value);
template <> const options::dumpModels__option_t::type& Options::operator[](
    options::dumpModels__option_t) const;
template <> bool Options::wasSetByUser(options::dumpModels__option_t) const;
template <> void Options::assignBool(
    options::dumpModels__option_t,
    std::string option,
    bool value);
template <> const options::dumpProofs__option_t::type& Options::operator[](
    options::dumpProofs__option_t) const;
template <> bool Options::wasSetByUser(options::dumpProofs__option_t) const;
template <> void Options::assignBool(
    options::dumpProofs__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::dumpSynth__option_t,
    const options::dumpSynth__option_t::type& x);
template <> const options::dumpSynth__option_t::type& Options::operator[](
    options::dumpSynth__option_t) const;
template <> bool Options::wasSetByUser(options::dumpSynth__option_t) const;
template <> void Options::assignBool(
    options::dumpSynth__option_t,
    std::string option,
    bool value);
template <> const options::dumpToFileName__option_t::type& Options::operator[](
    options::dumpToFileName__option_t) const;
template <> bool Options::wasSetByUser(options::dumpToFileName__option_t) const;
template <> void Options::assign(
    options::dumpToFileName__option_t,
    std::string option,
    std::string value);
template <> const options::dumpUnsatCores__option_t::type& Options::operator[](
    options::dumpUnsatCores__option_t) const;
template <> bool Options::wasSetByUser(options::dumpUnsatCores__option_t) const;
template <> void Options::assignBool(
    options::dumpUnsatCores__option_t,
    std::string option,
    bool value);
template <> const options::dumpUnsatCoresFull__option_t::type& Options::operator[](
    options::dumpUnsatCoresFull__option_t) const;
template <> bool Options::wasSetByUser(options::dumpUnsatCoresFull__option_t) const;
template <> void Options::assignBool(
    options::dumpUnsatCoresFull__option_t,
    std::string option,
    bool value);
template <> const options::dumpModeString__option_t::type& Options::operator[](
    options::dumpModeString__option_t) const;
template <> bool Options::wasSetByUser(options::dumpModeString__option_t) const;
template <> void Options::assign(
    options::dumpModeString__option_t,
    std::string option,
    std::string value);
template <> const options::expandDefinitions__option_t::type& Options::operator[](
    options::expandDefinitions__option_t) const;
template <> bool Options::wasSetByUser(options::expandDefinitions__option_t) const;
template <> void Options::assignBool(
    options::expandDefinitions__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::extRewPrep__option_t,
    const options::extRewPrep__option_t::type& x);
template <> const options::extRewPrep__option_t::type& Options::operator[](
    options::extRewPrep__option_t) const;
template <> bool Options::wasSetByUser(options::extRewPrep__option_t) const;
template <> void Options::assignBool(
    options::extRewPrep__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::extRewPrepAgg__option_t,
    const options::extRewPrepAgg__option_t::type& x);
template <> const options::extRewPrepAgg__option_t::type& Options::operator[](
    options::extRewPrepAgg__option_t) const;
template <> bool Options::wasSetByUser(options::extRewPrepAgg__option_t) const;
template <> void Options::assignBool(
    options::extRewPrepAgg__option_t,
    std::string option,
    bool value);
template <> const options::forceLogicString__option_t::type& Options::operator[](
    options::forceLogicString__option_t) const;
template <> bool Options::wasSetByUser(options::forceLogicString__option_t) const;
template <> void Options::assign(
    options::forceLogicString__option_t,
    std::string option,
    std::string value);
template <> const options::forceNoLimitCpuWhileDump__option_t::type& Options::operator[](
    options::forceNoLimitCpuWhileDump__option_t) const;
template <> bool Options::wasSetByUser(options::forceNoLimitCpuWhileDump__option_t) const;
template <> void Options::assignBool(
    options::forceNoLimitCpuWhileDump__option_t,
    std::string option,
    bool value);
template <> const options::hardLimit__option_t::type& Options::operator[](
    options::hardLimit__option_t) const;
template <> bool Options::wasSetByUser(options::hardLimit__option_t) const;
template <> void Options::assignBool(
    options::hardLimit__option_t,
    std::string option,
    bool value);
template <> const options::incrementalSolving__option_t::type& Options::operator[](
    options::incrementalSolving__option_t) const;
template <> bool Options::wasSetByUser(options::incrementalSolving__option_t) const;
template <> void Options::assignBool(
    options::incrementalSolving__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::interactiveMode__option_t,
    const options::interactiveMode__option_t::type& x);
template <> const options::interactiveMode__option_t::type& Options::operator[](
    options::interactiveMode__option_t) const;
template <> bool Options::wasSetByUser(options::interactiveMode__option_t) const;
template <> void Options::assignBool(
    options::interactiveMode__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::doITESimp__option_t,
    const options::doITESimp__option_t::type& x);
template <> const options::doITESimp__option_t::type& Options::operator[](
    options::doITESimp__option_t) const;
template <> bool Options::wasSetByUser(options::doITESimp__option_t) const;
template <> void Options::assignBool(
    options::doITESimp__option_t,
    std::string option,
    bool value);
template <> const options::lemmaStep__option_t::type& Options::operator[](
    options::lemmaStep__option_t) const;
template <> bool Options::wasSetByUser(options::lemmaStep__option_t) const;
template <> void Options::assign(
    options::lemmaStep__option_t,
    std::string option,
    std::string value);
template <> const options::modelUninterpDtEnum__option_t::type& Options::operator[](
    options::modelUninterpDtEnum__option_t) const;
template <> bool Options::wasSetByUser(options::modelUninterpDtEnum__option_t) const;
template <> void Options::assignBool(
    options::modelUninterpDtEnum__option_t,
    std::string option,
    bool value);
template <> const options::omitDontCares__option_t::type& Options::operator[](
    options::omitDontCares__option_t) const;
template <> bool Options::wasSetByUser(options::omitDontCares__option_t) const;
template <> void Options::assignBool(
    options::omitDontCares__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::doITESimpOnRepeat__option_t,
    const options::doITESimpOnRepeat__option_t::type& x);
template <> const options::doITESimpOnRepeat__option_t::type& Options::operator[](
    options::doITESimpOnRepeat__option_t) const;
template <> bool Options::wasSetByUser(options::doITESimpOnRepeat__option_t) const;
template <> void Options::assignBool(
    options::doITESimpOnRepeat__option_t,
    std::string option,
    bool value);
template <> const options::parseStep__option_t::type& Options::operator[](
    options::parseStep__option_t) const;
template <> bool Options::wasSetByUser(options::parseStep__option_t) const;
template <> void Options::assign(
    options::parseStep__option_t,
    std::string option,
    std::string value);
template <> const options::preprocessStep__option_t::type& Options::operator[](
    options::preprocessStep__option_t) const;
template <> bool Options::wasSetByUser(options::preprocessStep__option_t) const;
template <> void Options::assign(
    options::preprocessStep__option_t,
    std::string option,
    std::string value);
template <> void Options::set(
    options::produceAssertions__option_t,
    const options::produceAssertions__option_t::type& x);
template <> const options::produceAssertions__option_t::type& Options::operator[](
    options::produceAssertions__option_t) const;
template <> bool Options::wasSetByUser(options::produceAssertions__option_t) const;
template <> void Options::assignBool(
    options::produceAssertions__option_t,
    std::string option,
    bool value);
template <> const options::produceAssignments__option_t::type& Options::operator[](
    options::produceAssignments__option_t) const;
template <> bool Options::wasSetByUser(options::produceAssignments__option_t) const;
template <> void Options::assignBool(
    options::produceAssignments__option_t,
    std::string option,
    bool value);
template <> const options::produceModels__option_t::type& Options::operator[](
    options::produceModels__option_t) const;
template <> bool Options::wasSetByUser(options::produceModels__option_t) const;
template <> void Options::assignBool(
    options::produceModels__option_t,
    std::string option,
    bool value);
template <> const options::unsatAssumptions__option_t::type& Options::operator[](
    options::unsatAssumptions__option_t) const;
template <> bool Options::wasSetByUser(options::unsatAssumptions__option_t) const;
template <> void Options::assignBool(
    options::unsatAssumptions__option_t,
    std::string option,
    bool value);
template <> const options::unsatCores__option_t::type& Options::operator[](
    options::unsatCores__option_t) const;
template <> bool Options::wasSetByUser(options::unsatCores__option_t) const;
template <> void Options::assignBool(
    options::unsatCores__option_t,
    std::string option,
    bool value);
template <> const options::proof__option_t::type& Options::operator[](
    options::proof__option_t) const;
template <> bool Options::wasSetByUser(options::proof__option_t) const;
template <> void Options::assignBool(
    options::proof__option_t,
    std::string option,
    bool value);
template <> const options::quantifierStep__option_t::type& Options::operator[](
    options::quantifierStep__option_t) const;
template <> bool Options::wasSetByUser(options::quantifierStep__option_t) const;
template <> void Options::assign(
    options::quantifierStep__option_t,
    std::string option,
    std::string value);
template <> const options::regularChannelName__option_t::type& Options::operator[](
    options::regularChannelName__option_t) const;
template <> bool Options::wasSetByUser(options::regularChannelName__option_t) const;
template <> void Options::assign(
    options::regularChannelName__option_t,
    std::string option,
    std::string value);
template <> void Options::set(
    options::repeatSimp__option_t,
    const options::repeatSimp__option_t::type& x);
template <> const options::repeatSimp__option_t::type& Options::operator[](
    options::repeatSimp__option_t) const;
template <> bool Options::wasSetByUser(options::repeatSimp__option_t) const;
template <> void Options::assignBool(
    options::repeatSimp__option_t,
    std::string option,
    bool value);
template <> const options::replayLogFilename__option_t::type& Options::operator[](
    options::replayLogFilename__option_t) const;
template <> bool Options::wasSetByUser(options::replayLogFilename__option_t) const;
template <> void Options::assign(
    options::replayLogFilename__option_t,
    std::string option,
    std::string value);
template <> const options::replayInputFilename__option_t::type& Options::operator[](
    options::replayInputFilename__option_t) const;
template <> bool Options::wasSetByUser(options::replayInputFilename__option_t) const;
template <> void Options::assign(
    options::replayInputFilename__option_t,
    std::string option,
    std::string value);
template <> const options::restartStep__option_t::type& Options::operator[](
    options::restartStep__option_t) const;
template <> bool Options::wasSetByUser(options::restartStep__option_t) const;
template <> void Options::assign(
    options::restartStep__option_t,
    std::string option,
    std::string value);
template <> const options::rewriteApplyToConst__option_t::type& Options::operator[](
    options::rewriteApplyToConst__option_t) const;
template <> bool Options::wasSetByUser(options::rewriteApplyToConst__option_t) const;
template <> void Options::assignBool(
    options::rewriteApplyToConst__option_t,
    std::string option,
    bool value);
template <> const options::rewriteStep__option_t::type& Options::operator[](
    options::rewriteStep__option_t) const;
template <> bool Options::wasSetByUser(options::rewriteStep__option_t) const;
template <> void Options::assign(
    options::rewriteStep__option_t,
    std::string option,
    std::string value);
template <> const options::perCallResourceLimit__option_t::type& Options::operator[](
    options::perCallResourceLimit__option_t) const;
template <> bool Options::wasSetByUser(options::perCallResourceLimit__option_t) const;
template <> void Options::assign(
    options::perCallResourceLimit__option_t,
    std::string option,
    std::string value);
template <> const options::cumulativeResourceLimit__option_t::type& Options::operator[](
    options::cumulativeResourceLimit__option_t) const;
template <> bool Options::wasSetByUser(options::cumulativeResourceLimit__option_t) const;
template <> void Options::assign(
    options::cumulativeResourceLimit__option_t,
    std::string option,
    std::string value);
template <> const options::satConflictStep__option_t::type& Options::operator[](
    options::satConflictStep__option_t) const;
template <> bool Options::wasSetByUser(options::satConflictStep__option_t) const;
template <> void Options::assign(
    options::satConflictStep__option_t,
    std::string option,
    std::string value);
template <> void Options::set(
    options::compressItes__option_t,
    const options::compressItes__option_t::type& x);
template <> const options::compressItes__option_t::type& Options::operator[](
    options::compressItes__option_t) const;
template <> bool Options::wasSetByUser(options::compressItes__option_t) const;
template <> void Options::assignBool(
    options::compressItes__option_t,
    std::string option,
    bool value);
template <> const options::zombieHuntThreshold__option_t::type& Options::operator[](
    options::zombieHuntThreshold__option_t) const;
template <> bool Options::wasSetByUser(options::zombieHuntThreshold__option_t) const;
template <> void Options::assign(
    options::zombieHuntThreshold__option_t,
    std::string option,
    std::string value);
template <> void Options::set(
    options::simplifyWithCareEnabled__option_t,
    const options::simplifyWithCareEnabled__option_t::type& x);
template <> const options::simplifyWithCareEnabled__option_t::type& Options::operator[](
    options::simplifyWithCareEnabled__option_t) const;
template <> bool Options::wasSetByUser(options::simplifyWithCareEnabled__option_t) const;
template <> void Options::assignBool(
    options::simplifyWithCareEnabled__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::simplificationMode__option_t,
    const options::simplificationMode__option_t::type& x);
template <> const options::simplificationMode__option_t::type& Options::operator[](
    options::simplificationMode__option_t) const;
template <> bool Options::wasSetByUser(options::simplificationMode__option_t) const;
template <> void Options::assign(
    options::simplificationMode__option_t,
    std::string option,
    std::string value);
template <> const options::solveIntAsBV__option_t::type& Options::operator[](
    options::solveIntAsBV__option_t) const;
template <> bool Options::wasSetByUser(options::solveIntAsBV__option_t) const;
template <> void Options::assign(
    options::solveIntAsBV__option_t,
    std::string option,
    std::string value);
template <> const options::solveRealAsInt__option_t::type& Options::operator[](
    options::solveRealAsInt__option_t) const;
template <> bool Options::wasSetByUser(options::solveRealAsInt__option_t) const;
template <> void Options::assignBool(
    options::solveRealAsInt__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::sortInference__option_t,
    const options::sortInference__option_t::type& x);
template <> const options::sortInference__option_t::type& Options::operator[](
    options::sortInference__option_t) const;
template <> bool Options::wasSetByUser(options::sortInference__option_t) const;
template <> void Options::assignBool(
    options::sortInference__option_t,
    std::string option,
    bool value);
template <> const options::doStaticLearning__option_t::type& Options::operator[](
    options::doStaticLearning__option_t) const;
template <> bool Options::wasSetByUser(options::doStaticLearning__option_t) const;
template <> void Options::assignBool(
    options::doStaticLearning__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::sygusOut__option_t,
    const options::sygusOut__option_t::type& x);
template <> const options::sygusOut__option_t::type& Options::operator[](
    options::sygusOut__option_t) const;
template <> bool Options::wasSetByUser(options::sygusOut__option_t) const;
template <> void Options::assign(
    options::sygusOut__option_t,
    std::string option,
    std::string value);
template <> const options::sygusPrintCallbacks__option_t::type& Options::operator[](
    options::sygusPrintCallbacks__option_t) const;
template <> bool Options::wasSetByUser(options::sygusPrintCallbacks__option_t) const;
template <> void Options::assignBool(
    options::sygusPrintCallbacks__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::symmetryBreakerExp__option_t,
    const options::symmetryBreakerExp__option_t::type& x);
template <> const options::symmetryBreakerExp__option_t::type& Options::operator[](
    options::symmetryBreakerExp__option_t) const;
template <> bool Options::wasSetByUser(options::symmetryBreakerExp__option_t) const;
template <> void Options::assignBool(
    options::symmetryBreakerExp__option_t,
    std::string option,
    bool value);
template <> const options::theoryCheckStep__option_t::type& Options::operator[](
    options::theoryCheckStep__option_t) const;
template <> bool Options::wasSetByUser(options::theoryCheckStep__option_t) const;
template <> void Options::assign(
    options::theoryCheckStep__option_t,
    std::string option,
    std::string value);
template <> const options::perCallMillisecondLimit__option_t::type& Options::operator[](
    options::perCallMillisecondLimit__option_t) const;
template <> bool Options::wasSetByUser(options::perCallMillisecondLimit__option_t) const;
template <> void Options::assign(
    options::perCallMillisecondLimit__option_t,
    std::string option,
    std::string value);
template <> const options::cumulativeMillisecondLimit__option_t::type& Options::operator[](
    options::cumulativeMillisecondLimit__option_t) const;
template <> bool Options::wasSetByUser(options::cumulativeMillisecondLimit__option_t) const;
template <> void Options::assign(
    options::cumulativeMillisecondLimit__option_t,
    std::string option,
    std::string value);
template <> void Options::set(
    options::unconstrainedSimp__option_t,
    const options::unconstrainedSimp__option_t::type& x);
template <> const options::unconstrainedSimp__option_t::type& Options::operator[](
    options::unconstrainedSimp__option_t) const;
template <> bool Options::wasSetByUser(options::unconstrainedSimp__option_t) const;
template <> void Options::assignBool(
    options::unconstrainedSimp__option_t,
    std::string option,
    bool value);


namespace options {

inline abstractValues__option_t::type abstractValues__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool abstractValues__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline bitblastStep__option_t::type bitblastStep__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool bitblastStep__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline bvSatConflictStep__option_t::type bvSatConflictStep__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool bvSatConflictStep__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline checkModels__option_t::type checkModels__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool checkModels__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline checkProofs__option_t::type checkProofs__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool checkProofs__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void checkProofs__option_t::set(const checkProofs__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline checkSynthSol__option_t::type checkSynthSol__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool checkSynthSol__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline checkUnsatCores__option_t::type checkUnsatCores__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool checkUnsatCores__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void checkUnsatCores__option_t::set(const checkUnsatCores__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline cnfStep__option_t::type cnfStep__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool cnfStep__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline cpuTime__option_t::type cpuTime__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool cpuTime__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline decisionStep__option_t::type decisionStep__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool decisionStep__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline diagnosticChannelName__option_t::type diagnosticChannelName__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool diagnosticChannelName__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline dumpInstantiations__option_t::type dumpInstantiations__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool dumpInstantiations__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline dumpModels__option_t::type dumpModels__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool dumpModels__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline dumpProofs__option_t::type dumpProofs__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool dumpProofs__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline dumpSynth__option_t::type dumpSynth__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool dumpSynth__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void dumpSynth__option_t::set(const dumpSynth__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline dumpToFileName__option_t::type dumpToFileName__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool dumpToFileName__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline dumpUnsatCores__option_t::type dumpUnsatCores__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool dumpUnsatCores__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline dumpUnsatCoresFull__option_t::type dumpUnsatCoresFull__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool dumpUnsatCoresFull__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline dumpModeString__option_t::type dumpModeString__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool dumpModeString__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline expandDefinitions__option_t::type expandDefinitions__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool expandDefinitions__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline extRewPrep__option_t::type extRewPrep__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool extRewPrep__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void extRewPrep__option_t::set(const extRewPrep__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline extRewPrepAgg__option_t::type extRewPrepAgg__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool extRewPrepAgg__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void extRewPrepAgg__option_t::set(const extRewPrepAgg__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline forceLogicString__option_t::type forceLogicString__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool forceLogicString__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline forceNoLimitCpuWhileDump__option_t::type forceNoLimitCpuWhileDump__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool forceNoLimitCpuWhileDump__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline hardLimit__option_t::type hardLimit__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool hardLimit__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline incrementalSolving__option_t::type incrementalSolving__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool incrementalSolving__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline interactiveMode__option_t::type interactiveMode__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool interactiveMode__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void interactiveMode__option_t::set(const interactiveMode__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline doITESimp__option_t::type doITESimp__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool doITESimp__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void doITESimp__option_t::set(const doITESimp__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline lemmaStep__option_t::type lemmaStep__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool lemmaStep__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline modelUninterpDtEnum__option_t::type modelUninterpDtEnum__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool modelUninterpDtEnum__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline omitDontCares__option_t::type omitDontCares__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool omitDontCares__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline doITESimpOnRepeat__option_t::type doITESimpOnRepeat__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool doITESimpOnRepeat__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void doITESimpOnRepeat__option_t::set(const doITESimpOnRepeat__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline parseStep__option_t::type parseStep__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool parseStep__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline preprocessStep__option_t::type preprocessStep__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool preprocessStep__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline produceAssertions__option_t::type produceAssertions__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool produceAssertions__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void produceAssertions__option_t::set(const produceAssertions__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline produceAssignments__option_t::type produceAssignments__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool produceAssignments__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline produceModels__option_t::type produceModels__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool produceModels__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline unsatAssumptions__option_t::type unsatAssumptions__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool unsatAssumptions__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline unsatCores__option_t::type unsatCores__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool unsatCores__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline proof__option_t::type proof__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool proof__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline quantifierStep__option_t::type quantifierStep__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool quantifierStep__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline regularChannelName__option_t::type regularChannelName__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool regularChannelName__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline repeatSimp__option_t::type repeatSimp__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool repeatSimp__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void repeatSimp__option_t::set(const repeatSimp__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline replayLogFilename__option_t::type replayLogFilename__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool replayLogFilename__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline replayInputFilename__option_t::type replayInputFilename__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool replayInputFilename__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline restartStep__option_t::type restartStep__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool restartStep__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline rewriteApplyToConst__option_t::type rewriteApplyToConst__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool rewriteApplyToConst__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline rewriteStep__option_t::type rewriteStep__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool rewriteStep__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline perCallResourceLimit__option_t::type perCallResourceLimit__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool perCallResourceLimit__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline cumulativeResourceLimit__option_t::type cumulativeResourceLimit__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool cumulativeResourceLimit__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline satConflictStep__option_t::type satConflictStep__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool satConflictStep__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline compressItes__option_t::type compressItes__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool compressItes__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void compressItes__option_t::set(const compressItes__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline zombieHuntThreshold__option_t::type zombieHuntThreshold__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool zombieHuntThreshold__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline simplifyWithCareEnabled__option_t::type simplifyWithCareEnabled__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool simplifyWithCareEnabled__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void simplifyWithCareEnabled__option_t::set(const simplifyWithCareEnabled__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline simplificationMode__option_t::type simplificationMode__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool simplificationMode__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void simplificationMode__option_t::set(const simplificationMode__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline solveIntAsBV__option_t::type solveIntAsBV__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool solveIntAsBV__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline solveRealAsInt__option_t::type solveRealAsInt__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool solveRealAsInt__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline sortInference__option_t::type sortInference__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool sortInference__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void sortInference__option_t::set(const sortInference__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline doStaticLearning__option_t::type doStaticLearning__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool doStaticLearning__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline sygusOut__option_t::type sygusOut__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool sygusOut__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void sygusOut__option_t::set(const sygusOut__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline sygusPrintCallbacks__option_t::type sygusPrintCallbacks__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool sygusPrintCallbacks__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline symmetryBreakerExp__option_t::type symmetryBreakerExp__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool symmetryBreakerExp__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void symmetryBreakerExp__option_t::set(const symmetryBreakerExp__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline theoryCheckStep__option_t::type theoryCheckStep__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool theoryCheckStep__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline perCallMillisecondLimit__option_t::type perCallMillisecondLimit__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool perCallMillisecondLimit__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline cumulativeMillisecondLimit__option_t::type cumulativeMillisecondLimit__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool cumulativeMillisecondLimit__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline unconstrainedSimp__option_t::type unconstrainedSimp__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool unconstrainedSimp__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void unconstrainedSimp__option_t::set(const unconstrainedSimp__option_t::type& v)
{
  Options::current()->set(*this, v);
}


}  // namespace options
}  // namespace CVC4

#endif /* __CVC4__OPTIONS__SMT_H */
