struct cpuinfo_mock_file filesystem[] = {
	{
		.path = "/proc/cpuinfo",
		.size = 369,
		.content =
			"processor\t: 0\n"
			"BogoMIPS\t: 24.00\n"
			"Features\t: fp asimd aes pmull sha1 sha2 crc32\n"
			"CPU implementer\t: 0x4e\n"
			"CPU architecture: 8\n"
			"CPU variant\t: 0x0\n"
			"CPU part\t: 0x000\n"
			"CPU revision\t: 0\n"
			"\n"
			"processor\t: 1\n"
			"BogoMIPS\t: 24.00\n"
			"Features\t: fp asimd aes pmull sha1 sha2 crc32\n"
			"CPU implementer\t: 0x4e\n"
			"CPU architecture: 8\n"
			"CPU variant\t: 0x0\n"
			"CPU part\t: 0x000\n"
			"CPU revision\t: 0\n"
			"\n"
			"MTS version\t: 33985182\n",
	},
	{
		.path = "/system/build.prop",
		.size = 3780,
		.content =
			"\n"
			"# begin build properties\n"
			"# autogenerated by buildinfo.sh\n"
			"ro.build.id=N9F27C\n"
			"ro.build.display.id=N9F27C\n"
			"ro.build.version.incremental=3938480\n"
			"ro.build.version.sdk=25\n"
			"ro.build.version.preview_sdk=0\n"
			"ro.build.version.codename=REL\n"
			"ro.build.version.all_codenames=REL\n"
			"ro.build.version.release=7.1.1\n"
			"ro.build.version.security_patch=2017-06-05\n"
			"ro.build.version.base_os=\n"
			"ro.build.date=Mon Apr 24 19:32:57 UTC 2017\n"
			"ro.build.date.utc=1493062377\n"
			"ro.build.type=user\n"
			"ro.build.user=android-build\n"
			"ro.build.host=wphn4.hot.corp.google.com\n"
			"ro.build.tags=release-keys\n"
			"ro.build.flavor=volantis-user\n"
			"ro.product.model=Nexus 9\n"
			"ro.product.brand=google\n"
			"ro.product.name=volantis\n"
			"ro.product.device=flounder\n"
			"ro.product.board=flounder\n"
			"# ro.product.cpu.abi and ro.product.cpu.abi2 are obsolete,\n"
			"# use ro.product.cpu.abilist instead.\n"
			"ro.product.cpu.abi=arm64-v8a\n"
			"ro.product.cpu.abilist=arm64-v8a,armeabi-v7a,armeabi\n"
			"ro.product.cpu.abilist32=armeabi-v7a,armeabi\n"
			"ro.product.cpu.abilist64=arm64-v8a\n"
			"ro.product.manufacturer=htc\n"
			"ro.product.locale=en-US\n"
			"ro.wifi.channels=\n"
			"ro.board.platform=tegra132\n"
			"# ro.build.product is obsolete; use ro.product.device\n"
			"ro.build.product=flounder\n"
			"# Do not try to parse description, fingerprint, or thumbprint\n"
			"ro.build.description=volantis-user 7.1.1 N9F27C 3938480 release-keys\n"
			"ro.build.fingerprint=google/volantis/flounder:7.1.1/N9F27C/3938480:user/release-keys\n"
			"ro.build.characteristics=tablet,nosdcard\n"
			"# end build properties\n"
			"\n"
			"#\n"
			"# ADDITIONAL_BUILD_PROPERTIES\n"
			"#\n"
			"wifi.interface=wlan0\n"
			"ro.opengles.version=196609\n"
			"ro.sf.lcd_density=320\n"
			"ro.hwui.texture_cache_size=72\n"
			"ro.hwui.layer_cache_size=48\n"
			"ro.hwui.r_buffer_cache_size=8\n"
			"ro.hwui.path_cache_size=32\n"
			"ro.hwui.gradient_cache_size=1\n"
			"ro.hwui.drop_shadow_cache_size=6\n"
			"ro.hwui.texture_cache_flushrate=0.4\n"
			"ro.hwui.text_small_cache_width=1024\n"
			"ro.hwui.text_small_cache_height=1024\n"
			"ro.hwui.text_large_cache_width=2048\n"
			"ro.hwui.text_large_cache_height=1024\n"
			"ro.hwui.disable_scissor_opt=true\n"
			"ro.bt.bdaddr_path=/sys/module/flounder_bdaddress/parameters/bdaddress\n"
			"ro.frp.pst=/dev/block/platform/sdhci-tegra.3/by-name/PST\n"
			"ro.ril.def.agps.mode=1\n"
			"persist.tegra.compositor=glcomposer\n"
			"dalvik.vm.heapstartsize=16m\n"
			"dalvik.vm.heapgrowthlimit=192m\n"
			"dalvik.vm.heapsize=512m\n"
			"dalvik.vm.heaptargetutilization=0.75\n"
			"dalvik.vm.heapminfree=512k\n"
			"dalvik.vm.heapmaxfree=8m\n"
			"ro.audio.monitorRotation=true\n"
			"af.fast_track_multiplier=1\n"
			"audio_hal.period_size=128\n"
			"ro.config.ringtone=Girtab.ogg\n"
			"ro.config.notification_sound=Tethys.ogg\n"
			"ro.config.alarm_alert=Oxygen.ogg\n"
			"ro.carrier=unknown\n"
			"ro.com.android.dataroaming=false\n"
			"ro.url.legal=http://www.google.com/intl/%s/mobile/android/basic/phone-legal.html\n"
			"ro.url.legal.android_privacy=http://www.google.com/intl/%s/mobile/android/basic/privacy.html\n"
			"ro.com.google.clientidbase=android-google\n"
			"ro.com.android.wifi-watchlist=GoogleGuest\n"
			"ro.error.receiver.system.apps=com.google.android.gms\n"
			"ro.setupwizard.enterprise_mode=1\n"
			"ro.atrace.core.services=com.google.android.gms,com.google.android.gms.ui,com.google.android.gms.persistent\n"
			"ro.retaildemo.video_path=/data/preloads/demo/retail_demo.mp4\n"
			"ro.com.android.prov_mobiledata=false\n"
			"keyguard.no_require_sim=true\n"
			"ro.facelock.black_timeout=700\n"
			"ro.facelock.det_timeout=2500\n"
			"ro.facelock.rec_timeout=3500\n"
			"ro.facelock.est_max_time=500\n"
			"camera.flash_off=0\n"
			"drm.service.enabled=true\n"
			"ro.com.widevine.cachesize=16777216\n"
			"fmas.spkr_6ch=35,20,110\n"
			"fmas.spkr_2ch=35,25\n"
			"fmas.spkr_angles=10\n"
			"fmas.spkr_sgain=0\n"
			"media.aac_51_output_enabled=true\n"
			"persist.sys.dalvik.vm.lib.2=libart.so\n"
			"dalvik.vm.isa.arm64.variant=denver64\n"
			"dalvik.vm.isa.arm64.features=default\n"
			"dalvik.vm.isa.arm.variant=denver\n"
			"dalvik.vm.isa.arm.features=default\n"
			"net.bt.name=Android\n"
			"dalvik.vm.stack-trace-file=/data/anr/traces.txt\n"
			"ro.build.expect.bootloader=3.50.0.0143\n"
			"ro.expect.recovery_id=0x93bff4385eaddb27367f1343ab6468f037ef2b7e000000000000000000000000\n"
			"\n",
	},
	{
		.path = "/sys/devices/system/cpu/kernel_max",
		.size = 2,
		.content = "1\n",
	},
	{
		.path = "/sys/devices/system/cpu/possible",
		.size = 4,
		.content = "0-1\n",
	},
	{
		.path = "/sys/devices/system/cpu/present",
		.size = 4,
		.content = "0-1\n",
	},
	{
		.path = "/sys/devices/system/cpu/online",
		.size = 4,
		.content = "0-1\n",
	},
	{
		.path = "/sys/devices/system/cpu/offline",
		.size = 1,
		.content = "\n",
	},
	{
		.path = "/sys/devices/system/cpu/modalias",
		.size = 61,
		.content = "cpu:type:aarch64:feature:,0000,0001,0003,0004,0005,0006,0007\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpufreq/all_time_in_state",
		.size = 773,
		.content =
			"freq\t\tcpu0\t\tcpu1\t\t\n"
			"204000\t\t0\t\t0\t\t\n"
			"229500\t\t0\t\t0\t\t\n"
			"255000\t\t0\t\t0\t\t\n"
			"280500\t\t0\t\t0\t\t\n"
			"306000\t\t0\t\t0\t\t\n"
			"331500\t\t0\t\t0\t\t\n"
			"357000\t\t0\t\t0\t\t\n"
			"382500\t\t0\t\t0\t\t\n"
			"408000\t\t0\t\t0\t\t\n"
			"433500\t\t0\t\t0\t\t\n"
			"459000\t\t0\t\t0\t\t\n"
			"484500\t\t0\t\t0\t\t\n"
			"510000\t\t11\t\t11\t\t\n"
			"535500\t\t0\t\t0\t\t\n"
			"561000\t\t0\t\t0\t\t\n"
			"586500\t\t0\t\t0\t\t\n"
			"612000\t\t2\t\t2\t\t\n"
			"637500\t\t4\t\t4\t\t\n"
			"663000\t\t0\t\t0\t\t\n"
			"688500\t\t844\t\t844\t\t\n"
			"714000\t\t2\t\t2\t\t\n"
			"739500\t\t0\t\t0\t\t\n"
			"765000\t\t0\t\t0\t\t\n"
			"790500\t\t0\t\t0\t\t\n"
			"816000\t\t3\t\t3\t\t\n"
			"841500\t\t0\t\t0\t\t\n"
			"867000\t\t0\t\t0\t\t\n"
			"892500\t\t0\t\t0\t\t\n"
			"918000\t\t0\t\t0\t\t\n"
			"943500\t\t3\t\t3\t\t\n"
			"969000\t\t0\t\t0\t\t\n"
			"994500\t\t24\t\t24\t\t\n"
			"1020000\t\t0\t\t0\t\t\n"
			"1122000\t\t4\t\t4\t\t\n"
			"1224000\t\t0\t\t0\t\t\n"
			"1326000\t\t1\t\t1\t\t\n"
			"1428000\t\t0\t\t0\t\t\n"
			"1530000\t\t26\t\t26\t\t\n"
			"1632000\t\t1\t\t1\t\t\n"
			"1734000\t\t6\t\t6\t\t\n"
			"1836000\t\t7\t\t7\t\t\n"
			"1938000\t\t3\t\t3\t\t\n"
			"2014500\t\t0\t\t0\t\t\n"
			"2091000\t\t1\t\t1\t\t\n"
			"2193000\t\t84\t\t84\t\t\n"
			"2295000\t\t1467\t\t1467\t\t\n"
			"2397000\t\t0\t\t0\t\t\n"
			"2499000\t\t0\t\t0\t\t\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpufreq/current_in_state",
		.size = 1397,
		.content =
			"CPU0:204000=92060 229500=103560 255000=115070 280500=126580 306000=138080 331500=149590 357000=161100 382500=172600 408000=184110 433500=195620 459000=207120 484500=218630 510000=230140 535500=241640 561000=253150 586500=264660 612000=276170 637500=287670 663000=299180 688500=310690 714000=322190 739500=333700 765000=345210 790500=356710 816000=377360 841500=389150 867000=400950 892500=412740 918000=441640 943500=453910 969000=466180 994500=478440 1020000=511520 1122000=587620 1224000=670620 1326000=761250 1428000=860270 1530000=968510 1632000=1086830 1734000=1215570 1836000=1356860 1938000=1511200 2014500=1570850 2091000=1769650 2193000=1961670 2295000=2170950 2397000=2398880 2499000=2646910 \n"
			"CPU1:204000=60759 229500=68349 255000=75946 280500=83542 306000=91132 331500=98729 357000=106326 382500=113916 408000=121512 433500=129109 459000=136699 484500=144295 510000=151892 535500=159482 561000=167079 586500=174675 612000=182272 637500=189862 663000=197458 688500=205055 714000=212645 739500=220242 765000=227838 790500=235428 816000=249057 841500=256839 867000=264627 892500=272408 918000=291482 943500=299580 969000=307678 994500=315770 1020000=337603 1122000=387829 1224000=442609 1326000=502425 1428000=567778 1530000=639216 1632000=717307 1734000=802276 1836000=895527 1938000=997392 2014500=1036761 2091000=1167969 2193000=1294702 2295000=1432827 2397000=1583260 2499000=1746960 \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpuidle/current_driver",
		.size = 12,
		.content = "denver_idle\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpuidle/current_governor_ro",
		.size = 5,
		.content = "menu\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/affected_cpus",
		.size = 4,
		.content = "0 1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/cpuinfo_max_freq",
		.size = 8,
		.content = "2499000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/cpuinfo_min_freq",
		.size = 7,
		.content = "204000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/cpuinfo_transition_latency",
		.size = 7,
		.content = "300000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/related_cpus",
		.size = 4,
		.content = "0 1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_available_frequencies",
		.size = 353,
		.content = "204000 229500 255000 280500 306000 331500 357000 382500 408000 433500 459000 484500 510000 535500 561000 586500 612000 637500 663000 688500 714000 739500 765000 790500 816000 841500 867000 892500 918000 943500 969000 994500 1020000 1122000 1224000 1326000 1428000 1530000 1632000 1734000 1836000 1938000 2014500 2091000 2193000 2295000 2397000 2499000 \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_available_governors",
		.size = 67,
		.content = "interactive conservative ondemand powersave userspace performance \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_cur_freq",
		.size = 8,
		.content = "1530000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_driver",
		.size = 6,
		.content = "tegra\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_governor",
		.size = 12,
		.content = "interactive\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_min_freq",
		.size = 8,
		.content = "1400000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/stats/time_in_state",
		.size = 459,
		.content =
			"204000 0\n"
			"229500 0\n"
			"255000 0\n"
			"280500 0\n"
			"306000 0\n"
			"331500 0\n"
			"357000 0\n"
			"382500 0\n"
			"408000 0\n"
			"433500 0\n"
			"459000 0\n"
			"484500 0\n"
			"510000 11\n"
			"535500 0\n"
			"561000 0\n"
			"586500 0\n"
			"612000 2\n"
			"637500 4\n"
			"663000 0\n"
			"688500 844\n"
			"714000 2\n"
			"739500 0\n"
			"765000 0\n"
			"790500 0\n"
			"816000 3\n"
			"841500 0\n"
			"867000 0\n"
			"892500 0\n"
			"918000 0\n"
			"943500 3\n"
			"969000 0\n"
			"994500 24\n"
			"1020000 0\n"
			"1122000 4\n"
			"1224000 0\n"
			"1326000 1\n"
			"1428000 0\n"
			"1530000 28\n"
			"1632000 8\n"
			"1734000 11\n"
			"1836000 11\n"
			"1938000 3\n"
			"2014500 0\n"
			"2091000 3\n"
			"2193000 89\n"
			"2295000 1556\n"
			"2397000 0\n"
			"2499000 0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/stats/total_trans",
		.size = 3,
		.content = "70\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/physical_package_id",
		.size = 3,
		.content = "-1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/core_siblings_list",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/core_siblings",
		.size = 2,
		.content = "1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/core_id",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/thread_siblings_list",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/thread_siblings",
		.size = 2,
		.content = "1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/affected_cpus",
		.size = 4,
		.content = "0 1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/cpuinfo_max_freq",
		.size = 8,
		.content = "2499000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/cpuinfo_min_freq",
		.size = 7,
		.content = "204000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/cpuinfo_transition_latency",
		.size = 7,
		.content = "300000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/related_cpus",
		.size = 4,
		.content = "0 1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_available_frequencies",
		.size = 353,
		.content = "204000 229500 255000 280500 306000 331500 357000 382500 408000 433500 459000 484500 510000 535500 561000 586500 612000 637500 663000 688500 714000 739500 765000 790500 816000 841500 867000 892500 918000 943500 969000 994500 1020000 1122000 1224000 1326000 1428000 1530000 1632000 1734000 1836000 1938000 2014500 2091000 2193000 2295000 2397000 2499000 \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_available_governors",
		.size = 67,
		.content = "interactive conservative ondemand powersave userspace performance \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_cur_freq",
		.size = 7,
		.content = "637500\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_driver",
		.size = 6,
		.content = "tegra\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_governor",
		.size = 12,
		.content = "interactive\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_min_freq",
		.size = 7,
		.content = "510000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/stats/time_in_state",
		.size = 465,
		.content =
			"204000 0\n"
			"229500 0\n"
			"255000 0\n"
			"280500 0\n"
			"306000 0\n"
			"331500 0\n"
			"357000 0\n"
			"382500 0\n"
			"408000 0\n"
			"433500 0\n"
			"459000 0\n"
			"484500 0\n"
			"510000 84\n"
			"535500 2\n"
			"561000 2\n"
			"586500 6\n"
			"612000 4\n"
			"637500 42\n"
			"663000 11\n"
			"688500 846\n"
			"714000 10\n"
			"739500 0\n"
			"765000 15\n"
			"790500 0\n"
			"816000 3\n"
			"841500 0\n"
			"867000 0\n"
			"892500 0\n"
			"918000 0\n"
			"943500 3\n"
			"969000 0\n"
			"994500 24\n"
			"1020000 0\n"
			"1122000 8\n"
			"1224000 0\n"
			"1326000 1\n"
			"1428000 33\n"
			"1530000 58\n"
			"1632000 18\n"
			"1734000 21\n"
			"1836000 30\n"
			"1938000 3\n"
			"2014500 0\n"
			"2091000 3\n"
			"2193000 89\n"
			"2295000 1556\n"
			"2397000 0\n"
			"2499000 0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/stats/total_trans",
		.size = 4,
		.content = "105\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/physical_package_id",
		.size = 3,
		.content = "-1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/core_siblings_list",
		.size = 2,
		.content = "1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/core_siblings",
		.size = 2,
		.content = "2\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/core_id",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/thread_siblings_list",
		.size = 2,
		.content = "1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/thread_siblings",
		.size = 2,
		.content = "2\n",
	},
	{ NULL },
};

#ifdef __ANDROID__
struct cpuinfo_mock_property properties[] = {
	{
		.key = "af.fast_track_multiplier",
		.value = "1",
	},
	{
		.key = "audio_hal.period_size",
		.value = "128",
	},
	{
		.key = "camera.flash_off",
		.value = "0",
	},
	{
		.key = "dalvik.vm.appimageformat",
		.value = "lz4",
	},
	{
		.key = "dalvik.vm.dex2oat-Xms",
		.value = "64m",
	},
	{
		.key = "dalvik.vm.dex2oat-Xmx",
		.value = "512m",
	},
	{
		.key = "dalvik.vm.heapgrowthlimit",
		.value = "192m",
	},
	{
		.key = "dalvik.vm.heapmaxfree",
		.value = "8m",
	},
	{
		.key = "dalvik.vm.heapminfree",
		.value = "512k",
	},
	{
		.key = "dalvik.vm.heapsize",
		.value = "512m",
	},
	{
		.key = "dalvik.vm.heapstartsize",
		.value = "16m",
	},
	{
		.key = "dalvik.vm.heaptargetutilization",
		.value = "0.75",
	},
	{
		.key = "dalvik.vm.image-dex2oat-Xms",
		.value = "64m",
	},
	{
		.key = "dalvik.vm.image-dex2oat-Xmx",
		.value = "64m",
	},
	{
		.key = "dalvik.vm.isa.arm.features",
		.value = "default",
	},
	{
		.key = "dalvik.vm.isa.arm.variant",
		.value = "denver",
	},
	{
		.key = "dalvik.vm.isa.arm64.features",
		.value = "default",
	},
	{
		.key = "dalvik.vm.isa.arm64.variant",
		.value = "denver64",
	},
	{
		.key = "dalvik.vm.stack-trace-file",
		.value = "/data/anr/traces.txt",
	},
	{
		.key = "dalvik.vm.usejit",
		.value = "true",
	},
	{
		.key = "dalvik.vm.usejitprofiles",
		.value = "true",
	},
	{
		.key = "debug.atrace.tags.enableflags",
		.value = "0",
	},
	{
		.key = "debug.force_rtl",
		.value = "0",
	},
	{
		.key = "drm.service.enabled",
		.value = "true",
	},
	{
		.key = "fmas.spkr_2ch",
		.value = "35,25",
	},
	{
		.key = "fmas.spkr_6ch",
		.value = "35,20,110",
	},
	{
		.key = "fmas.spkr_angles",
		.value = "10",
	},
	{
		.key = "fmas.spkr_sgain",
		.value = "0",
	},
	{
		.key = "gsm.current.phone-type",
		.value = "1",
	},
	{
		.key = "gsm.network.type",
		.value = "Unknown",
	},
	{
		.key = "gsm.sim.operator.alpha",
		.value = "",
	},
	{
		.key = "gsm.sim.operator.iso-country",
		.value = "",
	},
	{
		.key = "gsm.sim.operator.numeric",
		.value = "",
	},
	{
		.key = "gsm.sim.state",
		.value = "NOT_READY",
	},
	{
		.key = "init.svc.adbd",
		.value = "running",
	},
	{
		.key = "init.svc.audioserver",
		.value = "running",
	},
	{
		.key = "init.svc.bootanim",
		.value = "running",
	},
	{
		.key = "init.svc.cameraserver",
		.value = "running",
	},
	{
		.key = "init.svc.debuggerd",
		.value = "running",
	},
	{
		.key = "init.svc.debuggerd64",
		.value = "running",
	},
	{
		.key = "init.svc.drm",
		.value = "running",
	},
	{
		.key = "init.svc.flash_recovery",
		.value = "stopped",
	},
	{
		.key = "init.svc.gatekeeperd",
		.value = "running",
	},
	{
		.key = "init.svc.gpsd",
		.value = "running",
	},
	{
		.key = "init.svc.healthd",
		.value = "running",
	},
	{
		.key = "init.svc.installd",
		.value = "running",
	},
	{
		.key = "init.svc.keystore",
		.value = "running",
	},
	{
		.key = "init.svc.lmkd",
		.value = "running",
	},
	{
		.key = "init.svc.logd",
		.value = "running",
	},
	{
		.key = "init.svc.logd-reinit",
		.value = "stopped",
	},
	{
		.key = "init.svc.media",
		.value = "running",
	},
	{
		.key = "init.svc.mediacodec",
		.value = "running",
	},
	{
		.key = "init.svc.mediadrm",
		.value = "running",
	},
	{
		.key = "init.svc.mediaextractor",
		.value = "running",
	},
	{
		.key = "init.svc.netd",
		.value = "running",
	},
	{
		.key = "init.svc.p2p_supplicant",
		.value = "running",
	},
	{
		.key = "init.svc.servicemanager",
		.value = "running",
	},
	{
		.key = "init.svc.surfaceflinger",
		.value = "running",
	},
	{
		.key = "init.svc.tlk_daemon",
		.value = "running",
	},
	{
		.key = "init.svc.ueventd",
		.value = "running",
	},
	{
		.key = "init.svc.vold",
		.value = "running",
	},
	{
		.key = "init.svc.watchdogd",
		.value = "running",
	},
	{
		.key = "init.svc.zygote",
		.value = "running",
	},
	{
		.key = "init.svc.zygote_secondary",
		.value = "running",
	},
	{
		.key = "keyguard.no_require_sim",
		.value = "true",
	},
	{
		.key = "media.aac_51_output_enabled",
		.value = "true",
	},
	{
		.key = "net.bt.name",
		.value = "Android",
	},
	{
		.key = "net.change",
		.value = "net.qtaguid_enabled",
	},
	{
		.key = "net.hostname",
		.value = "android-bace03474dcf1dcc",
	},
	{
		.key = "net.qtaguid_enabled",
		.value = "1",
	},
	{
		.key = "net.tcp.default_init_rwnd",
		.value = "60",
	},
	{
		.key = "partition.system.verified",
		.value = "2",
	},
	{
		.key = "partition.vendor.verified",
		.value = "2",
	},
	{
		.key = "persist.sys.dalvik.vm.lib.2",
		.value = "libart.so",
	},
	{
		.key = "persist.sys.profiler_ms",
		.value = "0",
	},
	{
		.key = "persist.sys.timezone",
		.value = "America/Los_Angeles",
	},
	{
		.key = "persist.sys.usb.config",
		.value = "mtp,adb",
	},
	{
		.key = "persist.sys.webview.vmsize",
		.value = "121768048",
	},
	{
		.key = "persist.tegra.compositor",
		.value = "glcomposer",
	},
	{
		.key = "pm.dexopt.ab-ota",
		.value = "speed-profile",
	},
	{
		.key = "pm.dexopt.bg-dexopt",
		.value = "speed-profile",
	},
	{
		.key = "pm.dexopt.boot",
		.value = "verify-profile",
	},
	{
		.key = "pm.dexopt.core-app",
		.value = "speed",
	},
	{
		.key = "pm.dexopt.first-boot",
		.value = "interpret-only",
	},
	{
		.key = "pm.dexopt.forced-dexopt",
		.value = "speed",
	},
	{
		.key = "pm.dexopt.install",
		.value = "interpret-only",
	},
	{
		.key = "pm.dexopt.nsys-library",
		.value = "speed",
	},
	{
		.key = "pm.dexopt.shared-apk",
		.value = "speed",
	},
	{
		.key = "ro.adb.secure",
		.value = "1",
	},
	{
		.key = "ro.allow.mock.location",
		.value = "0",
	},
	{
		.key = "ro.atrace.core.services",
		.value = "com.google.android.gms,com.google.android.gms.ui,com.google.android.gms.persistent",
	},
	{
		.key = "ro.audio.monitorRotation",
		.value = "true",
	},
	{
		.key = "ro.baseband",
		.value = "N/A",
	},
	{
		.key = "ro.board.platform",
		.value = "tegra132",
	},
	{
		.key = "ro.boot.baseband",
		.value = "N/A",
	},
	{
		.key = "ro.boot.bootloader",
		.value = "3.50.0.0143",
	},
	{
		.key = "ro.boot.bootreason",
		.value = "reboot",
	},
	{
		.key = "ro.boot.hardware",
		.value = "flounder",
	},
	{
		.key = "ro.boot.misc_pagesize",
		.value = "2048",
	},
	{
		.key = "ro.boot.mode",
		.value = "normal",
	},
	{
		.key = "ro.boot.serialno",
		.value = "HT4CSJT01353",
	},
	{
		.key = "ro.boot.wificountrycode",
		.value = "US",
	},
	{
		.key = "ro.bootimage.build.date",
		.value = "Mon Apr 24 19:32:57 UTC 2017",
	},
	{
		.key = "ro.bootimage.build.date.utc",
		.value = "1493062377",
	},
	{
		.key = "ro.bootimage.build.fingerprint",
		.value = "google/volantis/flounder:7.1.1/N9F27C/3938480:user/release-keys",
	},
	{
		.key = "ro.bootloader",
		.value = "3.50.0.0143",
	},
	{
		.key = "ro.bootmode",
		.value = "normal",
	},
	{
		.key = "ro.bt.bdaddr_path",
		.value = "/sys/module/flounder_bdaddress/parameters/bdaddress",
	},
	{
		.key = "ro.build.characteristics",
		.value = "tablet,nosdcard",
	},
	{
		.key = "ro.build.date",
		.value = "Mon Apr 24 19:32:57 UTC 2017",
	},
	{
		.key = "ro.build.date.utc",
		.value = "1493062377",
	},
	{
		.key = "ro.build.description",
		.value = "volantis-user 7.1.1 N9F27C 3938480 release-keys",
	},
	{
		.key = "ro.build.display.id",
		.value = "N9F27C",
	},
	{
		.key = "ro.build.expect.bootloader",
		.value = "3.50.0.0143",
	},
	{
		.key = "ro.build.fingerprint",
		.value = "google/volantis/flounder:7.1.1/N9F27C/3938480:user/release-keys",
	},
	{
		.key = "ro.build.flavor",
		.value = "volantis-user",
	},
	{
		.key = "ro.build.host",
		.value = "wphn4.hot.corp.google.com",
	},
	{
		.key = "ro.build.id",
		.value = "N9F27C",
	},
	{
		.key = "ro.build.product",
		.value = "flounder",
	},
	{
		.key = "ro.build.tags",
		.value = "release-keys",
	},
	{
		.key = "ro.build.type",
		.value = "user",
	},
	{
		.key = "ro.build.user",
		.value = "android-build",
	},
	{
		.key = "ro.build.version.all_codenames",
		.value = "REL",
	},
	{
		.key = "ro.build.version.base_os",
		.value = "",
	},
	{
		.key = "ro.build.version.codename",
		.value = "REL",
	},
	{
		.key = "ro.build.version.incremental",
		.value = "3938480",
	},
	{
		.key = "ro.build.version.preview_sdk",
		.value = "0",
	},
	{
		.key = "ro.build.version.release",
		.value = "7.1.1",
	},
	{
		.key = "ro.build.version.sdk",
		.value = "25",
	},
	{
		.key = "ro.build.version.security_patch",
		.value = "2017-06-05",
	},
	{
		.key = "ro.carrier",
		.value = "unknown",
	},
	{
		.key = "ro.com.android.dataroaming",
		.value = "false",
	},
	{
		.key = "ro.com.android.prov_mobiledata",
		.value = "false",
	},
	{
		.key = "ro.com.android.wifi-watchlist",
		.value = "GoogleGuest",
	},
	{
		.key = "ro.com.google.clientidbase",
		.value = "android-google",
	},
	{
		.key = "ro.com.widevine.cachesize",
		.value = "16777216",
	},
	{
		.key = "ro.config.alarm_alert",
		.value = "Oxygen.ogg",
	},
	{
		.key = "ro.config.notification_sound",
		.value = "Tethys.ogg",
	},
	{
		.key = "ro.config.ringtone",
		.value = "Girtab.ogg",
	},
	{
		.key = "ro.crypto.fs_crypto_blkdev",
		.value = "/dev/block/dm-2",
	},
	{
		.key = "ro.crypto.state",
		.value = "encrypted",
	},
	{
		.key = "ro.crypto.type",
		.value = "block",
	},
	{
		.key = "ro.dalvik.vm.native.bridge",
		.value = "0",
	},
	{
		.key = "ro.debuggable",
		.value = "0",
	},
	{
		.key = "ro.enable_boot_charger_mode",
		.value = "1",
	},
	{
		.key = "ro.error.receiver.system.apps",
		.value = "com.google.android.gms",
	},
	{
		.key = "ro.expect.recovery_id",
		.value = "0x93bff4385eaddb27367f1343ab6468f037ef2b7e000000000000000000000000",
	},
	{
		.key = "ro.facelock.black_timeout",
		.value = "700",
	},
	{
		.key = "ro.facelock.det_timeout",
		.value = "2500",
	},
	{
		.key = "ro.facelock.est_max_time",
		.value = "500",
	},
	{
		.key = "ro.facelock.rec_timeout",
		.value = "3500",
	},
	{
		.key = "ro.frp.pst",
		.value = "/dev/block/platform/sdhci-tegra.3/by-name/PST",
	},
	{
		.key = "ro.hardware",
		.value = "flounder",
	},
	{
		.key = "ro.hardware.gps",
		.value = "bcm47521",
	},
	{
		.key = "ro.hwui.disable_scissor_opt",
		.value = "true",
	},
	{
		.key = "ro.hwui.drop_shadow_cache_size",
		.value = "6",
	},
	{
		.key = "ro.hwui.gradient_cache_size",
		.value = "1",
	},
	{
		.key = "ro.hwui.layer_cache_size",
		.value = "48",
	},
	{
		.key = "ro.hwui.path_cache_size",
		.value = "32",
	},
	{
		.key = "ro.hwui.r_buffer_cache_size",
		.value = "8",
	},
	{
		.key = "ro.hwui.text_large_cache_height",
		.value = "1024",
	},
	{
		.key = "ro.hwui.text_large_cache_width",
		.value = "2048",
	},
	{
		.key = "ro.hwui.text_small_cache_height",
		.value = "1024",
	},
	{
		.key = "ro.hwui.text_small_cache_width",
		.value = "1024",
	},
	{
		.key = "ro.hwui.texture_cache_flushrate",
		.value = "0.4",
	},
	{
		.key = "ro.hwui.texture_cache_size",
		.value = "72",
	},
	{
		.key = "ro.opengles.version",
		.value = "196609",
	},
	{
		.key = "ro.product.board",
		.value = "flounder",
	},
	{
		.key = "ro.product.brand",
		.value = "google",
	},
	{
		.key = "ro.product.cpu.abi",
		.value = "arm64-v8a",
	},
	{
		.key = "ro.product.cpu.abilist",
		.value = "arm64-v8a,armeabi-v7a,armeabi",
	},
	{
		.key = "ro.product.cpu.abilist32",
		.value = "armeabi-v7a,armeabi",
	},
	{
		.key = "ro.product.cpu.abilist64",
		.value = "arm64-v8a",
	},
	{
		.key = "ro.product.device",
		.value = "flounder",
	},
	{
		.key = "ro.product.locale",
		.value = "en-US",
	},
	{
		.key = "ro.product.manufacturer",
		.value = "htc",
	},
	{
		.key = "ro.product.model",
		.value = "Nexus 9",
	},
	{
		.key = "ro.product.name",
		.value = "volantis",
	},
	{
		.key = "ro.radio.noril",
		.value = "true",
	},
	{
		.key = "ro.recovery_id",
		.value = "0x0000000000000000000000000000000000000000000000000000000000000000",
	},
	{
		.key = "ro.retaildemo.video_path",
		.value = "/data/preloads/demo/retail_demo.mp4",
	},
	{
		.key = "ro.revision",
		.value = "0",
	},
	{
		.key = "ro.ril.def.agps.mode",
		.value = "1",
	},
	{
		.key = "ro.secure",
		.value = "1",
	},
	{
		.key = "ro.serialno",
		.value = "HT4CSJT01353",
	},
	{
		.key = "ro.setupwizard.enterprise_mode",
		.value = "1",
	},
	{
		.key = "ro.sf.lcd_density",
		.value = "320",
	},
	{
		.key = "ro.url.legal",
		.value = "http://www.google.com/intl/%s/mobile/android/basic/phone-legal.html",
	},
	{
		.key = "ro.url.legal.android_privacy",
		.value = "http://www.google.com/intl/%s/mobile/android/basic/privacy.html",
	},
	{
		.key = "ro.vendor.build.date",
		.value = "Mon Apr 24 19:32:57 UTC 2017",
	},
	{
		.key = "ro.vendor.build.date.utc",
		.value = "1493062377",
	},
	{
		.key = "ro.vendor.build.fingerprint",
		.value = "google/volantis/flounder:7.1.1/N9F27C/3938480:user/release-keys",
	},
	{
		.key = "ro.wifi.channels",
		.value = "",
	},
	{
		.key = "ro.zygote",
		.value = "zygote64_32",
	},
	{
		.key = "security.perf_harden",
		.value = "1",
	},
	{
		.key = "selinux.reload_policy",
		.value = "1",
	},
	{
		.key = "service.bootanim.exit",
		.value = "0",
	},
	{
		.key = "sys.oem_unlock_allowed",
		.value = "0",
	},
	{
		.key = "sys.sysctl.extra_free_kbytes",
		.value = "36864",
	},
	{
		.key = "sys.usb.config",
		.value = "mtp,adb",
	},
	{
		.key = "sys.usb.configfs",
		.value = "0",
	},
	{
		.key = "sys.usb.ffs.ready",
		.value = "1",
	},
	{
		.key = "sys.usb.state",
		.value = "mtp,adb",
	},
	{
		.key = "vold.decrypt",
		.value = "trigger_restart_framework",
	},
	{
		.key = "vold.has_adoptable",
		.value = "0",
	},
	{
		.key = "vold.post_fs_data_done",
		.value = "1",
	},
	{
		.key = "wifi.interface",
		.value = "wlan0",
	},
	{
		.key = "wlan.driver.status",
		.value = "ok",
	},
	{ NULL },
};
#endif /* __ANDROID__ */
