/*
This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License as
published by the Free Software Foundation; either version 2, or (at
your option) any later version.

This program is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

Copyright (c) Andrew St. Jean <andrew@arda.homeunix.nst> 2002

Provide logging facilities

*/

#ifndef LOGGING_H_
#define LOGGING_H_ 1

#include <stdio.h>
#include <syslog.h>

extern int opt_stderr;
extern int opt_verbose;

#define init_logging() \
	do { \
		openlog("courierpassd", LOG_PID, LOG_AUTHPRIV); \
	} while (0)

#define end_logging() \
	do { \
		closelog(); \
	} while (0)

#define logging(priority, msg, args...) \
	do { \
		if (opt_stderr) { \
			fprintf(stderr, msg, ##args); \
			fputc('\n', stderr);\
		} else { \
			syslog(priority, msg, ##args); \
		} \
	} while (0)

#define verbose(msg, args...) \
	do { \
		if (opt_verbose) { \
			fprintf(stderr, msg , ##args); \
			fputc('\n', stderr); \
		} \
	} while (0)

#endif /* LOGGING_H_ */
