var UI = new UbuntuUI();

document.addEventListener("deviceready", onDeviceReady, false);

var SCAN_HISTORY_KEY='scan-code-history-key';

function appendScantoHistory(data) {
    if ( ! window.localStorage || ! data) {
	return;
    }
    if ( ! window.localStorage.getItem(SCAN_HISTORY_KEY)) {
	window.localStorage.setItem(SCAN_HISTORY_KEY, JSON.stringify([]));
    }

    function saveScanResultTakenAtPosition(position) {
	var history = JSON.parse(window.localStorage.getItem(SCAN_HISTORY_KEY));
	history.push({data: data, time: new Date(), location: position.coords});
	window.localStorage.setItem(SCAN_HISTORY_KEY, JSON.stringify(history));
    };

    function geolocationError(error) {
	console.log(error);
    };

    // disabled since the geolocation backend does not seem to work
    //  in my quick tests ...
/*
    navigator.geolocation.getCurrentPosition(
	saveScanResultTakenAtPosition,
        geolocationError,
        { maximumAge: 3000, timeout: 5000, enableHighAccuracy: true });
*/

    // ... instead we just save the result with a dummy position (guess which one!)
    saveScanResultTakenAtPosition({coords: {latitude: '34.943742', longitude:'136.888269'}});
};

function displayScannedResults(data) {
    document.getElementById('scan-results').innerHTML = data;
};

function doScanCode() {
    // Error strings returned by the qrcode js library, so that
    //  we can try (even with false positives) to identify scanning
    //  errors & user cancelled operations

    var ERROR_STRING = 'error decoding QR Code';
    var CANCELLED_SCAN = 'canceled';

    var onQrScanningComplete = function(data) {
	navigator.notification.vibrate(1000);

	displayScannedResults(data);

	UI.dialog('scanning').hide();

	if (data != ERROR_STRING && data != CANCELLED_SCAN)
	    appendScantoHistory(data);
    };

    var onPictureTaken = function (data) {
	qrcode.callback = onQrScanningComplete;

	UI.dialog('scanning').show();

	qrcode.decode("data:image/jpeg;base64," + data);
    };

    var onPictureErrors = function(message) {
	console.log('Scan Code error: ' + message);
    };

    navigator.camera.getPicture(onPictureTaken,
				onPictureErrors,
				{ quality: 100,
				  targetWidth: 300,
				  targetHeight: 300,
				  sourceType: Camera.PictureSourceType.CAMERA,
				  encodingType: Camera.EncodingType.JPEG,
				  destinationType: Camera.DestinationType.DATA_URL });
};

function onHistoryList() {
    if ( ! window.localStorage.getItem(SCAN_HISTORY_KEY))
	return;

    var history = JSON.parse(window.localStorage.getItem(SCAN_HISTORY_KEY));

    UI.list('#history-items-list').removeAllItems();

    history.forEach(function (element) {
	UI.list('#history-items-list').append(element.data,
					      // the label for this item
					      element.time,
					      // no specific 'id'
					      null,
					      // onclick handler
					      function (targetNode, location) {
						  // We use the Cordova inappbrowser 'API'
						  window.open('https://maps.google.ca/maps?safe=off&q=' + location.latitude + '+' + location.longitude);
					      },
					      element.location);
    });
};

function onDeviceReady() {
    UI.init();

    // Set up the app by pushing the main view
    UI.pagestack.push("main-page");

    // Wire up the pages logic
    UI.button('scan').click(function (e) {
	UI.pagestack.push('scan-page',
			  {subtitle: 'Scan Code'});
	displayScannedResults('');
    });

    UI.button('history').click(function (e) {
	UI.pagestack.push('history-page',
			  {subtitle: 'Scan History'});
	onHistoryList();
    });

/*
    UI.button('clear-history-list').click(function (e) {
	if (window.localStorage.getItem(SCAN_HISTORY_KEY)) {
	    window.localStorage.setItem(SCAN_HISTORY_KEY, JSON.stringify([]));
	    UI.list('#history-items-list').removeAllItems();
	}
    });
*/

    UI.button('info').click(function (e) {
	UI.pagestack.push('info-page',
			  {subtitle: 'Application Info'});
    });

    UI.button('do-scan').click(function () {
	doScanCode();
    });
};

