#include <iostream>
#include <catch.hpp>
#include <map>

#include "chk-systemd.h"

using namespace std;

TEST_CASE("should create object bus", "[ChkBus]") {
  ChkBus *bus = new ChkBus();

  REQUIRE(bus != NULL);
  REQUIRE(bus->isConnected() == false);

  delete bus;
}

TEST_CASE("should connect to systemd bus", "[ChkBus]") {
  ChkBus *bus = new ChkBus();

  REQUIRE_NOTHROW(bus->connect());
  REQUIRE(bus->isConnected() == true);
  bus->disconnect();
  REQUIRE(bus->isConnected() == false);

  delete bus;
}

TEST_CASE("should get list of unit files", "[ChkBus]") {
  ChkBus *bus = new ChkBus();
  bool sshServiceFound = false;

  vector<UnitInfo *> files = bus->getUnitFiles();

  int foundCount = 0;

  for (auto file : files) {
    string id(file->id);
    string path(file->unitPath);

    if (path.find(id) == std::string::npos) {
      REQUIRE( true == false );
    }
  }

  delete bus;
}

TEST_CASE("should get list of units", "[ChkBus]") {
  ChkBus *bus = new ChkBus();
  bool sshServiceFound = false;

  REQUIRE_NOTHROW(bus->connect());

  vector<UnitInfo *> units;

  REQUIRE_NOTHROW((units = bus->getAllUnits()));
  REQUIRE(typeid(*units[0]) == typeid(UnitInfo));
  REQUIRE(typeid(units[0]->id) == typeid(const char *));
  REQUIRE(string(units[0]->id).length() > 0);

  for (auto unit : units) {
    if (string(unit->id).find("ssh.service") == 0) {
      sshServiceFound = true;
    }
  }

  REQUIRE(sshServiceFound == true);

  delete bus;
}

TEST_CASE("should get all units", "[ChkBus]") {
  ChkBus *bus = new ChkBus();

  auto allUnits = bus->getAllUnits();
  auto units = bus->getUnits();

  REQUIRE(allUnits.size() > units.size());

  allUnits.clear();
  units.clear();

  delete bus;
}

TEST_CASE("should be able enable/disable unit", "[ChkBus]") {
  ChkBus *bus = new ChkBus();

  REQUIRE_NOTHROW(bus->enableUnit("ssh.service"));

  for (auto unit : bus->getAllUnits()) {
    if (string(unit->id).find("ssh.service") == 0) {
      REQUIRE(string(unit->state).find("enabled") == 0);
      break;
    }
  }

  REQUIRE_NOTHROW(bus->disableUnit("ssh.service"));
  REQUIRE_NOTHROW(bus->reloadDaemon());

  for (auto unit : bus->getAllUnits()) {
    if (string(unit->id).find("ssh.service") == 0) {
      REQUIRE(string(unit->state).find("disabled") == 0);
      break;
    }
  }

  delete bus;
}

TEST_CASE("should be able start/stop unit", "[ChkBus]") {
  ChkBus *bus = new ChkBus();

  REQUIRE_NOTHROW(bus->stopUnit("ssh.service"));

  for (auto unit : bus->getAllUnits()) {
    if (string(unit->id).compare("ssh.service") == 0) {
      REQUIRE(unit->loadState == NULL);
      break;
    }
  }

  REQUIRE_NOTHROW(bus->startUnit("ssh.service"));

  for (auto unit : bus->getAllUnits()) {
    if (string(unit->id).compare("ssh.service") == 0) {
      REQUIRE(unit->loadState != NULL);
      break;
    }
  }

  delete bus;
}
