
from __future__ import absolute_import, division, print_function
import libtbx.load_env
import sys
from mmtbx.monomer_library import server
from mmtbx.monomer_library import pdb_interpretation
from six.moves import cStringIO as StringIO
from libtbx.utils import format_cpu_times

protein_pdb_str = """
ATOM      1  N   SER C   2      34.351  13.914  38.850  1.00 25.20           N
ATOM      2  CA  SER C   2      35.564  14.555  38.349  1.00 23.89           C
ATOM      3  C   SER C   2      35.509  14.878  36.846  1.00 22.90           C
ATOM      4  O   SER C   2      35.800  16.010  36.460  1.00 23.08           O
ATOM      5  CB  SER C   2      36.790  13.687  38.657  1.00 23.11           C
ATOM      6  OG  SER C   2      36.939  13.492  40.053  1.00 21.13           O
ATOM      7  N   PRO C   3      35.146  13.899  35.989  1.00 22.39           N
ATOM      8  CA  PRO C   3      35.107  14.258  34.566  1.00 19.74           C
ATOM      9  C   PRO C   3      34.000  15.256  34.228  1.00 13.82           C
ATOM     10  O   PRO C   3      34.193  16.119  33.371  1.00 12.80           O
ATOM     11  CB  PRO C   3      34.857  12.915  33.872  1.00 23.07           C
ATOM     12  CG  PRO C   3      34.164  12.092  34.890  1.00 24.21           C
ATOM     13  CD  PRO C   3      34.778  12.485  36.199  1.00 23.79           C
ATOM     14  N   LEU C   4      32.857  15.135  34.897  1.00 11.29           N
ATOM     15  CA  LEU C   4      31.727  16.026  34.654  1.00  9.66           C
ATOM     16  C   LEU C   4      32.034  17.454  35.105  1.00  7.86           C
ATOM     17  O   LEU C   4      31.610  18.416  34.465  1.00  7.65           O
ATOM     18  CB  LEU C   4      30.456  15.496  35.345  1.00 10.57           C
ATOM     19  CG  LEU C   4      30.191  15.483  36.863  1.00 11.83           C
ATOM     20  CD1 LEU C   4      29.728  16.845  37.386  1.00 12.67           C
ATOM     21  CD2 LEU C   4      31.376  14.965  37.676  1.00 13.04           C
ATOM     22  N   ALA C   5      32.770  17.587  36.205  1.00  8.13           N
ATOM     23  CA  ALA C   5      33.144  18.900  36.719  1.00  8.04           C
ATOM     24  C   ALA C   5      34.126  19.589  35.777  1.00  7.24           C
ATOM     25  O   ALA C   5      34.030  20.794  35.529  1.00  6.98           O
ATOM     26  CB  ALA C   5      33.740  18.775  38.112  1.00  9.33           C
ATOM     27  N   GLN C   6      35.065  18.813  35.246  1.00  6.89           N
ATOM     28  CA  GLN C   6      36.032  19.335  34.292  1.00  7.52           C
ATOM     29  C   GLN C   6      35.326  19.718  33.000  1.00  5.67           C
ATOM     30  O   GLN C   6      35.664  20.719  32.364  1.00  5.64           O
ATOM     31  CB  GLN C   6      37.135  18.311  34.017  1.00  9.58           C
ATOM     32  CG  GLN C   6      38.024  18.016  35.215  1.00 12.45           C
ATOM     33  CD  GLN C   6      38.792  19.235  35.688  1.00 16.41           C
ATOM     34  OE1 GLN C   6      39.169  20.095  34.891  1.00 17.91           O
ATOM     35  NE2 GLN C   6      39.026  19.317  36.993  1.00 18.48           N
ATOM     36  N   GLN C   7      34.330  18.921  32.627  1.00  5.24           N
ATOM     37  CA  GLN C   7      33.571  19.174  31.411  1.00  4.92           C
ATOM     38  C   GLN C   7      32.744  20.449  31.523  1.00  4.44           C
ATOM     39  O   GLN C   7      32.739  21.270  30.609  1.00  4.63           O
ATOM     40  CB  GLN C   7      32.661  17.985  31.094  1.00  5.87           C
ATOM     41  CG  GLN C   7      31.868  18.136  29.805  1.00  8.74           C
ATOM     42  CD  GLN C   7      31.016  16.920  29.500  1.00 11.90           C
ATOM     43  OE1 GLN C   7      31.059  15.921  30.219  1.00 17.10           O
ATOM     44  NE2 GLN C   7      30.235  16.999  28.429  1.00 12.32           N
ATOM     45  N   ILE C   8      32.069  20.633  32.653  1.00  4.24           N
ATOM     46  CA  ILE C   8      31.246  21.823  32.833  1.00  4.30           C
ATOM     47  C   ILE C   8      32.114  23.072  33.008  1.00  4.16           C
ATOM     48  O   ILE C   8      31.758  24.146  32.517  1.00  5.21           O
ATOM     49  CB  ILE C   8      30.262  21.674  34.028  1.00  4.60           C
ATOM     50  CG1 ILE C   8      29.291  22.857  34.076  1.00  5.10           C
ATOM     51  CG2 ILE C   8      30.995  21.526  35.350  1.00  4.97           C
ATOM     52  CD1 ILE C   8      28.415  22.977  32.848  1.00  5.70           C
ATOM     53  N   LYS C   9      33.252  22.941  33.687  1.00  4.57           N
ATOM     54  CA  LYS C   9      34.120  24.099  33.882  1.00  5.70           C
ATOM     55  C   LYS C   9      34.801  24.516  32.574  1.00  5.50           C
ATOM     56  O   LYS C   9      34.930  25.712  32.300  1.00  6.01           O
ATOM     57  CB  LYS C   9      35.164  23.834  34.978  1.00  8.15           C
ATOM     58  CG  LYS C   9      36.291  22.887  34.608  1.00 13.11           C
ATOM     59  CD  LYS C   9      37.294  22.751  35.743  1.00 17.07           C
ATOM     60  CE  LYS C   9      36.641  22.185  36.994  1.00 20.09           C
ATOM     61  NZ  LYS C   9      37.615  22.041  38.112  1.00 22.35           N
ATOM     62  N   ASN C  10      35.227  23.550  31.761  1.00  5.00           N
ATOM     63  CA  ASN C  10      35.842  23.898  30.484  1.00  5.09           C
ATOM     64  C   ASN C  10      34.792  24.427  29.512  1.00  4.73           C
ATOM     65  O   ASN C  10      35.075  25.320  28.711  1.00  4.79           O
ATOM     66  CB  ASN C  10      36.618  22.712  29.883  1.00  5.93           C
ATOM     67  CG  ASN C  10      35.730  21.547  29.469  1.00  6.66           C
ATOM     68  OD1 ASN C  10      34.715  21.717  28.794  1.00  7.40           O
ATOM     69  ND2 ASN C  10      36.134  20.344  29.858  1.00  8.16           N
ATOM     70  N   ILE C  11      33.579  23.881  29.591  1.00  4.14           N
ATOM     71  CA  ILE C  11      32.485  24.354  28.750  1.00  4.17           C
ATOM     72  C   ILE C  11      32.165  25.800  29.101  1.00  4.30           C
ATOM     73  O   ILE C  11      31.964  26.636  28.216  1.00  4.57           O
ATOM     74  CB  ILE C  11      31.217  23.481  28.900  1.00  4.26           C
ATOM     75  CG1 ILE C  11      31.325  22.234  28.021  1.00  4.74           C
ATOM     76  CG2 ILE C  11      29.969  24.260  28.518  1.00  5.09           C
ATOM     77  CD1 ILE C  11      30.158  21.281  28.165  1.00  5.63           C
ATOM     78  N   GLU C  12      32.173  26.097  30.396  1.00  5.14           N
ATOM     79  CA  GLU C  12      31.933  27.453  30.866  1.00  6.72           C
ATOM     80  C   GLU C  12      33.067  28.362  30.404  1.00  5.62           C
ATOM     81  O   GLU C  12      32.845  29.523  30.048  1.00  6.01           O
ATOM     82  CB  GLU C  12      31.800  27.481  32.392  1.00  8.41           C
ATOM     83  CG  GLU C  12      31.326  28.810  32.968  1.00 10.55           C
ATOM     84  CD  GLU C  12      32.457  29.796  33.193  1.00 11.85           C
ATOM     85  OE1 GLU C  12      33.623  29.358  33.274  1.00 13.15           O
ATOM     86  OE2 GLU C  12      32.178  31.010  33.290  1.00 11.88           O
ATOM     87  N   SER C  13      34.281  27.822  30.391  1.00  5.36           N
ATOM     88  CA  SER C  13      35.443  28.605  29.996  0.48  5.54           C
ATOM     89  C   SER C  13      35.431  28.984  28.515  1.00  4.98           C
ATOM     90  O   SER C  13      35.623  30.158  28.175  1.00  5.24           O
ATOM     91  CB  SER C  13      36.728  27.839  30.320  0.48  7.24           C
ATOM     92  OG  SER C  13      37.874  28.579  29.935  0.48  8.58           O
ATOM     93  N   PHE C  14      35.187  28.019  27.630  1.00  4.22           N
ATOM     94  CA  PHE C  14      35.185  28.362  26.211  1.00  4.26           C
ATOM     95  C   PHE C  14      33.912  29.116  25.824  1.00  3.83           C
ATOM     96  O   PHE C  14      33.946  29.930  24.905  1.00  4.21           O
ATOM     97  CB  PHE C  14      35.434  27.135  25.298  1.00  4.34           C
ATOM     98  CG  PHE C  14      34.346  26.085  25.291  1.00  4.32           C
ATOM     99  CD1 PHE C  14      33.092  26.342  24.758  1.00  5.73           C
ATOM    100  CD2 PHE C  14      34.625  24.799  25.721  1.00  4.92           C
ATOM    101  CE1 PHE C  14      32.119  25.363  24.729  1.00  6.75           C
ATOM    102  CE2 PHE C  14      33.661  23.811  25.681  1.00  5.77           C
ATOM    103  CZ  PHE C  14      32.404  24.096  25.189  1.00  6.41           C
ATOM    104  N   ILE C  15      32.795  28.855  26.500  1.00  3.71           N
ATOM    105  CA  ILE C  15      31.581  29.610  26.195  1.00  3.57           C
ATOM    106  C   ILE C  15      31.766  31.066  26.631  1.00  3.45           C
ATOM    107  O   ILE C  15      31.252  31.976  25.984  1.00  3.86           O
ATOM    108  CB  ILE C  15      30.304  29.004  26.847  1.00  4.42           C
ATOM    109  CG1 ILE C  15      29.046  29.556  26.174  1.00  5.07           C
ATOM    110  CG2 ILE C  15      30.234  29.286  28.335  1.00  5.27           C
ATOM    111  CD1 ILE C  15      28.921  29.196  24.717  1.00  5.89           C
ATOM    112  N   HIS C  16      32.500  31.286  27.721  0.73  3.71           N
ATOM    113  CA  HIS C  16      32.766  32.646  28.182  0.73  3.79           C
ATOM    114  C   HIS C  16      33.758  33.374  27.274  0.73  3.39           C
ATOM    115  O   HIS C  16      33.541  34.536  26.904  0.73  3.85           O
ATOM    116  CB  HIS C  16      33.292  32.632  29.619  0.73  4.49           C
ATOM    117  CG  HIS C  16      33.579  33.994  30.170  0.73  5.87           C
ATOM    118  ND1 HIS C  16      32.610  34.965  30.298  0.73  8.05           N
ATOM    119  CD2 HIS C  16      34.728  34.546  30.627  0.73  5.56           C
ATOM    120  CE1 HIS C  16      33.148  36.057  30.810  0.73  7.55           C
ATOM    121  NE2 HIS C  16      34.432  35.830  31.019  0.73  6.08           N
ATOM    122  N   GLN C  17      34.833  32.685  26.896  0.73  3.40           N
ATOM    123  CA  GLN C  17      35.849  33.300  26.046  0.73  3.79           C
ATOM    124  C   GLN C  17      35.277  33.576  24.658  0.73  3.29           C
ATOM    125  O   GLN C  17      35.638  34.562  24.017  0.73  3.69           O
ATOM    126  CB  GLN C  17      37.107  32.426  25.957  0.73  4.26           C
ATOM    127  CG  GLN C  17      36.981  31.185  25.093  0.73  5.23           C
ATOM    128  CD  GLN C  17      38.258  30.368  25.057  0.73  7.38           C
ATOM    129  OE1 GLN C  17      39.173  30.590  25.850  0.73  8.36           O
ATOM    130  NE2 GLN C  17      38.326  29.416  24.133  0.73  9.04           N
ATOM    131  N   ALA C  18      34.390  32.700  24.196  1.00  3.36           N
ATOM    132  CA  ALA C  18      33.704  32.907  22.928  1.00  3.89           C
ATOM    133  C   ALA C  18      32.711  34.051  23.063  1.00  4.05           C
ATOM    134  O   ALA C  18      32.548  34.852  22.145  1.00  4.91           O
ATOM    135  CB  ALA C  18      33.001  31.643  22.480  1.00  4.53           C
ATOM    136  N   LYS C  19      32.068  34.137  24.225  1.00  4.37           N
ATOM    137  CA  LYS C  19      31.101  35.195  24.484  1.00  5.39           C
ATOM    138  C   LYS C  19      31.805  36.537  24.378  1.00  5.25           C
ATOM    139  O   LYS C  19      31.232  37.516  23.899  1.00  5.52           O
ATOM    140  CB  LYS C  19      30.456  35.032  25.862  1.00  6.50           C
ATOM    141  CG  LYS C  19      29.397  36.074  26.182  1.00  7.77           C
ATOM    142  CD  LYS C  19      28.842  35.886  27.585  1.00 10.16           C
ATOM    143  CE  LYS C  19      28.157  34.536  27.730  1.00 12.49           C
ATOM    144  NZ  LYS C  19      27.618  34.333  29.103  1.00 15.57           N
ATOM    145  N   ALA C  20      33.054  36.577  24.827  1.00  5.38           N
ATOM    146  CA  ALA C  20      33.869  37.769  24.640  1.00  5.88           C
ATOM    147  C   ALA C  20      34.255  37.929  23.167  1.00  5.38           C
ATOM    148  O   ALA C  20      34.229  39.034  22.626  1.00  6.73           O
ATOM    149  CB  ALA C  20      35.111  37.708  25.514  1.00  6.65           C
ATOM    150  N   ALA C  21      34.611  36.817  22.526  1.00  4.87           N
ATOM    151  CA  ALA C  21      35.030  36.822  21.124  1.00  5.54           C
ATOM    152  C   ALA C  21      33.874  36.868  20.120  1.00  4.89           C
ATOM    153  O   ALA C  21      33.628  37.898  19.493  1.00  5.59           O
ATOM    154  CB  ALA C  21      35.904  35.606  20.846  1.00  6.30           C
ATOM    155  N   GLY C  22      33.169  35.747  19.974  1.00  4.70           N
ATOM    156  CA  GLY C  22      32.123  35.622  18.971  1.00  4.84           C
ATOM    157  C   GLY C  22      31.060  34.606  19.349  1.00  4.56           C
ATOM    158  O   GLY C  22      31.318  33.683  20.120  1.00  5.92           O
ATOM    159  N   ARG C  23      29.869  34.747  18.777  1.00  4.30           N
ATOM    160  CA  ARG C  23      28.710  34.023  19.289  1.00  4.97           C
ATOM    161  C   ARG C  23      28.116  32.970  18.352  1.00  5.19           C
ATOM    162  O   ARG C  23      28.051  31.798  18.708  1.00  5.70           O
ATOM    163  CB  ARG C  23      27.613  35.021  19.669  1.00  5.52           C
ATOM    164  CG  ARG C  23      26.401  34.386  20.333  1.00  6.50           C
ATOM    165  CD  ARG C  23      25.368  35.434  20.715  1.00  7.51           C
ATOM    166  NE  ARG C  23      24.219  34.845  21.397  1.00  8.98           N
ATOM    167  CZ  ARG C  23      24.140  34.672  22.713  1.00 10.56           C
ATOM    168  NH1 ARG C  23      23.055  34.128  23.248  1.00 10.81           N
ATOM    169  NH2 ARG C  23      25.145  35.043  23.494  1.00 11.93           N
ATOM    170  N   MET C  24      27.705  33.380  17.156  0.69  5.87       seg N
ATOM    171  CA  MET C  24      26.942  32.498  16.270  0.69  7.12       seg C
ATOM    172  C   MET C  24      27.678  31.243  15.787  0.69  6.14       seg C
ATOM    173  O   MET C  24      27.095  30.156  15.762  0.69  5.80       seg O
ATOM    174  CB  MET C  24      26.452  33.294  15.055  0.69  9.83       seg C
ATOM    175  CG  MET C  24      27.541  34.062  14.321  0.69 13.17       seg C
ATOM    176  SD  MET C  24      26.891  35.077  12.980  0.69 13.65       seg S
ATOM    177  CE  MET C  24      25.967  36.304  13.900  0.69 13.09       seg C
ATOM    178  N   ASP C  25      28.948  31.378  15.421  1.00  6.26       seg N
ATOM    179  CA  ASP C  25      29.705  30.234  14.921  1.00  6.70       seg C
ATOM    180  C   ASP C  25      29.990  29.217  16.025  1.00  5.34       seg C
ATOM    181  O   ASP C  25      29.846  28.007  15.825  1.00  5.81       seg O
ATOM    182  CB  ASP C  25      31.016  30.700  14.281  1.00  9.38       seg C
ATOM    183  CG  ASP C  25      31.838  31.577  15.205  1.00 13.52       seg C
ATOM    184  OD1 ASP C  25      31.266  32.128  16.169  1.00 14.07       seg O
ATOM    185  OD2 ASP C  25      33.057  31.716  14.967  1.00 17.20       seg O
ATOM    186  N   GLU C  26      30.369  29.718  17.195  0.67  4.76       seg N
ATOM    187  CA  GLU C  26      30.676  28.861  18.332  0.67  4.83       seg C
ATOM    188  C   GLU C  26      29.412  28.186  18.854  0.67  4.62       seg C
ATOM    189  O   GLU C  26      29.442  27.026  19.263  0.67  4.93       seg O
ATOM    190  CB  GLU C  26      31.358  29.666  19.440  0.67  5.41       seg C
ATOM    191  CG  GLU C  26      31.896  28.827  20.587  0.67  6.20       seg C
ATOM    192  CD  GLU C  26      30.908  28.695  21.727  0.67  7.05       seg C
ATOM    193  OE1 GLU C  26      29.820  29.303  21.645  0.67  7.13       seg O
ATOM    194  OE2 GLU C  26      31.224  27.991  22.709  0.67  8.43       seg O
ATOM    195  N   VAL C  27      28.304  28.920  18.836  1.00  4.54       seg N
ATOM    196  CA  VAL C  27      27.020  28.373  19.257  1.00  5.02       seg C
ATOM    197  C   VAL C  27      26.564  27.299  18.274  1.00  4.94       seg C
ATOM    198  O   VAL C  27      26.014  26.277  18.678  1.00  5.05       seg O
ATOM    199  CB  VAL C  27      25.941  29.477  19.381  1.00  5.29       seg C
ATOM    200  CG1 VAL C  27      26.139  30.263  20.668  1.00  5.41       seg C
ATOM    201  CG2 VAL C  27      24.541  28.882  19.346  1.00  6.00       seg C
ATOM    202  N   ARG C  28      26.816  27.519  16.987  1.00  5.20       seg N
ATOM    203  CA  ARG C  28      26.446  26.537  15.971  1.00  5.54       seg C
ATOM    204  C   ARG C  28      27.274  25.259  16.109  1.00  4.76       seg C
ATOM    205  O   ARG C  28      26.742  24.146  16.012  1.00  5.46       seg O
ATOM    206  CB  ARG C  28      26.617  27.126  14.569  1.00  6.82       seg C
ATOM    207  CG  ARG C  28      26.209  26.187  13.446  1.00  9.78       seg C
ATOM    208  CD  ARG C  28      26.389  26.843  12.087  1.00 13.05       seg C
ATOM    209  NE  ARG C  28      25.989  25.959  10.996  1.00 17.58       seg N
ATOM    210  CZ  ARG C  28      26.803  25.098  10.395  1.00 20.46       seg C
ATOM    211  NH1 ARG C  28      26.353  24.333   9.410  1.00 20.45       seg N
ATOM    212  NH2 ARG C  28      28.069  25.001  10.778  1.00 21.92       seg N
ATOM    213  N   THR C  29      28.570  25.421  16.364  1.00  4.62       seg N
ATOM    214  CA  THR C  29      29.451  24.272  16.550  1.00  5.38       seg C
ATOM    215  C   THR C  29      29.069  23.516  17.817  1.00  4.39       seg C
ATOM    216  O   THR C  29      29.128  22.286  17.862  1.00  5.02       seg O
ATOM    217  CB  THR C  29      30.932  24.687  16.629  1.00  7.77       seg C
ATOM    218  OG1 THR C  29      31.098  25.687  17.643  1.00  9.68       seg O
ATOM    219  CG2 THR C  29      31.405  25.239  15.293  1.00  8.93       seg C
ATOM    220  N   LEU C  30      28.673  24.262  18.843  1.00  4.10       seg N
ATOM    221  CA  LEU C  30      28.225  23.668  20.095  1.00  4.03       seg C
ATOM    222  C   LEU C  30      26.920  22.911  19.897  1.00  4.40       seg C
ATOM    223  O   LEU C  30      26.685  21.894  20.540  1.00  4.33       seg O
ATOM    224  CB  LEU C  30      28.056  24.737  21.175  1.00  4.41       seg C
ATOM    225  CG  LEU C  30      29.156  24.767  22.237  1.00  5.82       seg C
ATOM    226  CD1 LEU C  30      30.514  25.010  21.597  1.00  7.43       seg C
ATOM    227  CD2 LEU C  30      28.853  25.816  23.293  1.00  7.81       seg C
ATOM    228  N   GLN C  31      26.067  23.421  19.015  1.00  4.65       seg N
ATOM    229  CA  GLN C  31      24.813  22.752  18.697  1.00  5.33       seg C
ATOM    230  C   GLN C  31      25.085  21.453  17.952  1.00  5.02       seg C
ATOM    231  O   GLN C  31      24.417  20.445  18.186  1.00  5.56       seg O
ATOM    232  CB  GLN C  31      23.902  23.660  17.868  1.00  6.58       seg C
ATOM    233  CG  GLN C  31      23.231  24.766  18.667  1.00  9.50       seg C
ATOM    234  CD  GLN C  31      22.343  25.647  17.810  1.00 12.70       seg C
ATOM    235  OE1 GLN C  31      22.452  25.652  16.584  1.00 14.44       seg O
ATOM    236  NE2 GLN C  31      21.458  26.399  18.454  1.00 13.69       seg N
ATOM    237  N   GLU C  32      26.072  21.475  17.061  1.00  5.72       seg N
ATOM    238  CA  GLU C  32      26.439  20.268  16.326  1.00  6.90       seg C
ATOM    239  C   GLU C  32      27.043  19.221  17.261  1.00  5.82       seg C
ATOM    240  O   GLU C  32      26.741  18.028  17.155  1.00  6.63       seg O
ATOM    241  CB  GLU C  32      27.420  20.600  15.200  1.00 10.01       seg C
ATOM    242  CG  GLU C  32      26.842  21.491  14.114  1.00 16.02       seg C
ATOM    243  CD  GLU C  32      27.844  21.802  13.019  1.00 22.44       seg C
ATOM    244  OE1 GLU C  32      29.028  21.435  13.174  1.00 25.00       seg O
ATOM    245  OE2 GLU C  32      27.448  22.413  12.005  1.00 24.85       seg O
ATOM    246  N   ASN C  33      27.880  19.678  18.188  1.00  5.36       seg N
ATOM    247  CA  ASN C  33      28.513  18.787  19.154  1.00  5.56       seg C
ATOM    248  C   ASN C  33      27.501  18.199  20.132  1.00  5.07       seg C
ATOM    249  O   ASN C  33      27.587  17.029  20.503  1.00  6.19       seg O
ATOM    250  CB  ASN C  33      29.613  19.524  19.921  1.00  6.47       seg C
ATOM    251  CG  ASN C  33      30.768  19.936  19.030  1.00  8.34       seg C
ATOM    252  OD1 ASN C  33      31.035  19.304  18.008  1.00 11.36       seg O
ATOM    253  ND2 ASN C  33      31.461  21.002  19.415  1.00  8.04       seg N
ATOM    254  N   LEU C  34      26.543  19.020  20.547  1.00  4.51       seg N
ATOM    255  CA  LEU C  34      25.489  18.576  21.449  1.00  4.72       seg C
ATOM    256  C   LEU C  34      24.557  17.597  20.749  1.00  4.80       seg C
ATOM    257  O   LEU C  34      24.075  16.645  21.360  1.00  4.90       seg O
ATOM    258  CB  LEU C  34      24.696  19.769  21.988  1.00  4.81       seg C
ATOM    259  CG  LEU C  34      25.051  20.247  23.398  1.00  4.99       seg C
ATOM    260  CD1 LEU C  34      26.525  20.610  23.505  1.00  5.66       seg C
ATOM    261  CD2 LEU C  34      24.175  21.425  23.799  1.00  6.50       seg C
ATOM    262  N   HIS C  35      24.299  17.838  19.467  1.00  5.03       seg N
ATOM    263  CA  HIS C  35      23.442  16.949  18.691  1.00  5.85       seg C
ATOM    264  C   HIS C  35      24.105  15.596  18.443  1.00  5.91       seg C
ATOM    265  O   HIS C  35      23.460  14.554  18.568  1.00  6.51       seg O
ATOM    266  CB  HIS C  35      23.061  17.597  17.357  1.00  7.35       seg C
ATOM    267  CG  HIS C  35      21.980  18.626  17.472  1.00 10.07       seg C
ATOM    268  ND1 HIS C  35      22.198  19.880  18.001  1.00 13.24       seg N
ATOM    269  CD2 HIS C  35      20.672  18.587  17.125  1.00 10.94       seg C
ATOM    270  CE1 HIS C  35      21.071  20.569  17.975  1.00 14.19       seg C
ATOM    271  NE2 HIS C  35      20.130  19.807  17.449  1.00 13.06       seg N
ATOM    272  N   GLN C  36      25.393  15.607  18.107  1.00  5.86       seg N
ATOM    273  CA  GLN C  36      26.105  14.353  17.876  1.00  7.12       seg C
ATOM    274  C   GLN C  36      26.292  13.595  19.191  1.00  5.57       seg C
ATOM    275  O   GLN C  36      26.231  12.363  19.218  1.00  6.15       seg O
ATOM    276  CB  GLN C  36      27.454  14.599  17.187  1.00 10.81       seg C
ATOM    277  CG  GLN C  36      28.480  15.354  18.009  1.00 15.82       seg C
ATOM    278  CD  GLN C  36      29.782  15.569  17.262  1.00 20.43       seg C
ATOM    279  OE1 GLN C  36      29.786  16.007  16.112  1.00 21.72       seg O
ATOM    280  NE2 GLN C  36      30.896  15.259  17.915  1.00 22.23       seg N
ATOM    281  N   LEU C  37      26.508  14.332  20.278  1.00  4.79       seg N
ATOM    282  CA  LEU C  37      26.654  13.725  21.597  1.00  5.02       seg C
ATOM    283  C   LEU C  37      25.338  13.101  22.046  1.00  4.81       seg C
ATOM    284  O   LEU C  37      25.320  12.023  22.640  1.00  5.11       seg O
ATOM    285  CB  LEU C  37      27.123  14.760  22.622  1.00  5.48       seg C
ATOM    286  CG  LEU C  37      27.185  14.318  24.086  1.00  7.48       seg C
ATOM    287  CD1 LEU C  37      28.176  13.180  24.270  1.00  8.34       seg C
ATOM    288  CD2 LEU C  37      27.539  15.492  24.986  1.00  9.38       seg C
ATOM    289  N   MET C  38      24.237  13.784  21.751  1.00  5.10       seg N
ATOM    290  CA  MET C  38      22.913  13.286  22.098  0.60  5.87       seg C
ATOM    291  C   MET C  38      22.569  12.054  21.271  1.00  5.55       seg C
ATOM    292  O   MET C  38      21.963  11.108  21.775  1.00  5.83       seg O
ATOM    293  CB  MET C  38      21.856  14.374  21.892  0.60  7.11       seg C
ATOM    294  CG  MET C  38      20.443  13.946  22.255  0.60  8.46       seg C
ATOM    295  SD  MET C  38      19.234  15.263  22.019  0.60 10.21       seg S
ATOM    296  CE  MET C  38      19.348  15.514  20.249  0.60 11.26       seg C
ATOM    297  N   HIS C  39      22.962  12.067  20.001  1.00  5.90       seg N
ATOM    298  CA  HIS C  39      22.700  10.937  19.117  1.00  6.60       seg C
ATOM    299  C   HIS C  39      23.515   9.706  19.503  1.00  6.76       seg C
ATOM    300  O   HIS C  39      22.995   8.589  19.502  1.00  7.35       seg O
ATOM    301  CB  HIS C  39      22.987  11.318  17.663  1.00  7.90       seg C
ATOM    302  CG  HIS C  39      21.937  12.189  17.047  1.00  9.99       seg C
ATOM    303  ND1 HIS C  39      21.807  13.527  17.349  1.00 11.79       seg N
ATOM    304  CD2 HIS C  39      20.966  11.912  16.144  1.00 10.09       seg C
ATOM    305  CE1 HIS C  39      20.802  14.037  16.660  1.00 11.60       seg C
ATOM    306  NE2 HIS C  39      20.275  13.078  15.921  1.00 10.84       seg N
ATOM    307  N   GLU C  40      24.787   9.905  19.838  1.00  6.24       seg N
ATOM    308  CA  GLU C  40      25.634   8.786  20.240  1.00  7.45       seg C
ATOM    309  C   GLU C  40      25.229   8.261  21.617  1.00  6.69       seg C
ATOM    310  O   GLU C  40      25.306   7.060  21.874  1.00  7.99       seg O
ATOM    311  CB  GLU C  40      27.117   9.177  20.221  1.00  8.91       seg C
ATOM    312  CG  GLU C  40      27.533  10.220  21.241  1.00 12.58       seg C
ATOM    313  CD  GLU C  40      29.006  10.566  21.145  1.00 17.22       seg C
ATOM    314  OE1 GLU C  40      29.755   9.803  20.500  1.00 19.50       seg O
ATOM    315  OE2 GLU C  40      29.414  11.601  21.712  1.00 19.12       seg O
ATOM    316  N   TYR C  41      24.800   9.160  22.499  1.00  6.31       seg N
ATOM    317  CA  TYR C  41      24.342   8.761  23.827  1.00  6.52       seg C
ATOM    318  C   TYR C  41      23.036   7.980  23.732  1.00  6.93       seg C
ATOM    319  O   TYR C  41      22.826   7.011  24.461  1.00  7.89       seg O
ATOM    320  CB  TYR C  41      24.164   9.982  24.731  1.00  6.84       seg C
ATOM    321  CG  TYR C  41      23.671   9.653  26.123  1.00  7.08       seg C
ATOM    322  CD1 TYR C  41      24.546   9.195  27.100  1.00  8.09       seg C
ATOM    323  CD2 TYR C  41      22.333   9.805  26.462  1.00  8.31       seg C
ATOM    324  CE1 TYR C  41      24.102   8.894  28.373  1.00  8.88       seg C
ATOM    325  CE2 TYR C  41      21.879   9.506  27.733  1.00  8.84       seg C
ATOM    326  CZ  TYR C  41      22.768   9.051  28.684  1.00  9.01       seg C
ATOM    327  OH  TYR C  41      22.321   8.753  29.951  1.00  9.91       seg O
ATOM    328  N   PHE C  42      22.160   8.412  22.829  1.00  7.44       seg N
ATOM    329  CA  PHE C  42      20.888   7.733  22.609  1.00  9.29       seg C
ATOM    330  C   PHE C  42      21.110   6.371  21.963  1.00 11.50       seg C
ATOM    331  O   PHE C  42      20.420   5.402  22.282  1.00 13.50       seg O
ATOM    332  CB  PHE C  42      19.964   8.589  21.740  1.00  9.49       seg C
ATOM    333  CG  PHE C  42      18.635   7.948  21.453  1.00  9.99       seg C
ATOM    334  CD1 PHE C  42      17.617   7.983  22.392  1.00 11.43       seg C
ATOM    335  CD2 PHE C  42      18.400   7.318  20.241  1.00 10.35       seg C
ATOM    336  CE1 PHE C  42      16.393   7.397  22.131  1.00 11.84       seg C
ATOM    337  CE2 PHE C  42      17.178   6.730  19.974  1.00 11.43       seg C
ATOM    338  CZ  PHE C  42      16.174   6.770  20.921  1.00 12.29       seg C
ATOM    339  N   GLN C  43      22.076   6.305  21.052  1.00 11.97       seg N
ATOM    340  CA  GLN C  43      22.408   5.056  20.376  1.00 13.21       seg C
ATOM    341  C   GLN C  43      23.035   4.058  21.345  1.00 16.37       seg C
ATOM    342  O   GLN C  43      22.759   2.860  21.283  1.00 17.39       seg O
ATOM    343  CB  GLN C  43      23.353   5.318  19.202  1.00 11.79       seg C
ATOM    344  CG  GLN C  43      23.738   4.071  18.421  1.00 11.86       seg C
ATOM    345  CD  GLN C  43      24.676   4.372  17.268  1.00 12.53       seg C
ATOM    346  OE1 GLN C  43      24.443   5.296  16.489  1.00 14.19       seg O
ATOM    347  NE2 GLN C  43      25.744   3.592  17.155  1.00 13.65       seg N
ATOM    348  N   GLN C  44      23.879   4.562  22.241  1.00 19.32       seg N
ATOM    349  CA  GLN C  44      24.531   3.721  23.238  1.00 22.77       seg C
ATOM    350  C   GLN C  44      23.530   3.198  24.263  1.00 25.16       seg C
ATOM    351  O   GLN C  44      23.747   2.157  24.882  1.00 27.03       seg O
ATOM    352  CB  GLN C  44      25.648   4.493  23.942  1.00 23.69       seg C
TER
"""

rna_pdb_str = """
ATOM      1  C5'  DG A   1      -3.978  -5.685  17.586  1.00 10.33           C
ATOM      2  C4'  DG A   1      -3.637  -6.940  16.870  1.00  7.67           C
ATOM      3  O4'  DG A   1      -4.730  -7.294  15.970  1.00  7.90           O
ATOM      4  C3'  DG A   1      -2.415  -6.913  15.950  1.00  7.02           C
ATOM      5  O3'  DG A   1      -1.253  -7.199  16.735  1.00  7.48           O
ATOM      6  C2'  DG A   1      -2.743  -7.953  14.919  1.00  6.34           C
ATOM      7  C1'  DG A   1      -4.181  -7.833  14.764  1.00  7.13           C
ATOM      8  N9   DG A   1      -4.669  -6.929  13.664  1.00  7.10           N
ATOM      9  C8   DG A   1      -5.410  -5.780  13.735  1.00  8.55           C
ATOM     10  N7   DG A   1      -5.682  -5.281  12.554  1.00  8.50           N
ATOM     11  C5   DG A   1      -5.105  -6.154  11.649  1.00  6.84           C
ATOM     12  C6   DG A   1      -5.074  -6.171  10.236  1.00  7.07           C
ATOM     13  O6   DG A   1      -5.560  -5.361   9.442  1.00  8.18           O
ATOM     14  N1   DG A   1      -4.385  -7.274   9.738  1.00  6.07           N
ATOM     15  C2   DG A   1      -3.792  -8.250  10.486  1.00  5.88           C
ATOM     16  N2   DG A   1      -3.158  -9.232   9.863  1.00  6.30           N
ATOM     17  N3   DG A   1      -3.814  -8.251  11.818  1.00  6.14           N
ATOM     18  C4   DG A   1      -4.475  -7.184  12.328  1.00  6.40           C
ATOM     19  O5'  DG A   1      -4.129  -4.616  16.670  1.00 13.23           O
ATOM     20  P    DC A   2       0.159  -6.607  16.354  1.00  7.17           P
ATOM     21  OP1  DC A   2       1.032  -7.098  17.438  1.00  9.49           O
ATOM     22  OP2  DC A   2       0.079  -5.157  16.084  1.00  8.19           O
ATOM     23  O5'  DC A   2       0.540  -7.259  14.978  1.00  6.67           O
ATOM     24  C5'  DC A   2       0.845  -8.687  14.933  1.00  6.21           C
ATOM     25  C4'  DC A   2       1.061  -9.042  13.480  1.00  5.85           C
ATOM     26  O4'  DC A   2      -0.171  -8.807  12.756  1.00  5.64           O
ATOM     27  C3'  DC A   2       2.080  -8.258  12.694  1.00  5.87           C
ATOM     28  O3'  DC A   2       3.384  -8.830  12.944  1.00  6.20           O
ATOM     29  C2'  DC A   2       1.621  -8.416  11.264  1.00  5.92           C
ATOM     30  C1'  DC A   2       0.149  -8.416  11.402  1.00  5.36           C
ATOM     31  N1   DC A   2      -0.536  -7.095  11.175  1.00  5.25           N
ATOM     32  C2   DC A   2      -0.789  -6.771   9.851  1.00  5.43           C
ATOM     33  O2   DC A   2      -0.402  -7.525   8.959  1.00  5.62           O
ATOM     34  N3   DC A   2      -1.483  -5.633   9.585  1.00  5.07           N
ATOM     35  C4   DC A   2      -1.832  -4.811  10.582  1.00  5.35           C
ATOM     36  N4   DC A   2      -2.459  -3.681  10.271  1.00  6.32           N
ATOM     37  C5   DC A   2      -1.489  -5.072  11.930  1.00  6.06           C
ATOM     38  C6   DC A   2      -0.863  -6.228  12.175  1.00  5.82           C
ATOM     39  P    DG A   3       4.694  -7.979  12.612  1.00  6.44           P
ATOM     40  OP1  DG A   3       5.824  -8.863  12.983  1.00  8.30           O
ATOM     41  OP2  DG A   3       4.632  -6.627  13.229  1.00  7.47           O
ATOM     42  O5'  DG A   3       4.565  -7.883  11.033  1.00  6.85           O
ATOM     43  C5'  DG A   3       5.087  -6.782  10.277  1.00  6.15           C
ATOM     44  C4'  DG A   3       4.628  -6.912   8.863  1.00  5.98           C
ATOM     45  O4'  DG A   3       3.198  -6.768   8.835  1.00  6.93           O
ATOM     46  C3'  DG A   3       5.140  -5.841   7.909  1.00  6.17           C
ATOM     47  O3'  DG A   3       6.438  -6.239   7.429  1.00  6.98           O
ATOM     48  C2'  DG A   3       4.093  -5.795   6.848  1.00  6.25           C
ATOM     49  C1'  DG A   3       2.922  -6.068   7.584  1.00  7.07           C
ATOM     50  N9   DG A   3       2.090  -4.883   8.068  1.00  5.57           N
ATOM     51  C8   DG A   3       1.731  -4.500   9.337  1.00  6.21           C
ATOM     52  N7   DG A   3       0.978  -3.447   9.375  1.00  5.89           N
ATOM     53  C5   DG A   3       0.800  -3.101   8.043  1.00  5.50           C
ATOM     54  C6   DG A   3       0.052  -2.059   7.446  1.00  5.33           C
ATOM     55  O6   DG A   3      -0.613  -1.177   8.002  1.00  6.41           O
ATOM     56  N1   DG A   3       0.162  -2.064   6.056  1.00  5.28           N
ATOM     57  C2   DG A   3       0.904  -2.968   5.338  1.00  5.04           C
ATOM     58  N2   DG A   3       0.882  -2.763   4.024  1.00  5.53           N
ATOM     59  N3   DG A   3       1.579  -3.967   5.878  1.00  5.25           N
ATOM     60  C4   DG A   3       1.481  -3.975   7.228  1.00  5.17           C
ATOM     61  P    DT A   4       7.494  -5.119   7.002  1.00  6.95           P
ATOM     62  OP1  DT A   4       8.729  -5.879   6.636  1.00  8.83           O
ATOM     63  OP2  DT A   4       7.560  -4.065   8.008  1.00  8.54           O
ATOM     64  O5'  DT A   4       6.867  -4.454   5.706  1.00  6.35           O
ATOM     65  C5'  DT A   4       6.991  -5.019   4.402  1.00  6.40           C
ATOM     66  C4'  DT A   4       6.569  -3.963   3.385  1.00  6.14           C
ATOM     67  O4'  DT A   4       5.172  -3.691   3.509  1.00  5.85           O
ATOM     68  C3'  DT A   4       7.260  -2.609   3.531  1.00  5.96           C
ATOM     69  O3'  DT A   4       8.570  -2.657   2.955  1.00  7.00           O
ATOM     70  C2'  DT A   4       6.281  -1.694   2.834  1.00  5.83           C
ATOM     71  C1'  DT A   4       4.995  -2.269   3.199  1.00  5.50           C
ATOM     72  N1   DT A   4       4.319  -1.695   4.408  1.00  4.88           N
ATOM     73  C2   DT A   4       3.479  -0.614   4.203  1.00  4.89           C
ATOM     74  O2   DT A   4       3.238  -0.157   3.100  1.00  5.46           O
ATOM     75  N3   DT A   4       2.870  -0.136   5.336  1.00  4.98           N
ATOM     76  C4   DT A   4       3.060  -0.549   6.631  1.00  5.07           C
ATOM     77  O4   DT A   4       2.451  -0.030   7.571  1.00  5.20           O
ATOM     78  C5   DT A   4       4.052  -1.592   6.790  1.00  5.28           C
ATOM     79  C7   DT A   4       4.391  -2.043   8.172  1.00  5.73           C
ATOM     80  C6   DT A   4       4.601  -2.115   5.688  1.00  4.94           C
ATOM     81  P    DA A   5       9.713  -1.721   3.558  1.00  7.31           P
ATOM     82  OP1  DA A   5      10.936  -2.057   2.755  1.00 10.22           O
ATOM     83  OP2  DA A   5       9.792  -1.797   5.019  1.00  8.84           O
ATOM     84  O5'  DA A   5       9.202  -0.284   3.122  1.00  6.72           O
ATOM     85  C5'  DA A   5       9.353   0.848   3.965  1.00  7.16           C
ATOM     86  C4'  DA A   5       8.507   1.956   3.432  1.00  6.26           C
ATOM     87  O4'  DA A   5       7.101   1.592   3.512  1.00  6.16           O
ATOM     88  C3'  DA A   5       8.616   3.260   4.198  1.00  6.67           C
ATOM     89  O3'  DA A   5       9.773   3.987   3.773  1.00  8.06           O
ATOM     90  C2'  DA A   5       7.309   3.930   3.859  1.00  6.69           C
ATOM     91  C1'  DA A   5       6.348   2.752   3.827  1.00  5.98           C
ATOM     92  N9   DA A   5       5.704   2.499   5.127  1.00  5.34           N
ATOM     93  C8   DA A   5       5.954   1.516   6.040  1.00  5.75           C
ATOM     94  N7   DA A   5       5.193   1.582   7.116  1.00  5.44           N
ATOM     95  C5   DA A   5       4.395   2.695   6.888  1.00  5.38           C
ATOM     96  C6   DA A   5       3.346   3.282   7.618  1.00  5.28           C
ATOM     97  N6   DA A   5       2.951   2.826   8.808  1.00  5.35           N
ATOM     98  N1   DA A   5       2.743   4.365   7.111  1.00  5.45           N
ATOM     99  C2   DA A   5       3.146   4.832   5.915  1.00  5.47           C
ATOM    100  N3   DA A   5       4.105   4.372   5.121  1.00  5.80           N
ATOM    101  C4   DA A   5       4.691   3.277   5.672  1.00  5.05           C
ATOM    102  P    DA A   7      10.361   9.907   7.735  1.00  7.99       seg P
ATOM    103  OP1  DA A   7      11.390  11.000   7.496  1.00 10.78       seg O
ATOM    104  OP2  DA A   7      10.815   8.642   8.293  1.00  9.63       seg O
ATOM    105  N9   DA A   7       6.334   9.455  11.116  1.00  5.65       seg N
ATOM    106  C8   DA A   7       7.224   8.572  10.573  1.00  6.17       seg C
ATOM    107  N7   DA A   7       7.120   7.360  11.049  1.00  6.56       seg N
ATOM    108  C5   DA A   7       6.093   7.459  11.988  1.00  5.71       seg C
ATOM    109  C6   DA A   7       5.502   6.522  12.853  1.00  6.10       seg C
ATOM    110  N6   DA A   7       5.857   5.242  12.917  1.00  7.10       seg N
ATOM    111  N1   DA A   7       4.527   6.967  13.680  1.00  6.05       seg N
ATOM    112  C2   DA A   7       4.148   8.245  13.617  1.00  6.15       seg C
ATOM    113  N3   DA A   7       4.623   9.210  12.837  1.00  6.29       seg N
ATOM    114  C4   DA A   7       5.590   8.748  12.022  1.00  5.70       seg C
ATOM    115  O5'  DA A   7       9.260  10.485   8.777  1.00  6.82       seg O
ATOM    116  C5'  DA A   7       8.750  11.813   8.635  1.00  7.00       seg C
ATOM    117  C4'  DA A   7       7.804  12.093   9.780  1.00  6.45       seg C
ATOM    118  O4'  DA A   7       6.598  11.282   9.642  1.00  4.73       seg O
ATOM    119  C3'  DA A   7       8.274  11.755  11.194  1.00  5.90       seg C
ATOM    120  O3'  DA A   7       9.154  12.775  11.689  1.00  6.00       seg O
ATOM    121  C2'  DA A   7       6.975  11.670  11.899  1.00  4.64       seg C
ATOM    122  C1'  DA A   7       6.132  10.895  10.898  1.00  5.64       seg C
ATOM    123  N1   DC A   8       6.735   9.699  15.920  1.00  5.92       seg N
ATOM    124  C2   DC A   8       6.159   8.694  16.692  1.00  6.04       seg C
ATOM    125  O2   DC A   8       5.281   9.024  17.522  1.00  6.66       seg O
ATOM    126  N3   DC A   8       6.569   7.420  16.535  1.00  6.40       seg N
ATOM    127  C4   DC A   8       7.504   7.119  15.618  1.00  6.85       seg C
ATOM    128  N4   DC A   8       7.874   5.856  15.500  1.00  8.97       seg N
ATOM    129  C5   DC A   8       8.129   8.134  14.832  1.00  7.62       seg C
ATOM    130  C6   DC A   8       7.715   9.401  15.007  1.00  6.89       seg C
ATOM    131  P    DC A   8      10.149  12.560  12.869  1.00  7.33       seg P
ATOM    132  OP1  DC A   8      10.964  13.795  12.977  1.00 11.24       seg O
ATOM    133  OP2  DC A   8      10.865  11.262  12.719  1.00 11.23       seg O
ATOM    134  O5'  DC A   8       9.256  12.419  14.149  1.00  5.64       seg O
ATOM    135  C5'  DC A   8       8.458  13.523  14.600  1.00  7.95       seg C
ATOM    136  C4'  DC A   8       7.513  13.014  15.672  1.00  5.78       seg C
ATOM    137  O4'  DC A   8       6.736  11.895  15.132  1.00  5.71       seg O
ATOM    138  C3'  DC A   8       8.072  12.394  16.940  1.00  5.19       seg C
ATOM    139  O3'  DC A   8       8.587  13.377  17.832  1.00  5.00       seg O
ATOM    140  C2'  DC A   8       6.847  11.654  17.449  1.00  5.70       seg C
ATOM    141  C1'  DC A   8       6.269  11.067  16.181  1.00  6.41       seg C
ATOM    142  P    DG A   9       9.587  13.026  19.037  1.00  6.28       seg P
ATOM    143  OP1  DG A   9       9.944  14.347  19.602  1.00  8.07       seg O
ATOM    144  OP2  DG A   9      10.654  12.085  18.639  1.00  8.27       seg O
ATOM    145  O5'  DG A   9       8.717  12.191  20.048  1.00  5.88       seg O
ATOM    146  C5'  DG A   9       7.723  12.833  20.854  1.00  5.45       seg C
ATOM    147  C4'  DG A   9       7.145  11.818  21.807  1.00  5.40       seg C
ATOM    148  O4'  DG A   9       6.435  10.777  21.087  1.00  5.77       seg O
ATOM    149  C3'  DG A   9       8.142  11.036  22.648  1.00  5.10       seg C
ATOM    150  O3'  DG A   9       8.612  11.838  23.723  1.00  5.90       seg O
ATOM    151  C2'  DG A   9       7.300   9.857  23.068  1.00  5.97       seg C
ATOM    152  C1'  DG A   9       6.619   9.536  21.805  1.00  5.97       seg C
ATOM    153  N9   DG A   9       7.390   8.643  20.931  1.00  5.97       seg N
ATOM    154  C8   DG A   9       8.074   8.881  19.775  1.00  6.62       seg C
ATOM    155  N7   DG A   9       8.647   7.820  19.249  1.00  6.57       seg N
ATOM    156  C5   DG A   9       8.308   6.806  20.141  1.00  6.22       seg C
ATOM    157  C6   DG A   9       8.620   5.431  20.136  1.00  6.03       seg C
ATOM    158  O6   DG A   9       9.297   4.803  19.296  1.00  7.21       seg O
ATOM    159  N1   DG A   9       8.101   4.773  21.247  1.00  6.10       seg N
ATOM    160  C2   DG A   9       7.365   5.351  22.260  1.00  6.24       seg C
ATOM    161  N2   DG A   9       6.948   4.569  23.241  1.00  7.88       seg N
ATOM    162  N3   DG A   9       7.051   6.652  22.257  1.00  6.53       seg N
ATOM    163  C4   DG A   9       7.539   7.295  21.184  1.00  5.69       seg C
ATOM    164  P    DC A  10      10.081  11.538  24.300  1.00  5.91       seg P
ATOM    165  OP1  DC A  10      10.273  12.645  25.291  1.00  7.27       seg O
ATOM    166  OP2  DC A  10      11.063  11.363  23.228  1.00  6.84       seg O
ATOM    167  O5'  DC A  10       9.953  10.128  25.026  1.00  5.75       seg O
ATOM    168  C5'  DC A  10       9.077   9.959  26.149  1.00  5.87       seg C
ATOM    169  C4'  DC A  10       9.188   8.549  26.672  1.00  5.56       seg C
ATOM    170  O4'  DC A  10       8.708   7.612  25.667  1.00  5.70       seg O
ATOM    171  C3'  DC A  10      10.580   8.059  27.007  1.00  5.27       seg C
ATOM    172  O3'  DC A  10      11.010   8.447  28.315  1.00  5.83       seg O
ATOM    173  C2'  DC A  10      10.422   6.549  26.893  1.00  5.34       seg C
ATOM    174  C1'  DC A  10       9.436   6.405  25.754  1.00  5.23       seg C
ATOM    175  N1   DC A  10      10.113   6.168  24.448  1.00  5.30       seg N
ATOM    176  C2   DC A  10      10.514   4.871  24.152  1.00  5.28       seg C
ATOM    177  O2   DC A  10      10.283   3.972  25.000  1.00  5.75       seg O
ATOM    178  N3   DC A  10      11.131   4.627  22.965  1.00  5.65       seg N
ATOM    179  C4   DC A  10      11.395   5.628  22.138  1.00  5.80       seg C
ATOM    180  N4   DC A  10      12.034   5.327  21.005  1.00  6.75       seg N
ATOM    181  C5   DC A  10      11.029   6.970  22.449  1.00  5.99       seg C
ATOM    182  C6   DC A  10      10.394   7.203  23.612  1.00  5.56       seg C
TER
ATOM    183  O5'  DG B  11      12.424  -4.393  18.427  1.00 22.70       seg O
ATOM    184  C5'  DG B  11      12.380  -5.516  19.282  1.00 14.75       seg C
ATOM    185  C4'  DG B  11      11.969  -5.112  20.676  1.00 10.42       seg C
ATOM    186  O4'  DG B  11      12.972  -4.192  21.210  1.00 10.51       seg O
ATOM    187  C3'  DG B  11      10.649  -4.394  20.782  1.00  8.57       seg C
ATOM    188  O3'  DG B  11       9.618  -5.363  20.846  1.00  8.69       seg O
ATOM    189  C2'  DG B  11      10.822  -3.597  22.051  1.00  8.63       seg C
ATOM    190  C1'  DG B  11      12.236  -3.233  21.980  1.00  9.81       seg C
ATOM    191  N9   DG B  11      12.509  -1.902  21.305  1.00  8.66       seg N
ATOM    192  C8   DG B  11      13.175  -1.667  20.135  1.00  9.57       seg C
ATOM    193  N7   DG B  11      13.255  -0.407  19.824  1.00  9.04       seg N
ATOM    194  C5   DG B  11      12.613   0.235  20.869  1.00  7.63       seg C
ATOM    195  C6   DG B  11      12.388   1.612  21.119  1.00  7.05       seg C
ATOM    196  O6   DG B  11      12.723   2.590  20.419  1.00  7.81       seg O
ATOM    197  N1   DG B  11      11.715   1.819  22.317  1.00  6.27       seg N
ATOM    198  C2   DG B  11      11.264   0.828  23.159  1.00  6.05       seg C
ATOM    199  N2   DG B  11      10.611   1.219  24.248  1.00  5.85       seg N
ATOM    200  N3   DG B  11      11.483  -0.457  22.942  1.00  6.55       seg N
ATOM    201  C4   DG B  11      12.150  -0.687  21.797  1.00  6.84       seg C
ATOM    202  P    DC B  12       8.134  -5.009  20.350  1.00  8.13       seg P
ATOM    203  OP1  DC B  12       7.367  -6.252  20.459  1.00 10.02       seg O
ATOM    204  OP2  DC B  12       8.172  -4.307  19.052  1.00  9.79       seg O
ATOM    205  O5'  DC B  12       7.564  -3.912  21.389  1.00  8.18       seg O
ATOM    206  C5'  DC B  12       7.275  -4.296  22.719  1.00  8.00       seg C
ATOM    207  C4'  DC B  12       6.856  -3.057  23.487  1.00  8.01       seg C
ATOM    208  O4'  DC B  12       8.006  -2.146  23.615  1.00  7.35       seg O
ATOM    209  C3'  DC B  12       5.763  -2.208  22.890  1.00  7.04       seg C
ATOM    210  O3'  DC B  12       4.456  -2.800  23.100  1.00  9.82       seg O
ATOM    211  C2'  DC B  12       6.019  -0.916  23.630  1.00  6.50       seg C
ATOM    212  C1'  DC B  12       7.467  -0.808  23.608  1.00  7.35       seg C
ATOM    213  N1   DC B  12       8.040  -0.143  22.396  1.00  6.64       seg N
ATOM    214  C2   DC B  12       8.017   1.257  22.382  1.00  5.68       seg C
ATOM    215  O2   DC B  12       7.524   1.832  23.357  1.00  6.32       seg O
ATOM    216  N3   DC B  12       8.543   1.930  21.312  1.00  6.18       seg N
ATOM    217  C4   DC B  12       9.009   1.236  20.266  1.00  6.48       seg C
ATOM    218  N4   DC B  12       9.518   1.926  19.243  1.00  7.43       seg N
ATOM    219  C5   DC B  12       9.012  -0.198  20.248  1.00  6.83       seg C
ATOM    220  C6   DC B  12       8.502  -0.825  21.311  1.00  6.80       seg C
ATOM    221  P    DG B  13       3.317  -2.567  21.984  1.00 10.53       seg P
ATOM    222  OP1  DG B  13       2.138  -3.315  22.464  1.00 12.90       seg O
ATOM    223  OP2  DG B  13       3.797  -2.910  20.692  1.00 15.34       seg O
ATOM    224  O5'  DG B  13       3.058  -1.005  22.003  1.00  8.16       seg O
ATOM    225  C5'  DG B  13       2.486  -0.453  23.175  1.00  7.96       seg C
ATOM    226  C4'  DG B  13       2.422   1.049  23.015  1.00  7.52       seg C
ATOM    227  O4'  DG B  13       3.776   1.585  22.972  1.00  8.03       seg O
ATOM    228  C3'  DG B  13       1.786   1.610  21.766  1.00  6.71       seg C
ATOM    229  O3'  DG B  13       0.374   1.467  21.862  1.00  6.44       seg O
ATOM    230  C2'  DG B  13       2.313   3.016  21.879  1.00  7.13       seg C
ATOM    231  C1'  DG B  13       3.801   2.784  22.295  1.00  7.50       seg C
ATOM    232  N9   DG B  13       4.601   2.712  21.088  1.00  7.08       seg N
ATOM    233  C8   DG B  13       5.173   1.609  20.512  1.00  6.87       seg C
ATOM    234  N7   DG B  13       5.814   1.892  19.415  1.00  7.15       seg N
ATOM    235  C5   DG B  13       5.655   3.258  19.245  1.00  6.53       seg C
ATOM    236  C6   DG B  13       6.091   4.135  18.221  1.00  6.23       seg C
ATOM    237  O6   DG B  13       6.762   3.865  17.217  1.00  7.02       seg O
ATOM    238  N1   DG B  13       5.657   5.437  18.454  1.00  6.37       seg N
ATOM    239  C2   DG B  13       4.896   5.858  19.514  1.00  6.35       seg C
ATOM    240  N2   DG B  13       4.599   7.146  19.531  1.00  6.42       seg N
ATOM    241  N3   DG B  13       4.501   5.043  20.466  1.00  6.38       seg N
ATOM    242  C4   DG B  13       4.904   3.776  20.267  1.00  6.57       seg C
ATOM    243  P    DT B  14      -0.502   1.442  20.533  1.00  6.12       seg P
ATOM    244  OP1  DT B  14      -1.889   1.279  21.023  1.00  7.43       seg O
ATOM    245  OP2  DT B  14       0.064   0.495  19.535  1.00  7.35       seg O
ATOM    246  O5'  DT B  14      -0.296   2.900  19.897  1.00  5.91       seg O
ATOM    247  C5'  DT B  14      -0.864   4.029  20.559  1.00  6.72       seg C
ATOM    248  C4'  DT B  14      -0.613   5.258  19.743  1.00  5.90       seg C
ATOM    249  O4'  DT B  14       0.836   5.541  19.679  1.00  5.83       seg O
ATOM    250  C3'  DT B  14      -1.009   5.225  18.272  1.00  5.92       seg C
ATOM    251  O3'  DT B  14      -2.417   5.269  18.155  1.00  6.57       seg O
ATOM    252  C2'  DT B  14      -0.248   6.446  17.791  1.00  5.66       seg C
ATOM    253  C1'  DT B  14       1.089   6.266  18.502  1.00  5.37       seg C
ATOM    254  N1   DT B  14       2.007   5.496  17.631  1.00  5.56       seg N
ATOM    255  C2   DT B  14       2.567   6.214  16.592  1.00  5.65       seg C
ATOM    256  O2   DT B  14       2.348   7.401  16.401  1.00  6.01       seg O
ATOM    257  N3   DT B  14       3.389   5.484  15.771  1.00  5.43       seg N
ATOM    258  C4   DT B  14       3.637   4.136  15.836  1.00  5.80       seg C
ATOM    259  O4   DT B  14       4.363   3.617  14.997  1.00  6.83       seg O
ATOM    260  C5   DT B  14       3.027   3.447  16.945  1.00  5.92       seg C
ATOM    261  C7   DT B  14       3.264   1.982  17.116  1.00  7.13       seg C
ATOM    262  C6   DT B  14       2.257   4.156  17.789  1.00  5.79       seg C
ATOM    263  P    DA B  15      -3.107   4.614  16.844  1.00  6.33       seg P
ATOM    264  OP1  DA B  15      -4.536   4.501  17.215  1.00  7.81       seg O
ATOM    265  OP2  DA B  15      -2.355   3.433  16.355  1.00  7.39       seg O
ATOM    266  O5'  DA B  15      -2.903   5.712  15.734  1.00  6.64       seg O
ATOM    267  C5'  DA B  15      -3.456   7.019  15.917  1.00  7.02       seg C
ATOM    268  C4'  DA B  15      -2.863   7.975  14.857  1.00  6.49       seg C
ATOM    269  O4'  DA B  15      -1.417   8.002  15.006  1.00  6.33       seg O
ATOM    270  C3'  DA B  15      -3.120   7.639  13.418  1.00  6.56       seg C
ATOM    271  O3'  DA B  15      -4.406   8.139  13.055  1.00  7.27       seg O
ATOM    272  C2'  DA B  15      -1.969   8.325  12.734  1.00  6.18       seg C
ATOM    273  C1'  DA B  15      -0.855   8.099  13.667  1.00  5.84       seg C
ATOM    274  N9   DA B  15      -0.080   6.863  13.448  1.00  5.58       seg N
ATOM    275  C8   DA B  15      -0.139   5.693  14.139  1.00  5.46       seg C
ATOM    276  N7   DA B  15       0.721   4.783  13.706  1.00  5.24       seg N
ATOM    277  C5   DA B  15       1.390   5.435  12.679  1.00  5.11       seg C
ATOM    278  C6   DA B  15       2.451   5.017  11.838  1.00  5.10       seg C
ATOM    279  N6   DA B  15       3.032   3.818  11.887  1.00  5.80       seg N
ATOM    280  N1   DA B  15       2.867   5.905  10.917  1.00  5.50       seg N
ATOM    281  C2   DA B  15       2.312   7.119  10.854  1.00  5.61       seg C
ATOM    282  N3   DA B  15       1.319   7.610  11.607  1.00  5.67       seg N
ATOM    283  C4   DA B  15       0.916   6.720  12.504  1.00  5.30       seg C
ATOM    284  P    DA B  17      -5.863   7.587   6.066  1.00  7.46           P
ATOM    285  OP1  DA B  17      -7.082   8.055   5.372  1.00  9.84           O
ATOM    286  OP2  DA B  17      -6.010   6.428   6.951  1.00  9.05           O
ATOM    287  O5'  DA B  17      -4.763   7.131   4.982  1.00  6.87           O
ATOM    288  C5'  DA B  17      -4.584   7.937   3.825  1.00  7.49           C
ATOM    289  C4'  DA B  17      -3.539   7.243   2.937  1.00  6.83           C
ATOM    290  O4'  DA B  17      -2.295   7.168   3.631  1.00  7.04           O
ATOM    291  C3'  DA B  17      -3.829   5.816   2.525  1.00  7.02           C
ATOM    292  O3'  DA B  17      -4.804   5.781   1.477  1.00  8.14           O
ATOM    293  C2'  DA B  17      -2.450   5.387   2.108  1.00  7.22           C
ATOM    294  C1'  DA B  17      -1.587   6.010   3.166  1.00  6.66           C
ATOM    295  N9   DA B  17      -1.369   5.144   4.326  1.00  5.85           N
ATOM    296  C8   DA B  17      -2.072   5.079   5.492  1.00  6.17           C
ATOM    297  N7   DA B  17      -1.643   4.156   6.319  1.00  6.03           N
ATOM    298  C5   DA B  17      -0.591   3.552   5.643  1.00  5.68           C
ATOM    299  C6   DA B  17       0.268   2.480   5.946  1.00  5.42           C
ATOM    300  N6   DA B  17       0.257   1.834   7.114  1.00  5.69           N
ATOM    301  N1   DA B  17       1.178   2.113   5.031  1.00  5.65           N
ATOM    302  C2   DA B  17       1.212   2.780   3.868  1.00  5.86           C
ATOM    303  N3   DA B  17       0.472   3.809   3.457  1.00  5.97           N
ATOM    304  C4   DA B  17      -0.423   4.147   4.410  1.00  5.68           C
ATOM    305  P    DC B  18      -5.850   4.605   1.415  1.00  8.75           P
ATOM    306  OP1  DC B  18      -6.730   4.928   0.276  1.00 12.93           O
ATOM    307  OP2  DC B  18      -6.479   4.382   2.720  1.00 11.49           O
ATOM    308  N1   DC B  18      -2.088   0.995   2.743  1.00  5.94           N
ATOM    309  C2   DC B  18      -1.320   0.079   3.454  1.00  5.53           C
ATOM    310  O2   DC B  18      -0.464  -0.570   2.845  1.00  6.20           O
ATOM    311  N3   DC B  18      -1.531  -0.063   4.785  1.00  5.53           N
ATOM    312  C4   DC B  18      -2.510   0.618   5.387  1.00  5.87           C
ATOM    313  N4   DC B  18      -2.692   0.431   6.686  1.00  6.96           N
ATOM    314  C5   DC B  18      -3.324   1.552   4.679  1.00  6.40           C
ATOM    315  C6   DC B  18      -3.077   1.692   3.371  1.00  6.07           C
ATOM    316  O5'  DC B  18      -4.980   3.312   1.052  1.00  9.67           O
ATOM    317  C5'  DC B  18      -4.326   3.201  -0.208  1.00 18.33           C
ATOM    318  C4'  DC B  18      -3.395   1.992  -0.189  1.00  7.63           C
ATOM    319  O4'  DC B  18      -2.311   2.271   0.750  1.00  6.13           O
ATOM    320  C3'  DC B  18      -3.906   0.638   0.289  1.00  6.36           C
ATOM    321  O3'  DC B  18      -4.745   0.062  -0.685  1.00  6.90           O
ATOM    322  C2'  DC B  18      -2.552  -0.024   0.545  1.00  4.15           C
ATOM    323  C1'  DC B  18      -1.815   1.074   1.293  1.00  6.79           C
ATOM    324  N9   DG B  19      -2.358  -3.762   3.056  1.00  5.17           N
ATOM    325  C8   DG B  19      -3.242  -2.728   3.235  1.00  5.72           C
ATOM    326  N7   DG B  19      -3.594  -2.570   4.492  1.00  5.81           N
ATOM    327  C5   DG B  19      -2.879  -3.533   5.177  1.00  5.12           C
ATOM    328  C6   DG B  19      -2.800  -3.847   6.569  1.00  4.99           C
ATOM    329  O6   DG B  19      -3.414  -3.301   7.509  1.00  6.20           O
ATOM    330  N1   DG B  19      -1.958  -4.914   6.801  1.00  5.03           N
ATOM    331  C2   DG B  19      -1.245  -5.621   5.857  1.00  4.92           C
ATOM    332  N2   DG B  19      -0.506  -6.630   6.310  1.00  5.16           N
ATOM    333  N3   DG B  19      -1.281  -5.323   4.563  1.00  4.95           N
ATOM    334  C4   DG B  19      -2.111  -4.279   4.311  1.00  4.86           C
ATOM    335  P    DG B  19      -5.394  -1.368  -0.434  1.00  6.03           P
ATOM    336  OP1  DG B  19      -6.386  -1.588  -1.504  1.00 10.24           O
ATOM    337  OP2  DG B  19      -5.801  -1.496   0.951  1.00  7.31           O
ATOM    338  O5'  DG B  19      -4.162  -2.301  -0.650  1.00 16.06           O
ATOM    339  C5'  DG B  19      -4.125  -3.645  -0.798  1.00 22.50           C
ATOM    340  C4'  DG B  19      -2.783  -4.124  -0.249  1.00  4.64           C
ATOM    341  O4'  DG B  19      -2.316  -3.216   0.749  1.00  6.27           O
ATOM    342  C3'  DG B  19      -2.908  -5.468   0.394  1.00  4.51           C
ATOM    343  O3'  DG B  19      -2.826  -6.486  -0.621  1.00  8.79           O
ATOM    344  C2'  DG B  19      -1.790  -5.568   1.388  1.00  3.09           C
ATOM    345  C1'  DG B  19      -1.724  -4.162   1.780  1.00  3.64           C
ATOM    346  P    DC B  20      -3.827  -7.730  -0.547  1.00  7.39           P
ATOM    347  OP1  DC B  20      -3.528  -8.515  -1.781  1.00 10.52           O
ATOM    348  OP2  DC B  20      -5.200  -7.318  -0.309  1.00  9.09           O
ATOM    349  O5'  DC B  20      -3.338  -8.510   0.743  1.00  7.10           O
ATOM    350  C5'  DC B  20      -2.082  -9.184   0.769  1.00  6.85           C
ATOM    351  C4'  DC B  20      -1.886  -9.845   2.096  1.00  5.89           C
ATOM    352  O4'  DC B  20      -1.809  -8.845   3.109  1.00  5.69           O
ATOM    353  C3'  DC B  20      -3.027 -10.776   2.575  1.00  6.11           C
ATOM    354  O3'  DC B  20      -2.893 -12.101   2.117  1.00  6.77           O
ATOM    355  C2'  DC B  20      -2.924 -10.707   4.083  1.00  6.12           C
ATOM    356  C1'  DC B  20      -2.345  -9.366   4.353  1.00  5.64           C
ATOM    357  N1   DC B  20      -3.277  -8.343   4.869  1.00  5.40           N
ATOM    358  C2   DC B  20      -3.487  -8.319   6.251  1.00  5.46           C
ATOM    359  O2   DC B  20      -2.925  -9.189   6.930  1.00  5.71           O
ATOM    360  N3   DC B  20      -4.256  -7.344   6.779  1.00  5.66           N
ATOM    361  C4   DC B  20      -4.870  -6.469   5.972  1.00  5.89           C
ATOM    362  N4   DC B  20      -5.635  -5.536   6.565  1.00  6.38           N
ATOM    363  C5   DC B  20      -4.742  -6.533   4.557  1.00  5.85           C
ATOM    364  C6   DC B  20      -3.917  -7.457   4.043  1.00  5.82           C
TER
END"""

def get_grm(pdb_str, mon_lib_srv, ener_lib, log):
  pdb_int_pars = pdb_interpretation.master_params.extract()
  pdb_int_pars.secondary_structure.enabled=True
  processed_pdb_file = pdb_interpretation.process(
    mon_lib_srv=mon_lib_srv,
    ener_lib=ener_lib,
    params=pdb_int_pars,
    raw_records=pdb_str,
    substitute_non_crystallographic_unit_cell_if_necessary=True,
    log=log)
  return processed_pdb_file.geometry_restraints_manager()


def exercise_protein(mon_lib_srv, ener_lib, log):
  grm = get_grm(protein_pdb_str.split('\n'), mon_lib_srv, ener_lib, log)
  print(grm.get_n_hbond_proxies(), "want 30")  # 31 hbonds, with segids 30
  print(grm.get_n_hangle_proxies(), "want 90")
  assert grm.get_n_hbond_proxies() == 30  # 31 hbonds, with segids 30
  assert grm.get_n_hangle_proxies() == 90

def exercise_rna(mon_lib_srv, ener_lib, log):
  grm = get_grm(rna_pdb_str.split('\n'), mon_lib_srv, ener_lib, log)
  print(grm.get_n_hbond_proxies(), "want 22")  # 22 hbonds, with segids
  print(grm.get_n_hangle_proxies(), "want 44")
  assert grm.get_n_hbond_proxies() == 22
  assert grm.get_n_hangle_proxies() == 44

def exercise_both(mon_lib_srv, ener_lib, log):
  grm = get_grm(protein_pdb_str.split('\n') + rna_pdb_str.split('\n'),
      mon_lib_srv, ener_lib, log)
  print(grm.get_n_hbond_proxies(), "want 52")
  print(grm.get_n_hangle_proxies(), "want 44+90=134") # 90 from protein
  assert grm.get_n_hbond_proxies() == 52
  assert grm.get_n_hangle_proxies() == 134


if __name__ == "__main__":
  if (not libtbx.env.has_module(name="ksdssp")):
    print("Skipping KSDSSP tests: ksdssp module not available.")
  else:
    mon_lib_srv = server.server()
    ener_lib = server.ener_lib()
    # log = sys.stdout
    log = StringIO()
    exercise_protein(mon_lib_srv, ener_lib, log)
    exercise_rna(mon_lib_srv, ener_lib, log)
    exercise_both(mon_lib_srv, ener_lib, log)
  print(format_cpu_times())
  print("OK")
