/*
** (c) 1996-2000 The Regents of the University of California (through
** E.O. Lawrence Berkeley National Laboratory), subject to approval by
** the U.S. Department of Energy.  Your use of this software is under
** license -- the license agreement is attached and included in the
** directory as license.txt or you may contact Berkeley Lab's Technology
** Transfer Department at TTD@lbl.gov.  NOTICE OF U.S. GOVERNMENT RIGHTS.
** The Software was developed under funding from the U.S. Government
** which consequently retains certain rights as follows: the
** U.S. Government has been granted for itself and others acting on its
** behalf a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, and perform publicly
** and display publicly.  Beginning five (5) years after the date
** permission to assert copyright is obtained from the U.S. Department of
** Energy, and subject to any subsequent five (5) year renewals, the
** U.S. Government is granted for itself and others acting on its behalf
** a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, distribute copies to
** the public, perform publicly and display publicly, and to permit
** others to do so.
*/

#include "REAL.H"
#include "ArrayLim.H"

#define SDIM 3

      subroutine TRANSV(v,DIMS(v),dx,domnlo,
     &     avVR,avVT,avVZ,avC,Nbin,DIMS(av),maxbin,bsize)
      implicit none
      integer DIMDEC(v)
      integer DIMDEC(av)
      REAL_T  v(DIMV(v),SDIM+2)
      REAL_T avVR(DIMV(av))
      REAL_T avVT(DIMV(av))
      REAL_T avVZ(DIMV(av))
      REAL_T avC(DIMV(av))
      integer Nbin(DIMV(av))
      REAL_T dx(SDIM), domnlo(SDIM)
      integer i,j,k,n,bsize,maxbin,bin
      REAL_T x,y,vx,vy,vz,vr,vt,rat,r,st,ct,kk

      kk = ARG_L3(av)
      do j=ARG_L2(v),ARG_H2(v)

         do n=0,maxbin
            Nbin(j,n,kk) = 0
            avVR(j,n,kk) = 0.d0
            avVT(j,n,kk) = 0.d0
            avVZ(j,n,kk) = 0.d0
            avC(j,n,kk)  = 0.d0
         enddo

         do k=ARG_L3(v),ARG_H3(v)
            y = (float(k)+0.5d0)*dx(3)+domnlo(3)
            do i=ARG_L1(v),ARG_H1(v)
               x = (float(i)+0.5d0)*dx(1)+domnlo(1)

               vx = v(i,j,k,1)*1.d-2
               vy = v(i,j,k,3)*1.d-2
               vz = v(i,j,k,2)*1.d-2

               r = SQRT(x*x + y*y)
               if (r.le.2.5d0) then

                  bin = INT(r/(bsize*dx(1)))

                  if (r.lt.1.d-10) then
                     print *,'PUKE! illdefined if r=0'
                     call bl_abort(" ")
                  else
                     st = y / r
                     ct = x / r
                     vr = vx*ct + vy*st
                     vt = vy*ct - vx*st
                  endif
                  
               else 

                  bin = -1
                  vr = 0.d0
                  vt = 0.d0

               endif

               if (bin.gt.maxbin) call bl_abort('...maxbin not enough!')

               if (bin.ge.0) then
                  avVR(j,bin,kk) = avVR(j,bin,kk) + vr
                  avVT(j,bin,kk) = avVT(j,bin,kk) + vt
                  avVZ(j,bin,kk) = avVZ(j,bin,kk) + vz
                  avC(j,bin,kk)  = avC(j,bin,kk)  + v(i,j,k,5)/v(i,j,k,4)
                  Nbin(j,bin,kk) = Nbin(j,bin,kk) + 1
               endif

            enddo
         enddo

         do n=0,maxbin
            if (Nbin(j,n,kk).gt.0) then
               avVR(j,n,kk) = avVR(j,n,kk)/Nbin(j,n,kk)
               avVT(j,n,kk) = avVT(j,n,kk)/Nbin(j,n,kk)
               avVZ(j,n,kk) = avVZ(j,n,kk)/Nbin(j,n,kk)
               avC(j,n,kk)  = avC(j,n,kk)/Nbin(j,n,kk)
            endif
         enddo

      enddo

      end
