/*
    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA  02110-1301, USA.

    ---
    Copyright (C) 2009 Alexander Rieder <alexanderrieder@gmail.com>
 */

#include "maximakeywords.h"

#include <QDebug>

MaximaKeywords::MaximaKeywords()
{

}


MaximaKeywords::~MaximaKeywords()
{

}

MaximaKeywords* MaximaKeywords::instance()
{
    static MaximaKeywords* inst=0;
    if(inst==0)
    {
        inst=new MaximaKeywords();
        inst->loadKeywords();
    }

    return inst;
}

void MaximaKeywords::loadKeywords()
{
    //Begin m_variables initialization
    m_variables << QLatin1String("_");
    m_variables << QLatin1String("__");
    m_variables << QLatin1String("%");
    m_variables << QLatin1String("%%");
    m_variables << QLatin1String("absboxchar");
    m_variables << QLatin1String("activecontexts");
    m_variables << QLatin1String("additive");
    m_variables << QLatin1String("algebraic");
    m_variables << QLatin1String("algepsilon");
    m_variables << QLatin1String("algexact");
    m_variables << QLatin1String("aliases");
    m_variables << QLatin1String("all_dotsimp_denoms");
    m_variables << QLatin1String("allbut");
    m_variables << QLatin1String("allsym");
    m_variables << QLatin1String("arrays");
    m_variables << QLatin1String("askexp");
    m_variables << QLatin1String("assume_pos");
    m_variables << QLatin1String("assume_pos_pred");
    m_variables << QLatin1String("assumescalar");
    m_variables << QLatin1String("atomgrad");
    m_variables << QLatin1String("backsubst");
    m_variables << QLatin1String("berlefact");
    m_variables << QLatin1String("besselexpand");
    m_variables << QLatin1String("bftorat");
    m_variables << QLatin1String("bftrunc");
    m_variables << QLatin1String("boxchar");
    m_variables << QLatin1String("breakup");
    m_variables << QLatin1String("cauchysum");
    m_variables << QLatin1String("cflength");
    m_variables << QLatin1String("cframe_flag");
    m_variables << QLatin1String("cnonmet_flag");
    m_variables << QLatin1String("context");
    m_variables << QLatin1String("contexts");
    m_variables << QLatin1String("cosnpiflag");
    m_variables << QLatin1String("ctaypov");
    m_variables << QLatin1String("ctaypt");
    m_variables << QLatin1String("ctayswitch");
    m_variables << QLatin1String("ctayvar");
    m_variables << QLatin1String("ct_coords");
    m_variables << QLatin1String("ctorsion_flag");
    m_variables << QLatin1String("ctrgsimp");
    m_variables << QLatin1String("current_let_rule_package");
    m_variables << QLatin1String("debugmode");
    m_variables << QLatin1String("default_let_rule_package");
    m_variables << QLatin1String("demoivre");
    m_variables << QLatin1String("dependencies");
    m_variables << QLatin1String("derivabbrev");
    m_variables << QLatin1String("derivsubst");
    m_variables << QLatin1String("detout");
    m_variables << QLatin1String("diagmetric");
    m_variables << QLatin1String("dim");
    m_variables << QLatin1String("dispflag");
    m_variables << QLatin1String("display2d");
    m_variables << QLatin1String("display_format_internal");
    m_variables << QLatin1String("doallmxops");
    m_variables << QLatin1String("domain");
    m_variables << QLatin1String("domxexpt");
    m_variables << QLatin1String("domxmxops");
    m_variables << QLatin1String("domxnctimes");
    m_variables << QLatin1String("dontfactor");
    m_variables << QLatin1String("doscmxops");
    m_variables << QLatin1String("doscmxplus");
    m_variables << QLatin1String("dot0nscsimp");
    m_variables << QLatin1String("dot0simp");
    m_variables << QLatin1String("dot1simp");
    m_variables << QLatin1String("dotassoc");
    m_variables << QLatin1String("dotconstrules");
    m_variables << QLatin1String("dotdistrib");
    m_variables << QLatin1String("dotexptsimp");
    m_variables << QLatin1String("dotident");
    m_variables << QLatin1String("dotscrules");
    m_variables << QLatin1String("draw_graph_program");
    m_variables << QLatin1String("%edispflag");
    m_variables << QLatin1String("%emode");
    m_variables << QLatin1String("%enumer");
    m_variables << QLatin1String("epsilon_lp");
    m_variables << QLatin1String("erfflag");
    m_variables << QLatin1String("error");
    m_variables << QLatin1String("error_size");
    m_variables << QLatin1String("error_syms");
    m_variables << QLatin1String("%e_to_numlog");
    m_variables << QLatin1String("evflag");
    m_variables << QLatin1String("evfun");
    m_variables << QLatin1String("expandwrt_denom");
    m_variables << QLatin1String("expon");
    m_variables << QLatin1String("exponentialize");
    m_variables << QLatin1String("expop");
    m_variables << QLatin1String("exptdispflag");
    m_variables << QLatin1String("exptisolate");
    m_variables << QLatin1String("exptsubst");
    m_variables << QLatin1String("facexpand");
    m_variables << QLatin1String("factlim");
    m_variables << QLatin1String("factorflag");
    m_variables << QLatin1String("file_output_append");
    m_variables << QLatin1String("file_search_demo");
    m_variables << QLatin1String("file_search_lisp");
    m_variables << QLatin1String("file_search_maxima");
    m_variables << QLatin1String("find_root_abs");
    m_variables << QLatin1String("find_root_error");
    m_variables << QLatin1String("find_root_rel");
    m_variables << QLatin1String("flipflag");
    m_variables << QLatin1String("float2bf");
    m_variables << QLatin1String("fortindent");
    m_variables << QLatin1String("fortspaces");
    m_variables << QLatin1String("fpprec");
    m_variables << QLatin1String("fpprintprec");
    m_variables << QLatin1String("functions");
    m_variables << QLatin1String("gammalim");
    m_variables << QLatin1String("gdet");
    m_variables << QLatin1String("genindex");
    m_variables << QLatin1String("gensumnum");
    m_variables << QLatin1String("GGFCFMAX");
    m_variables << QLatin1String("GGFINFINITY");
    m_variables << QLatin1String("globalsolve");
    m_variables << QLatin1String("gradefs");
    m_variables << QLatin1String("grind");
    m_variables << QLatin1String("halfangles");
    m_variables << QLatin1String("%iargs");
    m_variables << QLatin1String("ibase");
    m_variables << QLatin1String("icounter");
    m_variables << QLatin1String("idummyx");
    m_variables << QLatin1String("ieqnprint");
    m_variables << QLatin1String("iframe_bracket_form");
    m_variables << QLatin1String("igeowedge_flag");
    m_variables << QLatin1String("imetric");
    m_variables << QLatin1String("inchar");
    m_variables << QLatin1String("infeval");
    m_variables << QLatin1String("inflag");
    m_variables << QLatin1String("infolists");
    m_variables << QLatin1String("in_netmath");
    m_variables << QLatin1String("integrate_use_rootsof");
    m_variables << QLatin1String("integration_constant");
    m_variables << QLatin1String("integration_constant_counter");
    m_variables << QLatin1String("intfaclim");
    m_variables << QLatin1String("isolate_wrt_times");
    m_variables << QLatin1String("keepfloat");
    m_variables << QLatin1String("labels");
    m_variables << QLatin1String("letrat");
    m_variables << QLatin1String("let_rule_packages");
    m_variables << QLatin1String("lhospitallim");
    m_variables << QLatin1String("limsubst");
    m_variables << QLatin1String("linechar");
    m_variables << QLatin1String("linel");
    m_variables << QLatin1String("linenum");
    m_variables << QLatin1String("linsolve_params");
    m_variables << QLatin1String("linsolvewarn");
    m_variables << QLatin1String("lispdisp");
    m_variables << QLatin1String("listarith");
    m_variables << QLatin1String("listconstvars");
    m_variables << QLatin1String("listdummyvars");
    m_variables << QLatin1String("lmxchar");
    m_variables << QLatin1String("loadprint");
    m_variables << QLatin1String("logabs");
    m_variables << QLatin1String("logarc");
    m_variables << QLatin1String("logconcoeffp");
    m_variables << QLatin1String("logexpand");
    m_variables << QLatin1String("lognegint");
    m_variables << QLatin1String("lognumer");
    m_variables << QLatin1String("logsimp");
    m_variables << QLatin1String("m1pbranch");
    m_variables << QLatin1String("macroexpansion");
    m_variables << QLatin1String("maperror");
    m_variables << QLatin1String("mapprint");
    m_variables << QLatin1String("matrix_element_add");
    m_variables << QLatin1String("matrix_element_mult");
    m_variables << QLatin1String("matrix_element_transpose");
    m_variables << QLatin1String("maxapplydepth");
    m_variables << QLatin1String("maxapplyheight");
    m_variables << QLatin1String("maxima_tempdir");
    m_variables << QLatin1String("maxima_userdir");
    m_variables << QLatin1String("maxnegex");
    m_variables << QLatin1String("maxposex");
    m_variables << QLatin1String("maxpsifracdenom");
    m_variables << QLatin1String("maxpsifracnum");
    m_variables << QLatin1String("maxpsinegint");
    m_variables << QLatin1String("maxpsiposint");
    m_variables << QLatin1String("maxtayorder");
    m_variables << QLatin1String("method");
    m_variables << QLatin1String("mode_check_errorp");
    m_variables << QLatin1String("mode_checkp");
    m_variables << QLatin1String("mode_check_warnp");
    m_variables << QLatin1String("modulus");
    m_variables << QLatin1String("multiplicities");
    m_variables << QLatin1String("myoptions");
    m_variables << QLatin1String("negdistrib");
    m_variables << QLatin1String("negsumdispflag");
    m_variables << QLatin1String("newtonepsilon");
    m_variables << QLatin1String("newtonmaxiter");
    m_variables << QLatin1String("niceindicespref");
    m_variables << QLatin1String("nolabels");
    m_variables << QLatin1String("nonegative_lp");
    m_variables << QLatin1String("noundisp");
    m_variables << QLatin1String("obase");
    m_variables << QLatin1String("opproperties");
    m_variables << QLatin1String("opsubst");
    m_variables << QLatin1String("optimprefix");
    m_variables << QLatin1String("optionset");
    m_variables << QLatin1String("outchar");
    m_variables << QLatin1String("packagefile");
    m_variables << QLatin1String("partswitch");
    m_variables << QLatin1String("pfeformat");
    m_variables << QLatin1String("%piargs");
    m_variables << QLatin1String("piece");
    m_variables << QLatin1String("plot_options");
    m_variables << QLatin1String("poislim");
    m_variables << QLatin1String("poly_coefficient_ring");
    m_variables << QLatin1String("poly_elimination_order");
    m_variables << QLatin1String("poly_grobner_algorithm");
    m_variables << QLatin1String("poly_grobner_debug");
    m_variables << QLatin1String("poly_monomial_order");
    m_variables << QLatin1String("poly_primary_elimination_order");
    m_variables << QLatin1String("poly_return_term_list");
    m_variables << QLatin1String("poly_secondary_elimination_order");
    m_variables << QLatin1String("poly_top_reduction_only");
    m_variables << QLatin1String("powerdisp");
    m_variables << QLatin1String("prederror");
    m_variables << QLatin1String("primep_number_of_tests");
    m_variables << QLatin1String("product_use_gamma");
    m_variables << QLatin1String("programmode");
    m_variables << QLatin1String("prompt");
    m_variables << QLatin1String("psexpand");
    m_variables << QLatin1String("radexpand");
    m_variables << QLatin1String("radsubstflag");
    m_variables << QLatin1String("random_beta_algorithm");
    m_variables << QLatin1String("random_binomial_algorithm");
    m_variables << QLatin1String("random_chi2_algorithm");
    m_variables << QLatin1String("random_exp_algorithm");
    m_variables << QLatin1String("random_f_algorithm");
    m_variables << QLatin1String("random_gamma_algorithm");
    m_variables << QLatin1String("random_geometric_algorithm");
    m_variables << QLatin1String("random_hypergeometric_algorithm");
    m_variables << QLatin1String("random_negative_binomial_algorithm");
    m_variables << QLatin1String("random_normal_algorithm");
    m_variables << QLatin1String("random_poisson_algorithm");
    m_variables << QLatin1String("random_student_t_algorithm");
    m_variables << QLatin1String("ratalgdenom");
    m_variables << QLatin1String("ratchristof");
    m_variables << QLatin1String("ratdenomdivide");
    m_variables << QLatin1String("rateinstein");
    m_variables << QLatin1String("ratepsilon");
    m_variables << QLatin1String("ratexpand");
    m_variables << QLatin1String("ratfac");
    m_variables << QLatin1String("ratmx");
    m_variables << QLatin1String("ratprint");
    m_variables << QLatin1String("ratriemann");
    m_variables << QLatin1String("ratsimpexpons");
    m_variables << QLatin1String("ratvars");
    m_variables << QLatin1String("ratweights");
    m_variables << QLatin1String("ratweyl");
    m_variables << QLatin1String("ratwtlvl");
    m_variables << QLatin1String("realonly");
    m_variables << QLatin1String("refcheck");
    m_variables << QLatin1String("rmxchar");
    m_variables << QLatin1String("%rnum_list");
    m_variables << QLatin1String("rombergabs");
    m_variables << QLatin1String("rombergit");
    m_variables << QLatin1String("rombergmin");
    m_variables << QLatin1String("rombergtol");
    m_variables << QLatin1String("rootsconmode");
    m_variables << QLatin1String("rootsepsilon");
    m_variables << QLatin1String("savedef");
    m_variables << QLatin1String("savefactors");
    m_variables << QLatin1String("scalarmatrixp");
    m_variables << QLatin1String("setcheck");
    m_variables << QLatin1String("setcheckbreak");
    m_variables << QLatin1String("setval");
    m_variables << QLatin1String("showtime");
    m_variables << QLatin1String("simplify_products");
    m_variables << QLatin1String("simpsum");
    m_variables << QLatin1String("sinnpiflag");
    m_variables << QLatin1String("solvedecomposes");
    m_variables << QLatin1String("solveexplicit");
    m_variables << QLatin1String("solvefactors");
    m_variables << QLatin1String("solve_inconsistent_error");
    m_variables << QLatin1String("solvenullwarn");
    m_variables << QLatin1String("solveradcan");
    m_variables << QLatin1String("solvetrigwarn");
    m_variables << QLatin1String("sparse");
    m_variables << QLatin1String("sqrtdispflag");
    m_variables << QLatin1String("stardisp");
    m_variables << QLatin1String("stats_numer");
    m_variables << QLatin1String("stringdisp");
    m_variables << QLatin1String("sublis_apply_lambda");
    m_variables << QLatin1String("sumexpand");
    m_variables << QLatin1String("sumsplitfact");
    m_variables << QLatin1String("taylordepth");
    m_variables << QLatin1String("taylor_logexpand");
    m_variables << QLatin1String("taylor_order_coefficients");
    m_variables << QLatin1String("taylor_truncate_polynomials");
    m_variables << QLatin1String("tensorkill");
    m_variables << QLatin1String("testsuite_files");
    m_variables << QLatin1String("timer_devalue");
    m_variables << QLatin1String("tlimswitch");
    m_variables << QLatin1String("transcompile");
    m_variables << QLatin1String("transrun");
    m_variables << QLatin1String("tr_array_as_ref");
    m_variables << QLatin1String("tr_bound_function_applyp");
    m_variables << QLatin1String("tr_file_tty_messagesp");
    m_variables << QLatin1String("tr_float_can_branch_complex");
    m_variables << QLatin1String("tr_function_call_default");
    m_variables << QLatin1String("trigexpandplus");
    m_variables << QLatin1String("trigexpandtimes");
    m_variables << QLatin1String("triginverses");
    m_variables << QLatin1String("trigsign");
    m_variables << QLatin1String("tr_numer");
    m_variables << QLatin1String("tr_optimize_max_loop");
    m_variables << QLatin1String("tr_semicompile");
    m_variables << QLatin1String("tr_state_vars");
    m_variables << QLatin1String("tr_warn_bad_function_calls");
    m_variables << QLatin1String("tr_warn_fexpr");
    m_variables << QLatin1String("tr_warn_meval");
    m_variables << QLatin1String("tr_warn_mode");
    m_variables << QLatin1String("tr_warn_undeclared");
    m_variables << QLatin1String("tr_warn_undefined_variable");
    m_variables << QLatin1String("tr_windy");
    m_variables << QLatin1String("ttyoff");
    m_variables << QLatin1String("use_fast_arrays");
    m_variables << QLatin1String("values");
    m_variables << QLatin1String("vect_cross");
    m_variables << QLatin1String("verbose");
    m_variables << QLatin1String("zerobern");
    m_variables << QLatin1String("zeta%pi");
    //Finish m_variables initialization

    //Begin m_functions initialization
    m_functions << QLatin1String("abasep");
    m_functions << QLatin1String("abs");
    m_functions << QLatin1String("absint");
    m_functions << QLatin1String("absolute_real_time");
    m_functions << QLatin1String("acos");
    m_functions << QLatin1String("acosh");
    m_functions << QLatin1String("acot");
    m_functions << QLatin1String("acoth");
    m_functions << QLatin1String("acsc");
    m_functions << QLatin1String("acsch");
    m_functions << QLatin1String("activate");
    m_functions << QLatin1String("addcol");
    m_functions << QLatin1String("add_edge");
    m_functions << QLatin1String("add_edges");
    m_functions << QLatin1String("addmatrices");
    m_functions << QLatin1String("addrow");
    m_functions << QLatin1String("add_vertex");
    m_functions << QLatin1String("add_vertices");
    m_functions << QLatin1String("adjacency_matrix");
    m_functions << QLatin1String("adjoin");
    m_functions << QLatin1String("adjoint");
    m_functions << QLatin1String("af");
    m_functions << QLatin1String("agd");
    m_functions << QLatin1String("airy_ai");
    m_functions << QLatin1String("airy_bi");
    m_functions << QLatin1String("airy_dai");
    m_functions << QLatin1String("airy_dbi");
    m_functions << QLatin1String("algsys");
    m_functions << QLatin1String("alg_type");
    m_functions << QLatin1String("alias");
    m_functions << QLatin1String("allroots");
    m_functions << QLatin1String("alphacharp");
    m_functions << QLatin1String("alphanumericp");
    m_functions << QLatin1String("antid");
    m_functions << QLatin1String("antidiff");
    m_functions << QLatin1String("AntiDifference");
    m_functions << QLatin1String("append");
    m_functions << QLatin1String("appendfile");
    m_functions << QLatin1String("apply");
    m_functions << QLatin1String("apply1");
    m_functions << QLatin1String("apply2");
    m_functions << QLatin1String("applyb1");
    m_functions << QLatin1String("apropos");
    m_functions << QLatin1String("args");
    m_functions << QLatin1String("arithmetic");
    m_functions << QLatin1String("arithsum");
    m_functions << QLatin1String("array");
    m_functions << QLatin1String("arrayapply");
    m_functions << QLatin1String("arrayinfo");
    m_functions << QLatin1String("arraymake");
    m_functions << QLatin1String("ascii");
    m_functions << QLatin1String("asec");
    m_functions << QLatin1String("asech");
    m_functions << QLatin1String("asin");
    m_functions << QLatin1String("asinh");
    m_functions << QLatin1String("askinteger");
    m_functions << QLatin1String("asksign");
    m_functions << QLatin1String("assoc");
    m_functions << QLatin1String("assoc_legendre_p");
    m_functions << QLatin1String("assoc_legendre_q");
    m_functions << QLatin1String("assume");
    m_functions << QLatin1String("asympa");
    m_functions << QLatin1String("at");
    m_functions << QLatin1String("atan");
    m_functions << QLatin1String("atan2");
    m_functions << QLatin1String("atanh");
    m_functions << QLatin1String("atensimp");
    m_functions << QLatin1String("atom");
    m_functions << QLatin1String("atvalue");
    m_functions << QLatin1String("augcoefmatrix");
    m_functions << QLatin1String("augmented_lagrangian_method");
    m_functions << QLatin1String("av");
    m_functions << QLatin1String("average_degree");
    m_functions << QLatin1String("backtrace");
    m_functions << QLatin1String("barsplot");
    m_functions << QLatin1String("bashindices");
    m_functions << QLatin1String("batch");
    m_functions << QLatin1String("batchload");
    m_functions << QLatin1String("bc2");
    m_functions << QLatin1String("bdvac");
    m_functions << QLatin1String("belln");
    m_functions << QLatin1String("bern");
    m_functions << QLatin1String("bernpoly");
    m_functions << QLatin1String("bessel");
    m_functions << QLatin1String("bessel_i");
    m_functions << QLatin1String("bessel_j");
    m_functions << QLatin1String("bessel_k");
    m_functions << QLatin1String("bessel_y");
    m_functions << QLatin1String("beta");
    m_functions << QLatin1String("bezout");
    m_functions << QLatin1String("bffac");
    m_functions << QLatin1String("bfhzeta");
    m_functions << QLatin1String("bfloat");
    m_functions << QLatin1String("bfloatp");
    m_functions << QLatin1String("bfpsi");
    m_functions << QLatin1String("bfpsi0");
    m_functions << QLatin1String("bfzeta");
    m_functions << QLatin1String("biconected_components");
    m_functions << QLatin1String("bimetric");
    m_functions << QLatin1String("binomial");
    m_functions << QLatin1String("bipartition");
    m_functions << QLatin1String("block");
    m_functions << QLatin1String("blockmatrixp");
    m_functions << QLatin1String("bode_gain");
    m_functions << QLatin1String("bode_phase");
    m_functions << QLatin1String("bothcoef");
    m_functions << QLatin1String("box");
    m_functions << QLatin1String("boxplot");
    m_functions << QLatin1String("break");
    m_functions << QLatin1String("bug_report");
    m_functions << QLatin1String("build_info");
    m_functions << QLatin1String("buildq");
    m_functions << QLatin1String("burn");
    m_functions << QLatin1String("cabs");
    m_functions << QLatin1String("canform");
    m_functions << QLatin1String("canten");
    m_functions << QLatin1String("cardinality");
    m_functions << QLatin1String("carg");
    m_functions << QLatin1String("cartan");
    m_functions << QLatin1String("cartesian_product");
    m_functions << QLatin1String("catch");
    m_functions << QLatin1String("cbffac");
    m_functions << QLatin1String("cdf_bernoulli");
    m_functions << QLatin1String("cdf_beta");
    m_functions << QLatin1String("cdf_binomial");
    m_functions << QLatin1String("cdf_cauchy");
    m_functions << QLatin1String("cdf_chi2");
    m_functions << QLatin1String("cdf_continuous_uniform");
    m_functions << QLatin1String("cdf_discrete_uniform");
    m_functions << QLatin1String("cdf_exp");
    m_functions << QLatin1String("cdf_f");
    m_functions << QLatin1String("cdf_gamma");
    m_functions << QLatin1String("cdf_geometric");
    m_functions << QLatin1String("cdf_gumbel");
    m_functions << QLatin1String("cdf_hypergeometric");
    m_functions << QLatin1String("cdf_laplace");
    m_functions << QLatin1String("cdf_logistic");
    m_functions << QLatin1String("cdf_lognormal");
    m_functions << QLatin1String("cdf_negative_binomial");
    m_functions << QLatin1String("cdf_normal");
    m_functions << QLatin1String("cdf_pareto");
    m_functions << QLatin1String("cdf_poisson");
    m_functions << QLatin1String("cdf_rank_sum");
    m_functions << QLatin1String("cdf_rayleigh");
    m_functions << QLatin1String("cdf_signed_rank");
    m_functions << QLatin1String("cdf_student_t");
    m_functions << QLatin1String("cdf_weibull");
    m_functions << QLatin1String("cdisplay");
    m_functions << QLatin1String("ceiling");
    m_functions << QLatin1String("central_moment");
    m_functions << QLatin1String("cequal");
    m_functions << QLatin1String("cequalignore");
    m_functions << QLatin1String("cf");
    m_functions << QLatin1String("cfdisrep");
    m_functions << QLatin1String("cfexpand");
    m_functions << QLatin1String("cgeodesic");
    m_functions << QLatin1String("cgreaterp");
    m_functions << QLatin1String("cgreaterpignore");
    m_functions << QLatin1String("changename");
    m_functions << QLatin1String("changevar");
    m_functions << QLatin1String("chaosgame");
    m_functions << QLatin1String("charat");
    m_functions << QLatin1String("charfun");
    m_functions << QLatin1String("charfun2");
    m_functions << QLatin1String("charlist");
    m_functions << QLatin1String("charp");
    m_functions << QLatin1String("charpoly");
    m_functions << QLatin1String("chebyshev_t");
    m_functions << QLatin1String("chebyshev_u");
    m_functions << QLatin1String("checkdiv");
    m_functions << QLatin1String("check_overlaps");
    m_functions << QLatin1String("cholesky");
    m_functions << QLatin1String("christof");
    m_functions << QLatin1String("chromatic_index");
    m_functions << QLatin1String("chromatic_number");
    m_functions << QLatin1String("cint");
    m_functions << QLatin1String("circulant_graph");
    m_functions << QLatin1String("clear_edge_weight");
    m_functions << QLatin1String("clear_rules");
    m_functions << QLatin1String("clear_vertex_label");
    m_functions << QLatin1String("clebsch_graph");
    m_functions << QLatin1String("clessp");
    m_functions << QLatin1String("clesspignore");
    m_functions << QLatin1String("close");
    m_functions << QLatin1String("closefile");
    m_functions << QLatin1String("cmetric");
    m_functions << QLatin1String("coeff");
    m_functions << QLatin1String("coefmatrix");
    m_functions << QLatin1String("cograd");
    m_functions << QLatin1String("col");
    m_functions << QLatin1String("collapse");
    m_functions << QLatin1String("collectterms");
    m_functions << QLatin1String("columnop");
    m_functions << QLatin1String("columnspace");
    m_functions << QLatin1String("columnswap");
    m_functions << QLatin1String("columnvector");
    m_functions << QLatin1String("combination");
    m_functions << QLatin1String("combine");
    m_functions << QLatin1String("comp2pui");
    m_functions << QLatin1String("compare");
    m_functions << QLatin1String("compfile");
    m_functions << QLatin1String("compile");
    m_functions << QLatin1String("compile_file");
    m_functions << QLatin1String("complement_graph");
    m_functions << QLatin1String("complete_bipartite_graph");
    m_functions << QLatin1String("complete_graph");
    m_functions << QLatin1String("components");
    m_functions << QLatin1String("concan");
    m_functions << QLatin1String("concat");
    m_functions << QLatin1String("conjugate");
    m_functions << QLatin1String("conmetderiv");
    m_functions << QLatin1String("connected_components");
    m_functions << QLatin1String("connect_vertices");
    m_functions << QLatin1String("cons");
    m_functions << QLatin1String("constantp");
    m_functions << QLatin1String("constituent");
    m_functions << QLatin1String("cont2part");
    m_functions << QLatin1String("content");
    m_functions << QLatin1String("continuous_freq");
    m_functions << QLatin1String("contortion");
    m_functions << QLatin1String("contour_plot");
    m_functions << QLatin1String("contract");
    m_functions << QLatin1String("contract_edge");
    m_functions << QLatin1String("contragrad");
    m_functions << QLatin1String("contrib_ode");
    m_functions << QLatin1String("convert");
    m_functions << QLatin1String("coord");
    m_functions << QLatin1String("copy");
    m_functions << QLatin1String("copy_graph");
    m_functions << QLatin1String("copylist");
    m_functions << QLatin1String("copymatrix");
    m_functions << QLatin1String("cor");
    m_functions << QLatin1String("cos");
    m_functions << QLatin1String("cosh");
    m_functions << QLatin1String("cot");
    m_functions << QLatin1String("coth");
    m_functions << QLatin1String("cov");
    m_functions << QLatin1String("cov1");
    m_functions << QLatin1String("covdiff");
    m_functions << QLatin1String("covect");
    m_functions << QLatin1String("covers");
    m_functions << QLatin1String("create_graph");
    m_functions << QLatin1String("create_list");
    m_functions << QLatin1String("csc");
    m_functions << QLatin1String("csch");
    m_functions << QLatin1String("csetup");
    m_functions << QLatin1String("cspline");
    m_functions << QLatin1String("ctaylor");
    m_functions << QLatin1String("ct_coordsys");
    m_functions << QLatin1String("ctransform");
    m_functions << QLatin1String("ctranspose");
    m_functions << QLatin1String("cube_graph");
    m_functions << QLatin1String("cunlisp");
    m_functions << QLatin1String("cv");
    m_functions << QLatin1String("cycle_digraph");
    m_functions << QLatin1String("cycle_graph");
    m_functions << QLatin1String("dblint");
    m_functions << QLatin1String("deactivate");
    m_functions << QLatin1String("declare");
    m_functions << QLatin1String("declare_translated");
    m_functions << QLatin1String("declare_weight");
    m_functions << QLatin1String("decsym");
    m_functions << QLatin1String("defcon");
    m_functions << QLatin1String("define");
    m_functions << QLatin1String("define_variable");
    m_functions << QLatin1String("defint");
    m_functions << QLatin1String("defmatch");
    m_functions << QLatin1String("defrule");
    m_functions << QLatin1String("deftaylor");
    m_functions << QLatin1String("degree_sequence");
    m_functions << QLatin1String("del");
    m_functions << QLatin1String("delete");
    m_functions << QLatin1String("deleten");
    m_functions << QLatin1String("delta");
    m_functions << QLatin1String("demo");
    m_functions << QLatin1String("demoivre");
    m_functions << QLatin1String("denom");
    m_functions << QLatin1String("depends");
    m_functions << QLatin1String("derivdegree");
    m_functions << QLatin1String("derivlist");
    m_functions << QLatin1String("describe");
    m_functions << QLatin1String("desolve");
    m_functions << QLatin1String("determinant");
    m_functions << QLatin1String("dgauss_a");
    m_functions << QLatin1String("dgauss_b");
    m_functions << QLatin1String("dgeev");
    m_functions << QLatin1String("dgesvd");
    m_functions << QLatin1String("diag");
    m_functions << QLatin1String("diagmatrix");
    m_functions << QLatin1String("diag_matrix");
    m_functions << QLatin1String("diagmatrixp");
    m_functions << QLatin1String("diameter");
    m_functions << QLatin1String("diff");
    m_functions << QLatin1String("digitcharp");
    m_functions << QLatin1String("dimacs_export");
    m_functions << QLatin1String("dimacs_import");
    m_functions << QLatin1String("dimension");
    m_functions << QLatin1String("direct");
    m_functions << QLatin1String("discrete_freq");
    m_functions << QLatin1String("disjoin");
    m_functions << QLatin1String("disjointp");
    m_functions << QLatin1String("disolate");
    m_functions << QLatin1String("disp");
    m_functions << QLatin1String("dispcon");
    m_functions << QLatin1String("dispform");
    m_functions << QLatin1String("dispfun");
    m_functions << QLatin1String("dispJordan");
    m_functions << QLatin1String("display");
    m_functions << QLatin1String("disprule");
    m_functions << QLatin1String("dispterms");
    m_functions << QLatin1String("distrib");
    m_functions << QLatin1String("divide");
    m_functions << QLatin1String("divisors");
    m_functions << QLatin1String("divsum");
    m_functions << QLatin1String("dkummer_m");
    m_functions << QLatin1String("dkummer_u");
    m_functions << QLatin1String("dlange");
    m_functions << QLatin1String("dodecahedron_graph");
    m_functions << QLatin1String("dotproduct");
    m_functions << QLatin1String("dotsimp");
    m_functions << QLatin1String("dpart");
    m_functions << QLatin1String("draw");
    m_functions << QLatin1String("draw2d");
    m_functions << QLatin1String("draw3d");
    m_functions << QLatin1String("draw_graph");
    m_functions << QLatin1String("dscalar");
    m_functions << QLatin1String("echelon");
    m_functions << QLatin1String("edge_coloring");
    m_functions << QLatin1String("edges");
    m_functions << QLatin1String("eigens_by_jacobi");
    m_functions << QLatin1String("eigenvalues");
    m_functions << QLatin1String("eigenvectors");
    m_functions << QLatin1String("eighth");
    m_functions << QLatin1String("einstein");
    m_functions << QLatin1String("eivals");
    m_functions << QLatin1String("eivects");
    m_functions << QLatin1String("elapsed_real_time");
    m_functions << QLatin1String("elapsed_run_time");
    m_functions << QLatin1String("ele2comp");
    m_functions << QLatin1String("ele2polynome");
    m_functions << QLatin1String("ele2pui");
    m_functions << QLatin1String("elem");
    m_functions << QLatin1String("elementp");
    m_functions << QLatin1String("eliminate");
    m_functions << QLatin1String("elliptic_e");
    m_functions << QLatin1String("elliptic_ec");
    m_functions << QLatin1String("elliptic_eu");
    m_functions << QLatin1String("elliptic_f");
    m_functions << QLatin1String("elliptic_kc");
    m_functions << QLatin1String("elliptic_pi");
    m_functions << QLatin1String("ematrix");
    m_functions << QLatin1String("empty_graph");
    m_functions << QLatin1String("emptyp");
    m_functions << QLatin1String("endcons");
    m_functions << QLatin1String("entermatrix");
    m_functions << QLatin1String("entertensor");
    m_functions << QLatin1String("entier");
    m_functions << QLatin1String("equal");
    m_functions << QLatin1String("equalp");
    m_functions << QLatin1String("equiv_classes");
    m_functions << QLatin1String("erf");
    m_functions << QLatin1String("errcatch");
    m_functions << QLatin1String("error");
    m_functions << QLatin1String("errormsg");
    m_functions << QLatin1String("euler");
    m_functions << QLatin1String("ev");
    m_functions << QLatin1String("eval_string");
    m_functions << QLatin1String("evenp");
    m_functions << QLatin1String("every");
    m_functions << QLatin1String("evolution");
    m_functions << QLatin1String("evolution2d");
    m_functions << QLatin1String("evundiff");
    m_functions << QLatin1String("example");
    m_functions << QLatin1String("exp");
    m_functions << QLatin1String("expand");
    m_functions << QLatin1String("expandwrt");
    m_functions << QLatin1String("expandwrt_factored");
    m_functions << QLatin1String("explose");
    m_functions << QLatin1String("exponentialize");
    m_functions << QLatin1String("express");
    m_functions << QLatin1String("expt");
    m_functions << QLatin1String("exsec");
    m_functions << QLatin1String("extdiff");
    m_functions << QLatin1String("extract_linear_equations");
    m_functions << QLatin1String("extremal_subset");
    m_functions << QLatin1String("ezgcd");
    m_functions << QLatin1String("f90");
    m_functions << QLatin1String("facsum");
    m_functions << QLatin1String("factcomb");
    m_functions << QLatin1String("factor");
    m_functions << QLatin1String("factorfacsum");
    m_functions << QLatin1String("factorial");
    m_functions << QLatin1String("factorout");
    m_functions << QLatin1String("factorsum");
    m_functions << QLatin1String("facts");
    m_functions << QLatin1String("fast_central_elements");
    m_functions << QLatin1String("fast_linsolve");
    m_functions << QLatin1String("fasttimes");
    m_functions << QLatin1String("featurep");
    m_functions << QLatin1String("fft");
    m_functions << QLatin1String("fib");
    m_functions << QLatin1String("fibtophi");
    m_functions << QLatin1String("fifth");
    m_functions << QLatin1String("filename_merge");
    m_functions << QLatin1String("file_search");
    m_functions << QLatin1String("file_type");
    m_functions << QLatin1String("fillarray");
    m_functions << QLatin1String("findde");
    m_functions << QLatin1String("find_root");
    m_functions << QLatin1String("first");
    m_functions << QLatin1String("fix");
    m_functions << QLatin1String("flatten");
    m_functions << QLatin1String("flength");
    m_functions << QLatin1String("float");
    m_functions << QLatin1String("floatnump");
    m_functions << QLatin1String("floor");
    m_functions << QLatin1String("flower_snark");
    m_functions << QLatin1String("flush");
    m_functions << QLatin1String("flush1deriv");
    m_functions << QLatin1String("flushd");
    m_functions << QLatin1String("flushnd");
    m_functions << QLatin1String("forget");
    m_functions << QLatin1String("fortran");
    m_functions << QLatin1String("fourcos");
    m_functions << QLatin1String("fourexpand");
    m_functions << QLatin1String("fourier");
    m_functions << QLatin1String("fourint");
    m_functions << QLatin1String("fourintcos");
    m_functions << QLatin1String("fourintsin");
    m_functions << QLatin1String("foursimp");
    m_functions << QLatin1String("foursin");
    m_functions << QLatin1String("fourth");
    m_functions << QLatin1String("fposition");
    m_functions << QLatin1String("frame_bracket");
    m_functions << QLatin1String("freeof");
    m_functions << QLatin1String("freshline");
    m_functions << QLatin1String("from_adjacency_matrix");
    m_functions << QLatin1String("frucht_graph");
    m_functions << QLatin1String("full_listify");
    m_functions << QLatin1String("fullmap");
    m_functions << QLatin1String("fullmapl");
    m_functions << QLatin1String("fullratsimp");
    m_functions << QLatin1String("fullratsubst");
    m_functions << QLatin1String("fullsetify");
    m_functions << QLatin1String("funcsolve");
    m_functions << QLatin1String("fundef");
    m_functions << QLatin1String("funmake");
    m_functions << QLatin1String("funp");
    m_functions << QLatin1String("gamma");
    m_functions << QLatin1String("gauss_a");
    m_functions << QLatin1String("gauss_b");
    m_functions << QLatin1String("gaussprob");
    m_functions << QLatin1String("gcd");
    m_functions << QLatin1String("gcdex");
    m_functions << QLatin1String("gcdivide");
    m_functions << QLatin1String("gcfac");
    m_functions << QLatin1String("gcfactor");
    m_functions << QLatin1String("gd");
    m_functions << QLatin1String("genfact");
    m_functions << QLatin1String("gen_laguerre");
    m_functions << QLatin1String("genmatrix");
    m_functions << QLatin1String("geometric");
    m_functions << QLatin1String("geometric_mean");
    m_functions << QLatin1String("geosum");
    m_functions << QLatin1String("get");
    m_functions << QLatin1String("get_edge_weight");
    m_functions << QLatin1String("get_lu_factors");
    m_functions << QLatin1String("get_pixel");
    m_functions << QLatin1String("get_vertex_label");
    m_functions << QLatin1String("gfactor");
    m_functions << QLatin1String("gfactorsum");
    m_functions << QLatin1String("ggf");
    m_functions << QLatin1String("girth");
    m_functions << QLatin1String("global_variances");
    m_functions << QLatin1String("gnuplot_close");
    m_functions << QLatin1String("gnuplot_replot");
    m_functions << QLatin1String("gnuplot_reset");
    m_functions << QLatin1String("gnuplot_restart");
    m_functions << QLatin1String("gnuplot_start");
    m_functions << QLatin1String("go");
    m_functions << QLatin1String("Gosper");
    m_functions << QLatin1String("GosperSum");
    m_functions << QLatin1String("gradef");
    m_functions << QLatin1String("gramschmidt");
    m_functions << QLatin1String("graph6_decode");
    m_functions << QLatin1String("graph6_encode");
    m_functions << QLatin1String("graph6_export");
    m_functions << QLatin1String("graph6_import");
    m_functions << QLatin1String("graph_center");
    m_functions << QLatin1String("graph_charpoly");
    m_functions << QLatin1String("graph_eigenvalues");
    m_functions << QLatin1String("graph_order");
    m_functions << QLatin1String("graph_periphery");
    m_functions << QLatin1String("graph_product");
    m_functions << QLatin1String("graph_size");
    m_functions << QLatin1String("graph_union");
    m_functions << QLatin1String("grid_graph");
    m_functions << QLatin1String("grind");
    m_functions << QLatin1String("grobner_basis");
    m_functions << QLatin1String("grotzch_graph");
    m_functions << QLatin1String("hamilton_cycle");
    m_functions << QLatin1String("hamilton_path");
    m_functions << QLatin1String("hankel");
    m_functions << QLatin1String("harmonic");
    m_functions << QLatin1String("harmonic_mean");
    m_functions << QLatin1String("hav");
    m_functions << QLatin1String("heawood_graph");
    m_functions << QLatin1String("hermite");
    m_functions << QLatin1String("hessian");
    m_functions << QLatin1String("hilbert_matrix");
    m_functions << QLatin1String("hipow");
    m_functions << QLatin1String("histogram");
    m_functions << QLatin1String("hodge");
    m_functions << QLatin1String("horner");
    m_functions << QLatin1String("ic1");
    m_functions << QLatin1String("ic2");
    m_functions << QLatin1String("ic_convert");
    m_functions << QLatin1String("ichr1");
    m_functions << QLatin1String("ichr2");
    m_functions << QLatin1String("icosahedron_graph");
    m_functions << QLatin1String("icurvature");
    m_functions << QLatin1String("ident");
    m_functions << QLatin1String("identfor");
    m_functions << QLatin1String("identity");
    m_functions << QLatin1String("idiff");
    m_functions << QLatin1String("idim");
    m_functions << QLatin1String("idummy");
    m_functions << QLatin1String("ieqn");
    m_functions << QLatin1String("ifactors");
    m_functions << QLatin1String("iframes");
    m_functions << QLatin1String("ifs");
    m_functions << QLatin1String("ift");
    m_functions << QLatin1String("igeodesic_coords");
    m_functions << QLatin1String("ilt");
    m_functions << QLatin1String("imagpart");
    m_functions << QLatin1String("imetric");
    m_functions << QLatin1String("implicit_derivative");
    m_functions << QLatin1String("implicit_plot");
    m_functions << QLatin1String("indexed_tensor");
    m_functions << QLatin1String("indices");
    m_functions << QLatin1String("induced_subgraph");
    m_functions << QLatin1String("inferencep");
    m_functions << QLatin1String("inference_result");
    m_functions << QLatin1String("infix");
    m_functions << QLatin1String("init_atensor");
    m_functions << QLatin1String("init_ctensor");
    m_functions << QLatin1String("in_neighbors");
    m_functions << QLatin1String("innerproduct");
    m_functions << QLatin1String("inpart");
    m_functions << QLatin1String("inprod");
    m_functions << QLatin1String("inrt");
    m_functions << QLatin1String("integerp");
    m_functions << QLatin1String("integer_partitions");
    m_functions << QLatin1String("integrate");
    m_functions << QLatin1String("intersect");
    m_functions << QLatin1String("intersection");
    m_functions << QLatin1String("intervalp");
    m_functions << QLatin1String("intopois");
    m_functions << QLatin1String("intosum");
    m_functions << QLatin1String("invariant1");
    m_functions << QLatin1String("invariant2");
    m_functions << QLatin1String("inverse_jacobi_cd");
    m_functions << QLatin1String("inverse_jacobi_cn");
    m_functions << QLatin1String("inverse_jacobi_cs");
    m_functions << QLatin1String("inverse_jacobi_dc");
    m_functions << QLatin1String("inverse_jacobi_dn");
    m_functions << QLatin1String("inverse_jacobi_ds");
    m_functions << QLatin1String("inverse_jacobi_nc");
    m_functions << QLatin1String("inverse_jacobi_nd");
    m_functions << QLatin1String("inverse_jacobi_ns");
    m_functions << QLatin1String("inverse_jacobi_sc");
    m_functions << QLatin1String("inverse_jacobi_sd");
    m_functions << QLatin1String("inverse_jacobi_sn");
    m_functions << QLatin1String("invert");
    m_functions << QLatin1String("invert_by_lu");
    m_functions << QLatin1String("inv_mod");
    m_functions << QLatin1String("is");
    m_functions << QLatin1String("is_biconnected");
    m_functions << QLatin1String("is_bipartite");
    m_functions << QLatin1String("is_connected");
    m_functions << QLatin1String("is_digraph");
    m_functions << QLatin1String("is_edge_in_graph");
    m_functions << QLatin1String("is_graph");
    m_functions << QLatin1String("is_graph_or_digraph");
    m_functions << QLatin1String("ishow");
    m_functions << QLatin1String("is_isomorphic");
    m_functions << QLatin1String("isolate");
    m_functions << QLatin1String("isomorphism");
    m_functions << QLatin1String("is_planar");
    m_functions << QLatin1String("isqrt");
    m_functions << QLatin1String("is_sconnected");
    m_functions << QLatin1String("is_tree");
    m_functions << QLatin1String("is_vertex_in_graph");
    m_functions << QLatin1String("items_inference");
    m_functions << QLatin1String("jacobi");
    m_functions << QLatin1String("jacobian");
    m_functions << QLatin1String("jacobi_cd");
    m_functions << QLatin1String("jacobi_cn");
    m_functions << QLatin1String("jacobi_cs");
    m_functions << QLatin1String("jacobi_dc");
    m_functions << QLatin1String("jacobi_dn");
    m_functions << QLatin1String("jacobi_ds");
    m_functions << QLatin1String("jacobi_nc");
    m_functions << QLatin1String("jacobi_nd");
    m_functions << QLatin1String("jacobi_ns");
    m_functions << QLatin1String("jacobi_p");
    m_functions << QLatin1String("jacobi_sc");
    m_functions << QLatin1String("jacobi_sd");
    m_functions << QLatin1String("jacobi_sn");
    m_functions << QLatin1String("JF");
    m_functions << QLatin1String("join");
    m_functions << QLatin1String("jordan");
    m_functions << QLatin1String("julia");
    m_functions << QLatin1String("kdels");
    m_functions << QLatin1String("kdelta");
    m_functions << QLatin1String("kill");
    m_functions << QLatin1String("killcontext");
    m_functions << QLatin1String("kostka");
    m_functions << QLatin1String("kron_delta");
    m_functions << QLatin1String("kronecker_product");
    m_functions << QLatin1String("kummer_m");
    m_functions << QLatin1String("kummer_u");
    m_functions << QLatin1String("kurtosis");
    m_functions << QLatin1String("kurtosis_bernoulli");
    m_functions << QLatin1String("kurtosis_beta");
    m_functions << QLatin1String("kurtosis_binomial");
    m_functions << QLatin1String("kurtosis_chi2");
    m_functions << QLatin1String("kurtosis_continuous_uniform");
    m_functions << QLatin1String("kurtosis_discrete_uniform");
    m_functions << QLatin1String("kurtosis_exp");
    m_functions << QLatin1String("kurtosis_f");
    m_functions << QLatin1String("kurtosis_gamma");
    m_functions << QLatin1String("kurtosis_geometric");
    m_functions << QLatin1String("kurtosis_gumbel");
    m_functions << QLatin1String("kurtosis_hypergeometric");
    m_functions << QLatin1String("kurtosis_laplace");
    m_functions << QLatin1String("kurtosis_logistic");
    m_functions << QLatin1String("kurtosis_lognormal");
    m_functions << QLatin1String("kurtosis_negative_binomial");
    m_functions << QLatin1String("kurtosis_normal");
    m_functions << QLatin1String("kurtosis_pareto");
    m_functions << QLatin1String("kurtosis_poisson");
    m_functions << QLatin1String("kurtosis_rayleigh");
    m_functions << QLatin1String("kurtosis_student_t");
    m_functions << QLatin1String("kurtosis_weibull");
    m_functions << QLatin1String("labels");
    m_functions << QLatin1String("lagrange");
    m_functions << QLatin1String("laguerre");
    m_functions << QLatin1String("lambda");
    m_functions << QLatin1String("laplace");
    m_functions << QLatin1String("laplacian_matrix");
    m_functions << QLatin1String("last");
    m_functions << QLatin1String("lbfgs");
    m_functions << QLatin1String("lc2kdt");
    m_functions << QLatin1String("lcharp");
    m_functions << QLatin1String("lc_l");
    m_functions << QLatin1String("lcm");
    m_functions << QLatin1String("lc_u");
    m_functions << QLatin1String("ldefint");
    m_functions << QLatin1String("ldisp");
    m_functions << QLatin1String("ldisplay");
    m_functions << QLatin1String("legendre_p");
    m_functions << QLatin1String("legendre_q");
    m_functions << QLatin1String("leinstein");
    m_functions << QLatin1String("length");
    m_functions << QLatin1String("let");
    m_functions << QLatin1String("letrules");
    m_functions << QLatin1String("letsimp");
    m_functions << QLatin1String("levi_civita");
    m_functions << QLatin1String("lfreeof");
    m_functions << QLatin1String("lgtreillis");
    m_functions << QLatin1String("lhs");
    m_functions << QLatin1String("li");
    m_functions << QLatin1String("liediff");
    m_functions << QLatin1String("limit");
    m_functions << QLatin1String("Lindstedt");
    m_functions << QLatin1String("linear");
    m_functions << QLatin1String("linearinterpol");
    m_functions << QLatin1String("linear_program");
    m_functions << QLatin1String("line_graph");
    m_functions << QLatin1String("linsolve");
    m_functions << QLatin1String("listarray");
    m_functions << QLatin1String("list_correlations");
    m_functions << QLatin1String("listify");
    m_functions << QLatin1String("list_nc_monomials");
    m_functions << QLatin1String("listoftens");
    m_functions << QLatin1String("listofvars");
    m_functions << QLatin1String("listp");
    m_functions << QLatin1String("lmax");
    m_functions << QLatin1String("lmin");
    m_functions << QLatin1String("load");
    m_functions << QLatin1String("loadfile");
    m_functions << QLatin1String("local");
    m_functions << QLatin1String("locate_matrix_entry");
    m_functions << QLatin1String("log");
    m_functions << QLatin1String("logand");
    m_functions << QLatin1String("logarc");
    m_functions << QLatin1String("logcontract");
    m_functions << QLatin1String("logor");
    m_functions << QLatin1String("logxor");
    m_functions << QLatin1String("lopow");
    m_functions << QLatin1String("lorentz_gauge");
    m_functions << QLatin1String("lowercasep");
    m_functions << QLatin1String("lpart");
    m_functions << QLatin1String("lratsubst");
    m_functions << QLatin1String("lreduce");
    m_functions << QLatin1String("lriemann");
    m_functions << QLatin1String("lsquares_estimates");
    m_functions << QLatin1String("lsquares_estimates_approximate");
    m_functions << QLatin1String("lsquares_estimates_exact");
    m_functions << QLatin1String("lsquares_mse");
    m_functions << QLatin1String("lsquares_residual_mse");
    m_functions << QLatin1String("lsquares_residuals");
    m_functions << QLatin1String("lsum");
    m_functions << QLatin1String("ltreillis");
    m_functions << QLatin1String("lu_backsub");
    m_functions << QLatin1String("lu_factor");
    m_functions << QLatin1String("macroexpand");
    m_functions << QLatin1String("macroexpand1");
    m_functions << QLatin1String("make_array");
    m_functions << QLatin1String("makebox");
    m_functions << QLatin1String("makefact");
    m_functions << QLatin1String("makegamma");
    m_functions << QLatin1String("make_level_picture");
    m_functions << QLatin1String("makelist");
    m_functions << QLatin1String("makeOrders");
    m_functions << QLatin1String("make_poly_continent");
    m_functions << QLatin1String("make_poly_country");
    m_functions << QLatin1String("make_polygon");
    m_functions << QLatin1String("make_random_state");
    m_functions << QLatin1String("make_rgb_picture");
    m_functions << QLatin1String("makeset");
    m_functions << QLatin1String("make_transform");
    m_functions << QLatin1String("mandelbrot");
    m_functions << QLatin1String("map");
    m_functions << QLatin1String("mapatom");
    m_functions << QLatin1String("maplist");
    m_functions << QLatin1String("matchdeclare");
    m_functions << QLatin1String("matchfix");
    m_functions << QLatin1String("mat_cond");
    m_functions << QLatin1String("mat_fullunblocker");
    m_functions << QLatin1String("mat_function");
    m_functions << QLatin1String("mat_norm");
    m_functions << QLatin1String("matrix");
    m_functions << QLatin1String("matrixmap");
    m_functions << QLatin1String("matrixp");
    m_functions << QLatin1String("matrix_size");
    m_functions << QLatin1String("mattrace");
    m_functions << QLatin1String("mat_trace");
    m_functions << QLatin1String("mat_unblocker");
    m_functions << QLatin1String("max");
    m_functions << QLatin1String("max_clique");
    m_functions << QLatin1String("max_degree");
    m_functions << QLatin1String("max_flow");
    m_functions << QLatin1String("maxi");
    m_functions << QLatin1String("maximize_lp");
    m_functions << QLatin1String("max_independent_set");
    m_functions << QLatin1String("max_matching");
    m_functions << QLatin1String("maybe");
    m_functions << QLatin1String("mean");
    m_functions << QLatin1String("mean_bernoulli");
    m_functions << QLatin1String("mean_beta");
    m_functions << QLatin1String("mean_binomial");
    m_functions << QLatin1String("mean_chi2");
    m_functions << QLatin1String("mean_continuous_uniform");
    m_functions << QLatin1String("mean_deviation");
    m_functions << QLatin1String("mean_discrete_uniform");
    m_functions << QLatin1String("mean_exp");
    m_functions << QLatin1String("mean_f");
    m_functions << QLatin1String("mean_gamma");
    m_functions << QLatin1String("mean_geometric");
    m_functions << QLatin1String("mean_gumbel");
    m_functions << QLatin1String("mean_hypergeometric");
    m_functions << QLatin1String("mean_laplace");
    m_functions << QLatin1String("mean_logistic");
    m_functions << QLatin1String("mean_lognormal");
    m_functions << QLatin1String("mean_negative_binomial");
    m_functions << QLatin1String("mean_normal");
    m_functions << QLatin1String("mean_pareto");
    m_functions << QLatin1String("mean_poisson");
    m_functions << QLatin1String("mean_rayleigh");
    m_functions << QLatin1String("mean_student_t");
    m_functions << QLatin1String("mean_weibull");
    m_functions << QLatin1String("median");
    m_functions << QLatin1String("median_deviation");
    m_functions << QLatin1String("member");
    m_functions << QLatin1String("metricexpandall");
    m_functions << QLatin1String("min");
    m_functions << QLatin1String("min_degree");
    m_functions << QLatin1String("minfactorial");
    m_functions << QLatin1String("mini");
    m_functions << QLatin1String("minimalPoly");
    m_functions << QLatin1String("minimize_lp");
    m_functions << QLatin1String("minimum_spanning_tree");
    m_functions << QLatin1String("minor");
    m_functions << QLatin1String("mnewton");
    m_functions << QLatin1String("mod");
    m_functions << QLatin1String("mode_declare");
    m_functions << QLatin1String("mode_identity");
    m_functions << QLatin1String("ModeMatrix");
    m_functions << QLatin1String("moebius");
    m_functions << QLatin1String("mon2schur");
    m_functions << QLatin1String("mono");
    m_functions << QLatin1String("monomial_dimensions");
    m_functions << QLatin1String("multi_elem");
    m_functions << QLatin1String("multinomial");
    m_functions << QLatin1String("multinomial_coeff");
    m_functions << QLatin1String("multi_orbit");
    m_functions << QLatin1String("multi_pui");
    m_functions << QLatin1String("multsym");
    m_functions << QLatin1String("multthru");
    m_functions << QLatin1String("mycielski_graph");
    m_functions << QLatin1String("nary");
    m_functions << QLatin1String("nc_degree");
    m_functions << QLatin1String("ncexpt");
    m_functions << QLatin1String("ncharpoly");
    m_functions << QLatin1String("negative_picture");
    m_functions << QLatin1String("neighbors");
    m_functions << QLatin1String("newcontext");
    m_functions << QLatin1String("newdet");
    m_functions << QLatin1String("new_graph");
    m_functions << QLatin1String("newline");
    m_functions << QLatin1String("newton");
    m_functions << QLatin1String("next_prime");
    m_functions << QLatin1String("niceindices");
    m_functions << QLatin1String("ninth");
    m_functions << QLatin1String("noncentral_moment");
    m_functions << QLatin1String("nonmetricity");
    m_functions << QLatin1String("nonnegintegerp");
    m_functions << QLatin1String("nonscalarp");
    m_functions << QLatin1String("nonzeroandfreeof");
    m_functions << QLatin1String("notequal");
    m_functions << QLatin1String("nounify");
    m_functions << QLatin1String("nptetrad");
    m_functions << QLatin1String("nroots");
    m_functions << QLatin1String("nterms");
    m_functions << QLatin1String("ntermst");
    m_functions << QLatin1String("nthroot");
    m_functions << QLatin1String("nullity");
    m_functions << QLatin1String("nullspace");
    m_functions << QLatin1String("num");
    m_functions << QLatin1String("numbered_boundaries");
    m_functions << QLatin1String("numberp");
    m_functions << QLatin1String("num_distinct_partitions");
    m_functions << QLatin1String("numerval");
    m_functions << QLatin1String("numfactor");
    m_functions << QLatin1String("num_partitions");
    m_functions << QLatin1String("nusum");
    m_functions << QLatin1String("odd_girth");
    m_functions << QLatin1String("oddp");
    m_functions << QLatin1String("ode2");
    m_functions << QLatin1String("ode_check");
    m_functions << QLatin1String("odelin");
    m_functions << QLatin1String("op");
    m_functions << QLatin1String("opena");
    m_functions << QLatin1String("openr");
    m_functions << QLatin1String("openw");
    m_functions << QLatin1String("operatorp");
    m_functions << QLatin1String("opsubst");
    m_functions << QLatin1String("optimize");
    m_functions << QLatin1String("orbit");
    m_functions << QLatin1String("orbits");
    m_functions << QLatin1String("ordergreat");
    m_functions << QLatin1String("ordergreatp");
    m_functions << QLatin1String("orderless");
    m_functions << QLatin1String("orderlessp");
    m_functions << QLatin1String("orthogonal_complement");
    m_functions << QLatin1String("orthopoly_recur");
    m_functions << QLatin1String("orthopoly_weight");
    m_functions << QLatin1String("outermap");
    m_functions << QLatin1String("out_neighbors");
    m_functions << QLatin1String("outofpois");
    m_functions << QLatin1String("pade");
    m_functions << QLatin1String("parGosper");
    m_functions << QLatin1String("parse_string");
    m_functions << QLatin1String("part");
    m_functions << QLatin1String("part2cont");
    m_functions << QLatin1String("partfrac");
    m_functions << QLatin1String("partition");
    m_functions << QLatin1String("partition_set");
    m_functions << QLatin1String("partpol");
    m_functions << QLatin1String("path_digraph");
    m_functions << QLatin1String("path_graph");
    m_functions << QLatin1String("pdf_bernoulli");
    m_functions << QLatin1String("pdf_beta");
    m_functions << QLatin1String("pdf_binomial");
    m_functions << QLatin1String("pdf_cauchy");
    m_functions << QLatin1String("pdf_chi2");
    m_functions << QLatin1String("pdf_continuous_uniform");
    m_functions << QLatin1String("pdf_discrete_uniform");
    m_functions << QLatin1String("pdf_exp");
    m_functions << QLatin1String("pdf_f");
    m_functions << QLatin1String("pdf_gamma");
    m_functions << QLatin1String("pdf_geometric");
    m_functions << QLatin1String("pdf_gumbel");
    m_functions << QLatin1String("pdf_hypergeometric");
    m_functions << QLatin1String("pdf_laplace");
    m_functions << QLatin1String("pdf_logistic");
    m_functions << QLatin1String("pdf_lognormal");
    m_functions << QLatin1String("pdf_negative_binomial");
    m_functions << QLatin1String("pdf_normal");
    m_functions << QLatin1String("pdf_pareto");
    m_functions << QLatin1String("pdf_poisson");
    m_functions << QLatin1String("pdf_rank_sum");
    m_functions << QLatin1String("pdf_rayleigh");
    m_functions << QLatin1String("pdf_signed_rank");
    m_functions << QLatin1String("pdf_student_t");
    m_functions << QLatin1String("pdf_weibull");
    m_functions << QLatin1String("pearson_skewness");
    m_functions << QLatin1String("permanent");
    m_functions << QLatin1String("permut");
    m_functions << QLatin1String("permutation");
    m_functions << QLatin1String("permutations");
    m_functions << QLatin1String("petersen_graph");
    m_functions << QLatin1String("petrov");
    m_functions << QLatin1String("pickapart");
    m_functions << QLatin1String("picture_equalp");
    m_functions << QLatin1String("picturep");
    m_functions << QLatin1String("piechart");
    m_functions << QLatin1String("planar_embedding");
    m_functions << QLatin1String("playback");
    m_functions << QLatin1String("plog");
    m_functions << QLatin1String("plot2d");
    m_functions << QLatin1String("plot3d");
    m_functions << QLatin1String("plotdf");
    m_functions << QLatin1String("plsquares");
    m_functions << QLatin1String("pochhammer");
    m_functions << QLatin1String("poisdiff");
    m_functions << QLatin1String("poisexpt");
    m_functions << QLatin1String("poisint");
    m_functions << QLatin1String("poismap");
    m_functions << QLatin1String("poisplus");
    m_functions << QLatin1String("poissimp");
    m_functions << QLatin1String("poissubst");
    m_functions << QLatin1String("poistimes");
    m_functions << QLatin1String("poistrim");
    m_functions << QLatin1String("polarform");
    m_functions << QLatin1String("polartorect");
    m_functions << QLatin1String("poly_add");
    m_functions << QLatin1String("poly_buchberger");
    m_functions << QLatin1String("poly_buchberger_criterion");
    m_functions << QLatin1String("poly_colon_ideal");
    m_functions << QLatin1String("poly_content");
    m_functions << QLatin1String("polydecomp");
    m_functions << QLatin1String("poly_depends_p");
    m_functions << QLatin1String("poly_elimination_ideal");
    m_functions << QLatin1String("poly_exact_divide");
    m_functions << QLatin1String("poly_expand");
    m_functions << QLatin1String("poly_expt");
    m_functions << QLatin1String("poly_gcd");
    m_functions << QLatin1String("poly_grobner");
    m_functions << QLatin1String("poly_grobner_equal");
    m_functions << QLatin1String("poly_grobner_member");
    m_functions << QLatin1String("poly_grobner_subsetp");
    m_functions << QLatin1String("poly_ideal_intersection");
    m_functions << QLatin1String("poly_ideal_polysaturation");
    m_functions << QLatin1String("poly_ideal_polysaturation1");
    m_functions << QLatin1String("poly_ideal_saturation");
    m_functions << QLatin1String("poly_ideal_saturation1");
    m_functions << QLatin1String("poly_lcm");
    m_functions << QLatin1String("poly_minimization");
    m_functions << QLatin1String("polymod");
    m_functions << QLatin1String("poly_multiply");
    m_functions << QLatin1String("polynome2ele");
    m_functions << QLatin1String("polynomialp");
    m_functions << QLatin1String("poly_normal_form");
    m_functions << QLatin1String("poly_normalize");
    m_functions << QLatin1String("poly_normalize_list");
    m_functions << QLatin1String("poly_polysaturation_extension");
    m_functions << QLatin1String("poly_primitive_part");
    m_functions << QLatin1String("poly_pseudo_divide");
    m_functions << QLatin1String("poly_reduced_grobner");
    m_functions << QLatin1String("poly_reduction");
    m_functions << QLatin1String("poly_saturation_extension");
    m_functions << QLatin1String("poly_s_polynomial");
    m_functions << QLatin1String("poly_subtract");
    m_functions << QLatin1String("polytocompanion");
    m_functions << QLatin1String("potential");
    m_functions << QLatin1String("power_mod");
    m_functions << QLatin1String("powers");
    m_functions << QLatin1String("powerseries");
    m_functions << QLatin1String("powerset");
    m_functions << QLatin1String("prev_prime");
    m_functions << QLatin1String("primep");
    m_functions << QLatin1String("print");
    m_functions << QLatin1String("printf");
    m_functions << QLatin1String("print_graph");
    m_functions << QLatin1String("printpois");
    m_functions << QLatin1String("printprops");
    m_functions << QLatin1String("prodrac");
    m_functions << QLatin1String("product");
    m_functions << QLatin1String("properties");
    m_functions << QLatin1String("propvars");
    m_functions << QLatin1String("psi");
    m_functions << QLatin1String("ptriangularize");
    m_functions << QLatin1String("pui");
    m_functions << QLatin1String("pui2comp");
    m_functions << QLatin1String("pui2ele");
    m_functions << QLatin1String("pui2polynome");
    m_functions << QLatin1String("pui_direct");
    m_functions << QLatin1String("puireduc");
    m_functions << QLatin1String("put");
    m_functions << QLatin1String("qput");
    m_functions << QLatin1String("qrange");
    m_functions << QLatin1String("quad_qag");
    m_functions << QLatin1String("quad_qagi");
    m_functions << QLatin1String("quad_qags");
    m_functions << QLatin1String("quad_qawc");
    m_functions << QLatin1String("quad_qawf");
    m_functions << QLatin1String("quad_qawo");
    m_functions << QLatin1String("quad_qaws");
    m_functions << QLatin1String("quantile");
    m_functions << QLatin1String("quantile_bernoulli");
    m_functions << QLatin1String("quantile_beta");
    m_functions << QLatin1String("quantile_binomial");
    m_functions << QLatin1String("quantile_cauchy");
    m_functions << QLatin1String("quantile_chi2");
    m_functions << QLatin1String("quantile_continuous_uniform");
    m_functions << QLatin1String("quantile_discrete_uniform");
    m_functions << QLatin1String("quantile_exp");
    m_functions << QLatin1String("quantile_f");
    m_functions << QLatin1String("quantile_gamma");
    m_functions << QLatin1String("quantile_geometric");
    m_functions << QLatin1String("quantile_gumbel");
    m_functions << QLatin1String("quantile_hypergeometric");
    m_functions << QLatin1String("quantile_laplace");
    m_functions << QLatin1String("quantile_logistic");
    m_functions << QLatin1String("quantile_lognormal");
    m_functions << QLatin1String("quantile_negative_binomial");
    m_functions << QLatin1String("quantile_normal");
    m_functions << QLatin1String("quantile_pareto");
    m_functions << QLatin1String("quantile_poisson");
    m_functions << QLatin1String("quantile_rayleigh");
    m_functions << QLatin1String("quantile_student_t");
    m_functions << QLatin1String("quantile_weibull");
    m_functions << QLatin1String("quartile_skewness");
    m_functions << QLatin1String("quit");
    m_functions << QLatin1String("qunit");
    m_functions << QLatin1String("quotient");
    m_functions << QLatin1String("radcan");
    m_functions << QLatin1String("radius");
    m_functions << QLatin1String("random");
    m_functions << QLatin1String("random_bernoulli");
    m_functions << QLatin1String("random_beta");
    m_functions << QLatin1String("random_binomial");
    m_functions << QLatin1String("random_cauchy");
    m_functions << QLatin1String("random_chi2");
    m_functions << QLatin1String("random_continuous_uniform");
    m_functions << QLatin1String("random_digraph");
    m_functions << QLatin1String("random_discrete_uniform");
    m_functions << QLatin1String("random_exp");
    m_functions << QLatin1String("random_f");
    m_functions << QLatin1String("random_gamma");
    m_functions << QLatin1String("random_geometric");
    m_functions << QLatin1String("random_graph");
    m_functions << QLatin1String("random_graph1");
    m_functions << QLatin1String("random_gumbel");
    m_functions << QLatin1String("random_hypergeometric");
    m_functions << QLatin1String("random_laplace");
    m_functions << QLatin1String("random_logistic");
    m_functions << QLatin1String("random_lognormal");
    m_functions << QLatin1String("random_negative_binomial");
    m_functions << QLatin1String("random_network");
    m_functions << QLatin1String("random_normal");
    m_functions << QLatin1String("random_pareto");
    m_functions << QLatin1String("random_permutation");
    m_functions << QLatin1String("random_poisson");
    m_functions << QLatin1String("random_rayleigh");
    m_functions << QLatin1String("random_regular_graph");
    m_functions << QLatin1String("random_student_t");
    m_functions << QLatin1String("random_tournament");
    m_functions << QLatin1String("random_tree");
    m_functions << QLatin1String("random_weibull");
    m_functions << QLatin1String("range");
    m_functions << QLatin1String("rank");
    m_functions << QLatin1String("rat");
    m_functions << QLatin1String("ratcoef");
    m_functions << QLatin1String("ratdenom");
    m_functions << QLatin1String("ratdiff");
    m_functions << QLatin1String("ratdisrep");
    m_functions << QLatin1String("ratexpand");
    m_functions << QLatin1String("rational");
    m_functions << QLatin1String("rationalize");
    m_functions << QLatin1String("ratnumer");
    m_functions << QLatin1String("ratnump");
    m_functions << QLatin1String("ratp");
    m_functions << QLatin1String("ratsimp");
    m_functions << QLatin1String("ratsubst");
    m_functions << QLatin1String("ratvars");
    m_functions << QLatin1String("ratweight");
    m_functions << QLatin1String("read");
    m_functions << QLatin1String("read_hashed_array");
    m_functions << QLatin1String("readline");
    m_functions << QLatin1String("read_lisp_array");
    m_functions << QLatin1String("read_list");
    m_functions << QLatin1String("read_matrix");
    m_functions << QLatin1String("read_maxima_array");
    m_functions << QLatin1String("read_nested_list");
    m_functions << QLatin1String("readonly");
    m_functions << QLatin1String("read_xpm");
    m_functions << QLatin1String("realpart");
    m_functions << QLatin1String("realroots");
    m_functions << QLatin1String("rearray");
    m_functions << QLatin1String("rectform");
    m_functions << QLatin1String("recttopolar");
    m_functions << QLatin1String("rediff");
    m_functions << QLatin1String("reduce_consts");
    m_functions << QLatin1String("reduce_order");
    m_functions << QLatin1String("region_boundaries");
    m_functions << QLatin1String("rem");
    m_functions << QLatin1String("remainder");
    m_functions << QLatin1String("remarray");
    m_functions << QLatin1String("rembox");
    m_functions << QLatin1String("remcomps");
    m_functions << QLatin1String("remcon");
    m_functions << QLatin1String("remcoord");
    m_functions << QLatin1String("remfun");
    m_functions << QLatin1String("remfunction");
    m_functions << QLatin1String("remlet");
    m_functions << QLatin1String("remove");
    m_functions << QLatin1String("remove_edge");
    m_functions << QLatin1String("remove_vertex");
    m_functions << QLatin1String("rempart");
    m_functions << QLatin1String("remrule");
    m_functions << QLatin1String("remsym");
    m_functions << QLatin1String("remvalue");
    m_functions << QLatin1String("rename");
    m_functions << QLatin1String("reset");
    m_functions << QLatin1String("residue");
    m_functions << QLatin1String("resolvante");
    m_functions << QLatin1String("resolvante_alternee1");
    m_functions << QLatin1String("resolvante_bipartite");
    m_functions << QLatin1String("resolvante_diedrale");
    m_functions << QLatin1String("resolvante_klein");
    m_functions << QLatin1String("resolvante_klein3");
    m_functions << QLatin1String("resolvante_produit_sym");
    m_functions << QLatin1String("resolvante_unitaire");
    m_functions << QLatin1String("resolvante_vierer");
    m_functions << QLatin1String("rest");
    m_functions << QLatin1String("resultant");
    m_functions << QLatin1String("return");
    m_functions << QLatin1String("reveal");
    m_functions << QLatin1String("reverse");
    m_functions << QLatin1String("revert");
    m_functions << QLatin1String("revert2");
    m_functions << QLatin1String("rgb2level");
    m_functions << QLatin1String("rhs");
    m_functions << QLatin1String("ricci");
    m_functions << QLatin1String("riemann");
    m_functions << QLatin1String("rinvariant");
    m_functions << QLatin1String("risch");
    m_functions << QLatin1String("rk");
    m_functions << QLatin1String("rncombine");
    m_functions << QLatin1String("romberg");
    m_functions << QLatin1String("room");
    m_functions << QLatin1String("rootscontract");
    m_functions << QLatin1String("row");
    m_functions << QLatin1String("rowop");
    m_functions << QLatin1String("rowswap");
    m_functions << QLatin1String("rreduce");
    m_functions << QLatin1String("run_testsuite");
    m_functions << QLatin1String("save");
    m_functions << QLatin1String("scalarp");
    m_functions << QLatin1String("scaled_bessel_i");
    m_functions << QLatin1String("scaled_bessel_i0");
    m_functions << QLatin1String("scaled_bessel_i1");
    m_functions << QLatin1String("scalefactors");
    m_functions << QLatin1String("scanmap");
    m_functions << QLatin1String("scatterplot");
    m_functions << QLatin1String("schur2comp");
    m_functions << QLatin1String("sconcat");
    m_functions << QLatin1String("scopy");
    m_functions << QLatin1String("scsimp");
    m_functions << QLatin1String("scurvature");
    m_functions << QLatin1String("sdowncase");
    m_functions << QLatin1String("sec");
    m_functions << QLatin1String("sech");
    m_functions << QLatin1String("second");
    m_functions << QLatin1String("sequal");
    m_functions << QLatin1String("sequalignore");
    m_functions << QLatin1String("setdifference");
    m_functions << QLatin1String("set_edge_weight");
    m_functions << QLatin1String("setelmx");
    m_functions << QLatin1String("setequalp");
    m_functions << QLatin1String("setify");
    m_functions << QLatin1String("setp");
    m_functions << QLatin1String("set_partitions");
    m_functions << QLatin1String("set_plot_option");
    m_functions << QLatin1String("set_random_state");
    m_functions << QLatin1String("setunits");
    m_functions << QLatin1String("setup_autoload");
    m_functions << QLatin1String("set_up_dot_simplifications");
    m_functions << QLatin1String("set_vertex_label");
    m_functions << QLatin1String("seventh");
    m_functions << QLatin1String("sexplode");
    m_functions << QLatin1String("sf");
    m_functions << QLatin1String("shortest_path");
    m_functions << QLatin1String("show");
    m_functions << QLatin1String("showcomps");
    m_functions << QLatin1String("showratvars");
    m_functions << QLatin1String("sign");
    m_functions << QLatin1String("signum");
    m_functions << QLatin1String("similaritytransform");
    m_functions << QLatin1String("simple_linear_regression");
    m_functions << QLatin1String("simplify_sum");
    m_functions << QLatin1String("simplode");
    m_functions << QLatin1String("simpmetderiv");
    m_functions << QLatin1String("simtran");
    m_functions << QLatin1String("sin");
    m_functions << QLatin1String("sinh");
    m_functions << QLatin1String("sinsert");
    m_functions << QLatin1String("sinvertcase");
    m_functions << QLatin1String("sixth");
    m_functions << QLatin1String("skewness");
    m_functions << QLatin1String("skewness_bernoulli");
    m_functions << QLatin1String("skewness_beta");
    m_functions << QLatin1String("skewness_binomial");
    m_functions << QLatin1String("skewness_chi2");
    m_functions << QLatin1String("skewness_continuous_uniform");
    m_functions << QLatin1String("skewness_discrete_uniform");
    m_functions << QLatin1String("skewness_exp");
    m_functions << QLatin1String("skewness_f");
    m_functions << QLatin1String("skewness_gamma");
    m_functions << QLatin1String("skewness_geometric");
    m_functions << QLatin1String("skewness_gumbel");
    m_functions << QLatin1String("skewness_hypergeometric");
    m_functions << QLatin1String("skewness_laplace");
    m_functions << QLatin1String("skewness_logistic");
    m_functions << QLatin1String("skewness_lognormal");
    m_functions << QLatin1String("skewness_negative_binomial");
    m_functions << QLatin1String("skewness_normal");
    m_functions << QLatin1String("skewness_pareto");
    m_functions << QLatin1String("skewness_poisson");
    m_functions << QLatin1String("skewness_rayleigh");
    m_functions << QLatin1String("skewness_student_t");
    m_functions << QLatin1String("skewness_weibull");
    m_functions << QLatin1String("slength");
    m_functions << QLatin1String("smake");
    m_functions << QLatin1String("smismatch");
    m_functions << QLatin1String("solve");
    m_functions << QLatin1String("solve_rec");
    m_functions << QLatin1String("solve_rec_rat");
    m_functions << QLatin1String("some");
    m_functions << QLatin1String("somrac");
    m_functions << QLatin1String("sort");
    m_functions << QLatin1String("sparse6_decode");
    m_functions << QLatin1String("sparse6_encode");
    m_functions << QLatin1String("sparse6_export");
    m_functions << QLatin1String("sparse6_import");
    m_functions << QLatin1String("specint");
    m_functions << QLatin1String("spherical_bessel_j");
    m_functions << QLatin1String("spherical_bessel_y");
    m_functions << QLatin1String("spherical_hankel1");
    m_functions << QLatin1String("spherical_hankel2");
    m_functions << QLatin1String("spherical_harmonic");
    m_functions << QLatin1String("splice");
    m_functions << QLatin1String("split");
    m_functions << QLatin1String("sposition");
    m_functions << QLatin1String("sprint");
    m_functions << QLatin1String("sqfr");
    m_functions << QLatin1String("sqrt");
    m_functions << QLatin1String("sqrtdenest");
    m_functions << QLatin1String("sremove");
    m_functions << QLatin1String("sremovefirst");
    m_functions << QLatin1String("sreverse");
    m_functions << QLatin1String("ssearch");
    m_functions << QLatin1String("ssort");
    m_functions << QLatin1String("sstatus");
    m_functions << QLatin1String("ssubst");
    m_functions << QLatin1String("ssubstfirst");
    m_functions << QLatin1String("staircase");
    m_functions << QLatin1String("status");
    m_functions << QLatin1String("std");
    m_functions << QLatin1String("std1");
    m_functions << QLatin1String("std_bernoulli");
    m_functions << QLatin1String("std_beta");
    m_functions << QLatin1String("std_binomial");
    m_functions << QLatin1String("std_chi2");
    m_functions << QLatin1String("std_continuous_uniform");
    m_functions << QLatin1String("std_discrete_uniform");
    m_functions << QLatin1String("std_exp");
    m_functions << QLatin1String("std_f");
    m_functions << QLatin1String("std_gamma");
    m_functions << QLatin1String("std_geometric");
    m_functions << QLatin1String("std_gumbel");
    m_functions << QLatin1String("std_hypergeometric");
    m_functions << QLatin1String("std_laplace");
    m_functions << QLatin1String("std_logistic");
    m_functions << QLatin1String("std_lognormal");
    m_functions << QLatin1String("std_negative_binomial");
    m_functions << QLatin1String("std_normal");
    m_functions << QLatin1String("std_pareto");
    m_functions << QLatin1String("std_poisson");
    m_functions << QLatin1String("std_rayleigh");
    m_functions << QLatin1String("std_student_t");
    m_functions << QLatin1String("std_weibull");
    m_functions << QLatin1String("stirling");
    m_functions << QLatin1String("stirling1");
    m_functions << QLatin1String("stirling2");
    m_functions << QLatin1String("strim");
    m_functions << QLatin1String("striml");
    m_functions << QLatin1String("strimr");
    m_functions << QLatin1String("string");
    m_functions << QLatin1String("stringout");
    m_functions << QLatin1String("stringp");
    m_functions << QLatin1String("strong_components");
    m_functions << QLatin1String("sublis");
    m_functions << QLatin1String("sublist");
    m_functions << QLatin1String("sublist_indices");
    m_functions << QLatin1String("submatrix");
    m_functions << QLatin1String("subsample");
    m_functions << QLatin1String("subset");
    m_functions << QLatin1String("subsetp");
    m_functions << QLatin1String("subst");
    m_functions << QLatin1String("substinpart");
    m_functions << QLatin1String("substpart");
    m_functions << QLatin1String("substring");
    m_functions << QLatin1String("subvar");
    m_functions << QLatin1String("subvarp");
    m_functions << QLatin1String("sum");
    m_functions << QLatin1String("sumcontract");
    m_functions << QLatin1String("summand_to_rec");
    m_functions << QLatin1String("supcase");
    m_functions << QLatin1String("supcontext");
    m_functions << QLatin1String("symbolp");
    m_functions << QLatin1String("symmdifference");
    m_functions << QLatin1String("symmetric");
    m_functions << QLatin1String("system");
    m_functions << QLatin1String("take_channel");
    m_functions << QLatin1String("take_inference");
    m_functions << QLatin1String("tan");
    m_functions << QLatin1String("tanh");
    m_functions << QLatin1String("taylor");
    m_functions << QLatin1String("taylorinfo");
    m_functions << QLatin1String("taylorp");
    m_functions << QLatin1String("taylor_simplifier");
    m_functions << QLatin1String("taytorat");
    m_functions << QLatin1String("tcl_output");
    m_functions << QLatin1String("tcontract");
    m_functions << QLatin1String("tellrat");
    m_functions << QLatin1String("tellsimp");
    m_functions << QLatin1String("tellsimpafter");
    m_functions << QLatin1String("tentex");
    m_functions << QLatin1String("tenth");
    m_functions << QLatin1String("test_mean");
    m_functions << QLatin1String("test_means_difference");
    m_functions << QLatin1String("test_normality");
    m_functions << QLatin1String("test_rank_sum");
    m_functions << QLatin1String("test_sign");
    m_functions << QLatin1String("test_signed_rank");
    m_functions << QLatin1String("test_variance");
    m_functions << QLatin1String("test_variance_ratio");
    m_functions << QLatin1String("tex");
    m_functions << QLatin1String("texput");
    m_functions << QLatin1String("%th");
    m_functions << QLatin1String("third");
    m_functions << QLatin1String("throw");
    m_functions << QLatin1String("time");
    m_functions << QLatin1String("timedate");
    m_functions << QLatin1String("timer");
    m_functions << QLatin1String("timer_info");
    m_functions << QLatin1String("tldefint");
    m_functions << QLatin1String("tlimit");
    m_functions << QLatin1String("todd_coxeter");
    m_functions << QLatin1String("toeplitz");
    m_functions << QLatin1String("tokens");
    m_functions << QLatin1String("to_lisp");
    m_functions << QLatin1String("topological_sort");
    m_functions << QLatin1String("totaldisrep");
    m_functions << QLatin1String("totalfourier");
    m_functions << QLatin1String("totient");
    m_functions << QLatin1String("tpartpol");
    m_functions << QLatin1String("trace");
    m_functions << QLatin1String("tracematrix");
    m_functions << QLatin1String("trace_options");
    m_functions << QLatin1String("translate");
    m_functions << QLatin1String("translate_file");
    m_functions << QLatin1String("transpose");
    m_functions << QLatin1String("tree_reduce");
    m_functions << QLatin1String("treillis");
    m_functions << QLatin1String("treinat");
    m_functions << QLatin1String("triangularize");
    m_functions << QLatin1String("trigexpand");
    m_functions << QLatin1String("trigrat");
    m_functions << QLatin1String("trigreduce");
    m_functions << QLatin1String("trigsimp");
    m_functions << QLatin1String("trunc");
    m_functions << QLatin1String("tr_warnings_get");
    m_functions << QLatin1String("ueivects");
    m_functions << QLatin1String("uforget");
    m_functions << QLatin1String("ultraspherical");
    m_functions << QLatin1String("underlying_graph");
    m_functions << QLatin1String("undiff");
    m_functions << QLatin1String("union");
    m_functions << QLatin1String("unique");
    m_functions << QLatin1String("uniteigenvectors");
    m_functions << QLatin1String("unit_step");
    m_functions << QLatin1String("unitvector");
    m_functions << QLatin1String("unknown");
    m_functions << QLatin1String("unorder");
    m_functions << QLatin1String("unsum");
    m_functions << QLatin1String("untellrat");
    m_functions << QLatin1String("untimer");
    m_functions << QLatin1String("untrace");
    m_functions << QLatin1String("uppercasep");
    m_functions << QLatin1String("uricci");
    m_functions << QLatin1String("uriemann");
    m_functions << QLatin1String("uvect");
    m_functions << QLatin1String("vandermonde_matrix");
    m_functions << QLatin1String("var");
    m_functions << QLatin1String("var1");
    m_functions << QLatin1String("var_bernoulli");
    m_functions << QLatin1String("var_beta");
    m_functions << QLatin1String("var_binomial");
    m_functions << QLatin1String("var_chi2");
    m_functions << QLatin1String("var_continuous_uniform");
    m_functions << QLatin1String("var_discrete_uniform");
    m_functions << QLatin1String("var_exp");
    m_functions << QLatin1String("var_f");
    m_functions << QLatin1String("var_gamma");
    m_functions << QLatin1String("var_geometric");
    m_functions << QLatin1String("var_gumbel");
    m_functions << QLatin1String("var_hypergeometric");
    m_functions << QLatin1String("var_laplace");
    m_functions << QLatin1String("var_logistic");
    m_functions << QLatin1String("var_lognormal");
    m_functions << QLatin1String("var_negative_binomial");
    m_functions << QLatin1String("var_normal");
    m_functions << QLatin1String("var_pareto");
    m_functions << QLatin1String("var_poisson");
    m_functions << QLatin1String("var_rayleigh");
    m_functions << QLatin1String("var_student_t");
    m_functions << QLatin1String("var_weibull");
    m_functions << QLatin1String("vectorpotential");
    m_functions << QLatin1String("vectorsimp");
    m_functions << QLatin1String("verbify");
    m_functions << QLatin1String("vers");
    m_functions << QLatin1String("vertex_coloring");
    m_functions << QLatin1String("vertex_degree");
    m_functions << QLatin1String("vertex_distance");
    m_functions << QLatin1String("vertex_eccentricity");
    m_functions << QLatin1String("vertex_in_degree");
    m_functions << QLatin1String("vertex_out_degree");
    m_functions << QLatin1String("vertices");
    m_functions << QLatin1String("vertices_to_cycle");
    m_functions << QLatin1String("vertices_to_path");
    m_functions << QLatin1String("weyl");
    m_functions << QLatin1String("wheel_graph");
    m_functions << QLatin1String("with_stdout");
    m_functions << QLatin1String("write_data");
    m_functions << QLatin1String("writefile");
    m_functions << QLatin1String("wronskian");
    m_functions << QLatin1String("xgraph_curves");
    m_functions << QLatin1String("xreduce");
    m_functions << QLatin1String("xthru");
    m_functions << QLatin1String("Zeilberger");
    m_functions << QLatin1String("zeroequiv");
    m_functions << QLatin1String("zerofor");
    m_functions << QLatin1String("zeromatrix");
    m_functions << QLatin1String("zeromatrixp");
    m_functions << QLatin1String("zeta");
    m_functions << QLatin1String("zlange");
    //Finish m_functions initialization

    //Begin m_keywords initialization
    m_keywords << QLatin1String("and");
    m_keywords << QLatin1String("do");
    m_keywords << QLatin1String("else");
    m_keywords << QLatin1String("elseif");
    m_keywords << QLatin1String("false");
    m_keywords << QLatin1String("for");
    m_keywords << QLatin1String("if");
    m_keywords << QLatin1String("in");
    m_keywords << QLatin1String("not");
    m_keywords << QLatin1String("or");
    m_keywords << QLatin1String("step");
    m_keywords << QLatin1String("then");
    m_keywords << QLatin1String("thru");
    m_keywords << QLatin1String("true");
    m_keywords << QLatin1String("while");
    //Finish m_keywords initialization
}

const QStringList& MaximaKeywords::variables() const
{
    return m_variables;
}

const QStringList& MaximaKeywords::functions() const
{
    return m_functions;
}

const QStringList& MaximaKeywords::keywords() const
{
    return m_keywords;
}
