// -*- indent-tabs-mode: nil -*-

#include <cppunit/extensions/HelperMacros.h>

#include <string>
#include <iostream>

#include "../namespacespolicy.h"
#include "../canlxx.h"

std::string trusted_cacertpath = "trusted_certificates";
std::string certpath = "testCA/certs/cert.pem";
std::string keypath = "testCA/certs/key.pem";

class NamespacesPolicyTest
  : public CppUnit::TestFixture {

  CPPUNIT_TEST_SUITE(NamespacesPolicyTest);
  CPPUNIT_TEST(TestNamespacesPolicy);
  CPPUNIT_TEST_SUITE_END();

public:
  NamespacesPolicyTest() {};
  void setUp(){};
  void tearDown(){};
  void TestNamespacesPolicy();

};

void NamespacesPolicyTest::TestNamespacesPolicy(){
  std::string cert;
  std::string issuer_name;
  std::string subject_name;
  AuthN::Context ctx(AuthN::Context::EmptyContext);
  ctx.SetCredentials(certpath, keypath);
  ctx.SetCAPath(trusted_cacertpath);
  AuthN::Credentials cred(ctx);  

  cred.GetCertificate(cert);  
  issuer_name = cred.GetIssuerName();
  subject_name = cred.GetSubjectName();  

  CPPUNIT_ASSERT(!cert.empty());
  CPPUNIT_ASSERT(!issuer_name.empty());
  CPPUNIT_ASSERT(!subject_name.empty());
  CPPUNIT_ASSERT(!(ctx.GetCAPath().empty()));
 
  AuthN::NamespacesPolicy ns_policy(issuer_name, ctx.GetCAPath());
  bool res = ns_policy.Match(subject_name);
  CPPUNIT_ASSERT(res);

}

CPPUNIT_TEST_SUITE_REGISTRATION(NamespacesPolicyTest);
