//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/Instrument/OffspecDetectorEditor.cpp
//! @brief     Implements class DetectorEditor
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#include "GUI/View/Instrument/OffspecDetectorEditor.h"
#include "GUI/Model/Detector/OffspecDetectorItem.h"
#include "GUI/Model/Device/InstrumentItems.h"
#include "GUI/View/Device/AxisPropertyForm.h"
#include "GUI/View/Tool/GroupBoxCollapser.h"
#include <QFormLayout>


OffspecDetectorEditor::OffspecDetectorEditor(QWidget* parent, OffspecInstrumentItem* instrument)
    : QGroupBox("Detector parameters", parent)
    , m_instrument(instrument)
{
    ASSERT(instrument);
    m_formLayout = new QFormLayout(this);

    auto* collapser = GroupBoxCollapser::installIntoGroupBox(this);
    collapser->setExpanded(instrument->isExpandDetector());
    connect(collapser, &GroupBoxCollapser::toggled, this,
            [instrument](bool b) { instrument->setExpandDetector(b); });

    while (m_formLayout->rowCount() > 1)
        m_formLayout->removeRow(1);

    OffspecDetectorItem* detector_item = m_instrument->detectorItem();

    auto* grid = new QGridLayout;
    grid->setColumnStretch(0, 1);
    grid->setColumnStretch(1, 1);
    grid->setColumnStretch(2, 1);

    auto* phiForm = new AxisPropertyForm(this, u8"\u03c6 axis", &detector_item->phiAxis(),
                                         "Number of phi-axis bins");
    grid->addWidget(phiForm, 1, 0);

    auto* alphaForm = new AxisPropertyForm(this, u8"\u03b1 axis", &detector_item->alphaAxis(),
                                           "Number of alpha-axis bins");
    grid->addWidget(alphaForm, 1, 1);

    grid->setRowStretch(2, 1);

    connect(phiForm, &AxisPropertyForm::dataChanged, this, &OffspecDetectorEditor::dataChanged);

    connect(alphaForm, &AxisPropertyForm::dataChanged, this, &OffspecDetectorEditor::dataChanged);

    m_formLayout->addRow(grid);
}
