# RPM .spec file
#
# Release number can be specified with rpm --define 'rel SOMETHING' ...
# If no such --define is used, the release number is 1.
#
# Source archive's extension can be specified with rpm --define 'srcext .foo'
# where .foo is the source archive's actual extension.
# To compile an RPM from a .bz2 source archive, give the command
#   rpmbuild -ta --define 'srcext .bz2' boolstuff-0.1.14.tar.bz2
#
%if %{?rel:0}%{!?rel:1}
%define rel 1
%endif
%if %{?srcext:0}%{!?srcext:1}
%define srcext .gz
%endif

Summary: Disjunctive Normal Form boolean expression library
Summary(fr): Librairie calculant la forme normale disjonctive boolenne
Name: boolstuff
Version: 0.1.14
Release: %{rel}
License: GPL
Group: Development/Libraries
Source0: %{name}-%{version}.tar%{srcext}
URL: http://sarrazip.com/dev/boolstuff.html
Prefix: /usr
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root

%description
This library contains an algorithm that converts a boolean expression
binary tree into the Disjunctive Normal Form.  The NOT operator
is supported.
A command that calls this library is also provided.

%description -l fr
Cette librairie contient un algorithme qui convertit une expression
booléenne sous forme d'arbre binaire en sa forme normale disjonctive.
L'opérateur de négation est supporté.
Une commande appelant cette librairie est aussi fournie.


%package devel
Summary: C++ header files for the boolstuff library
Summary(fr): En-têtes C++ pour la librairie boolstuff.
Group: Development/Libraries
Requires: %{name} = %{version}-%{release}

%description devel
C++ header files to develop with the BoolStuff library.

%description -l fr devel
En-têtes C++ pour développer avec la librairie BoolStuff.


%prep
%setup -q

%build
# Option --disable-dependency-tracking seems necessary for g++ 2.95.3.
%configure --disable-dependency-tracking --disable-maintainer-mode
make %{?_smp_mflags}

%install
rm -fR $RPM_BUILD_ROOT
make install DESTDIR=$RPM_BUILD_ROOT INSTALL="%{__install} -p"

%clean
rm -fR $RPM_BUILD_ROOT

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%files
%defattr(-, root, root)
%{_libdir}/lib*.so.*
%{_mandir}/man*/*.*
%{_bindir}/*
%doc %{_defaultdocdir}/*

%files devel
%defattr(-, root, root)
%{_includedir}/*
%{_libdir}/lib*.so
%{_prefix}/lib/lib*.la
%{_libdir}/pkgconfig/*
