# -*- coding: utf-8 -*-
# Balazar in the Rancid Skull Dungeon
# Copyright (C) 2008 Jean-Baptiste LAMY
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import sys, os, os.path, struct, random, atexit

import cerealizer
import balazar3.tofu    as tofu
import balazar3.globdef as globdef

exec "import balazar3.driver_%s as driver" % globdef.DRIVER

init = driver.init

class MainLoop    (driver.MainLoop    ): pass
class PlayerID    (driver.PlayerID    ): pass
class Player      (driver.Player      ): pass
class Level       (driver.Level       ): pass
class ItemOnGround(driver.ItemOnGround): pass

class Chest(driver.Chest):
  def get_item(self):
    h = random.random()
    if h < 0.2: return LifePotion()
    if h > 0.8: return ExperiencePotion()
    return random.choice([Cudgel, BigClub, Staff, Axe, Knife, Sword, LargeSword, FireWand, FireStaff, IceWand, IceStaff])()
    
  
class Club(driver.Weapon, driver.Item):
  damages    = [[driver.ATTACK_BASH, 3]]
  model_name = "gourdin"
  
class Cudgel(driver.Weapon, driver.Dropable, driver.Item):
  damages    = [[driver.ATTACK_BASH, 3], [driver.ATTACK_SHARP, 1]]
  model_name = "massue"
  
class BigClub(driver.Weapon, driver.Dropable, driver.Item):
  damages    = [[driver.ATTACK_BASH, 4]]
  model_name = "gros_gourdin"
  
class Staff(driver.Weapon, driver.Dropable, driver.Item):
  damages    = [[driver.ATTACK_BASH, 1], [driver.ATTACK_BASH, 1]]
  model_name = "baton"
  
class Axe(driver.Weapon, driver.Dropable, driver.Item):
  damages    = [[driver.ATTACK_SHARP, 2], [driver.ATTACK_BASH, 2]]
  model_name = "hache"
  def usable_by(self, character):
    if isinstance(character, Balazar): return 0
    return 1
  
class Knife(driver.Weapon, driver.Dropable, driver.Item):
  damages      = [[driver.ATTACK_SHARP, 3]]
  model_name   = "couteau"
  strike_sound = "strike2.wav"
  def usable_by(self, character):
    if isinstance(character, Balazar): return 0
    return 1
  
class Sword(driver.Weapon, driver.Dropable, driver.Item):
  damages      = [[driver.ATTACK_SHARP, 4]]
  model_name   = "epee"
  strike_sound = "strike2.wav"
  def usable_by(self, character):
    if isinstance(character, Balazar): return 0
    return 1
  
class LargeSword(driver.Weapon, driver.Dropable, driver.Item):
  damages      = [[driver.ATTACK_SHARP, 3], [driver.ATTACK_BASH, 1]]
  model_name   = "epee_large"
  strike_sound = "strike2.wav"
  def usable_by(self, character):
    if isinstance(character, Balazar): return 0
    return 1
  
class FireWand(driver.Limited, driver.Weapon, driver.Usable, driver.Dropable, driver.Item):
  damages      = [[driver.ATTACK_FIRE, 8]]
  model_name   = "baguette_feu"
  nb_use       = 8
  strike_sound = "fire1.wav"
  
class FireStaff(driver.Limited, driver.Weapon, driver.Usable, driver.Dropable, driver.Item):
  damages      = [[driver.ATTACK_FIRE, 12]]
  model_name   = "baton_feu"
  nb_use       = 5
  strike_sound = "fire1.wav"
  
class IceWand(driver.Limited, driver.Weapon, driver.Usable, driver.Dropable, driver.Item):
  damages      = [[driver.ATTACK_ICE, 5]]
  model_name   = "baguette_glace"
  nb_use       = 8
  strike_sound = "fire1.wav"
  
class IceStaff(driver.Limited, driver.Weapon, driver.Usable, driver.Dropable, driver.Item):
  damages      = [[driver.ATTACK_ICE, 8]]
  model_name   = "baton_glace"
  nb_use       = 5
  strike_sound = "fire1.wav"
  
class LifePotion(driver.Limited, driver.Usable, driver.Dropable, driver.Item):
  model_name = "potion_de_vie"
  @tofu.side("server", "single")
  def used(self, character):
    super(LifePotion, self).used(character)
    character.send_message(driver.MESSAGE_LIFE + str(driver.ATTACK_HEAL) + struct.pack("!f", 1.0))
    
class ExperiencePotion(driver.Limited, driver.Usable, driver.Dropable, driver.Item):
  model_name = "potion_dexperience"
  @tofu.side("server", "single")
  def used(self, character):
    super(ExperiencePotion, self).used(character)
    character.add_experience_curse(0.3, 0.0)
    
class HeavyBasher(driver.Power):
  model_name = "cogne_dur"
  level      = 1
  def gained(self, character): character.calc_damage()
  def lost  (self, character): character.calc_damage()
  def calc_damage(self, character):
    for damage in character.damages:
      if damage[0] == driver.ATTACK_BASH: damage[1] += self.level
      
class HeavyBasher2(HeavyBasher):
  model_name = "cogne_dur2"
  level      = 2
  requires   = deprecates = set([HeavyBasher])
  
class HeavyBasher3(HeavyBasher):
  model_name = "cogne_dur3"
  level      = 3
  requires   = set([HeavyBasher2])
  deprecates = set([HeavyBasher, HeavyBasher2])
  
class Elementalist(driver.Power):
  model_name = "elementaliste"
  level      = 1
  def gained(self, character): character.calc_damage()
  def lost  (self, character): character.calc_damage()
  def calc_damage(self, character):
    for damage in character.damages:
      if (damage[0] == driver.ATTACK_FIRE) or (damage[0] == driver.ATTACK_ICE): damage[1] += self.level
      
class Elementalist2(Elementalist):
  model_name = "elementaliste2"
  level      = 2
  requires   = deprecates = set([Elementalist])
  
class EchassianDisguise(driver.Limited, driver.Equipable, driver.Power):
  model_name = "deguisement_echassien"
  nb_use     = 10
  def on_equiped  (self, character):
    super(EchassianDisguise, self).on_equiped  (character)
    character.set_model_name("echassien")
    character.set_display_name(u"")
    character.set_animation_name("attente")
  def on_unequiped(self, character):
    super(EchassianDisguise, self).on_unequiped(character)
    character.set_model_name(character.default_model_name)
    character.set_display_name(character.player_name)
    character.set_animation_name("attente")

class ItemLore(driver.Limited, driver.Power):
  model_name = "identification"
  nb_use     = 10
  def gained(self, character): character.flag |=  driver.FLAG_ITEM_LORE
  def lost  (self, character): character.flag &= ~driver.FLAG_ITEM_LORE

class MonsterLore(driver.Limited, driver.Usable, driver.Power):
  model_name = "nomenclature"
  nb_use     = 25
  @tofu.side("server", "single")
  def used(self, character):
    cs = [c for c in character.level.mobiles if isinstance(c, driver.Character) and (not c is character)]
    if cs:
      super(MonsterLore, self).used(self)
      c = random.choice(cs)
      if isinstance(c, driver.Hero):
        s = c.player_name + _(u": ") + _(u"__level_curse__") % (int(c.experience), int(c.curse)) + u" "
      else:
        s = _(u"__%s__" % c.__class__.__name__) + _(u": ")
      s += (
        _(u"__life__"            ) % (u"%s%%" % int(round(100 * c.life))) + u". " +
        _(u"__experience_curse__") % (u"%s%%" % int(round(100 * c.experience_value)), u"%s%%" % int(round(100 * c.curse_value))) + u". " +
        _(u"__speed__"           ) % (u"%s%%" % int(round(1000 * c.move_speed))) + u" " +
        _(u"__attack__"          ) % u", ".join([u"%s +%s"  % (_(u"__attack_%s__" % attack), damage) for attack, damage in c.damages]) + u" " +
        _(u"__resistance__"      ) % u", ".join([u"%s %i%%" % (_(u"__attack_%s__" % attack), 100 - round(100 * c.resistances[attack])) for attack in range(1, 6)])
        )
      
      character.chat(s)
      
class TeleportShort(driver.Limited, driver.Usable, driver.Power):
  model_name = "teleportation1"
  nb_use     = 50
  @tofu.side("server", "single")
  def used(self, character):
    super(TeleportShort, self).used(character)
    while 1:
      character.i = random.uniform(0.3, 4.7)
      character.j = random.uniform(0.3, 4.7)
      if character.can_pass(0.0, 0.0): break
    character.set_current_state_importance(2)
    character.set_animation_name("attente") # Hack ; needed to disable 2D driver "skip render" optimization
    
class TeleportLong(driver.Limited, driver.Usable, driver.Power):
  model_name = "teleportation2"
  nb_use     = 12
  requires   = deprecates = set([TeleportShort])
  @tofu.side("server", "single")
  def used(self, character, due_to_unequip = 0):
    super(TeleportLong, self).used(character)

    if    45 <= character.angle <= 135: character.i = 0.1; character.j = 2.5
    elif 135 <= character.angle <= 225: character.i = 2.5; character.j = 0.1
    elif 225 <= character.angle <= 315: character.i = 4.9; character.j = 2.5
    else                              : character.i = 2.5; character.j = 4.9
    character.change_room()
    
    while 1:
      character.i = random.uniform(0.3, 4.7)
      character.j = random.uniform(0.3, 4.7)
      if character.can_pass(0.0, 0.0): break
    character.set_current_state_importance(2)
    character.set_animation_name("attente") # Hack ; needed to disable 2D driver "skip render" optimization
    
class TeleportShield(driver.DodgeTool, TeleportShort):
  model_name = "teleportation2"
  nb_use     = 12
  requires   = deprecates = set([TeleportShort])

  
class Balazar(driver.Hero):
  model_name = default_model_name = "balazar"
  move_speed = 0.08
  
  possible_powers = set([HeavyBasher, HeavyBasher2, HeavyBasher3, Elementalist, Elementalist2, EchassianDisguise, ItemLore, MonsterLore, TeleportShort, TeleportLong, TeleportShield])
  resistances = {
    driver.ATTACK_BASH    : 0.8,
    driver.ATTACK_SHARP   : 1.0,
    driver.ATTACK_FIRE    : 0.8,
    driver.ATTACK_ICE     : 0.8,
    driver.ATTACK_SULPHUR : 0.8,
    }
  


class Echassian(driver.Monster):
  move_speed       = 0.12
  experience_value = 0.1
  curse_value      = 0.15
  damages          = [[driver.ATTACK_SHARP, 3]]
  resistances = {
    driver.ATTACK_BASH    : 0.7,
    driver.ATTACK_SHARP   : 0.7,
    driver.ATTACK_FIRE    : 1.0,
    driver.ATTACK_ICE     : 0.7,
    driver.ATTACK_SULPHUR : 1.0,
    }
  hit_sound    = "couic_echassien.wav"
  die_sound    = "couic_echassien.wav"
  strike_sound = "strike2.wav"
  
  def __init__(self):
    driver.Monster.__init__(self)
    self.model_name = "echassien"
    self.life = 0.17
    self._init()
    
  def hit(self, by):
    if by.get_model_name() != "echassien": # => not hit by other echassian or by player disguised in echassian !
      driver.Monster.hit(self, by)
    

cerealizer.register(Player, tofu.SavedInAPathHandler(Player))
cerealizer.register(Level , tofu.SavedInAPathHandler(Level ))
cerealizer.register(Echassian)
cerealizer.register(Balazar)
cerealizer.register(Chest)
cerealizer.register(ItemOnGround)
cerealizer.register(Club)
cerealizer.register(BigClub)
cerealizer.register(Cudgel)
cerealizer.register(Staff)
cerealizer.register(Axe)
cerealizer.register(Knife)
cerealizer.register(Sword)
cerealizer.register(LargeSword)
cerealizer.register(FireWand)
cerealizer.register(FireStaff)
cerealizer.register(IceWand)
cerealizer.register(IceStaff)
cerealizer.register(LifePotion)
cerealizer.register(ExperiencePotion)
cerealizer.register(HeavyBasher)
cerealizer.register(HeavyBasher2)
cerealizer.register(HeavyBasher3)
cerealizer.register(Elementalist)
cerealizer.register(Elementalist2)
cerealizer.register(EchassianDisguise)
cerealizer.register(ItemLore)
cerealizer.register(MonsterLore)
cerealizer.register(TeleportShort)
cerealizer.register(TeleportLong)
cerealizer.register(TeleportShield)

tofu.LOAD_PLAYER_ID = PlayerID.loads
tofu.CREATE_PLAYER  = Player



def start_single():
  tofu.set_side("single")
  tofu.SAVED_GAME_DIR = globdef.SAVED_GAME_DIR
  tofu.GAME           = globdef.SINGLE_LOGIN
  tofu.PLAYER_IDS     = [PlayerID(globdef.SINGLE_LOGIN, globdef.SINGLE_LOGIN)]
  main_loop = MainLoop()
  if not globdef.LIMIT_FPS: main_loop.min_frame_duration = 0.0
  main_loop.main_loop()
  print getattr(main_loop, "fps", "-"), "FPS"

def start_multi():
  if SERVER_PID: # Connect to local server
    tofu.HOST = globdef.SERVER_HOST
    tofu.PORT = globdef.SERVER_PORT
  else:
    tofu.HOST = globdef.CLIENT_HOST
    tofu.PORT = globdef.CLIENT_PORT
    
  tofu.set_side("client")
  tofu.SAVED_GAME_DIR = globdef.SAVED_GAME_DIR
  tofu.GAME           = globdef.CLIENT_LOGIN
  tofu.PLAYER_IDS     = [PlayerID(globdef.CLIENT_LOGIN, globdef.CLIENT_PASSWORD)]
  main_loop = MainLoop()
  if not globdef.LIMIT_FPS: main_loop.min_frame_duration = 0.0
  main_loop.main_loop()
  print getattr(main_loop, "fps", "-"), "FPS"
  
SERVER_PID = 0

def start_server_spawn():
  global SERVER_PID
  SERVER_PID = os.spawnl(os.P_NOWAIT, sys.executable, sys.executable, sys.argv[0], "--server", globdef.SERVER_HOST, "--port", str(globdef.SERVER_PORT))
  
def start_server():
  tofu.HOST = globdef.SERVER_HOST
  tofu.PORT = globdef.SERVER_PORT
  tofu.GAME = "_server"
  
  tofu.set_side("server")
  tofu.SAVED_GAME_DIR = globdef.SAVED_GAME_DIR
  main_loop = MainLoop()
  main_loop.main_loop()
  
def kill_server():
  global SERVER_PID
  if SERVER_PID: 
    import signal
    os.kill(SERVER_PID, signal.SIGINT)
    SERVER_PID = 0
atexit.register(kill_server)

def erase_server_data():
  server_running = SERVER_PID
  if server_running: kill_server()
  
  import shutil
  try:    shutil.rmtree(os.path.join(globdef.SAVED_GAME_DIR, "_server"))
  except: pass
  
  if server_running: start_server_spawn()
  
