!{\src2tex{textfont=tt}}
!!****f* ABINIT/fftwfn
!! NAME
!! fftwfn
!!
!! FUNCTION
!! Calculate wavefunctions in real space using FFT
!!
!! COPYRIGHT
!! Copyright (C) 1999-2007 ABINIT group (GMR, VO, LR, RWG, MG)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!!  igfft(npwwfn)=index of each plane wave in FFT grid
!!  nb=number of bands
!!  ngfft1,ngfft1a,ngfft2,ngfft3=FFT grid dimensions
!!  nk=number of k points
!!  npwwfn=number of plane waves
!!  nr=number of FFT grid points
!!  ns=number of independent spin polarizations 
!!  tim_fourdp=4 if called from within screening ; =5 if called from within sigma
!!  wfg(npwwfn,nb,nk,ns)=wavefunctions in reciprocal space, for each band, k point and spin
!!
!! OUTPUT
!!  wfr(nr,nb,nk,ns)=wavefunctions in real space, for each band, k point and spin
!!
!! PARENTS
!!      screening,sigma
!!
!! CHILDREN
!!      fourdp,wrtout,xcomm_init,xmaster_init,xme_init
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine fftwfn(npwwfn,nb,nk,nr,ns,wfg,wfr,igfft,ngfft1,ngfft1a,ngfft2,ngfft3,&
& tim_fourdp,mpi_enreg,min_band_proc,max_band_proc,parallelism_is_on_bands)

 use defs_basis
 use defs_datatypes

!This section has been created automatically by the script Abilint (TD). Do not modify these by hand.
#ifdef HAVE_FORTRAN_INTERFACES
 use interfaces_01manage_mpi
 use interfaces_12ffts
 use interfaces_lib01hidempi
#endif
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: max_band_proc,min_band_proc,nb,ngfft1,ngfft1a,ngfft2
 integer,intent(in) :: ngfft3,nk,npwwfn,nr,ns,tim_fourdp
 logical,intent(in) :: parallelism_is_on_bands
 type(MPI_type),intent(inout) :: mpi_enreg
!arrays
 integer,intent(in) :: igfft(npwwfn)
 complex,intent(in) :: wfg(npwwfn,min_band_proc:max_band_proc,nk,ns)
 complex,intent(out) :: wfr(nr,min_band_proc:max_band_proc,nk,ns)

!Local variables-------------------------------
!scalars
 integer :: ib,ierr,ig,ik,ir,is,istat,master,me,spaceComm
 character(len=500) :: message
!arrays
 integer :: ngfft(18)
 real(dp),allocatable :: wfg_dp(:,:),wfr_dp(:,:)

! *************************************************************************
 call xcomm_init(mpi_enreg,spaceComm)
!Init me
  call xme_init(mpi_enreg,me)
!Init master
  call xmaster_init(mpi_enreg,master)


 ngfft(1)=ngfft1
 ngfft(2)=ngfft2
 ngfft(3)=ngfft3
 !ngfft(4)=ngfft1a
 !ngfft(5)=ngfft2
 !ngfft(6)=ngfft3
 ngfft(4)=2*(ngfft(1)/2)+1
 ngfft(5)=2*(ngfft(2)/2)+1
 ngfft(6)=ngfft(3)
 ngfft(7)=200
 ngfft(8)=256
 ngfft(9)=0
 ngfft(10)=1
 ngfft(11)=0
 ngfft(12)=ngfft2
 ngfft(13)=ngfft3
 ngfft(14)=0

 allocate(wfg_dp(2,nr),stat=istat)
 if(istat/=0) stop 'out of memory'
 allocate(wfr_dp(2,nr),stat=istat)
 if(istat/=0) stop 'out of memory'

 write(message,'(a)')' FFT wavefunctions to real space'
 call wrtout(6,message,'COLL')

 !wfr(:,:,:)=(0.,0.)

 do is=1,ns
  do ik=1,nk
   do ib=1,nb
    if(parallelism_is_on_bands)then
     if(minval(abs(mpi_enreg%proc_distrb(ib,:,:)-mpi_enreg%me))/=0) cycle
    end if

    !fill FFT array from PW array
    wfg_dp(:,:)=zero
    do ig=1,npwwfn
     wfg_dp(1,igfft(ig))=real(wfg(ig,ib,ik,is))
     wfg_dp(2,igfft(ig))=aimag(wfg(ig,ib,ik,is))
    end do

    !take FFT to give wfn in real space
    !wfr_dp(:,:)=zero
    mpi_enreg%me_fft=0
    mpi_enreg%nproc_fft=1
    call fourdp(2,wfg_dp(:,:),wfr_dp(:,:),+1,mpi_enreg,nr,ngfft,tim_fourdp)
    wfr(:,ib,ik,is)=cmplx(wfr_dp(1,:),wfr_dp(2,:))

   end do !ib
  end do !ik
 end do !is

 write(message,'(2a)')' done',ch10
 call wrtout(6,message,'COLL')

 deallocate(wfg_dp,wfr_dp)

end subroutine fftwfn
!!***
