!{\src2tex{textfont=tt}}
!!****f* ABINIT/ckxcldar
!! NAME
!! ckxcldar
!!
!! FUNCTION
!! Calculate exchange-correlation kernel Kxclda in real space
!!
!! COPYRIGHT
!! Copyright (C) 1999-2007 ABINIT group (GMR, VO, LR, RWG)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!!  nr=number of points of FFT grid
!!  rho2(nr)=density in real space
!!
!! OUTPUT
!!  kxclda=exchange-correlation kernel in real space
!!
!! PARENTS
!!      ckxcldag
!!
!! CHILDREN
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine ckxcldar(nr,rho2,kxclda)

 use defs_basis

!This section has been created automatically by the script Abilint (TD). Do not modify these by hand.
#ifdef HAVE_FORTRAN_INTERFACES
 use interfaces_15gw, except_this_one => ckxcldar
#endif
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: nr
!arrays
 real(dp),intent(in) :: rho2(nr)
 complex,intent(out) :: kxclda(nr)

!Local variables ------------------------------
!scalars
 integer :: ir

! *************************************************************************
!This section has been created automatically by the script Abilint (TD). Do not modify these by hand.
#ifndef HAVE_FORTRAN_INTERFACES
 real(dp) :: difvxc
#endif
!End of the abilint section

 write(6,*) 'calculating kxclda'
 do ir=1,nr
   kxclda(ir)=difvxc(rho2(ir))
 end do
 write(6,*)

end subroutine ckxcldar
!!***
