!{\src2tex{textfont=tt}}
!!****f* ABINIT/abi_etsf_init
!! NAME
!! abi_etsf_init
!!
!! FUNCTION
!!  Output system geometry to a file, using the ETSF I/O file format.
!!
!! COPYRIGHT
!! Copyright (C) 2006-2007 The ABINIT group (Yann Pouillon)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!!  filapp = character string giving the root to form the name of the GEO file
!!
!! OUTPUT
!!  Data written in file whose name is filapp//'-etsf.nc'
!!
!! PARENTS
!!      driver,outkss
!!
!! CHILDREN
!!      etsf_io_data_init,etsf_io_low_close,etsf_io_low_error_to_str
!!      etsf_io_low_open_modify,etsf_io_main_def,ini_wf_etsf,leave_new,wrtout
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine abi_etsf_init(dtset, filapp, main_var, group_var, lmn_size, psps)

 use defs_basis
 use defs_datatypes
#if defined HAVE_ETSF_IO
 use etsf_io
#endif

!This section has been created automatically by the script Abilint (TD). Do not modify these by hand.
#ifdef HAVE_FORTRAN_INTERFACES
 use interfaces_01manage_mpi
 use interfaces_13ionetcdf, except_this_one => abi_etsf_init
#endif
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: group_var,main_var
 character(len=fnlen),intent(in) :: filapp
 type(dataset_type),intent(in) :: dtset
 type(pseudopotential_type),intent(in) :: psps
!arrays
 integer,intent(in) :: lmn_size(psps%npsp)

!Local variables-------------------------------
#if defined HAVE_ETSF_IO
 type(etsf_dims) :: dims
 logical :: lstat, add_main_group
 integer :: ncid, groups
 type(etsf_io_low_error) :: error
 character(len=1024) :: errmess
#endif
!scalars
 character(len=500) :: message
 character(len=fnlen) :: filetsf

! *************************************************************************

#if defined HAVE_ETSF_IO
!Initialize the filename
 filetsf=trim(filapp)//'-etsf.nc'
 write(message, '(a,a,a)' ) ch10,' abi_etsf_init : about to create file ',&
& filetsf
 call wrtout(std_out,message,'COLL')
 call wrtout(ab_out,message,'COLL')

!Set-up the dimensions
 dims%max_number_of_angular_momenta  = psps%mpsang
 dims%max_number_of_coefficients     = dtset%mpw
 dims%max_number_of_projectors       = 1
 dims%max_number_of_states           = dtset%mband
 dims%number_of_atoms                = dtset%natom
 dims%number_of_atom_species         = dtset%ntypat
 dims%number_of_components           = dtset%nspden
! In the case of BigDFT, the grid size is not defined by ngfft.
 if (dtset%usewvl == 1) then
    dims%number_of_grid_points_vector1  = dtset%wvl_internal%nSize(1) * 2
    dims%number_of_grid_points_vector2  = dtset%wvl_internal%nSize(2) * 2
    dims%number_of_grid_points_vector3  = dtset%wvl_internal%nSize(3) * 2
 else
    dims%number_of_grid_points_vector1  = dtset%ngfft(1)
    dims%number_of_grid_points_vector2  = dtset%ngfft(2)
    dims%number_of_grid_points_vector3  = dtset%ngfft(3)
 end if
 dims%number_of_kpoints              = dtset%nkpt
 dims%number_of_spinor_components    = dtset%nspinor
 dims%number_of_spins                = dtset%nsppol
 dims%number_of_symmetry_operations  = dtset%nsym
 dims%real_or_complex_density        = 1
 dims%real_or_complex_coefficients   = 2

  ! Actually create the file
  ! If the group contains main, we remove it for a while to be sure to
  ! add it at the end, after ABINIT private variables.
  if (iand(group_var, etsf_grp_main) /= 0) then
    groups = group_var - etsf_grp_main
    add_main_group = .true.
  else
    groups = group_var
    add_main_group = .false.
  end if
  call etsf_io_data_init(filetsf, main_var, groups, dims, &
                       & 'TEST', 'ABINIT generated file', lstat, error)
  if (lstat) then
   ! We now add the private ABINIT informations when required.
   if (add_main_group .or. iand(main_var, etsf_main_wfs_pw) /= 0 .or. &
     & iand(main_var, etsf_main_density) /= 0) then
    ! We open the file to add the private ABINIT variables
    call etsf_io_low_open_modify(ncid, trim(filetsf), lstat, error_data = error)
   end if
  end if

  if (lstat) then
    if (iand(main_var, etsf_main_wfs_pw) /= 0 .or. &
      & iand(main_var, etsf_main_density) /= 0) then
      ! We add the private data
      call ini_wf_etsf(lmn_size, psps%npsp, psps%ntypat, ncid)
    end if
    if (add_main_group) then
      ! We add the main group
      call etsf_io_main_def(ncid, main_var, lstat, error)
    end if
  end if
    
  if (lstat) then
    ! We close the file.
    call etsf_io_low_close(ncid, lstat, error_data = error)
  end if

  if (.not. lstat) then
    ! We handle the error
    call etsf_io_low_error_to_str(errmess, error)
    write(message, "(A,A,A,A)") ch10, " abi_etsf_init: ERROR -", ch10, &
                              & errmess(1:min(475, len(errmess)))
    call wrtout(std_out, message, 'COLL')
    call leave_new('COLL')
  end if

#endif

end subroutine abi_etsf_init
!!***
