#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2016 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Dungeon Keeper 2
###

script_version=20231018.1

PLAYIT_COMPATIBILITY_LEVEL='2.27'

GAME_ID='dungeon-keeper-2'
GAME_NAME='Dungeon Keeper Ⅱ'

ARCHIVE_BASE_1_NAME='setup_dungeon_keeper_2_1.7_(22280).exe'
ARCHIVE_BASE_1_TYPE='innosetup'
ARCHIVE_BASE_1_MD5='eeb2229ee49518504884a9ac65f611ad'
ARCHIVE_BASE_1_SIZE='510000'
ARCHIVE_BASE_1_VERSION='1.7-gog22280'
ARCHIVE_BASE_1_URL='https://www.gog.com/game/dungeon_keeper_2'

ARCHIVE_BASE_0_NAME='setup_dungeon_keeper2_2.0.0.32.exe'
ARCHIVE_BASE_0_MD5='92d04f84dd870d9624cd18449d3622a5'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_SIZE='510000'
ARCHIVE_BASE_0_VERSION='1.7-gog2.0.0.32'

CONTENT_PATH_DEFAULT='.'
CONTENT_PATH_DEFAULT_0='app'
CONTENT_GAME_BIN_FILES='
*.dll
*.exe'
CONTENT_GAME_DATA_FILES='
data
dk2texturecache'
CONTENT_DOC_DATA_FILES='
*.pdf
*.txt'

USER_PERSISTENT_DIRECTORIES='
data/settings
data/save'

WINE_REGEDIT_PERSISTENT_KEYS='
HKEY_CURRENT_USER\Software\Bullfrog Productions Ltd\Dungeon Keeper II'
## Work around poor performances using hardware rendering with Intel+Mesa
WINE_WINETRICKS_VERBS='csmt=off'

APP_MAIN_EXE='dkii-dx.exe'
APP_MAIN_ICON='dkii.exe'

PACKAGES_LIST='PKG_BIN PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='32'
PKG_BIN_DEPS="$PKG_DATA_ID"

## FIXME: This game should be run in a WINE virtual desktop.

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

set_current_package 'PKG_DATA'
icons_inclusion
content_inclusion_default

# Write launchers

set_current_package 'PKG_BIN'
launchers_write

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
