/*###############################################################################
# Linux Management Providers (LMP), Software Update provider package
# Copyright (C) 2009 Nazarov Nodir, TUIT <nazarov.nodir@gmail.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2009 Shakhrom RUSTAMOV, TUIT <shahrombek@gmail.com>
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#ifndef OPENDRIM_SERVICEAFFECTSSOFTWAREIDENTITYACCESS_H_
#define OPENDRIM_SERVICEAFFECTSSOFTWAREIDENTITYACCESS_H_

#include "SoftwareUpdate_Common.h"

#include "OpenDRIM_ServiceAffectsSoftwareIdentity.h"
#include "assocOpenDRIM_ServiceAffectsSoftwareIdentity.h"

int SoftwareUpdate_OpenDRIM_ServiceAffectsSoftwareIdentity_load(const CMPIBroker* broker, string& errorMessage);

int SoftwareUpdate_OpenDRIM_ServiceAffectsSoftwareIdentity_unload(string& errorMessage);

int SoftwareUpdate_OpenDRIM_ServiceAffectsSoftwareIdentity_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_ServiceAffectsSoftwareIdentity>& instances, const char** properties, string& errorMessage, const string& discriminant);

int SoftwareUpdate_OpenDRIM_ServiceAffectsSoftwareIdentity_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_ServiceAffectsSoftwareIdentity& instance, const char** properties, string& errorMessage);

int SoftwareUpdate_OpenDRIM_ServiceAffectsSoftwareIdentity_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_ServiceAffectsSoftwareIdentity& newInstance, const OpenDRIM_ServiceAffectsSoftwareIdentity& oldInstance, const char** properties, string& errorMessage);

int SoftwareUpdate_OpenDRIM_ServiceAffectsSoftwareIdentity_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_ServiceAffectsSoftwareIdentity& instance, string& errorMessage);

int SoftwareUpdate_OpenDRIM_ServiceAffectsSoftwareIdentity_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_ServiceAffectsSoftwareIdentity& instance, string& errorMessage);

int SoftwareUpdate_OpenDRIM_ServiceAffectsSoftwareIdentity_associatorAffectedElementToAffectingElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& AffectedElement_instance, const char** properties, vector<Instance>& AffectingElement_associatedInstances, string& errorMessage, const string& discriminant);

int SoftwareUpdate_OpenDRIM_ServiceAffectsSoftwareIdentity_associatorAffectingElementToAffectedElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& AffectingElement_instance, const char** properties, vector<Instance>& AffectedElement_associatedInstances, string& errorMessage, const string& discriminant);

int SoftwareUpdate_OpenDRIM_ServiceAffectsSoftwareIdentity_referenceAffectedElementToAffectingElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& AffectedElement_instance, const vector<Instance>& AffectingElement_instances, vector<OpenDRIM_ServiceAffectsSoftwareIdentity>& OpenDRIM_ServiceAffectsSoftwareIdentity_instances, const char** properties, string& errorMessage, const string& discriminant);

int SoftwareUpdate_OpenDRIM_ServiceAffectsSoftwareIdentity_referenceAffectingElementToAffectedElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& AffectingElement_instance, const vector<Instance>& AffectedElement_instances, vector<OpenDRIM_ServiceAffectsSoftwareIdentity>& OpenDRIM_ServiceAffectsSoftwareIdentity_instances, const char** properties, string& errorMessage, const string& discriminant);

int SoftwareUpdate_OpenDRIM_ServiceAffectsSoftwareIdentity_populate(OpenDRIM_ServiceAffectsSoftwareIdentity& instance, string& errorMessage);

#endif /*OPENDRIM_SERVICEAFFECTSSOFTWAREIDENTITYACCESS_H_*/
