/*###############################################################################
# Linux Management Providers (LMP), Physical Asset provider package
# Copyright (C) 2008 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr, guillaumebottex@gmail.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by <Author(s)>, <Affiliation>, <Year>
###############################################################################*/

#ifndef OPENDRIM_PHYSICALPACKAGECAPACITYACCESS_H_
#define OPENDRIM_PHYSICALPACKAGECAPACITYACCESS_H_

#include "PhysicalAsset_Common.h"

#include "OpenDRIM_PhysicalPackageCapacity.h"
#include "assocOpenDRIM_PhysicalPackageCapacity.h"

int PhysicalAsset_OpenDRIM_PhysicalPackageCapacity_load(const CMPIBroker* broker, string& errorMessage);

int PhysicalAsset_OpenDRIM_PhysicalPackageCapacity_unload(string& errorMessage);

int PhysicalAsset_OpenDRIM_PhysicalPackageCapacity_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_PhysicalPackageCapacity>& instances, const char** properties, string& errorMessage, const string& discriminant);

int PhysicalAsset_OpenDRIM_PhysicalPackageCapacity_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_PhysicalPackageCapacity& instance, const char** properties, string& errorMessage);

int PhysicalAsset_OpenDRIM_PhysicalPackageCapacity_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_PhysicalPackageCapacity& newInstance, const OpenDRIM_PhysicalPackageCapacity& oldInstance, const char** properties, string& errorMessage);

int PhysicalAsset_OpenDRIM_PhysicalPackageCapacity_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_PhysicalPackageCapacity& instance, string& errorMessage);

int PhysicalAsset_OpenDRIM_PhysicalPackageCapacity_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_PhysicalPackageCapacity& instance, string& errorMessage);

int PhysicalAsset_OpenDRIM_PhysicalPackageCapacity_associatorElementToCapacity(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Element_instance, const char** properties, vector<Instance>& Capacity_associatedInstances, string& errorMessage, const string& discriminant);

int PhysicalAsset_OpenDRIM_PhysicalPackageCapacity_associatorCapacityToElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Capacity_instance, const char** properties, vector<Instance>& Element_associatedInstances, string& errorMessage, const string& discriminant);

int PhysicalAsset_OpenDRIM_PhysicalPackageCapacity_referenceElementToCapacity(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Element_instance, const vector<Instance>& Capacity_instances, vector<OpenDRIM_PhysicalPackageCapacity>& OpenDRIM_PhysicalPackageCapacity_instances, const char** properties, string& errorMessage, const string& discriminant);

int PhysicalAsset_OpenDRIM_PhysicalPackageCapacity_referenceCapacityToElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Capacity_instance, const vector<Instance>& Element_instances, vector<OpenDRIM_PhysicalPackageCapacity>& OpenDRIM_PhysicalPackageCapacity_instances, const char** properties, string& errorMessage, const string& discriminant);

int PhysicalAsset_OpenDRIM_PhysicalPackageCapacity_populate(OpenDRIM_PhysicalPackageCapacity& instance, string& errorMessage);

#endif /*OPENDRIM_PHYSICALPACKAGECAPACITYACCESS_H_*/
