/*###############################################################################
# Linux Management Providers (LMP), Physical Asset provider package
# Copyright (C) 2008 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr, guillaumebottex@gmail.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by <Author(s)>, <Affiliation>, <Year>
###############################################################################*/

#include "cmpiOpenDRIM_PhysicalAssetCapabilities.h"

CMPIObjectPath* PhysicalAsset_OpenDRIM_PhysicalAssetCapabilities_toCMPIObjectPath(const CMPIBroker* broker, const OpenDRIM_PhysicalAssetCapabilities& instance) {
	_E_;
	Objectpath op(broker, OpenDRIM_PhysicalAssetCapabilities_classnames[0], OpenDRIM_PhysicalAssetCapabilities_NAMESPACE);

	if (!instance.InstanceID_isNULL)
		op.addKey("InstanceID", instance.InstanceID);

	_L_;
	return op.getHdl();
}

CMPIInstance* PhysicalAsset_OpenDRIM_PhysicalAssetCapabilities_toCMPIInstance(const CMPIBroker* broker, const OpenDRIM_PhysicalAssetCapabilities& instance) {
	_E_;
	Objectpath op(broker, PhysicalAsset_OpenDRIM_PhysicalAssetCapabilities_toCMPIObjectPath(broker, instance));
	Instance ci(broker, op);

	if (!instance.Caption_isNULL)
		ci.setProperty("Caption", instance.Caption);

	if (!instance.Description_isNULL)
		ci.setProperty("Description", instance.Description);

	if (!instance.ElementName_isNULL)
		ci.setProperty("ElementName", instance.ElementName);

	if (!instance.FRUInfoSupported_isNULL)
		ci.setProperty("FRUInfoSupported", instance.FRUInfoSupported);

	_L_;
	return ci.getHdl();
}

void PhysicalAsset_OpenDRIM_PhysicalAssetCapabilities_toCPP(const CMPIBroker* broker, const CMPIObjectPath* ref, OpenDRIM_PhysicalAssetCapabilities& instance) {
	_E_;
	Objectpath op(broker, (CMPIObjectPath*) ref);

	if (op.getKey("InstanceID", instance.InstanceID) == OK)
		instance.InstanceID_isNULL = false;

	_L_;
}

void PhysicalAsset_OpenDRIM_PhysicalAssetCapabilities_toCPP(const CMPIBroker* broker, const CMPIInstance* ci, OpenDRIM_PhysicalAssetCapabilities& instance) {
	_E_;
	Instance inst(broker, (CMPIInstance*) ci);

	if (inst.getProperty("Caption", instance.Caption) == OK)
		instance.Caption_isNULL = false;

	if (inst.getProperty("Description", instance.Description) == OK)
		instance.Description_isNULL = false;

	if (inst.getProperty("InstanceID", instance.InstanceID) == OK)
		instance.InstanceID_isNULL = false;

	if (inst.getProperty("ElementName", instance.ElementName) == OK)
		instance.ElementName_isNULL = false;

	if (inst.getProperty("FRUInfoSupported", instance.FRUInfoSupported) == OK)
		instance.FRUInfoSupported_isNULL = false;

	_L_;
}

void PhysicalAsset_OpenDRIM_PhysicalAssetCapabilities_toCPP(const CMPIBroker* broker, const CMPIArgs* in, OpenDRIM_PhysicalAssetCapabilities_CreateGoalSettings_In& args) {
	_E_;
	CMPIStatus rc;
	CMPIData data;

	vector<string> TemplateGoalSettings;
	data = in->ft->getArg(in, "TemplateGoalSettings", &rc);
	if (rc.rc == OK) {
		CT_ToC(data, TemplateGoalSettings);	
		args.setTemplateGoalSettings(TemplateGoalSettings);
	}			

	vector<string> SupportedGoalSettings;
	data = in->ft->getArg(in, "SupportedGoalSettings", &rc);
	if (rc.rc == OK) {
		CT_ToC(data, SupportedGoalSettings);	
		args.setSupportedGoalSettings(SupportedGoalSettings);
	}			

	_L_;
}

void PhysicalAsset_OpenDRIM_PhysicalAssetCapabilities_toCMPIArg(const CMPIBroker* broker, CMPIArgs* out, const OpenDRIM_PhysicalAssetCapabilities_CreateGoalSettings_Out& args) {
	_E_;
	CMPIValue value;
	int errorMessage;

	vector<string> SupportedGoalSettings;
	errorMessage = args.getSupportedGoalSettings(SupportedGoalSettings);
	if (errorMessage == OK) {
		value = CT_toCMPI(broker, SupportedGoalSettings);
		out->ft->addArg(out, "SupportedGoalSettings", &value, CMPI_stringA);
	}

	_L_;
}
