#!/bin/bash

################################################################################
# Linux Management Providers (LMP), IP provider package
# Copyright (C) 2007 Ilsoo Byun <widepis@etri.re.kr ,widepis@empal.com>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2008 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr, guillaumebottex@gmail.com>
################################################################################

if test "$3" = pegasus
then
	
	cimmof -aE -n $1 $6/mof/OpenDRIM_IPProtocolEndpoint.mof

	OUTFILE=./TEMP_REGISTRATION
	
cat >> $OUTFILE << EOFC
instance of PG_ProviderModule {
Caption = "OpenDRIM_IPProtocolEndpoint provider module";
Name = "IP_OpenDRIM_IPProtocolEndpointModule";
Location = "cmpiIP_OpenDRIM_IPProtocolEndpointProvider";
Vendor = "$2";
Version = "$5";
InterfaceType = "CMPI";
InterfaceVersion = "2.0.0";
};

instance of PG_Provider {
Caption = "OpenDRIM_IPProtocolEndpoint provider";
Name = "IP_OpenDRIM_IPProtocolEndpointProvider";
ProviderModuleName = "IP_OpenDRIM_IPProtocolEndpointModule";
};

instance of PG_ProviderCapabilities {
Caption = "OpenDRIM_IPProtocolEndpoint provider capabilities";
ProviderModuleName = "IP_OpenDRIM_IPProtocolEndpointModule";
ProviderName = "IP_OpenDRIM_IPProtocolEndpointProvider";
ClassName = "OpenDRIM_IPProtocolEndpoint";
ProviderType = {2, 5};
Namespaces = {"$1"};
SupportedProperties = {"Caption", "ElementName", "InstallDate", "StatusDescriptions", "Status", "HealthState", "PrimaryStatus", "DetailedStatus", "OperatingStatus", "CommunicationStatus", "OtherEnabledState", "RequestedState", "EnabledDefault", "AvailableRequestedStates", "TransitioningToState", "SystemCreationClassName", "SystemName", "CreationClassName", "Name", "Description", "OperationalStatus", "EnabledState", "TimeOfLastStateChange", "NameFormat", "ProtocolType", "OtherTypeDescription", "BroadcastResetSupported", "IPv4Address", "IPv6Address", "Address", "SubnetMask", "PrefixLength", "AddressType", "IPVersionSupport", "ProtocolIFType", "AddressOrigin"};
SupportedMethods = {"RequestStateChange", "BroadcastReset"};
CapabilityID = "IP_OpenDRIM_IPProtocolEndpoint";
};

EOFC
	
	cimmof -n root/PG_InterOp $OUTFILE
	
	rm -f $OUTFILE
	
fi

if test "$3" = sfcb
then
	
	OUTFILE=./OpenDRIM_IPProtocolEndpoint.reg
	
cat >> $OUTFILE <<EOFC
[OpenDRIM_IPProtocolEndpoint]   
   provider: IP_OpenDRIM_IPProtocolEndpointProvider
   location: cmpiIP_OpenDRIM_IPProtocolEndpointProvider
   type: instance method
   namespace: $1
#
EOFC
	
	sfcbstage -r $OUTFILE -n $1 $6/mof/OpenDRIM_IPProtocolEndpoint.mof
	
	rm -f $OUTFILE
	
	sfcbrepos -f
	
fi

if test "$3" = openwbem
then
	
	OUTFILE=./OpenDRIM_IPProtocolEndpoint-reg.mof
	rm -f $OUTFILE
	sed "s/Provider *( *\"cmpi:/Provider(\"cmpi::/g" < $6/mof/OpenDRIM_IPProtocolEndpoint.mof >> $OUTFILE
	owmofc -u http://localhost/$1 $OUTFILE
	
	rm -f $OUTFILE
	
fi
