#!/bin/bash

################################################################################
# Linux Management Providers (LMP), BIOS provider package
# Copyright (C) 2010 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by <Author(s)>, <Affiliation>, <Year>
################################################################################

if test "$3" = pegasus
then
	
	cimmof -aE -n $1 $6/mof/OpenDRIM_BIOSElement.mof

	OUTFILE=./TEMP_REGISTRATION
	
cat >> $OUTFILE << EOFC
instance of PG_ProviderModule {
Caption = "OpenDRIM_BIOSElement provider module";
Name = "BIOS_OpenDRIM_BIOSElementModule";
Location = "cmpiBIOS_OpenDRIM_BIOSElementProvider";
Vendor = "$2";
Version = "$5";
InterfaceType = "CMPI";
InterfaceVersion = "2.0.0";
};

instance of PG_Provider {
Caption = "OpenDRIM_BIOSElement provider";
Name = "BIOS_OpenDRIM_BIOSElementProvider";
ProviderModuleName = "BIOS_OpenDRIM_BIOSElementModule";
};

instance of PG_ProviderCapabilities {
Caption = "OpenDRIM_BIOSElement provider capabilities";
ProviderModuleName = "BIOS_OpenDRIM_BIOSElementModule";
ProviderName = "BIOS_OpenDRIM_BIOSElementProvider";
ClassName = "OpenDRIM_BIOSElement";
ProviderType = {2};
Namespaces = {"$1"};
SupportedProperties = {"InstanceID", "Caption", "Description", "ElementName", "InstallDate", "OperationalStatus", "StatusDescriptions", "Status", "HealthState", "CommunicationStatus", "DetailedStatus", "OperatingStatus", "PrimaryStatus", "Name", "Version", "SoftwareElementState", "SoftwareElementID", "TargetOperatingSystem", "OtherTargetOS", "BuildNumber", "SerialNumber", "CodeSet", "IdentificationCode", "LanguageEdition", "Manufacturer", "PrimaryBIOS", "ListOfLanguages", "CurrentLanguage", "LoadedStartingAddress", "LoadedEndingAddress", "LoadUtilityInformation", "ReleaseDate", "RegistryURIs"};
CapabilityID = "BIOS_OpenDRIM_BIOSElement";
};

EOFC
	
	cimmof -n root/PG_InterOp $OUTFILE
	
	rm -f $OUTFILE
	
fi

if test "$3" = sfcb
then
	
	OUTFILE=./OpenDRIM_BIOSElement.reg
	
cat >> $OUTFILE <<EOFC
[OpenDRIM_BIOSElement]   
   provider: BIOS_OpenDRIM_BIOSElementProvider
   location: cmpiBIOS_OpenDRIM_BIOSElementProvider
   type: instance
   namespace: $1
#
EOFC
	
	sfcbstage -r $OUTFILE -n $1 $6/mof/OpenDRIM_BIOSElement.mof
	
	rm -f $OUTFILE
	
	sfcbrepos -f
	
fi

if test "$3" = openwbem
then
	
	OUTFILE=./OpenDRIM_BIOSElement-reg.mof
	rm -f $OUTFILE
	sed "s/Provider *( *\"cmpi:/Provider(\"cmpi::/g" < $6/mof/OpenDRIM_BIOSElement.mof >> $OUTFILE
	owmofc -u http://localhost/$1 $OUTFILE
	
	rm -f $OUTFILE
	
fi
