/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.locusiterator;

import com.google.java.contract.Ensures;
import com.google.java.contract.Requires;
import htsjdk.samtools.CigarOperator;
import htsjdk.samtools.SAMFileReader;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.util.CloseableIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.log4j.Logger;
import org.broadinstitute.gatk.engine.ReadProperties;
import org.broadinstitute.gatk.engine.contexts.AlignmentContext;
import org.broadinstitute.gatk.engine.downsampling.DownsampleType;
import org.broadinstitute.gatk.engine.iterators.GATKSAMRecordIterator;
import org.broadinstitute.gatk.utils.GenomeLoc;
import org.broadinstitute.gatk.utils.GenomeLocParser;
import org.broadinstitute.gatk.utils.SampleUtils;
import org.broadinstitute.gatk.utils.locusiterator.AlignmentStateMachine;
import org.broadinstitute.gatk.utils.locusiterator.LIBSDownsamplingInfo;
import org.broadinstitute.gatk.utils.locusiterator.LocusIterator;
import org.broadinstitute.gatk.utils.locusiterator.PerSampleReadStateManager;
import org.broadinstitute.gatk.utils.locusiterator.ReadStateManager;
import org.broadinstitute.gatk.utils.pileup.PileupElement;
import org.broadinstitute.gatk.utils.pileup.ReadBackedPileup;
import org.broadinstitute.gatk.utils.pileup.ReadBackedPileupImpl;
import org.broadinstitute.gatk.utils.sam.GATKSAMRecord;
import org.broadinstitute.gatk.utils.sam.ReadUtils;

public final class LocusIteratorByState
extends LocusIterator {
    public static final LIBSDownsamplingInfo NO_DOWNSAMPLING = new LIBSDownsamplingInfo(false, -1);
    private static final Logger logger = Logger.getLogger(LocusIteratorByState.class);
    private final GenomeLocParser genomeLocParser;
    private final ArrayList<String> samples;
    private final ReadStateManager readStates;
    private final boolean includeReadsWithDeletionAtLoci;
    private AlignmentContext nextAlignmentContext;

    public LocusIteratorByState(Iterator<GATKSAMRecord> samIterator, ReadProperties readInformation, GenomeLocParser genomeLocParser, Collection<String> samples) {
        this(samIterator, LocusIteratorByState.toDownsamplingInfo(readInformation), readInformation.includeReadsWithDeletionAtLoci(), genomeLocParser, samples, readInformation.keepUniqueReadListInLIBS());
    }

    public LocusIteratorByState(SAMFileReader reader, CloseableIterator<SAMRecord> it) {
        this((Iterator<GATKSAMRecord>)new GATKSAMRecordIterator(it), new LIBSDownsamplingInfo(false, 0), true, new GenomeLocParser(reader.getFileHeader().getSequenceDictionary()), SampleUtils.getSAMFileSamples(reader.getFileHeader()), false);
    }

    public LocusIteratorByState(Iterator<GATKSAMRecord> samIterator, LIBSDownsamplingInfo downsamplingInfo, boolean includeReadsWithDeletionAtLoci, GenomeLocParser genomeLocParser, Collection<String> samples, boolean maintainUniqueReadsList) {
        if (samIterator == null) {
            throw new IllegalArgumentException("samIterator cannot be null");
        }
        if (downsamplingInfo == null) {
            throw new IllegalArgumentException("downsamplingInfo cannot be null");
        }
        if (genomeLocParser == null) {
            throw new IllegalArgumentException("genomeLocParser cannot be null");
        }
        if (samples == null) {
            throw new IllegalArgumentException("Samples cannot be null");
        }
        if (samples.isEmpty() && samIterator.hasNext()) {
            throw new IllegalArgumentException("samples list must not be empty");
        }
        this.genomeLocParser = genomeLocParser;
        this.includeReadsWithDeletionAtLoci = includeReadsWithDeletionAtLoci;
        this.samples = new ArrayList<String>(samples);
        this.readStates = new ReadStateManager(samIterator, this.samples, downsamplingInfo, maintainUniqueReadsList);
    }

    @Override
    public Iterator<AlignmentContext> iterator() {
        return this;
    }

    private GenomeLoc getLocation() {
        return this.readStates.isEmpty() ? null : this.readStates.getFirst().getLocation(this.genomeLocParser);
    }

    @Override
    public boolean hasNext() {
        this.lazyLoadNextAlignmentContext();
        return this.nextAlignmentContext != null;
    }

    @Override
    public AlignmentContext next() {
        this.lazyLoadNextAlignmentContext();
        if (!this.hasNext()) {
            throw new NoSuchElementException("LocusIteratorByState: out of elements.");
        }
        AlignmentContext currentAlignmentContext = this.nextAlignmentContext;
        this.nextAlignmentContext = null;
        return currentAlignmentContext;
    }

    public AlignmentContext advanceToLocus(int position, boolean stopAtFirstNonEmptySiteAfterPosition) {
        while (this.hasNext()) {
            AlignmentContext context = this.next();
            if (context == null) {
                return null;
            }
            if (context.getPosition() == (long)position) {
                return context;
            }
            if (context.getPosition() <= (long)position) continue;
            return stopAtFirstNonEmptySiteAfterPosition ? context : null;
        }
        return null;
    }

    private void lazyLoadNextAlignmentContext() {
        while (this.nextAlignmentContext == null && this.readStates.hasNext()) {
            this.readStates.collectPendingReads();
            GenomeLoc location = this.getLocation();
            HashMap<String, ReadBackedPileupImpl> fullPileup = new HashMap<String, ReadBackedPileupImpl>();
            for (Map.Entry<String, PerSampleReadStateManager> sampleStatePair : this.readStates) {
                String sample = sampleStatePair.getKey();
                PerSampleReadStateManager readState = sampleStatePair.getValue();
                Iterator<AlignmentStateMachine> iterator = readState.iterator();
                ArrayList<PileupElement> pile = new ArrayList<PileupElement>(readState.size());
                while (iterator.hasNext()) {
                    AlignmentStateMachine state = iterator.next();
                    GATKSAMRecord read = state.getRead();
                    CigarOperator op = state.getCigarOperator();
                    if (op == CigarOperator.N || this.dontIncludeReadInPileup(read, location.getStart()) || !this.includeReadsWithDeletionAtLoci && op == CigarOperator.D) continue;
                    pile.add(state.makePileupElement());
                }
                if (pile.isEmpty()) continue;
                fullPileup.put(sample, new ReadBackedPileupImpl(location, pile));
            }
            this.readStates.updateReadStates();
            if (fullPileup.isEmpty()) continue;
            this.nextAlignmentContext = new AlignmentContext(location, (ReadBackedPileup)new ReadBackedPileupImpl(location, fullPileup), false);
        }
    }

    @Ensures(value={"result != null"})
    public List<GATKSAMRecord> transferReadsFromAllPreviousPileups() {
        return this.readStates.transferSubmittedReads();
    }

    @Ensures(value={"result != null"})
    protected List<GATKSAMRecord> getReadsFromAllPreviousPileups() {
        return this.readStates.getSubmittedReads();
    }

    @Requires(value={"rec != null", "pos > 0"})
    private boolean dontIncludeReadInPileup(GATKSAMRecord rec, long pos) {
        return ReadUtils.isBaseInsideAdaptor(rec, pos);
    }

    @Requires(value={"readInfo != null"})
    @Ensures(value={"result != null"})
    private static LIBSDownsamplingInfo toDownsamplingInfo(ReadProperties readInfo) {
        boolean performDownsampling = readInfo.getDownsamplingMethod() != null && readInfo.getDownsamplingMethod().type == DownsampleType.BY_SAMPLE && readInfo.getDownsamplingMethod().toCoverage != null;
        int coverage = performDownsampling ? readInfo.getDownsamplingMethod().toCoverage : 0;
        return new LIBSDownsamplingInfo(performDownsampling, coverage);
    }

    @Ensures(value={"result != null"})
    public static PileupElement createPileupForReadAndOffset(GATKSAMRecord read, int offset) {
        if (read == null) {
            throw new IllegalArgumentException("read cannot be null");
        }
        if (offset < 0 || offset >= read.getReadLength()) {
            throw new IllegalArgumentException("Invalid offset " + offset + " outside of bounds 0 and " + read.getReadLength());
        }
        AlignmentStateMachine stateMachine = new AlignmentStateMachine(read);
        while (stateMachine.stepForwardOnGenome() != null) {
            if (stateMachine.getReadOffset() != offset) continue;
            return stateMachine.makePileupElement();
        }
        throw new IllegalStateException("Tried to create a pileup for read " + read + " with offset " + offset + " but we never saw such an offset in the alignment state machine");
    }

    public static List<String> sampleListForSAMWithoutReadGroups() {
        ArrayList<String> samples = new ArrayList<String>();
        samples.add(null);
        return samples;
    }
}

