/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.auth.identity.cli.controller;

import com.amazonaws.services.auth.identity.cli.common.Utils;
import com.amazonaws.services.auth.identity.cli.controller.IAMDriver;
import com.amazonaws.services.auth.identity.cli.model.CLIRequest;
import com.amazonaws.services.auth.identity.cli.model.GroupCreateRequest;
import com.amazonaws.services.identitymanagement.model.CreateGroupRequest;
import com.amazonaws.services.identitymanagement.model.CreateGroupResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IAMGroupCreateDriver
extends IAMDriver {
    private static final Log LOG = LogFactory.getLog(IAMGroupCreateDriver.class);

    public void invokeRequestImpl(CLIRequest request) {
        if (request instanceof GroupCreateRequest) {
            GroupCreateRequest req = (GroupCreateRequest)request;
            CreateGroupRequest createGroupRequest = new CreateGroupRequest();
            createGroupRequest.setGroupName(req.getGroupName());
            createGroupRequest.setPath(this.verifyPathAndAddSlashSuffix(req.getPath()));
            LOG.debug((Object)("Creating group with request: " + request));
            CreateGroupResult result = this.getClient().createGroup(createGroupRequest);
            if (req.isVerbose()) {
                LOG.info((Object)result.getGroup().getArn());
                LOG.info((Object)result.getGroup().getGroupId());
            }
        } else {
            Utils.exit(1, "request " + request + " is of an incorrect type.", null);
        }
    }
}

