/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.logging.simple;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.PathableClassLoader;
import org.apache.commons.logging.PathableTestSuite;
import org.apache.commons.logging.impl.SimpleLog;
import org.apache.commons.logging.simple.DecoratedSimpleLog;

public class DefaultConfigTestCase
extends TestCase {
    protected LogFactory factory = null;
    protected Log log = null;
    static /* synthetic */ Class class$org$apache$commons$logging$simple$DefaultConfigTestCase;
    static /* synthetic */ Class class$junit$framework$Test;

    public static Test suite() throws Exception {
        Class thisClass = class$org$apache$commons$logging$simple$DefaultConfigTestCase == null ? (class$org$apache$commons$logging$simple$DefaultConfigTestCase = DefaultConfigTestCase.class$("org.apache.commons.logging.simple.DefaultConfigTestCase")) : class$org$apache$commons$logging$simple$DefaultConfigTestCase;
        PathableClassLoader loader = new PathableClassLoader(null);
        loader.useExplicitLoader("junit.", (class$junit$framework$Test == null ? (class$junit$framework$Test = DefaultConfigTestCase.class$("junit.framework.Test")) : class$junit$framework$Test).getClassLoader());
        loader.addLogicalLib("testclasses");
        loader.addLogicalLib("commons-logging");
        Class<?> testClass = loader.loadClass(thisClass.getName());
        return new PathableTestSuite(testClass, loader);
    }

    public void setProperties() {
        System.setProperty("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.SimpleLog");
    }

    public void setUp() throws Exception {
        LogFactory.releaseAll();
        this.setProperties();
        this.setUpFactory();
        this.setUpLog("TestLogger");
    }

    public void tearDown() {
        this.log = null;
        this.factory = null;
        LogFactory.releaseAll();
    }

    public void testPristineDecorated() {
        this.setUpDecorated("DecoratedLogger");
        this.checkDecorated();
    }

    public void testPristineLog() {
        this.checkStandard();
    }

    public void testPristineFactory() {
        Assert.assertNotNull((String)"LogFactory exists", (Object)this.factory);
        Assert.assertEquals((String)"LogFactory class", (String)"org.apache.commons.logging.impl.LogFactoryImpl", (String)this.factory.getClass().getName());
        String[] names = this.factory.getAttributeNames();
        Assert.assertNotNull((String)"Names exists", (Object)names);
        Assert.assertEquals((String)"Names empty", (int)0, (int)names.length);
    }

    public void testSerializable() throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(this.log);
        oos.close();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        ObjectInputStream ois = new ObjectInputStream(bais);
        this.log = (Log)ois.readObject();
        ois.close();
        this.checkStandard();
    }

    protected void checkDecorated() {
        Assert.assertNotNull((String)"Log exists", (Object)this.log);
        Assert.assertEquals((String)"Log class", (String)"org.apache.commons.logging.simple.DecoratedSimpleLog", (String)this.log.getClass().getName());
        Assert.assertTrue((!this.log.isDebugEnabled() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.log.isErrorEnabled());
        Assert.assertTrue((boolean)this.log.isFatalEnabled());
        Assert.assertTrue((boolean)this.log.isInfoEnabled());
        Assert.assertTrue((!this.log.isTraceEnabled() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.log.isWarnEnabled());
        Assert.assertEquals((int)3, (int)((SimpleLog)this.log).getLevel());
        Assert.assertEquals((String)"yyyy/MM/dd HH:mm:ss:SSS zzz", (String)((DecoratedSimpleLog)this.log).getDateTimeFormat());
        Assert.assertEquals((String)"DecoratedLogger", (String)((DecoratedSimpleLog)this.log).getLogName());
        Assert.assertTrue((!((DecoratedSimpleLog)this.log).getShowDateTime() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)((DecoratedSimpleLog)this.log).getShowShortName());
    }

    protected void checkStandard() {
        Assert.assertNotNull((String)"Log exists", (Object)this.log);
        Assert.assertEquals((String)"Log class", (String)"org.apache.commons.logging.impl.SimpleLog", (String)this.log.getClass().getName());
        Assert.assertTrue((!this.log.isDebugEnabled() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.log.isErrorEnabled());
        Assert.assertTrue((boolean)this.log.isFatalEnabled());
        Assert.assertTrue((boolean)this.log.isInfoEnabled());
        Assert.assertTrue((!this.log.isTraceEnabled() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.log.isWarnEnabled());
        Assert.assertEquals((int)3, (int)((SimpleLog)this.log).getLevel());
    }

    protected void setUpDecorated(String name) {
        this.log = new DecoratedSimpleLog(name);
    }

    protected void setUpFactory() throws Exception {
        this.factory = LogFactory.getFactory();
    }

    protected void setUpLog(String name) throws Exception {
        this.log = LogFactory.getLog((String)name);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

