/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.logging.server;

import com.google.gwt.logging.server.RemoteLoggingServiceUtil;
import com.google.gwt.logging.server.StackTraceDeobfuscator;
import com.google.gwt.logging.shared.RemoteLoggingService;
import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class RemoteLoggingServiceImpl
extends RemoteServiceServlet
implements RemoteLoggingService {
    private static StackTraceDeobfuscator deobfuscator = null;
    private static Logger logger = Logger.getLogger(RemoteServiceServlet.class.getName());
    private static String loggerNameOverride = null;

    public final String logOnServer(LogRecord lr) {
        String strongName = this.getPermutationStrongName();
        try {
            RemoteLoggingServiceUtil.logOnServer(lr, strongName, deobfuscator, loggerNameOverride);
        }
        catch (RemoteLoggingServiceUtil.RemoteLoggingException e) {
            logger.log(Level.SEVERE, "Remote logging failed", e);
            return "Remote logging failed, check stack trace for details.";
        }
        return null;
    }

    public void setLoggerNameOverride(String override) {
        loggerNameOverride = override;
    }

    public void setSymbolMapsDirectory(String symbolMapsDir) {
        if (deobfuscator == null) {
            deobfuscator = new StackTraceDeobfuscator(symbolMapsDir);
        } else {
            deobfuscator.setSymbolMapsDirectory(symbolMapsDir);
        }
    }
}

