/* log-test.c generated by valac 0.20.1, the Vala compiler
 * generated from log-test.vala, do not modify */

/* log-test.vala
 *
 * Copyright © 2012 Christian Dywan <christian@twotoasts.de>
 *
 * Based upon a C implementation (© 2010 Canonical Ltd) by:
 *  Mikkel Kamstrup Erlandsen <mikkel.kamstrup@canonical.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include "zeitgeist.h"
#include <gio/gio.h>
#include "zeitgeist-datamodel.h"

#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
typedef struct _Block2Data Block2Data;
#define _g_array_unref0(var) ((var == NULL) ? NULL : (var = (g_array_unref (var), NULL)))
typedef struct _Block3Data Block3Data;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _Block1Data {
	int _ref_count_;
	GMainLoop* mainloop;
};

struct _Block2Data {
	int _ref_count_;
	GArray* event_ids;
	GPtrArray* expected_events;
	GMainLoop* mainloop;
};

struct _Block3Data {
	int _ref_count_;
	GMainLoop* mainloop;
	GPtrArray* expected_events;
};



gint _vala_main (gchar** argv, int argv_length1);
void insert_get_delete_test (void);
static void _insert_get_delete_test_gtest_func (void);
void get_default_test (void);
static void _get_default_test_gtest_func (void);
void events_received (ZeitgeistLog* log, GAsyncResult* res, GPtrArray* expected_events, GArray* event_ids, GMainLoop* mainloop);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void __lambda4_ (Block1Data* _data1_);
static void ___lambda4__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
void events_inserted (ZeitgeistLog* log, GAsyncResult* res, GPtrArray* expected_events, GMainLoop* mainloop);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void __lambda3_ (Block2Data* _data2_, GObject* log, GAsyncResult* res);
static void ___lambda3__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
gboolean quit_main_loop (void);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void _g_object_unref0_ (gpointer var);
static void __lambda2_ (Block3Data* _data3_, GObject* log, GAsyncResult* res);
static void ___lambda2__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static gboolean _quit_main_loop_gsource_func (gpointer self);


static void _insert_get_delete_test_gtest_func (void) {
#line 30 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	insert_get_delete_test ();
#line 92 "log-test.c"
}


static void _get_default_test_gtest_func (void) {
#line 31 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	get_default_test ();
#line 99 "log-test.c"
}


gint _vala_main (gchar** argv, int argv_length1) {
	gint result = 0;
	gint _tmp0_ = 0;
#line 28 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	g_test_init (&argv_length1, &argv, NULL);
#line 30 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	g_test_add_func ("/Log/InsertGetDelete", _insert_get_delete_test_gtest_func);
#line 31 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	g_test_add_func ("/Log/GetDefault", _get_default_test_gtest_func);
#line 33 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	_tmp0_ = g_test_run ();
#line 33 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	result = _tmp0_;
#line 33 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	return result;
#line 118 "log-test.c"
}


int main (int argc, char ** argv) {
#line 26 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	g_type_init ();
#line 26 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	return _vala_main (argv, argc);
#line 127 "log-test.c"
}


static gpointer _g_main_loop_ref0 (gpointer self) {
#line 36 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	return self ? g_main_loop_ref (self) : NULL;
#line 134 "log-test.c"
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
#line 36 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	g_atomic_int_inc (&_data1_->_ref_count_);
#line 36 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	return _data1_;
#line 143 "log-test.c"
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
#line 36 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
#line 36 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
		_g_main_loop_unref0 (_data1_->mainloop);
#line 36 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
		g_slice_free (Block1Data, _data1_);
#line 156 "log-test.c"
	}
}


static gint g_ptr_array_get_length (GPtrArray* self) {
	gint result;
	guint _tmp0_;
#line 4095 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 4095 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp0_ = self->len;
#line 4095 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	result = (gint) _tmp0_;
#line 4095 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	return result;
#line 172 "log-test.c"
}


static void g_ptr_array_set_length (GPtrArray* self, gint value) {
	gint _tmp0_;
#line 4096 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	g_return_if_fail (self != NULL);
#line 4096 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp0_ = value;
#line 4096 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	g_ptr_array_set_size (self, _tmp0_);
#line 184 "log-test.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 54 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	return self ? g_object_ref (self) : NULL;
#line 191 "log-test.c"
}


static void __lambda4_ (Block1Data* _data1_) {
	GMainLoop* _tmp0_;
#line 62 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	_tmp0_ = _data1_->mainloop;
#line 62 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	g_main_loop_quit (_tmp0_);
#line 201 "log-test.c"
}


static void ___lambda4__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 62 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	__lambda4_ (self);
#line 62 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	block1_data_unref (self);
#line 210 "log-test.c"
}


void events_received (ZeitgeistLog* log, GAsyncResult* res, GPtrArray* expected_events, GArray* event_ids, GMainLoop* mainloop) {
	Block1Data* _data1_;
	GMainLoop* _tmp0_;
	GMainLoop* _tmp1_;
	ZeitgeistResultSet* events = NULL;
	GPtrArray* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	ZeitgeistResultSet* _tmp11_;
	guint _tmp12_ = 0U;
	ZeitgeistLog* _tmp47_;
	GArray* _tmp48_;
	GError * _inner_error_ = NULL;
#line 36 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	g_return_if_fail (log != NULL);
#line 36 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	g_return_if_fail (res != NULL);
#line 36 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	g_return_if_fail (expected_events != NULL);
#line 36 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	g_return_if_fail (event_ids != NULL);
#line 36 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	g_return_if_fail (mainloop != NULL);
#line 36 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	_data1_ = g_slice_new0 (Block1Data);
#line 36 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	_data1_->_ref_count_ = 1;
#line 36 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	_tmp0_ = mainloop;
#line 36 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	_tmp1_ = _g_main_loop_ref0 (_tmp0_);
#line 36 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	_g_main_loop_unref0 (_data1_->mainloop);
#line 36 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	_data1_->mainloop = _tmp1_;
#line 249 "log-test.c"
	{
		ZeitgeistLog* _tmp2_;
		GAsyncResult* _tmp3_;
		ZeitgeistResultSet* _tmp4_ = NULL;
		ZeitgeistResultSet* _tmp5_;
#line 43 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
		_tmp2_ = log;
#line 43 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
		_tmp3_ = res;
#line 43 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
		_tmp4_ = zeitgeist_log_get_events_finish (_tmp2_, _tmp3_, &_inner_error_);
#line 43 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
		_tmp5_ = _tmp4_;
#line 43 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
		if (_inner_error_ != NULL) {
#line 265 "log-test.c"
			goto __catch0_g_error;
		}
#line 43 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
		_g_object_unref0 (events);
#line 43 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
		events = _tmp5_;
#line 272 "log-test.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
#line 42 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
		_error_ = _inner_error_;
#line 42 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
		_inner_error_ = NULL;
#line 46 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
		_tmp6_ = _error_;
#line 46 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
		_tmp7_ = _tmp6_->message;
#line 46 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
		g_critical ("log-test.vala:46: Failed to get events: %s", _tmp7_);
#line 47 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
		_g_error_free0 (_error_);
#line 47 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
		_g_object_unref0 (events);
#line 47 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
		block1_data_unref (_data1_);
#line 47 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
		_data1_ = NULL;
#line 47 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
		return;
#line 300 "log-test.c"
	}
	__finally0:
#line 42 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	if (_inner_error_ != NULL) {
#line 42 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
		_g_object_unref0 (events);
#line 42 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
		block1_data_unref (_data1_);
#line 42 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
		_data1_ = NULL;
#line 42 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 42 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
		g_clear_error (&_inner_error_);
#line 42 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
		return;
#line 317 "log-test.c"
	}
#line 51 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	_tmp8_ = expected_events;
#line 51 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	_tmp9_ = g_ptr_array_get_length (_tmp8_);
#line 51 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	_tmp10_ = _tmp9_;
#line 51 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	_tmp11_ = events;
#line 51 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	_tmp12_ = zeitgeist_result_set_size (_tmp11_);
#line 51 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	_vala_assert (((guint) _tmp10_) == _tmp12_, "expected_events.length == events.size()");
#line 331 "log-test.c"
	{
		gint i;
#line 52 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
		i = 0;
#line 336 "log-test.c"
		{
			gboolean _tmp13_;
#line 52 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
			_tmp13_ = TRUE;
#line 52 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
			while (TRUE) {
#line 343 "log-test.c"
				gboolean _tmp14_;
				gint _tmp16_;
				ZeitgeistResultSet* _tmp17_;
				guint _tmp18_ = 0U;
				GPtrArray* _tmp19_;
				gint _tmp20_;
				gconstpointer _tmp21_ = NULL;
				ZeitgeistEvent* _tmp22_;
				ZeitgeistEvent* exp_event;
				ZeitgeistResultSet* _tmp23_;
				ZeitgeistEvent* _tmp24_ = NULL;
				ZeitgeistEvent* event;
				ZeitgeistEvent* _tmp25_;
				const gchar* _tmp26_;
				const gchar* _tmp27_;
				ZeitgeistEvent* _tmp28_;
				const gchar* _tmp29_;
				const gchar* _tmp30_;
				ZeitgeistEvent* _tmp31_;
				const gchar* _tmp32_;
				const gchar* _tmp33_;
				ZeitgeistEvent* _tmp34_;
				const gchar* _tmp35_;
				const gchar* _tmp36_;
				ZeitgeistEvent* _tmp37_;
				const gchar* _tmp38_;
				const gchar* _tmp39_;
				ZeitgeistEvent* _tmp40_;
				const gchar* _tmp41_;
				const gchar* _tmp42_;
				ZeitgeistEvent* _tmp43_;
				gint _tmp44_ = 0;
				ZeitgeistEvent* _tmp45_;
				gint _tmp46_ = 0;
#line 52 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
				_tmp14_ = _tmp13_;
#line 52 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
				if (!_tmp14_) {
#line 382 "log-test.c"
					gint _tmp15_;
#line 52 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
					_tmp15_ = i;
#line 52 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
					i = _tmp15_ + 1;
#line 388 "log-test.c"
				}
#line 52 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
				_tmp13_ = FALSE;
#line 52 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
				_tmp16_ = i;
#line 52 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
				_tmp17_ = events;
#line 52 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
				_tmp18_ = zeitgeist_result_set_size (_tmp17_);
#line 52 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
				if (!(((guint) _tmp16_) < _tmp18_)) {
#line 52 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
					break;
#line 402 "log-test.c"
				}
#line 54 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
				_tmp19_ = expected_events;
#line 54 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
				_tmp20_ = i;
#line 54 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
				_tmp21_ = g_ptr_array_index (_tmp19_, (guint) _tmp20_);
#line 54 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
				_tmp22_ = _g_object_ref0 ((ZeitgeistEvent*) _tmp21_);
#line 54 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
				exp_event = _tmp22_;
#line 55 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
				_tmp23_ = events;
#line 55 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
				_tmp24_ = zeitgeist_result_set_next_value (_tmp23_);
#line 55 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
				event = _tmp24_;
#line 56 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
				_tmp25_ = event;
#line 56 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
				_tmp26_ = zeitgeist_event_get_interpretation (_tmp25_);
#line 56 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
				_tmp27_ = _tmp26_;
#line 56 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
				_tmp28_ = exp_event;
#line 56 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
				_tmp29_ = zeitgeist_event_get_interpretation (_tmp28_);
#line 56 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
				_tmp30_ = _tmp29_;
#line 56 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
				_vala_assert (g_strcmp0 (_tmp27_, _tmp30_) == 0, "event.interpretation == exp_event.interpretation");
#line 57 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
				_tmp31_ = event;
#line 57 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
				_tmp32_ = zeitgeist_event_get_manifestation (_tmp31_);
#line 57 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
				_tmp33_ = _tmp32_;
#line 57 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
				_tmp34_ = exp_event;
#line 57 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
				_tmp35_ = zeitgeist_event_get_manifestation (_tmp34_);
#line 57 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
				_tmp36_ = _tmp35_;
#line 57 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
				_vala_assert (g_strcmp0 (_tmp33_, _tmp36_) == 0, "event.manifestation == exp_event.manifestation");
#line 58 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
				_tmp37_ = event;
#line 58 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
				_tmp38_ = zeitgeist_event_get_actor (_tmp37_);
#line 58 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
				_tmp39_ = _tmp38_;
#line 58 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
				_tmp40_ = exp_event;
#line 58 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
				_tmp41_ = zeitgeist_event_get_actor (_tmp40_);
#line 58 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
				_tmp42_ = _tmp41_;
#line 58 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
				_vala_assert (g_strcmp0 (_tmp39_, _tmp42_) == 0, "event.actor == exp_event.actor");
#line 59 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
				_tmp43_ = event;
#line 59 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
				_tmp44_ = zeitgeist_event_num_subjects (_tmp43_);
#line 59 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
				_tmp45_ = exp_event;
#line 59 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
				_tmp46_ = zeitgeist_event_num_subjects (_tmp45_);
#line 59 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
				_vala_assert (_tmp44_ == _tmp46_, "event.num_subjects () == exp_event.num_subjects ()");
#line 52 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
				_g_object_unref0 (event);
#line 52 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
				_g_object_unref0 (exp_event);
#line 476 "log-test.c"
			}
		}
	}
#line 62 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	_tmp47_ = log;
#line 62 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	_tmp48_ = event_ids;
#line 62 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	zeitgeist_log_delete_events (_tmp47_, _tmp48_, NULL, ___lambda4__gasync_ready_callback, block1_data_ref (_data1_));
#line 36 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	_g_object_unref0 (events);
#line 36 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	block1_data_unref (_data1_);
#line 36 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	_data1_ = NULL;
#line 492 "log-test.c"
}


static gpointer _g_ptr_array_ref0 (gpointer self) {
#line 65 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	return self ? g_ptr_array_ref (self) : NULL;
#line 499 "log-test.c"
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
#line 65 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	g_atomic_int_inc (&_data2_->_ref_count_);
#line 65 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	return _data2_;
#line 508 "log-test.c"
}


static void block2_data_unref (void * _userdata_) {
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
#line 65 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
#line 65 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
		_g_array_unref0 (_data2_->event_ids);
#line 65 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
		_g_ptr_array_unref0 (_data2_->expected_events);
#line 65 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
		_g_main_loop_unref0 (_data2_->mainloop);
#line 65 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
		g_slice_free (Block2Data, _data2_);
#line 525 "log-test.c"
	}
}


static void __lambda3_ (Block2Data* _data2_, GObject* log, GAsyncResult* res) {
	GObject* _tmp0_;
	GAsyncResult* _tmp1_;
	GPtrArray* _tmp2_;
	GArray* _tmp3_;
	GMainLoop* _tmp4_;
#line 80 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	g_return_if_fail (res != NULL);
#line 81 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	_tmp0_ = log;
#line 81 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	_tmp1_ = res;
#line 81 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	_tmp2_ = _data2_->expected_events;
#line 81 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	_tmp3_ = _data2_->event_ids;
#line 81 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	_tmp4_ = _data2_->mainloop;
#line 81 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	events_received (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, ZEITGEIST_TYPE_LOG, ZeitgeistLog), _tmp1_, _tmp2_, _tmp3_, _tmp4_);
#line 550 "log-test.c"
}


static void ___lambda3__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 80 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	__lambda3_ (self, source_object, res);
#line 80 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	block2_data_unref (self);
#line 559 "log-test.c"
}


void events_inserted (ZeitgeistLog* log, GAsyncResult* res, GPtrArray* expected_events, GMainLoop* mainloop) {
	Block2Data* _data2_;
	GPtrArray* _tmp0_;
	GPtrArray* _tmp1_;
	GMainLoop* _tmp2_;
	GMainLoop* _tmp3_;
	GPtrArray* _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	GArray* _tmp13_;
	guint _tmp14_;
	ZeitgeistLog* _tmp15_;
	GArray* _tmp16_;
	GError * _inner_error_ = NULL;
#line 65 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	g_return_if_fail (log != NULL);
#line 65 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	g_return_if_fail (res != NULL);
#line 65 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	g_return_if_fail (expected_events != NULL);
#line 65 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	g_return_if_fail (mainloop != NULL);
#line 65 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	_data2_ = g_slice_new0 (Block2Data);
#line 65 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	_data2_->_ref_count_ = 1;
#line 65 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	_tmp0_ = expected_events;
#line 65 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	_tmp1_ = _g_ptr_array_ref0 (_tmp0_);
#line 65 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	_g_ptr_array_unref0 (_data2_->expected_events);
#line 65 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	_data2_->expected_events = _tmp1_;
#line 65 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	_tmp2_ = mainloop;
#line 65 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	_tmp3_ = _g_main_loop_ref0 (_tmp2_);
#line 65 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	_g_main_loop_unref0 (_data2_->mainloop);
#line 65 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	_data2_->mainloop = _tmp3_;
#line 605 "log-test.c"
	{
		ZeitgeistLog* _tmp4_;
		GAsyncResult* _tmp5_;
		GArray* _tmp6_ = NULL;
		GArray* _tmp7_;
#line 72 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
		_tmp4_ = log;
#line 72 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
		_tmp5_ = res;
#line 72 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
		_tmp6_ = zeitgeist_log_insert_events_finish (_tmp4_, _tmp5_, &_inner_error_);
#line 72 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
		_tmp7_ = _tmp6_;
#line 72 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
		if (_inner_error_ != NULL) {
#line 621 "log-test.c"
			goto __catch1_g_error;
		}
#line 72 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
		_g_array_unref0 (_data2_->event_ids);
#line 72 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
		_data2_->event_ids = _tmp7_;
#line 628 "log-test.c"
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp8_;
		const gchar* _tmp9_;
#line 71 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
		_error_ = _inner_error_;
#line 71 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
		_inner_error_ = NULL;
#line 75 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
		_tmp8_ = _error_;
#line 75 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
		_tmp9_ = _tmp8_->message;
#line 75 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
		g_critical ("log-test.vala:75: Failed to insert events: %s", _tmp9_);
#line 76 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
		_g_error_free0 (_error_);
#line 76 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
		block2_data_unref (_data2_);
#line 76 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
		_data2_ = NULL;
#line 76 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
		return;
#line 654 "log-test.c"
	}
	__finally1:
#line 71 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	if (_inner_error_ != NULL) {
#line 71 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
		block2_data_unref (_data2_);
#line 71 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
		_data2_ = NULL;
#line 71 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 71 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
		g_clear_error (&_inner_error_);
#line 71 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
		return;
#line 669 "log-test.c"
	}
#line 78 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	_tmp10_ = _data2_->expected_events;
#line 78 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	_tmp11_ = g_ptr_array_get_length (_tmp10_);
#line 78 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	_tmp12_ = _tmp11_;
#line 78 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	_tmp13_ = _data2_->event_ids;
#line 78 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	_tmp14_ = _tmp13_->len;
#line 78 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	_vala_assert (((guint) _tmp12_) == _tmp14_, "expected_events.length == event_ids.length");
#line 80 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	_tmp15_ = log;
#line 80 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	_tmp16_ = _data2_->event_ids;
#line 80 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	zeitgeist_log_get_events (_tmp15_, _tmp16_, NULL, ___lambda3__gasync_ready_callback, block2_data_ref (_data2_));
#line 65 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	block2_data_unref (_data2_);
#line 65 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	_data2_ = NULL;
#line 693 "log-test.c"
}


gboolean quit_main_loop (void) {
	gboolean result = FALSE;
	GMainContext* _tmp0_ = NULL;
	GMainLoop* _tmp1_;
	GMainLoop* _tmp2_;
#line 87 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	_tmp0_ = g_main_context_default ();
#line 87 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	_tmp1_ = g_main_loop_new (_tmp0_, FALSE);
#line 87 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	_tmp2_ = _tmp1_;
#line 87 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	g_main_loop_quit (_tmp2_);
#line 87 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	_g_main_loop_unref0 (_tmp2_);
#line 88 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	result = FALSE;
#line 88 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	return result;
#line 716 "log-test.c"
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
#line 91 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	g_atomic_int_inc (&_data3_->_ref_count_);
#line 91 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	return _data3_;
#line 725 "log-test.c"
}


static void block3_data_unref (void * _userdata_) {
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
#line 91 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
#line 91 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
		_g_ptr_array_unref0 (_data3_->expected_events);
#line 91 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
		_g_main_loop_unref0 (_data3_->mainloop);
#line 91 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
		g_slice_free (Block3Data, _data3_);
#line 740 "log-test.c"
	}
}


static void _g_object_unref0_ (gpointer var) {
#line 94 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 748 "log-test.c"
}


static void __lambda2_ (Block3Data* _data3_, GObject* log, GAsyncResult* res) {
	GObject* _tmp0_;
	GAsyncResult* _tmp1_;
#line 113 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	g_return_if_fail (res != NULL);
#line 114 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	_tmp0_ = log;
#line 114 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	_tmp1_ = res;
#line 114 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	events_inserted (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, ZEITGEIST_TYPE_LOG, ZeitgeistLog), _tmp1_, _data3_->expected_events, _data3_->mainloop);
#line 763 "log-test.c"
}


static void ___lambda2__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 112 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	__lambda2_ (self, source_object, res);
#line 112 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	block3_data_unref (self);
#line 772 "log-test.c"
}


static gboolean _quit_main_loop_gsource_func (gpointer self) {
	gboolean result;
	result = quit_main_loop ();
#line 118 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	return result;
#line 781 "log-test.c"
}


void insert_get_delete_test (void) {
	Block3Data* _data3_;
	GMainContext* _tmp0_ = NULL;
	GMainLoop* _tmp1_;
	GPtrArray* _tmp2_;
	ZeitgeistEvent* _tmp3_;
	ZeitgeistEvent* ev;
	ZeitgeistSubject* _tmp4_;
	ZeitgeistSubject* su;
	ZeitgeistEvent* _tmp5_;
	ZeitgeistLog* _tmp6_ = NULL;
	ZeitgeistLog* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
#line 91 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	_data3_ = g_slice_new0 (Block3Data);
#line 91 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	_data3_->_ref_count_ = 1;
#line 93 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	_tmp0_ = g_main_context_default ();
#line 93 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	_tmp1_ = g_main_loop_new (_tmp0_, FALSE);
#line 93 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	_data3_->mainloop = _tmp1_;
#line 94 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	_tmp2_ = g_ptr_array_new_with_free_func (_g_object_unref0_);
#line 94 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	_data3_->expected_events = _tmp2_;
#line 95 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	_tmp3_ = zeitgeist_event_new ();
#line 95 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	ev = _tmp3_;
#line 96 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	_tmp4_ = zeitgeist_subject_new ();
#line 96 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	su = _tmp4_;
#line 97 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	zeitgeist_event_add_subject (ev, su);
#line 98 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	_tmp5_ = _g_object_ref0 (ev);
#line 98 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	g_ptr_array_add (_data3_->expected_events, _tmp5_);
#line 99 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	zeitgeist_event_set_interpretation (ev, "foo://Interp");
#line 100 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	zeitgeist_event_set_manifestation (ev, "foo://Manif");
#line 101 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	zeitgeist_event_set_actor (ev, "app://firefox.desktop");
#line 103 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	zeitgeist_subject_set_uri (su, "file:///tmp/bar.txt");
#line 104 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	zeitgeist_subject_set_interpretation (su, "foo://TextDoc");
#line 105 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	zeitgeist_subject_set_manifestation (su, "foo://File");
#line 106 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	zeitgeist_subject_set_mimetype (su, "text/plain");
#line 107 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	zeitgeist_subject_set_origin (su, "file:///tmp");
#line 108 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	zeitgeist_subject_set_text (su, "bar.txt");
#line 109 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	zeitgeist_subject_set_storage (su, "bfb486f6-f5f8-4296-8871-0cc749cf8ef7");
#line 112 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	_tmp6_ = zeitgeist_log_get_default ();
#line 112 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	_tmp7_ = _tmp6_;
#line 112 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	zeitgeist_log_insert_events (_tmp7_, _data3_->expected_events, NULL, ___lambda2__gasync_ready_callback, block3_data_ref (_data3_));
#line 112 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	_g_object_unref0 (_tmp7_);
#line 116 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	_tmp8_ = g_ptr_array_get_length (_data3_->expected_events);
#line 116 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	_tmp9_ = _tmp8_;
#line 116 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	_vala_assert (_tmp9_ == 1, "expected_events.length == 1");
#line 118 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 1, _quit_main_loop_gsource_func, NULL, NULL);
#line 119 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	g_main_loop_run (_data3_->mainloop);
#line 91 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	_g_object_unref0 (su);
#line 91 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	_g_object_unref0 (ev);
#line 91 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	block3_data_unref (_data3_);
#line 91 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	_data3_ = NULL;
#line 873 "log-test.c"
}


void get_default_test (void) {
	ZeitgeistLog* _tmp0_ = NULL;
	ZeitgeistLog* log1;
	ZeitgeistLog* _tmp1_ = NULL;
	ZeitgeistLog* log2;
#line 124 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	_tmp0_ = zeitgeist_log_get_default ();
#line 124 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	log1 = _tmp0_;
#line 125 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	_tmp1_ = zeitgeist_log_get_default ();
#line 125 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	log2 = _tmp1_;
#line 126 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	_vala_assert (log1 == log2, "log1 == log2");
#line 122 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	_g_object_unref0 (log2);
#line 122 "/home/manish/code/zeitgeist/test/direct/log-test.vala"
	_g_object_unref0 (log1);
#line 896 "log-test.c"
}



