/* Thumbnail.c generated by valac 0.36.6, the Vala compiler
 * generated from Thumbnail.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU LGPL (version 2.1 or later).
 * See the COPYING file in this distribution.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <cairo.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gio/gio.h>
#include <gee.h>
#include <pango/pango.h>
#include <time.h>


#define TYPE_DATA_OBJECT (data_object_get_type ())
#define DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_OBJECT, DataObject))
#define DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_OBJECT, DataObjectClass))
#define IS_DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_OBJECT))
#define IS_DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_OBJECT))
#define DATA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_OBJECT, DataObjectClass))

typedef struct _DataObject DataObject;
typedef struct _DataObjectClass DataObjectClass;
typedef struct _DataObjectPrivate DataObjectPrivate;

#define TYPE_ALTERATION (alteration_get_type ())
#define ALTERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ALTERATION, Alteration))
#define ALTERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ALTERATION, AlterationClass))
#define IS_ALTERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ALTERATION))
#define IS_ALTERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ALTERATION))
#define ALTERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ALTERATION, AlterationClass))

typedef struct _Alteration Alteration;
typedef struct _AlterationClass AlterationClass;

#define TYPE_DATA_COLLECTION (data_collection_get_type ())
#define DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_COLLECTION, DataCollection))
#define DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_COLLECTION, DataCollectionClass))
#define IS_DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_COLLECTION))
#define IS_DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_COLLECTION))
#define DATA_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_COLLECTION, DataCollectionClass))

typedef struct _DataCollection DataCollection;
typedef struct _DataCollectionClass DataCollectionClass;

#define TYPE_DATA_VIEW (data_view_get_type ())
#define DATA_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_VIEW, DataView))
#define DATA_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_VIEW, DataViewClass))
#define IS_DATA_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_VIEW))
#define IS_DATA_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_VIEW))
#define DATA_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_VIEW, DataViewClass))

typedef struct _DataView DataView;
typedef struct _DataViewClass DataViewClass;
typedef struct _DataViewPrivate DataViewPrivate;

#define TYPE_DATA_SOURCE (data_source_get_type ())
#define DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_SOURCE, DataSource))
#define DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_SOURCE, DataSourceClass))
#define IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_SOURCE))
#define IS_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_SOURCE))
#define DATA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_SOURCE, DataSourceClass))

typedef struct _DataSource DataSource;
typedef struct _DataSourceClass DataSourceClass;

#define TYPE_THUMBNAIL_VIEW (thumbnail_view_get_type ())
#define THUMBNAIL_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAIL_VIEW, ThumbnailView))
#define THUMBNAIL_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAIL_VIEW, ThumbnailViewClass))
#define IS_THUMBNAIL_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAIL_VIEW))
#define IS_THUMBNAIL_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAIL_VIEW))
#define THUMBNAIL_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAIL_VIEW, ThumbnailViewClass))

typedef struct _ThumbnailView ThumbnailView;
typedef struct _ThumbnailViewClass ThumbnailViewClass;
typedef struct _ThumbnailViewPrivate ThumbnailViewPrivate;

#define TYPE_CHECKERBOARD_ITEM (checkerboard_item_get_type ())
#define CHECKERBOARD_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHECKERBOARD_ITEM, CheckerboardItem))
#define CHECKERBOARD_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHECKERBOARD_ITEM, CheckerboardItemClass))
#define IS_CHECKERBOARD_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHECKERBOARD_ITEM))
#define IS_CHECKERBOARD_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHECKERBOARD_ITEM))
#define CHECKERBOARD_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHECKERBOARD_ITEM, CheckerboardItemClass))

typedef struct _CheckerboardItem CheckerboardItem;
typedef struct _CheckerboardItemClass CheckerboardItemClass;
typedef struct _CheckerboardItemPrivate CheckerboardItemPrivate;

#define TYPE_DIMENSIONS (dimensions_get_type ())
typedef struct _Dimensions Dimensions;

#define TYPE_MEDIA_SOURCE_ITEM (media_source_item_get_type ())
#define MEDIA_SOURCE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE_ITEM, MediaSourceItem))
#define MEDIA_SOURCE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE_ITEM, MediaSourceItemClass))
#define IS_MEDIA_SOURCE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE_ITEM))
#define IS_MEDIA_SOURCE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE_ITEM))
#define MEDIA_SOURCE_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE_ITEM, MediaSourceItemClass))

typedef struct _MediaSourceItem MediaSourceItem;
typedef struct _MediaSourceItemClass MediaSourceItemClass;
typedef struct _MediaSourceItemPrivate MediaSourceItemPrivate;

#define TYPE_THUMBNAIL (thumbnail_get_type ())
#define THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAIL, Thumbnail))
#define THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAIL, ThumbnailClass))
#define IS_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAIL))
#define IS_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAIL))
#define THUMBNAIL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAIL, ThumbnailClass))

typedef struct _Thumbnail Thumbnail;
typedef struct _ThumbnailClass ThumbnailClass;
typedef struct _ThumbnailPrivate ThumbnailPrivate;

#define TYPE_THUMBNAIL_SOURCE (thumbnail_source_get_type ())
#define THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSource))
#define THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))
#define IS_THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAIL_SOURCE))
#define IS_THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAIL_SOURCE))
#define THUMBNAIL_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))

typedef struct _ThumbnailSource ThumbnailSource;
typedef struct _ThumbnailSourceClass ThumbnailSourceClass;

#define TYPE_MEDIA_SOURCE (media_source_get_type ())
#define MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE, MediaSource))
#define MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE, MediaSourceClass))
#define IS_MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE))
#define IS_MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE))
#define MEDIA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE, MediaSourceClass))

typedef struct _MediaSource MediaSource;
typedef struct _MediaSourceClass MediaSourceClass;

#define TYPE_SOURCE_COLLECTION (source_collection_get_type ())
#define SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_COLLECTION, SourceCollection))
#define SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_COLLECTION, SourceCollectionClass))
#define IS_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_COLLECTION))
#define IS_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_COLLECTION))
#define SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_COLLECTION, SourceCollectionClass))

typedef struct _SourceCollection SourceCollection;
typedef struct _SourceCollectionClass SourceCollectionClass;

#define TYPE_DATABASE_SOURCE_COLLECTION (database_source_collection_get_type ())
#define DATABASE_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollection))
#define DATABASE_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollectionClass))
#define IS_DATABASE_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATABASE_SOURCE_COLLECTION))
#define IS_DATABASE_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATABASE_SOURCE_COLLECTION))
#define DATABASE_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollectionClass))

typedef struct _DatabaseSourceCollection DatabaseSourceCollection;
typedef struct _DatabaseSourceCollectionClass DatabaseSourceCollectionClass;

#define TYPE_CONTAINER_SOURCE_COLLECTION (container_source_collection_get_type ())
#define CONTAINER_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollection))
#define CONTAINER_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollectionClass))
#define IS_CONTAINER_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONTAINER_SOURCE_COLLECTION))
#define IS_CONTAINER_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONTAINER_SOURCE_COLLECTION))
#define CONTAINER_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollectionClass))

typedef struct _ContainerSourceCollection ContainerSourceCollection;
typedef struct _ContainerSourceCollectionClass ContainerSourceCollectionClass;

#define TYPE_TAG_SOURCE_COLLECTION (tag_source_collection_get_type ())
#define TAG_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TAG_SOURCE_COLLECTION, TagSourceCollection))
#define TAG_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TAG_SOURCE_COLLECTION, TagSourceCollectionClass))
#define IS_TAG_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TAG_SOURCE_COLLECTION))
#define IS_TAG_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TAG_SOURCE_COLLECTION))
#define TAG_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TAG_SOURCE_COLLECTION, TagSourceCollectionClass))

typedef struct _TagSourceCollection TagSourceCollection;
typedef struct _TagSourceCollectionClass TagSourceCollectionClass;

#define TYPE_CONTAINER_SOURCE (container_source_get_type ())
#define CONTAINER_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONTAINER_SOURCE, ContainerSource))
#define IS_CONTAINER_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONTAINER_SOURCE))
#define CONTAINER_SOURCE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_CONTAINER_SOURCE, ContainerSourceIface))

typedef struct _ContainerSource ContainerSource;
typedef struct _ContainerSourceIface ContainerSourceIface;

#define TYPE_SOURCE_BACKLINK (source_backlink_get_type ())
#define SOURCE_BACKLINK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_BACKLINK, SourceBacklink))
#define SOURCE_BACKLINK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_BACKLINK, SourceBacklinkClass))
#define IS_SOURCE_BACKLINK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_BACKLINK))
#define IS_SOURCE_BACKLINK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_BACKLINK))
#define SOURCE_BACKLINK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_BACKLINK, SourceBacklinkClass))

typedef struct _SourceBacklink SourceBacklink;
typedef struct _SourceBacklinkClass SourceBacklinkClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define PHOTO_TYPE_EXCEPTION (photo_exception_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_PHOTO_SOURCE (photo_source_get_type ())
#define PHOTO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_SOURCE, PhotoSource))
#define PHOTO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_SOURCE, PhotoSourceClass))
#define IS_PHOTO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_SOURCE))
#define IS_PHOTO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_SOURCE))
#define PHOTO_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_SOURCE, PhotoSourceClass))

typedef struct _PhotoSource PhotoSource;
typedef struct _PhotoSourceClass PhotoSourceClass;

#define TYPE_PHOTO (photo_get_type ())
#define PHOTO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO, Photo))
#define PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO, PhotoClass))
#define IS_PHOTO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO))
#define IS_PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO))
#define PHOTO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO, PhotoClass))

typedef struct _Photo Photo;
typedef struct _PhotoClass PhotoClass;

#define TYPE_LIBRARY_PHOTO (library_photo_get_type ())
#define LIBRARY_PHOTO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LIBRARY_PHOTO, LibraryPhoto))
#define LIBRARY_PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LIBRARY_PHOTO, LibraryPhotoClass))
#define IS_LIBRARY_PHOTO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LIBRARY_PHOTO))
#define IS_LIBRARY_PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LIBRARY_PHOTO))
#define LIBRARY_PHOTO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LIBRARY_PHOTO, LibraryPhotoClass))

typedef struct _LibraryPhoto LibraryPhoto;
typedef struct _LibraryPhotoClass LibraryPhotoClass;

#define TYPE_VIDEO_SOURCE (video_source_get_type ())
#define VIDEO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO_SOURCE, VideoSource))
#define VIDEO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO_SOURCE, VideoSourceClass))
#define IS_VIDEO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO_SOURCE))
#define IS_VIDEO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO_SOURCE))
#define VIDEO_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO_SOURCE, VideoSourceClass))

typedef struct _VideoSource VideoSource;
typedef struct _VideoSourceClass VideoSourceClass;

#define TYPE_VIDEO (video_get_type ())
#define VIDEO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO, Video))
#define VIDEO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO, VideoClass))
#define IS_VIDEO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO))
#define IS_VIDEO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO))
#define VIDEO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO, VideoClass))

typedef struct _Video Video;
typedef struct _VideoClass VideoClass;

#define TYPE_TAG (tag_get_type ())
#define TAG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TAG, Tag))
#define TAG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TAG, TagClass))
#define IS_TAG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TAG))
#define IS_TAG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TAG))
#define TAG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TAG, TagClass))

typedef struct _Tag Tag;
typedef struct _TagClass TagClass;

#define TYPE_RATING (rating_get_type ())

#define THUMBNAIL_CACHE_TYPE_SIZE (thumbnail_cache_size_get_type ())

#define TYPE_FLAGGABLE (flaggable_get_type ())
#define FLAGGABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FLAGGABLE, Flaggable))
#define IS_FLAGGABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FLAGGABLE))
#define FLAGGABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_FLAGGABLE, FlaggableIface))

typedef struct _Flaggable Flaggable;
typedef struct _FlaggableIface FlaggableIface;
#define __vala_GValue_free0(var) ((var == NULL) ? NULL : (var = (_vala_GValue_free (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _DataObject {
	GObject parent_instance;
	DataObjectPrivate * priv;
};

struct _DataObjectClass {
	GObjectClass parent_class;
	void (*notify_altered) (DataObject* self, Alteration* alteration);
	void (*notify_membership_changed) (DataObject* self, DataCollection* collection);
	void (*notify_collection_property_set) (DataObject* self, const gchar* name, GValue* old, GValue* val);
	void (*notify_collection_property_cleared) (DataObject* self, const gchar* name);
	gchar* (*get_name) (DataObject* self);
	gchar* (*to_string) (DataObject* self);
};

struct _DataView {
	DataObject parent_instance;
	DataViewPrivate * priv;
};

struct _DataViewClass {
	DataObjectClass parent_class;
	void (*notify_view_altered) (DataView* self);
	void (*notify_geometry_altered) (DataView* self);
	void (*notify_unsubscribed) (DataView* self, DataSource* source);
	void (*state_changed) (DataView* self, gboolean selected);
	void (*visibility_changed) (DataView* self, gboolean visible);
	void (*view_altered) (DataView* self);
	void (*geometry_altered) (DataView* self);
	void (*unsubscribed) (DataView* self, DataSource* source);
};

struct _ThumbnailView {
	DataView parent_instance;
	ThumbnailViewPrivate * priv;
};

struct _ThumbnailViewClass {
	DataViewClass parent_class;
	void (*notify_thumbnail_altered) (ThumbnailView* self);
	void (*thumbnail_altered) (ThumbnailView* self);
};

struct _Dimensions {
	gint width;
	gint height;
};

struct _CheckerboardItem {
	ThumbnailView parent_instance;
	CheckerboardItemPrivate * priv;
	Dimensions requisition;
	GdkRectangle allocation;
};

struct _CheckerboardItemClass {
	ThumbnailViewClass parent_class;
	void (*exposed) (CheckerboardItem* self);
	void (*unexposed) (CheckerboardItem* self);
	gboolean (*is_exposed) (CheckerboardItem* self);
	void (*paint_shadow) (CheckerboardItem* self, cairo_t* ctx, Dimensions* dimensions, GdkPoint* origin, gint radius, gfloat initial_alpha);
	void (*paint_border) (CheckerboardItem* self, cairo_t* ctx, Dimensions* object_dimensions, GdkPoint* object_origin, gint border_width);
	void (*paint_image) (CheckerboardItem* self, cairo_t* ctx, GdkPixbuf* pixbuf, GdkPoint* origin);
	GdkPixbuf* (*get_top_left_trinket) (CheckerboardItem* self, gint scale);
	GdkPixbuf* (*get_top_right_trinket) (CheckerboardItem* self, gint scale);
	GdkPixbuf* (*get_bottom_left_trinket) (CheckerboardItem* self, gint scale);
	GdkPixbuf* (*get_bottom_right_trinket) (CheckerboardItem* self, gint scale);
};

struct _MediaSourceItem {
	CheckerboardItem parent_instance;
	MediaSourceItemPrivate * priv;
};

struct _MediaSourceItemClass {
	CheckerboardItemClass parent_class;
};

struct _Thumbnail {
	MediaSourceItem parent_instance;
	ThumbnailPrivate * priv;
};

struct _ThumbnailClass {
	MediaSourceItemClass parent_class;
};

struct _ThumbnailPrivate {
	MediaSource* media;
	gint scale;
	Dimensions original_dim;
	Dimensions dim;
	GdkPixbuf* unscaled_pixbuf;
	GCancellable* cancellable;
	gboolean hq_scheduled;
	gboolean hq_reschedule;
	gboolean exposure;
};

struct _ContainerSourceIface {
	GTypeInterface parent_iface;
	gboolean (*has_links) (ContainerSource* self);
	SourceBacklink* (*get_backlink) (ContainerSource* self);
	void (*break_link) (ContainerSource* self, DataSource* source);
	void (*break_link_many) (ContainerSource* self, GeeCollection* sources);
	void (*establish_link) (ContainerSource* self, DataSource* source);
	void (*establish_link_many) (ContainerSource* self, GeeCollection* sources);
};

typedef enum  {
	PHOTO_EXCEPTION_NONE = 0,
	PHOTO_EXCEPTION_ORIENTATION = 1 << 0,
	PHOTO_EXCEPTION_CROP = 1 << 1,
	PHOTO_EXCEPTION_REDEYE = 1 << 2,
	PHOTO_EXCEPTION_ADJUST = 1 << 3,
	PHOTO_EXCEPTION_STRAIGHTEN = 1 << 4,
	PHOTO_EXCEPTION_ALL = 0xFFFFFFFFLL
} PhotoException;

typedef enum  {
	RATING_REJECTED = -1,
	RATING_UNRATED = 0,
	RATING_ONE = 1,
	RATING_TWO = 2,
	RATING_THREE = 3,
	RATING_FOUR = 4,
	RATING_FIVE = 5
} Rating;

typedef void (*ThumbnailCacheAsyncFetchCallback) (GdkPixbuf* pixbuf, GdkPixbuf* unscaled, Dimensions* dim, GdkInterpType interp, GError* err, void* user_data);
typedef enum  {
	THUMBNAIL_CACHE_SIZE_LARGEST = 360,
	THUMBNAIL_CACHE_SIZE_BIG = 360,
	THUMBNAIL_CACHE_SIZE_MEDIUM = 128,
	THUMBNAIL_CACHE_SIZE_SMALLEST = 128
} ThumbnailCacheSize;

struct _FlaggableIface {
	GTypeInterface parent_iface;
	gboolean (*is_flagged) (Flaggable* self);
	void (*mark_flagged) (Flaggable* self);
	void (*mark_unflagged) (Flaggable* self);
};


static gpointer thumbnail_parent_class = NULL;
extern TagSourceCollection* tag_global;

GType data_object_get_type (void) G_GNUC_CONST;
gpointer alteration_ref (gpointer instance);
void alteration_unref (gpointer instance);
GParamSpec* param_spec_alteration (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_alteration (GValue* value, gpointer v_object);
void value_take_alteration (GValue* value, gpointer v_object);
gpointer value_get_alteration (const GValue* value);
GType alteration_get_type (void) G_GNUC_CONST;
gpointer data_collection_ref (gpointer instance);
void data_collection_unref (gpointer instance);
GParamSpec* param_spec_data_collection (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_data_collection (GValue* value, gpointer v_object);
void value_take_data_collection (GValue* value, gpointer v_object);
gpointer value_get_data_collection (const GValue* value);
GType data_collection_get_type (void) G_GNUC_CONST;
GType data_view_get_type (void) G_GNUC_CONST;
GType data_source_get_type (void) G_GNUC_CONST;
GType thumbnail_view_get_type (void) G_GNUC_CONST;
GType checkerboard_item_get_type (void) G_GNUC_CONST;
GType dimensions_get_type (void) G_GNUC_CONST;
Dimensions* dimensions_dup (const Dimensions* self);
void dimensions_free (Dimensions* self);
GType media_source_item_get_type (void) G_GNUC_CONST;
GType thumbnail_get_type (void) G_GNUC_CONST;
GType thumbnail_source_get_type (void) G_GNUC_CONST;
GType media_source_get_type (void) G_GNUC_CONST;
#define THUMBNAIL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_THUMBNAIL, ThumbnailPrivate))
enum  {
	THUMBNAIL_DUMMY_PROPERTY
};
GType source_collection_get_type (void) G_GNUC_CONST;
GType database_source_collection_get_type (void) G_GNUC_CONST;
GType container_source_collection_get_type (void) G_GNUC_CONST;
GType tag_source_collection_get_type (void) G_GNUC_CONST;
gpointer source_backlink_ref (gpointer instance);
void source_backlink_unref (gpointer instance);
GParamSpec* param_spec_source_backlink (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_source_backlink (GValue* value, gpointer v_object);
void value_take_source_backlink (GValue* value, gpointer v_object);
gpointer value_get_source_backlink (const GValue* value);
GType source_backlink_get_type (void) G_GNUC_CONST;
GType container_source_get_type (void) G_GNUC_CONST;
static void thumbnail_on_tag_contents_altered (Thumbnail* self, ContainerSource* container, GeeCollection* added, gboolean relinking, GeeCollection* removed, gboolean unlinking);
static void _thumbnail_on_tag_contents_altered_container_source_collection_container_contents_altered (ContainerSourceCollection* _sender, ContainerSource* container, GeeCollection* added, gboolean relinked, GeeCollection* removed, gboolean unlinked, gpointer self);
static void thumbnail_on_tags_altered (Thumbnail* self, GeeMap* altered);
static void _thumbnail_on_tags_altered_data_collection_items_altered (DataCollection* _sender, GeeMap* items, gpointer self);
#define CHECKERBOARD_ITEM_PROP_SHOW_SUBTITLES "show-subtitles"
#define THUMBNAIL_PROP_SHOW_TAGS CHECKERBOARD_ITEM_PROP_SHOW_SUBTITLES
#define THUMBNAIL_PROP_SIZE "thumbnail-size"
#define THUMBNAIL_PROP_SHOW_RATINGS "show-ratings"
#define THUMBNAIL_LOW_QUALITY_INTERP GDK_INTERP_NEAREST
#define THUMBNAIL_HIGH_QUALITY_INTERP GDK_INTERP_BILINEAR
#define THUMBNAIL_HQ_IMPROVEMENT_MSEC 100
Thumbnail* thumbnail_new (MediaSource* media, gint scale);
Thumbnail* thumbnail_construct (GType object_type, MediaSource* media, gint scale);
GType photo_exception_get_type (void) G_GNUC_CONST;
void media_source_get_dimensions (MediaSource* self, PhotoException disallowed_steps, Dimensions* result);
void dimensions_get_scaled (Dimensions *self, gint scale, gboolean scale_up, Dimensions* result);
gchar* data_object_get_name (DataObject* self);
gchar* media_source_get_comment (MediaSource* self);
MediaSourceItem* media_source_item_new (ThumbnailSource* source, Dimensions* initial_pixbuf_dim, const gchar* title, const gchar* comment, gboolean marked_up, PangoAlignment alignment);
MediaSourceItem* media_source_item_construct (GType object_type, ThumbnailSource* source, Dimensions* initial_pixbuf_dim, const gchar* title, const gchar* comment, gboolean marked_up, PangoAlignment alignment);
GType photo_source_get_type (void) G_GNUC_CONST;
GType photo_get_type (void) G_GNUC_CONST;
GType library_photo_get_type (void) G_GNUC_CONST;
GType video_source_get_type (void) G_GNUC_CONST;
GType video_get_type (void) G_GNUC_CONST;
void media_source_item_set_enable_sprockets (MediaSourceItem* self, gboolean enable_sprockets);
static void thumbnail_update_title (Thumbnail* self, gboolean init);
static void thumbnail_update_comment (Thumbnail* self, gboolean init);
static void thumbnail_update_tags (Thumbnail* self, gboolean init);
GType tag_get_type (void) G_GNUC_CONST;
GeeSortedSet* tag_source_collection_fetch_sorted_for_source (TagSourceCollection* self, MediaSource* photo);
void checkerboard_item_clear_tags (CheckerboardItem* self);
void checkerboard_item_set_tags (CheckerboardItem* self, GeeCollection* tags, PangoAlignment alignment);
gboolean tag_contains (Tag* self, MediaSource* source);
gboolean is_string_empty (const gchar* s);
void checkerboard_item_clear_title (CheckerboardItem* self);
void media_source_item_set_title (MediaSourceItem* self, const gchar* text, gboolean marked_up, PangoAlignment alignment);
void checkerboard_item_clear_comment (CheckerboardItem* self);
void checkerboard_item_set_comment (CheckerboardItem* self, const gchar* text, gboolean marked_up, PangoAlignment alignment);
static void thumbnail_real_notify_altered (DataObject* base, Alteration* alteration);
gboolean alteration_has_detail (Alteration* self, const gchar* subject, const gchar* detail);
void data_object_notify_altered (DataObject* self, Alteration* alteration);
MediaSource* thumbnail_get_media_source (Thumbnail* self);
gint64 thumbnail_photo_id_ascending_comparator (void* a, void* b);
gint64 data_source_get_instance_id (DataSource* self);
gint64 thumbnail_photo_id_descending_comparator (void* a, void* b);
gint64 thumbnail_title_ascending_comparator (void* a, void* b);
gchar* media_source_item_get_natural_collation_key (MediaSourceItem* self);
gint64 thumbnail_title_descending_comparator (void* a, void* b);
gboolean thumbnail_title_comparator_predicate (DataObject* object, Alteration* alteration);
gint64 thumbnail_exposure_time_ascending_comparator (void* a, void* b);
time_t media_source_get_exposure_time (MediaSource* self);
gint64 thumbnail_filename_ascending_comparator (void* a, void* b);
gint64 thumbnail_exposure_time_desending_comparator (void* a, void* b);
gint64 thumbnail_filename_descending_comparator (void* a, void* b);
gboolean thumbnail_exposure_time_comparator_predicate (DataObject* object, Alteration* alteration);
gboolean thumbnail_filename_comparator_predicate (DataObject* object, Alteration* alteration);
GFile* media_source_get_file (MediaSource* self);
gint64 thumbnail_rating_ascending_comparator (void* a, void* b);
GType rating_get_type (void) G_GNUC_CONST;
Rating media_source_get_rating (MediaSource* self);
gint64 thumbnail_rating_descending_comparator (void* a, void* b);
gboolean thumbnail_rating_comparator_predicate (DataObject* object, Alteration* alteration);
static void thumbnail_real_thumbnail_altered (ThumbnailView* base);
static void thumbnail_delayed_high_quality_fetch (Thumbnail* self);
static void thumbnail_paint_empty (Thumbnail* self);
static void thumbnail_real_notify_collection_property_set (DataObject* base, const gchar* name, GValue* old, GValue* val);
static void thumbnail_resize (Thumbnail* self, gint new_scale);
void data_view_notify_view_altered (DataView* self);
void data_object_notify_collection_property_set (DataObject* self, const gchar* name, GValue* old, GValue* val);
gint thumbnail_get_MIN_SCALE (void);
gint thumbnail_get_MAX_SCALE (void);
static void thumbnail_cancel_async_fetch (Thumbnail* self);
gboolean checkerboard_item_has_image (CheckerboardItem* self);
GdkPixbuf* checkerboard_item_get_image (CheckerboardItem* self);
void checkerboard_item_set_image (CheckerboardItem* self, GdkPixbuf* pixbuf);
GdkPixbuf* resize_pixbuf (GdkPixbuf* pixbuf, Dimensions* resized, GdkInterpType interp);
void checkerboard_item_clear_image (CheckerboardItem* self, Dimensions* dim);
static void thumbnail_schedule_low_quality_fetch (Thumbnail* self);
void thumbnail_cache_fetch_async_scaled (ThumbnailSource* source, gint scale, Dimensions* dim, GdkInterpType interp, ThumbnailCacheAsyncFetchCallback callback, void* callback_target, GCancellable* cancellable);
GType thumbnail_cache_size_get_type (void) G_GNUC_CONST;
static void thumbnail_on_low_quality_fetched (Thumbnail* self, GdkPixbuf* pixbuf, GdkPixbuf* unscaled, Dimensions* dim, GdkInterpType interp, GError* err);
static void _thumbnail_on_low_quality_fetched_thumbnail_cache_async_fetch_callback (GdkPixbuf* pixbuf, GdkPixbuf* unscaled, Dimensions* dim, GdkInterpType interp, GError* err, gpointer self);
static gboolean thumbnail_on_schedule_high_quality (Thumbnail* self);
static gboolean _thumbnail_on_schedule_high_quality_gsource_func (gpointer self);
static void thumbnail_on_high_quality_fetched (Thumbnail* self, GdkPixbuf* pixbuf, GdkPixbuf* unscaled, Dimensions* dim, GdkInterpType interp, GError* err);
static void _thumbnail_on_high_quality_fetched_thumbnail_cache_async_fetch_callback (GdkPixbuf* pixbuf, GdkPixbuf* unscaled, Dimensions* dim, GdkInterpType interp, GError* err, gpointer self);
gchar* data_object_to_string (DataObject* self);
static void thumbnail_real_exposed (CheckerboardItem* base);
void checkerboard_item_exposed (CheckerboardItem* self);
static void thumbnail_real_unexposed (CheckerboardItem* base);
void checkerboard_item_unexposed (CheckerboardItem* self);
static GdkPixbuf* thumbnail_real_get_top_right_trinket (CheckerboardItem* base, gint scale);
GType flaggable_get_type (void) G_GNUC_CONST;
gboolean flaggable_is_flagged (Flaggable* self);
GdkPixbuf* resources_get_icon (const gchar* name, gint scale);
#define RESOURCES_ICON_FLAGGED_TRINKET "flag-trinket.png"
#define RESOURCES_DEFAULT_ICON_SCALE 24
static GdkPixbuf* thumbnail_real_get_bottom_left_trinket (CheckerboardItem* base, gint scale);
void data_object_get_collection_property (DataObject* self, const gchar* name, GValue* def, GValue* result);
static void _vala_GValue_free (GValue* self);
GdkPixbuf* resources_get_rating_trinket (Rating rating, gint scale);
gint thumbnail_cache_size_get_scale (ThumbnailCacheSize self);
gint thumbnail_get_DEFAULT_SCALE (void);
static void thumbnail_finalize (GObject * obj);
static void _vala_thumbnail_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);


static void _thumbnail_on_tag_contents_altered_container_source_collection_container_contents_altered (ContainerSourceCollection* _sender, ContainerSource* container, GeeCollection* added, gboolean relinked, GeeCollection* removed, gboolean unlinked, gpointer self) {
#line 76 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	thumbnail_on_tag_contents_altered ((Thumbnail*) self, container, added, relinked, removed, unlinked);
#line 585 "Thumbnail.c"
}


static void _thumbnail_on_tags_altered_data_collection_items_altered (DataCollection* _sender, GeeMap* items, gpointer self) {
#line 77 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	thumbnail_on_tags_altered ((Thumbnail*) self, items);
#line 592 "Thumbnail.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 53 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	return self ? g_object_ref (self) : NULL;
#line 599 "Thumbnail.c"
}


Thumbnail* thumbnail_construct (GType object_type, MediaSource* media, gint scale) {
	Thumbnail * self = NULL;
	MediaSource* _tmp0_;
	MediaSource* _tmp1_;
	Dimensions _tmp2_ = {0};
	gint _tmp3_;
	Dimensions _tmp4_ = {0};
	MediaSource* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	MediaSource* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	MediaSource* _tmp11_;
	MediaSource* _tmp12_;
	gint _tmp13_;
	TagSourceCollection* _tmp14_;
	TagSourceCollection* _tmp15_;
	gboolean _tmp16_ = FALSE;
	MediaSource* _tmp17_;
	MediaSource* _tmp19_;
	MediaSource* _tmp20_;
	Dimensions _tmp21_ = {0};
	gint _tmp22_;
	Dimensions _tmp23_ = {0};
#line 49 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_return_val_if_fail (IS_MEDIA_SOURCE (media), NULL);
#line 50 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp0_ = media;
#line 50 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp1_ = media;
#line 50 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	media_source_get_dimensions (_tmp1_, PHOTO_EXCEPTION_NONE, &_tmp2_);
#line 50 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp3_ = scale;
#line 50 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	dimensions_get_scaled (&_tmp2_, _tmp3_, TRUE, &_tmp4_);
#line 50 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp5_ = media;
#line 50 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp6_ = data_object_get_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, TYPE_DATA_OBJECT, DataObject));
#line 50 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp7_ = _tmp6_;
#line 50 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp8_ = media;
#line 50 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp9_ = media_source_get_comment (_tmp8_);
#line 50 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp10_ = _tmp9_;
#line 50 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	self = (Thumbnail*) media_source_item_construct (object_type, G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_THUMBNAIL_SOURCE, ThumbnailSource), &_tmp4_, _tmp7_, _tmp10_, FALSE, PANGO_ALIGN_LEFT);
#line 50 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_g_free0 (_tmp10_);
#line 50 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_g_free0 (_tmp7_);
#line 53 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp11_ = media;
#line 53 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp12_ = _g_object_ref0 (_tmp11_);
#line 53 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_g_object_unref0 (self->priv->media);
#line 53 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	self->priv->media = _tmp12_;
#line 54 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp13_ = scale;
#line 54 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	self->priv->scale = _tmp13_;
#line 56 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp14_ = tag_global;
#line 56 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollection), "container-contents-altered", (GCallback) _thumbnail_on_tag_contents_altered_container_source_collection_container_contents_altered, self, 0);
#line 57 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp15_ = tag_global;
#line 57 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, TYPE_DATA_COLLECTION, DataCollection), "items-altered", (GCallback) _thumbnail_on_tags_altered_data_collection_items_altered, self, 0);
#line 59 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp17_ = media;
#line 59 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp17_, TYPE_LIBRARY_PHOTO)) {
#line 59 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp16_ = TRUE;
#line 684 "Thumbnail.c"
	} else {
		MediaSource* _tmp18_;
#line 59 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp18_ = media;
#line 59 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp16_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp18_, TYPE_VIDEO);
#line 691 "Thumbnail.c"
	}
#line 59 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_vala_assert (_tmp16_, "(media is LibraryPhoto) || (media is Video)");
#line 60 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp19_ = media;
#line 60 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	media_source_item_set_enable_sprockets (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE_ITEM, MediaSourceItem), G_TYPE_CHECK_INSTANCE_TYPE (_tmp19_, TYPE_VIDEO));
#line 62 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp20_ = media;
#line 62 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	media_source_get_dimensions (_tmp20_, PHOTO_EXCEPTION_NONE, &_tmp21_);
#line 62 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	self->priv->original_dim = _tmp21_;
#line 63 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp22_ = scale;
#line 63 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	dimensions_get_scaled (&self->priv->original_dim, _tmp22_, TRUE, &_tmp23_);
#line 63 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	self->priv->dim = _tmp23_;
#line 67 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	thumbnail_update_title (self, TRUE);
#line 68 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	thumbnail_update_comment (self, TRUE);
#line 69 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	thumbnail_update_tags (self, TRUE);
#line 49 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	return self;
#line 719 "Thumbnail.c"
}


Thumbnail* thumbnail_new (MediaSource* media, gint scale) {
#line 49 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	return thumbnail_construct (TYPE_THUMBNAIL, media, scale);
#line 726 "Thumbnail.c"
}


static void thumbnail_update_tags (Thumbnail* self, gboolean init) {
	GeeCollection* tags = NULL;
	TagSourceCollection* _tmp0_;
	MediaSource* _tmp1_;
	GeeSortedSet* _tmp2_;
	gboolean _tmp3_ = FALSE;
	GeeCollection* _tmp4_;
#line 80 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_return_if_fail (IS_THUMBNAIL (self));
#line 81 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp0_ = tag_global;
#line 81 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp1_ = self->priv->media;
#line 81 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp2_ = tag_source_collection_fetch_sorted_for_source (_tmp0_, _tmp1_);
#line 81 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	tags = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_COLLECTION, GeeCollection);
#line 82 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp4_ = tags;
#line 82 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (_tmp4_ == NULL) {
#line 82 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp3_ = TRUE;
#line 753 "Thumbnail.c"
	} else {
		GeeCollection* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
#line 82 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp5_ = tags;
#line 82 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp6_ = gee_collection_get_size (_tmp5_);
#line 82 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp7_ = _tmp6_;
#line 82 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp3_ = _tmp7_ == 0;
#line 766 "Thumbnail.c"
	}
#line 82 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (_tmp3_) {
#line 83 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		checkerboard_item_clear_tags (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem));
#line 772 "Thumbnail.c"
	} else {
		GeeCollection* _tmp8_;
#line 85 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp8_ = tags;
#line 85 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		checkerboard_item_set_tags (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem), _tmp8_, PANGO_ALIGN_LEFT);
#line 779 "Thumbnail.c"
	}
#line 80 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_g_object_unref0 (tags);
#line 783 "Thumbnail.c"
}


static void thumbnail_on_tag_contents_altered (Thumbnail* self, ContainerSource* container, GeeCollection* added, gboolean relinking, GeeCollection* removed, gboolean unlinking) {
	gboolean _tmp0_;
	gboolean _tmp1_ = FALSE;
	GeeCollection* _tmp2_;
	gboolean tag_added = FALSE;
	gboolean _tmp6_ = FALSE;
	GeeCollection* _tmp7_;
	gboolean tag_removed = FALSE;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp12_;
#line 88 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_return_if_fail (IS_THUMBNAIL (self));
#line 88 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_return_if_fail (IS_CONTAINER_SOURCE (container));
#line 88 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_return_if_fail ((added == NULL) || GEE_IS_COLLECTION (added));
#line 88 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_return_if_fail ((removed == NULL) || GEE_IS_COLLECTION (removed));
#line 90 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp0_ = self->priv->exposure;
#line 90 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (!_tmp0_) {
#line 91 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		return;
#line 811 "Thumbnail.c"
	}
#line 93 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp2_ = added;
#line 93 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (_tmp2_ != NULL) {
#line 817 "Thumbnail.c"
		GeeCollection* _tmp3_;
		MediaSource* _tmp4_;
		gboolean _tmp5_;
#line 93 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp3_ = added;
#line 93 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp4_ = self->priv->media;
#line 93 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp5_ = gee_collection_contains (_tmp3_, G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_DATA_SOURCE, DataSource));
#line 93 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp1_ = _tmp5_;
#line 829 "Thumbnail.c"
	} else {
#line 93 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp1_ = FALSE;
#line 833 "Thumbnail.c"
	}
#line 93 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	tag_added = _tmp1_;
#line 94 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp7_ = removed;
#line 94 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (_tmp7_ != NULL) {
#line 841 "Thumbnail.c"
		GeeCollection* _tmp8_;
		MediaSource* _tmp9_;
		gboolean _tmp10_;
#line 94 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp8_ = removed;
#line 94 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp9_ = self->priv->media;
#line 94 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp10_ = gee_collection_contains (_tmp8_, G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, TYPE_DATA_SOURCE, DataSource));
#line 94 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp6_ = _tmp10_;
#line 853 "Thumbnail.c"
	} else {
#line 94 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp6_ = FALSE;
#line 857 "Thumbnail.c"
	}
#line 94 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	tag_removed = _tmp6_;
#line 97 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp12_ = tag_added;
#line 97 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (_tmp12_) {
#line 97 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp11_ = TRUE;
#line 867 "Thumbnail.c"
	} else {
		gboolean _tmp13_;
#line 97 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp13_ = tag_removed;
#line 97 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp11_ = _tmp13_;
#line 874 "Thumbnail.c"
	}
#line 97 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (_tmp11_) {
#line 98 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		thumbnail_update_tags (self, FALSE);
#line 880 "Thumbnail.c"
	}
}


static void thumbnail_on_tags_altered (Thumbnail* self, GeeMap* altered) {
	gboolean _tmp0_;
#line 101 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_return_if_fail (IS_THUMBNAIL (self));
#line 101 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_return_if_fail (GEE_IS_MAP (altered));
#line 102 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp0_ = self->priv->exposure;
#line 102 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (!_tmp0_) {
#line 103 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		return;
#line 897 "Thumbnail.c"
	}
	{
		GeeIterator* _object_it = NULL;
		GeeMap* _tmp1_;
		GeeSet* _tmp2_;
		GeeSet* _tmp3_;
		GeeSet* _tmp4_;
		GeeIterator* _tmp5_;
		GeeIterator* _tmp6_;
#line 105 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp1_ = altered;
#line 105 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp2_ = gee_map_get_keys (_tmp1_);
#line 105 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp3_ = _tmp2_;
#line 105 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp4_ = _tmp3_;
#line 105 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp5_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_ITERABLE, GeeIterable));
#line 105 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp6_ = _tmp5_;
#line 105 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_g_object_unref0 (_tmp4_);
#line 105 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_object_it = _tmp6_;
#line 105 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		while (TRUE) {
#line 925 "Thumbnail.c"
			GeeIterator* _tmp7_;
			gboolean _tmp8_;
			DataObject* object = NULL;
			GeeIterator* _tmp9_;
			gpointer _tmp10_;
			Tag* tag = NULL;
			DataObject* _tmp11_;
			Tag* _tmp12_;
			Tag* _tmp13_;
			MediaSource* _tmp14_;
			gboolean _tmp15_;
#line 105 "/home/jens/Source/shotwell/src/Thumbnail.vala"
			_tmp7_ = _object_it;
#line 105 "/home/jens/Source/shotwell/src/Thumbnail.vala"
			_tmp8_ = gee_iterator_next (_tmp7_);
#line 105 "/home/jens/Source/shotwell/src/Thumbnail.vala"
			if (!_tmp8_) {
#line 105 "/home/jens/Source/shotwell/src/Thumbnail.vala"
				break;
#line 945 "Thumbnail.c"
			}
#line 105 "/home/jens/Source/shotwell/src/Thumbnail.vala"
			_tmp9_ = _object_it;
#line 105 "/home/jens/Source/shotwell/src/Thumbnail.vala"
			_tmp10_ = gee_iterator_get (_tmp9_);
#line 105 "/home/jens/Source/shotwell/src/Thumbnail.vala"
			object = (DataObject*) _tmp10_;
#line 106 "/home/jens/Source/shotwell/src/Thumbnail.vala"
			_tmp11_ = object;
#line 106 "/home/jens/Source/shotwell/src/Thumbnail.vala"
			_tmp12_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, TYPE_TAG, Tag));
#line 106 "/home/jens/Source/shotwell/src/Thumbnail.vala"
			tag = _tmp12_;
#line 108 "/home/jens/Source/shotwell/src/Thumbnail.vala"
			_tmp13_ = tag;
#line 108 "/home/jens/Source/shotwell/src/Thumbnail.vala"
			_tmp14_ = self->priv->media;
#line 108 "/home/jens/Source/shotwell/src/Thumbnail.vala"
			_tmp15_ = tag_contains (_tmp13_, _tmp14_);
#line 108 "/home/jens/Source/shotwell/src/Thumbnail.vala"
			if (_tmp15_) {
#line 109 "/home/jens/Source/shotwell/src/Thumbnail.vala"
				thumbnail_update_tags (self, FALSE);
#line 111 "/home/jens/Source/shotwell/src/Thumbnail.vala"
				_g_object_unref0 (tag);
#line 111 "/home/jens/Source/shotwell/src/Thumbnail.vala"
				_g_object_unref0 (object);
#line 111 "/home/jens/Source/shotwell/src/Thumbnail.vala"
				break;
#line 975 "Thumbnail.c"
			}
#line 105 "/home/jens/Source/shotwell/src/Thumbnail.vala"
			_g_object_unref0 (tag);
#line 105 "/home/jens/Source/shotwell/src/Thumbnail.vala"
			_g_object_unref0 (object);
#line 981 "Thumbnail.c"
		}
#line 105 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_g_object_unref0 (_object_it);
#line 985 "Thumbnail.c"
	}
}


static void thumbnail_update_title (Thumbnail* self, gboolean init) {
	gchar* title = NULL;
	MediaSource* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gboolean _tmp3_;
#line 116 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_return_if_fail (IS_THUMBNAIL (self));
#line 117 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp0_ = self->priv->media;
#line 117 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp1_ = data_object_get_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_DATA_OBJECT, DataObject));
#line 117 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	title = _tmp1_;
#line 118 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp2_ = title;
#line 118 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp3_ = is_string_empty (_tmp2_);
#line 118 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (_tmp3_) {
#line 119 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		checkerboard_item_clear_title (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem));
#line 1012 "Thumbnail.c"
	} else {
		gboolean _tmp4_;
#line 120 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp4_ = init;
#line 120 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		if (!_tmp4_) {
#line 1019 "Thumbnail.c"
			const gchar* _tmp5_;
#line 121 "/home/jens/Source/shotwell/src/Thumbnail.vala"
			_tmp5_ = title;
#line 121 "/home/jens/Source/shotwell/src/Thumbnail.vala"
			media_source_item_set_title (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE_ITEM, MediaSourceItem), _tmp5_, FALSE, PANGO_ALIGN_LEFT);
#line 1025 "Thumbnail.c"
		}
	}
#line 116 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_g_free0 (title);
#line 1030 "Thumbnail.c"
}


static void thumbnail_update_comment (Thumbnail* self, gboolean init) {
	gchar* comment = NULL;
	MediaSource* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gboolean _tmp3_;
#line 124 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_return_if_fail (IS_THUMBNAIL (self));
#line 125 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp0_ = self->priv->media;
#line 125 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp1_ = media_source_get_comment (_tmp0_);
#line 125 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	comment = _tmp1_;
#line 126 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp2_ = comment;
#line 126 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp3_ = is_string_empty (_tmp2_);
#line 126 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (_tmp3_) {
#line 127 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		checkerboard_item_clear_comment (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem));
#line 1056 "Thumbnail.c"
	} else {
		gboolean _tmp4_;
#line 128 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp4_ = init;
#line 128 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		if (!_tmp4_) {
#line 1063 "Thumbnail.c"
			const gchar* _tmp5_;
#line 129 "/home/jens/Source/shotwell/src/Thumbnail.vala"
			_tmp5_ = comment;
#line 129 "/home/jens/Source/shotwell/src/Thumbnail.vala"
			checkerboard_item_set_comment (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem), _tmp5_, FALSE, PANGO_ALIGN_LEFT);
#line 1069 "Thumbnail.c"
		}
	}
#line 124 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_g_free0 (comment);
#line 1074 "Thumbnail.c"
}


static void thumbnail_real_notify_altered (DataObject* base, Alteration* alteration) {
	Thumbnail * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_;
	Alteration* _tmp8_;
#line 132 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_THUMBNAIL, Thumbnail);
#line 132 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_return_if_fail (IS_ALTERATION (alteration));
#line 133 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp1_ = self->priv->exposure;
#line 133 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (_tmp1_) {
#line 1093 "Thumbnail.c"
		Alteration* _tmp2_;
		gboolean _tmp3_;
#line 133 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp2_ = alteration;
#line 133 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp3_ = alteration_has_detail (_tmp2_, "metadata", "name");
#line 133 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp0_ = _tmp3_;
#line 1102 "Thumbnail.c"
	} else {
#line 133 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp0_ = FALSE;
#line 1106 "Thumbnail.c"
	}
#line 133 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (_tmp0_) {
#line 134 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		thumbnail_update_title (self, FALSE);
#line 1112 "Thumbnail.c"
	}
#line 135 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp5_ = self->priv->exposure;
#line 135 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (_tmp5_) {
#line 1118 "Thumbnail.c"
		Alteration* _tmp6_;
		gboolean _tmp7_;
#line 135 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp6_ = alteration;
#line 135 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp7_ = alteration_has_detail (_tmp6_, "metadata", "comment");
#line 135 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp4_ = _tmp7_;
#line 1127 "Thumbnail.c"
	} else {
#line 135 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp4_ = FALSE;
#line 1131 "Thumbnail.c"
	}
#line 135 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (_tmp4_) {
#line 136 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		thumbnail_update_comment (self, FALSE);
#line 1137 "Thumbnail.c"
	}
#line 138 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp8_ = alteration;
#line 138 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	DATA_OBJECT_CLASS (thumbnail_parent_class)->notify_altered (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE_ITEM, MediaSourceItem), TYPE_DATA_OBJECT, DataObject), _tmp8_);
#line 1143 "Thumbnail.c"
}


MediaSource* thumbnail_get_media_source (Thumbnail* self) {
	MediaSource* result = NULL;
	MediaSource* _tmp0_;
	MediaSource* _tmp1_;
#line 141 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_return_val_if_fail (IS_THUMBNAIL (self), NULL);
#line 142 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp0_ = self->priv->media;
#line 142 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 142 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	result = _tmp1_;
#line 142 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	return result;
#line 1161 "Thumbnail.c"
}


gint64 thumbnail_photo_id_ascending_comparator (void* a, void* b) {
	gint64 result = 0LL;
	void* _tmp0_;
	MediaSource* _tmp1_;
	gint64 _tmp2_;
	void* _tmp3_;
	MediaSource* _tmp4_;
	gint64 _tmp5_;
#line 150 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp0_ = a;
#line 150 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp1_ = G_TYPE_CHECK_INSTANCE_CAST ((Thumbnail*) _tmp0_, TYPE_THUMBNAIL, Thumbnail)->priv->media;
#line 150 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp2_ = data_source_get_instance_id (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_DATA_SOURCE, DataSource));
#line 150 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp3_ = b;
#line 150 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp4_ = G_TYPE_CHECK_INSTANCE_CAST ((Thumbnail*) _tmp3_, TYPE_THUMBNAIL, Thumbnail)->priv->media;
#line 150 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp5_ = data_source_get_instance_id (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_DATA_SOURCE, DataSource));
#line 150 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	result = _tmp2_ - _tmp5_;
#line 150 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	return result;
#line 1189 "Thumbnail.c"
}


gint64 thumbnail_photo_id_descending_comparator (void* a, void* b) {
	gint64 result = 0LL;
	void* _tmp0_;
	void* _tmp1_;
	gint64 _tmp2_;
#line 154 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp0_ = b;
#line 154 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp1_ = a;
#line 154 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp2_ = thumbnail_photo_id_ascending_comparator (_tmp0_, _tmp1_);
#line 154 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	result = _tmp2_;
#line 154 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	return result;
#line 1208 "Thumbnail.c"
}


gint64 thumbnail_title_ascending_comparator (void* a, void* b) {
	gint64 result = 0LL;
	gint64 _result_ = 0LL;
	GCompareFunc _tmp0_;
	void* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	void* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gint _tmp7_;
	gint64 _tmp8_;
	gint64 _tmp9_ = 0LL;
	gint64 _tmp10_;
#line 158 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp0_ = g_strcmp0;
#line 158 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp1_ = a;
#line 158 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp2_ = media_source_item_get_natural_collation_key (G_TYPE_CHECK_INSTANCE_CAST ((Thumbnail*) _tmp1_, TYPE_MEDIA_SOURCE_ITEM, MediaSourceItem));
#line 158 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp3_ = _tmp2_;
#line 158 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp4_ = b;
#line 158 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp5_ = media_source_item_get_natural_collation_key (G_TYPE_CHECK_INSTANCE_CAST ((Thumbnail*) _tmp4_, TYPE_MEDIA_SOURCE_ITEM, MediaSourceItem));
#line 158 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp6_ = _tmp5_;
#line 158 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp7_ = _tmp0_ (_tmp3_, _tmp6_);
#line 158 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp8_ = (gint64) _tmp7_;
#line 158 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_g_free0 (_tmp6_);
#line 158 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_g_free0 (_tmp3_);
#line 158 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_result_ = _tmp8_;
#line 159 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp10_ = _result_;
#line 159 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (_tmp10_ != ((gint64) 0)) {
#line 1254 "Thumbnail.c"
		gint64 _tmp11_;
#line 159 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp11_ = _result_;
#line 159 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp9_ = _tmp11_;
#line 1260 "Thumbnail.c"
	} else {
		void* _tmp12_;
		void* _tmp13_;
		gint64 _tmp14_;
#line 159 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp12_ = a;
#line 159 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp13_ = b;
#line 159 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp14_ = thumbnail_photo_id_ascending_comparator (_tmp12_, _tmp13_);
#line 159 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp9_ = _tmp14_;
#line 1273 "Thumbnail.c"
	}
#line 159 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	result = _tmp9_;
#line 159 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	return result;
#line 1279 "Thumbnail.c"
}


gint64 thumbnail_title_descending_comparator (void* a, void* b) {
	gint64 result = 0LL;
	gint64 _result_ = 0LL;
	void* _tmp0_;
	void* _tmp1_;
	gint64 _tmp2_;
	gint64 _tmp3_ = 0LL;
	gint64 _tmp4_;
#line 163 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp0_ = b;
#line 163 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp1_ = a;
#line 163 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp2_ = thumbnail_title_ascending_comparator (_tmp0_, _tmp1_);
#line 163 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_result_ = _tmp2_;
#line 165 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp4_ = _result_;
#line 165 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (_tmp4_ != ((gint64) 0)) {
#line 1303 "Thumbnail.c"
		gint64 _tmp5_;
#line 165 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp5_ = _result_;
#line 165 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp3_ = _tmp5_;
#line 1309 "Thumbnail.c"
	} else {
		void* _tmp6_;
		void* _tmp7_;
		gint64 _tmp8_;
#line 165 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp6_ = a;
#line 165 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp7_ = b;
#line 165 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp8_ = thumbnail_photo_id_descending_comparator (_tmp6_, _tmp7_);
#line 165 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp3_ = _tmp8_;
#line 1322 "Thumbnail.c"
	}
#line 165 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	result = _tmp3_;
#line 165 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	return result;
#line 1328 "Thumbnail.c"
}


gboolean thumbnail_title_comparator_predicate (DataObject* object, Alteration* alteration) {
	gboolean result = FALSE;
	Alteration* _tmp0_;
	gboolean _tmp1_;
#line 168 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_return_val_if_fail (IS_DATA_OBJECT (object), FALSE);
#line 168 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_return_val_if_fail (IS_ALTERATION (alteration), FALSE);
#line 169 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp0_ = alteration;
#line 169 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp1_ = alteration_has_detail (_tmp0_, "metadata", "title");
#line 169 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	result = _tmp1_;
#line 169 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	return result;
#line 1348 "Thumbnail.c"
}


gint64 thumbnail_exposure_time_ascending_comparator (void* a, void* b) {
	gint64 result = 0LL;
	gint64 time_a = 0LL;
	void* _tmp0_;
	MediaSource* _tmp1_;
	time_t _tmp2_;
	gint64 time_b = 0LL;
	void* _tmp3_;
	MediaSource* _tmp4_;
	time_t _tmp5_;
	gint64 _result_ = 0LL;
	gint64 _tmp6_;
	gint64 _tmp7_;
	gint64 _tmp8_ = 0LL;
	gint64 _tmp9_;
#line 173 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp0_ = a;
#line 173 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp1_ = G_TYPE_CHECK_INSTANCE_CAST ((Thumbnail*) _tmp0_, TYPE_THUMBNAIL, Thumbnail)->priv->media;
#line 173 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp2_ = media_source_get_exposure_time (_tmp1_);
#line 173 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	time_a = (gint64) _tmp2_;
#line 174 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp3_ = b;
#line 174 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp4_ = G_TYPE_CHECK_INSTANCE_CAST ((Thumbnail*) _tmp3_, TYPE_THUMBNAIL, Thumbnail)->priv->media;
#line 174 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp5_ = media_source_get_exposure_time (_tmp4_);
#line 174 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	time_b = (gint64) _tmp5_;
#line 175 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp6_ = time_a;
#line 175 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp7_ = time_b;
#line 175 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_result_ = _tmp6_ - _tmp7_;
#line 177 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp9_ = _result_;
#line 177 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (_tmp9_ != ((gint64) 0)) {
#line 1393 "Thumbnail.c"
		gint64 _tmp10_;
#line 177 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp10_ = _result_;
#line 177 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp8_ = _tmp10_;
#line 1399 "Thumbnail.c"
	} else {
		void* _tmp11_;
		void* _tmp12_;
		gint64 _tmp13_;
#line 177 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp11_ = a;
#line 177 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp12_ = b;
#line 177 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp13_ = thumbnail_filename_ascending_comparator (_tmp11_, _tmp12_);
#line 177 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp8_ = _tmp13_;
#line 1412 "Thumbnail.c"
	}
#line 177 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	result = _tmp8_;
#line 177 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	return result;
#line 1418 "Thumbnail.c"
}


gint64 thumbnail_exposure_time_desending_comparator (void* a, void* b) {
	gint64 result = 0LL;
	gint64 _result_ = 0LL;
	void* _tmp0_;
	void* _tmp1_;
	gint64 _tmp2_;
	gint64 _tmp3_ = 0LL;
	gint64 _tmp4_;
#line 181 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp0_ = b;
#line 181 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp1_ = a;
#line 181 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp2_ = thumbnail_exposure_time_ascending_comparator (_tmp0_, _tmp1_);
#line 181 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_result_ = _tmp2_;
#line 183 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp4_ = _result_;
#line 183 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (_tmp4_ != ((gint64) 0)) {
#line 1442 "Thumbnail.c"
		gint64 _tmp5_;
#line 183 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp5_ = _result_;
#line 183 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp3_ = _tmp5_;
#line 1448 "Thumbnail.c"
	} else {
		void* _tmp6_;
		void* _tmp7_;
		gint64 _tmp8_;
#line 183 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp6_ = a;
#line 183 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp7_ = b;
#line 183 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp8_ = thumbnail_filename_descending_comparator (_tmp6_, _tmp7_);
#line 183 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp3_ = _tmp8_;
#line 1461 "Thumbnail.c"
	}
#line 183 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	result = _tmp3_;
#line 183 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	return result;
#line 1467 "Thumbnail.c"
}


gboolean thumbnail_exposure_time_comparator_predicate (DataObject* object, Alteration* alteration) {
	gboolean result = FALSE;
	Alteration* _tmp0_;
	gboolean _tmp1_;
#line 186 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_return_val_if_fail (IS_DATA_OBJECT (object), FALSE);
#line 186 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_return_val_if_fail (IS_ALTERATION (alteration), FALSE);
#line 187 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp0_ = alteration;
#line 187 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp1_ = alteration_has_detail (_tmp0_, "metadata", "exposure-time");
#line 187 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	result = _tmp1_;
#line 187 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	return result;
#line 1487 "Thumbnail.c"
}


gboolean thumbnail_filename_comparator_predicate (DataObject* object, Alteration* alteration) {
	gboolean result = FALSE;
	Alteration* _tmp0_;
	gboolean _tmp1_;
#line 190 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_return_val_if_fail (IS_DATA_OBJECT (object), FALSE);
#line 190 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_return_val_if_fail (IS_ALTERATION (alteration), FALSE);
#line 191 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp0_ = alteration;
#line 191 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp1_ = alteration_has_detail (_tmp0_, "metadata", "filename");
#line 191 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	result = _tmp1_;
#line 191 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	return result;
#line 1507 "Thumbnail.c"
}


gint64 thumbnail_filename_ascending_comparator (void* a, void* b) {
	gint64 result = 0LL;
	gchar* path_a = NULL;
	void* _tmp0_;
	MediaSource* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* path_b = NULL;
	void* _tmp8_;
	MediaSource* _tmp9_;
	GFile* _tmp10_;
	GFile* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gint64 _result_ = 0LL;
	GCompareFunc _tmp16_;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	const gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gint _tmp23_;
	gint64 _tmp24_;
	gint64 _tmp25_ = 0LL;
	gint64 _tmp26_;
#line 195 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp0_ = a;
#line 195 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp1_ = G_TYPE_CHECK_INSTANCE_CAST ((Thumbnail*) _tmp0_, TYPE_THUMBNAIL, Thumbnail)->priv->media;
#line 195 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp2_ = media_source_get_file (_tmp1_);
#line 195 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp3_ = _tmp2_;
#line 195 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp4_ = g_file_get_basename (_tmp3_);
#line 195 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp5_ = _tmp4_;
#line 195 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp6_ = g_utf8_strdown (_tmp5_, (gssize) -1);
#line 195 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp7_ = _tmp6_;
#line 195 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_g_free0 (_tmp5_);
#line 195 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_g_object_unref0 (_tmp3_);
#line 195 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	path_a = _tmp7_;
#line 196 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp8_ = b;
#line 196 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp9_ = G_TYPE_CHECK_INSTANCE_CAST ((Thumbnail*) _tmp8_, TYPE_THUMBNAIL, Thumbnail)->priv->media;
#line 196 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp10_ = media_source_get_file (_tmp9_);
#line 196 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp11_ = _tmp10_;
#line 196 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp12_ = g_file_get_basename (_tmp11_);
#line 196 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp13_ = _tmp12_;
#line 196 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp14_ = g_utf8_strdown (_tmp13_, (gssize) -1);
#line 196 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp15_ = _tmp14_;
#line 196 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_g_free0 (_tmp13_);
#line 196 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_g_object_unref0 (_tmp11_);
#line 196 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	path_b = _tmp15_;
#line 198 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp16_ = g_strcmp0;
#line 198 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp17_ = path_a;
#line 198 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp18_ = g_utf8_collate_key_for_filename (_tmp17_, (gssize) -1);
#line 198 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp19_ = _tmp18_;
#line 198 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp20_ = path_b;
#line 198 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp21_ = g_utf8_collate_key_for_filename (_tmp20_, (gssize) -1);
#line 198 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp22_ = _tmp21_;
#line 198 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp23_ = _tmp16_ (_tmp19_, _tmp22_);
#line 198 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp24_ = (gint64) _tmp23_;
#line 198 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_g_free0 (_tmp22_);
#line 198 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_g_free0 (_tmp19_);
#line 198 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_result_ = _tmp24_;
#line 199 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp26_ = _result_;
#line 199 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (_tmp26_ != ((gint64) 0)) {
#line 1615 "Thumbnail.c"
		gint64 _tmp27_;
#line 199 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp27_ = _result_;
#line 199 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp25_ = _tmp27_;
#line 1621 "Thumbnail.c"
	} else {
		void* _tmp28_;
		void* _tmp29_;
		gint64 _tmp30_;
#line 199 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp28_ = a;
#line 199 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp29_ = b;
#line 199 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp30_ = thumbnail_photo_id_ascending_comparator (_tmp28_, _tmp29_);
#line 199 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp25_ = _tmp30_;
#line 1634 "Thumbnail.c"
	}
#line 199 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	result = _tmp25_;
#line 199 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_g_free0 (path_b);
#line 199 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_g_free0 (path_a);
#line 199 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	return result;
#line 1644 "Thumbnail.c"
}


gint64 thumbnail_filename_descending_comparator (void* a, void* b) {
	gint64 result = 0LL;
	gint64 _result_ = 0LL;
	void* _tmp0_;
	void* _tmp1_;
	gint64 _tmp2_;
	gint64 _tmp3_ = 0LL;
	gint64 _tmp4_;
#line 203 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp0_ = b;
#line 203 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp1_ = a;
#line 203 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp2_ = thumbnail_filename_ascending_comparator (_tmp0_, _tmp1_);
#line 203 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_result_ = _tmp2_;
#line 205 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp4_ = _result_;
#line 205 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (_tmp4_ != ((gint64) 0)) {
#line 1668 "Thumbnail.c"
		gint64 _tmp5_;
#line 205 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp5_ = _result_;
#line 205 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp3_ = _tmp5_;
#line 1674 "Thumbnail.c"
	} else {
		void* _tmp6_;
		void* _tmp7_;
		gint64 _tmp8_;
#line 205 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp6_ = a;
#line 205 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp7_ = b;
#line 205 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp8_ = thumbnail_photo_id_descending_comparator (_tmp6_, _tmp7_);
#line 205 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp3_ = _tmp8_;
#line 1687 "Thumbnail.c"
	}
#line 205 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	result = _tmp3_;
#line 205 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	return result;
#line 1693 "Thumbnail.c"
}


gint64 thumbnail_rating_ascending_comparator (void* a, void* b) {
	gint64 result = 0LL;
	gint64 _result_ = 0LL;
	void* _tmp0_;
	MediaSource* _tmp1_;
	Rating _tmp2_;
	void* _tmp3_;
	MediaSource* _tmp4_;
	Rating _tmp5_;
	gint64 _tmp6_ = 0LL;
	gint64 _tmp7_;
#line 209 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp0_ = a;
#line 209 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp1_ = G_TYPE_CHECK_INSTANCE_CAST ((Thumbnail*) _tmp0_, TYPE_THUMBNAIL, Thumbnail)->priv->media;
#line 209 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp2_ = media_source_get_rating (_tmp1_);
#line 209 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp3_ = b;
#line 209 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp4_ = G_TYPE_CHECK_INSTANCE_CAST ((Thumbnail*) _tmp3_, TYPE_THUMBNAIL, Thumbnail)->priv->media;
#line 209 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp5_ = media_source_get_rating (_tmp4_);
#line 209 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_result_ = (gint64) (_tmp2_ - _tmp5_);
#line 211 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp7_ = _result_;
#line 211 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (_tmp7_ != ((gint64) 0)) {
#line 1726 "Thumbnail.c"
		gint64 _tmp8_;
#line 211 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp8_ = _result_;
#line 211 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp6_ = _tmp8_;
#line 1732 "Thumbnail.c"
	} else {
		void* _tmp9_;
		void* _tmp10_;
		gint64 _tmp11_;
#line 211 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp9_ = a;
#line 211 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp10_ = b;
#line 211 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp11_ = thumbnail_photo_id_ascending_comparator (_tmp9_, _tmp10_);
#line 211 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp6_ = _tmp11_;
#line 1745 "Thumbnail.c"
	}
#line 211 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	result = _tmp6_;
#line 211 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	return result;
#line 1751 "Thumbnail.c"
}


gint64 thumbnail_rating_descending_comparator (void* a, void* b) {
	gint64 result = 0LL;
	gint64 _result_ = 0LL;
	void* _tmp0_;
	void* _tmp1_;
	gint64 _tmp2_;
	gint64 _tmp3_ = 0LL;
	gint64 _tmp4_;
#line 215 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp0_ = b;
#line 215 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp1_ = a;
#line 215 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp2_ = thumbnail_rating_ascending_comparator (_tmp0_, _tmp1_);
#line 215 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_result_ = _tmp2_;
#line 217 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp4_ = _result_;
#line 217 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (_tmp4_ != ((gint64) 0)) {
#line 1775 "Thumbnail.c"
		gint64 _tmp5_;
#line 217 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp5_ = _result_;
#line 217 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp3_ = _tmp5_;
#line 1781 "Thumbnail.c"
	} else {
		void* _tmp6_;
		void* _tmp7_;
		gint64 _tmp8_;
#line 217 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp6_ = a;
#line 217 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp7_ = b;
#line 217 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp8_ = thumbnail_photo_id_descending_comparator (_tmp6_, _tmp7_);
#line 217 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp3_ = _tmp8_;
#line 1794 "Thumbnail.c"
	}
#line 217 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	result = _tmp3_;
#line 217 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	return result;
#line 1800 "Thumbnail.c"
}


gboolean thumbnail_rating_comparator_predicate (DataObject* object, Alteration* alteration) {
	gboolean result = FALSE;
	Alteration* _tmp0_;
	gboolean _tmp1_;
#line 220 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_return_val_if_fail (IS_DATA_OBJECT (object), FALSE);
#line 220 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_return_val_if_fail (IS_ALTERATION (alteration), FALSE);
#line 221 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp0_ = alteration;
#line 221 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp1_ = alteration_has_detail (_tmp0_, "metadata", "rating");
#line 221 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	result = _tmp1_;
#line 221 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	return result;
#line 1820 "Thumbnail.c"
}


static void thumbnail_real_thumbnail_altered (ThumbnailView* base) {
	Thumbnail * self;
	MediaSource* _tmp0_;
	Dimensions _tmp1_ = {0};
	gint _tmp2_;
	Dimensions _tmp3_ = {0};
	gboolean _tmp4_;
#line 224 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_THUMBNAIL, Thumbnail);
#line 225 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp0_ = self->priv->media;
#line 225 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	media_source_get_dimensions (_tmp0_, PHOTO_EXCEPTION_NONE, &_tmp1_);
#line 225 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	self->priv->original_dim = _tmp1_;
#line 226 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp2_ = self->priv->scale;
#line 226 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	dimensions_get_scaled (&self->priv->original_dim, _tmp2_, TRUE, &_tmp3_);
#line 226 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	self->priv->dim = _tmp3_;
#line 228 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp4_ = self->priv->exposure;
#line 228 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (_tmp4_) {
#line 229 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		thumbnail_delayed_high_quality_fetch (self);
#line 1851 "Thumbnail.c"
	} else {
#line 231 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		thumbnail_paint_empty (self);
#line 1855 "Thumbnail.c"
	}
#line 233 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	THUMBNAIL_VIEW_CLASS (thumbnail_parent_class)->thumbnail_altered (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE_ITEM, MediaSourceItem), TYPE_THUMBNAIL_VIEW, ThumbnailView));
#line 1859 "Thumbnail.c"
}


static void thumbnail_real_notify_collection_property_set (DataObject* base, const gchar* name, GValue* old, GValue* val) {
	Thumbnail * self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GQuark _tmp3_ = 0U;
	const gchar* _tmp5_;
	GValue* _tmp6_;
	GValue _tmp7_;
#line 236 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_THUMBNAIL, Thumbnail);
#line 236 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_return_if_fail (name != NULL);
#line 236 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_return_if_fail (val != NULL);
#line 237 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp0_ = name;
#line 237 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp1_ = _tmp0_;
#line 237 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
#line 237 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (_tmp3_ == g_quark_from_string (THUMBNAIL_PROP_SIZE)) {
#line 237 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		switch (0) {
#line 1887 "Thumbnail.c"
			default:
			{
				GValue _tmp4_;
#line 239 "/home/jens/Source/shotwell/src/Thumbnail.vala"
				_tmp4_ = *val;
#line 239 "/home/jens/Source/shotwell/src/Thumbnail.vala"
				thumbnail_resize (self, g_value_get_int (&_tmp4_));
#line 240 "/home/jens/Source/shotwell/src/Thumbnail.vala"
				break;
#line 1897 "Thumbnail.c"
			}
		}
	} else if (_tmp3_ == g_quark_from_string (THUMBNAIL_PROP_SHOW_RATINGS)) {
#line 237 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		switch (0) {
#line 1903 "Thumbnail.c"
			default:
			{
#line 243 "/home/jens/Source/shotwell/src/Thumbnail.vala"
				data_view_notify_view_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_VIEW, DataView));
#line 244 "/home/jens/Source/shotwell/src/Thumbnail.vala"
				break;
#line 1910 "Thumbnail.c"
			}
		}
	}
#line 247 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp5_ = name;
#line 247 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp6_ = old;
#line 247 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp7_ = *val;
#line 247 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	DATA_OBJECT_CLASS (thumbnail_parent_class)->notify_collection_property_set (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE_ITEM, MediaSourceItem), TYPE_DATA_OBJECT, DataObject), _tmp5_, _tmp6_, &_tmp7_);
#line 1922 "Thumbnail.c"
}


static void thumbnail_resize (Thumbnail* self, gint new_scale) {
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	Dimensions _tmp10_ = {0};
	gboolean _tmp11_;
#line 250 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_return_if_fail (IS_THUMBNAIL (self));
#line 251 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp0_ = new_scale;
#line 251 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp1_ = thumbnail_get_MIN_SCALE ();
#line 251 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp2_ = _tmp1_;
#line 251 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_vala_assert (_tmp0_ >= _tmp2_, "new_scale >= MIN_SCALE");
#line 252 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp3_ = new_scale;
#line 252 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp4_ = thumbnail_get_MAX_SCALE ();
#line 252 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp5_ = _tmp4_;
#line 252 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_vala_assert (_tmp3_ <= _tmp5_, "new_scale <= MAX_SCALE");
#line 254 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp6_ = self->priv->scale;
#line 254 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp7_ = new_scale;
#line 254 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (_tmp6_ == _tmp7_) {
#line 255 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		return;
#line 1965 "Thumbnail.c"
	}
#line 257 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp8_ = new_scale;
#line 257 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	self->priv->scale = _tmp8_;
#line 258 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp9_ = self->priv->scale;
#line 258 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	dimensions_get_scaled (&self->priv->original_dim, _tmp9_, TRUE, &_tmp10_);
#line 258 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	self->priv->dim = _tmp10_;
#line 260 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	thumbnail_cancel_async_fetch (self);
#line 262 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp11_ = self->priv->exposure;
#line 262 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (_tmp11_) {
#line 1983 "Thumbnail.c"
		GdkPixbuf* resizable = NULL;
		GdkPixbuf* _tmp12_;
		GdkPixbuf* _tmp17_;
#line 267 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		resizable = NULL;
#line 268 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp12_ = self->priv->unscaled_pixbuf;
#line 268 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		if (_tmp12_ != NULL) {
#line 1993 "Thumbnail.c"
			GdkPixbuf* _tmp13_;
			GdkPixbuf* _tmp14_;
#line 269 "/home/jens/Source/shotwell/src/Thumbnail.vala"
			_tmp13_ = self->priv->unscaled_pixbuf;
#line 269 "/home/jens/Source/shotwell/src/Thumbnail.vala"
			_tmp14_ = _g_object_ref0 (_tmp13_);
#line 269 "/home/jens/Source/shotwell/src/Thumbnail.vala"
			_g_object_unref0 (resizable);
#line 269 "/home/jens/Source/shotwell/src/Thumbnail.vala"
			resizable = _tmp14_;
#line 2004 "Thumbnail.c"
		} else {
			gboolean _tmp15_;
#line 270 "/home/jens/Source/shotwell/src/Thumbnail.vala"
			_tmp15_ = checkerboard_item_has_image (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem));
#line 270 "/home/jens/Source/shotwell/src/Thumbnail.vala"
			if (_tmp15_) {
#line 2011 "Thumbnail.c"
				GdkPixbuf* _tmp16_;
#line 271 "/home/jens/Source/shotwell/src/Thumbnail.vala"
				_tmp16_ = checkerboard_item_get_image (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem));
#line 271 "/home/jens/Source/shotwell/src/Thumbnail.vala"
				_g_object_unref0 (resizable);
#line 271 "/home/jens/Source/shotwell/src/Thumbnail.vala"
				resizable = _tmp16_;
#line 2019 "Thumbnail.c"
			}
		}
#line 273 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp17_ = resizable;
#line 273 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		if (_tmp17_ != NULL) {
#line 2026 "Thumbnail.c"
			GdkPixbuf* _tmp18_;
			Dimensions _tmp19_;
			GdkPixbuf* _tmp20_;
			GdkPixbuf* _tmp21_;
#line 274 "/home/jens/Source/shotwell/src/Thumbnail.vala"
			_tmp18_ = resizable;
#line 274 "/home/jens/Source/shotwell/src/Thumbnail.vala"
			_tmp19_ = self->priv->dim;
#line 274 "/home/jens/Source/shotwell/src/Thumbnail.vala"
			_tmp20_ = resize_pixbuf (_tmp18_, &_tmp19_, THUMBNAIL_LOW_QUALITY_INTERP);
#line 274 "/home/jens/Source/shotwell/src/Thumbnail.vala"
			_tmp21_ = _tmp20_;
#line 274 "/home/jens/Source/shotwell/src/Thumbnail.vala"
			checkerboard_item_set_image (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem), _tmp21_);
#line 274 "/home/jens/Source/shotwell/src/Thumbnail.vala"
			_g_object_unref0 (_tmp21_);
#line 2043 "Thumbnail.c"
		}
#line 276 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		thumbnail_delayed_high_quality_fetch (self);
#line 262 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_g_object_unref0 (resizable);
#line 2049 "Thumbnail.c"
	} else {
		Dimensions _tmp22_;
#line 278 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp22_ = self->priv->dim;
#line 278 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		checkerboard_item_clear_image (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem), &_tmp22_);
#line 2056 "Thumbnail.c"
	}
}


static void thumbnail_paint_empty (Thumbnail* self) {
	Dimensions _tmp0_;
#line 282 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_return_if_fail (IS_THUMBNAIL (self));
#line 283 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	thumbnail_cancel_async_fetch (self);
#line 284 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp0_ = self->priv->dim;
#line 284 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	checkerboard_item_clear_image (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem), &_tmp0_);
#line 285 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_g_object_unref0 (self->priv->unscaled_pixbuf);
#line 285 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	self->priv->unscaled_pixbuf = NULL;
#line 2075 "Thumbnail.c"
}


static void _thumbnail_on_low_quality_fetched_thumbnail_cache_async_fetch_callback (GdkPixbuf* pixbuf, GdkPixbuf* unscaled, Dimensions* dim, GdkInterpType interp, GError* err, gpointer self) {
#line 292 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	thumbnail_on_low_quality_fetched ((Thumbnail*) self, pixbuf, unscaled, dim, interp, err);
#line 2082 "Thumbnail.c"
}


static void thumbnail_schedule_low_quality_fetch (Thumbnail* self) {
	GCancellable* _tmp0_;
	MediaSource* _tmp1_;
	Dimensions _tmp2_;
	GCancellable* _tmp3_;
#line 288 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_return_if_fail (IS_THUMBNAIL (self));
#line 289 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	thumbnail_cancel_async_fetch (self);
#line 290 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp0_ = g_cancellable_new ();
#line 290 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_g_object_unref0 (self->priv->cancellable);
#line 290 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	self->priv->cancellable = _tmp0_;
#line 292 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp1_ = self->priv->media;
#line 292 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp2_ = self->priv->dim;
#line 292 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp3_ = self->priv->cancellable;
#line 292 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	thumbnail_cache_fetch_async_scaled (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_THUMBNAIL_SOURCE, ThumbnailSource), (gint) THUMBNAIL_CACHE_SIZE_SMALLEST, &_tmp2_, THUMBNAIL_LOW_QUALITY_INTERP, _thumbnail_on_low_quality_fetched_thumbnail_cache_async_fetch_callback, self, _tmp3_);
#line 2109 "Thumbnail.c"
}


static gboolean _thumbnail_on_schedule_high_quality_gsource_func (gpointer self) {
	gboolean result;
	result = thumbnail_on_schedule_high_quality ((Thumbnail*) self);
#line 303 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	return result;
#line 2118 "Thumbnail.c"
}


static void thumbnail_delayed_high_quality_fetch (Thumbnail* self) {
	gboolean _tmp0_;
#line 296 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_return_if_fail (IS_THUMBNAIL (self));
#line 297 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp0_ = self->priv->hq_scheduled;
#line 297 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (_tmp0_) {
#line 298 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		self->priv->hq_reschedule = TRUE;
#line 300 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		return;
#line 2134 "Thumbnail.c"
	}
#line 303 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) THUMBNAIL_HQ_IMPROVEMENT_MSEC, _thumbnail_on_schedule_high_quality_gsource_func, g_object_ref (self), g_object_unref);
#line 304 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	self->priv->hq_scheduled = TRUE;
#line 2140 "Thumbnail.c"
}


static void _thumbnail_on_high_quality_fetched_thumbnail_cache_async_fetch_callback (GdkPixbuf* pixbuf, GdkPixbuf* unscaled, Dimensions* dim, GdkInterpType interp, GError* err, gpointer self) {
#line 318 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	thumbnail_on_high_quality_fetched ((Thumbnail*) self, pixbuf, unscaled, dim, interp, err);
#line 2147 "Thumbnail.c"
}


static gboolean thumbnail_on_schedule_high_quality (Thumbnail* self) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	GCancellable* _tmp1_;
	gboolean _tmp2_;
#line 307 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_return_val_if_fail (IS_THUMBNAIL (self), FALSE);
#line 308 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp0_ = self->priv->hq_reschedule;
#line 308 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (_tmp0_) {
#line 309 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		self->priv->hq_reschedule = FALSE;
#line 311 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		result = TRUE;
#line 311 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		return result;
#line 2168 "Thumbnail.c"
	}
#line 314 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	thumbnail_cancel_async_fetch (self);
#line 315 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp1_ = g_cancellable_new ();
#line 315 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_g_object_unref0 (self->priv->cancellable);
#line 315 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	self->priv->cancellable = _tmp1_;
#line 317 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp2_ = self->priv->exposure;
#line 317 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (_tmp2_) {
#line 2182 "Thumbnail.c"
		MediaSource* _tmp3_;
		gint _tmp4_;
		Dimensions _tmp5_;
		GCancellable* _tmp6_;
#line 318 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp3_ = self->priv->media;
#line 318 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp4_ = self->priv->scale;
#line 318 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp5_ = self->priv->dim;
#line 318 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp6_ = self->priv->cancellable;
#line 318 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		thumbnail_cache_fetch_async_scaled (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TYPE_THUMBNAIL_SOURCE, ThumbnailSource), _tmp4_, &_tmp5_, THUMBNAIL_HIGH_QUALITY_INTERP, _thumbnail_on_high_quality_fetched_thumbnail_cache_async_fetch_callback, self, _tmp6_);
#line 2197 "Thumbnail.c"
	}
#line 322 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	self->priv->hq_scheduled = FALSE;
#line 324 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	result = FALSE;
#line 324 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	return result;
#line 2205 "Thumbnail.c"
}


static void thumbnail_cancel_async_fetch (Thumbnail* self) {
	GCancellable* _tmp0_;
#line 327 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_return_if_fail (IS_THUMBNAIL (self));
#line 329 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp0_ = self->priv->cancellable;
#line 329 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (_tmp0_ != NULL) {
#line 2217 "Thumbnail.c"
		GCancellable* _tmp1_;
#line 330 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp1_ = self->priv->cancellable;
#line 330 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		g_cancellable_cancel (_tmp1_);
#line 2223 "Thumbnail.c"
	}
}


static void thumbnail_on_low_quality_fetched (Thumbnail* self, GdkPixbuf* pixbuf, GdkPixbuf* unscaled, Dimensions* dim, GdkInterpType interp, GError* err) {
	GError* _tmp0_;
	GdkPixbuf* _tmp6_;
	GdkPixbuf* _tmp8_;
#line 333 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_return_if_fail (IS_THUMBNAIL (self));
#line 333 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_return_if_fail ((pixbuf == NULL) || GDK_IS_PIXBUF (pixbuf));
#line 333 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_return_if_fail ((unscaled == NULL) || GDK_IS_PIXBUF (unscaled));
#line 333 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_return_if_fail (dim != NULL);
#line 335 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp0_ = err;
#line 335 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (_tmp0_ != NULL) {
#line 2244 "Thumbnail.c"
		gchar* _tmp1_;
		gchar* _tmp2_;
		gint _tmp3_;
		GError* _tmp4_;
		const gchar* _tmp5_;
#line 336 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp1_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject));
#line 336 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp2_ = _tmp1_;
#line 336 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp3_ = self->priv->scale;
#line 336 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp4_ = err;
#line 336 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp5_ = _tmp4_->message;
#line 336 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		g_critical ("Thumbnail.vala:336: Unable to fetch low-quality thumbnail for %s (scal" \
"e: %d): %s", _tmp2_, _tmp3_, _tmp5_);
#line 336 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_g_free0 (_tmp2_);
#line 2264 "Thumbnail.c"
	}
#line 339 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp6_ = pixbuf;
#line 339 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (_tmp6_ != NULL) {
#line 2270 "Thumbnail.c"
		GdkPixbuf* _tmp7_;
#line 340 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp7_ = pixbuf;
#line 340 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		checkerboard_item_set_image (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem), _tmp7_);
#line 2276 "Thumbnail.c"
	}
#line 342 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp8_ = unscaled;
#line 342 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (_tmp8_ != NULL) {
#line 2282 "Thumbnail.c"
		GdkPixbuf* _tmp9_;
		GdkPixbuf* _tmp10_;
#line 343 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp9_ = unscaled;
#line 343 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp10_ = _g_object_ref0 (_tmp9_);
#line 343 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_g_object_unref0 (self->priv->unscaled_pixbuf);
#line 343 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		self->priv->unscaled_pixbuf = _tmp10_;
#line 2293 "Thumbnail.c"
	}
#line 345 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	thumbnail_delayed_high_quality_fetch (self);
#line 2297 "Thumbnail.c"
}


static void thumbnail_on_high_quality_fetched (Thumbnail* self, GdkPixbuf* pixbuf, GdkPixbuf* unscaled, Dimensions* dim, GdkInterpType interp, GError* err) {
	GError* _tmp0_;
	GdkPixbuf* _tmp6_;
	GdkPixbuf* _tmp8_;
#line 348 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_return_if_fail (IS_THUMBNAIL (self));
#line 348 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_return_if_fail ((pixbuf == NULL) || GDK_IS_PIXBUF (pixbuf));
#line 348 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_return_if_fail ((unscaled == NULL) || GDK_IS_PIXBUF (unscaled));
#line 348 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_return_if_fail (dim != NULL);
#line 350 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp0_ = err;
#line 350 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (_tmp0_ != NULL) {
#line 2317 "Thumbnail.c"
		gchar* _tmp1_;
		gchar* _tmp2_;
		gint _tmp3_;
		GError* _tmp4_;
		const gchar* _tmp5_;
#line 351 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp1_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject));
#line 351 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp2_ = _tmp1_;
#line 351 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp3_ = self->priv->scale;
#line 351 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp4_ = err;
#line 351 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp5_ = _tmp4_->message;
#line 351 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		g_critical ("Thumbnail.vala:351: Unable to fetch high-quality thumbnail for %s (sca" \
"le: %d): %s", _tmp2_, _tmp3_, _tmp5_);
#line 351 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_g_free0 (_tmp2_);
#line 2337 "Thumbnail.c"
	}
#line 354 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp6_ = pixbuf;
#line 354 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (_tmp6_ != NULL) {
#line 2343 "Thumbnail.c"
		GdkPixbuf* _tmp7_;
#line 355 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp7_ = pixbuf;
#line 355 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		checkerboard_item_set_image (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem), _tmp7_);
#line 2349 "Thumbnail.c"
	}
#line 357 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp8_ = unscaled;
#line 357 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (_tmp8_ != NULL) {
#line 2355 "Thumbnail.c"
		GdkPixbuf* _tmp9_;
		GdkPixbuf* _tmp10_;
#line 358 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp9_ = unscaled;
#line 358 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp10_ = _g_object_ref0 (_tmp9_);
#line 358 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_g_object_unref0 (self->priv->unscaled_pixbuf);
#line 358 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		self->priv->unscaled_pixbuf = _tmp10_;
#line 2366 "Thumbnail.c"
	}
}


static void thumbnail_real_exposed (CheckerboardItem* base) {
	Thumbnail * self;
	gboolean _tmp0_;
#line 361 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_THUMBNAIL, Thumbnail);
#line 362 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	self->priv->exposure = TRUE;
#line 364 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp0_ = checkerboard_item_has_image (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem));
#line 364 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (!_tmp0_) {
#line 365 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		thumbnail_schedule_low_quality_fetch (self);
#line 2384 "Thumbnail.c"
	}
#line 367 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	thumbnail_update_title (self, FALSE);
#line 368 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	thumbnail_update_comment (self, FALSE);
#line 369 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	thumbnail_update_tags (self, FALSE);
#line 371 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	CHECKERBOARD_ITEM_CLASS (thumbnail_parent_class)->exposed (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE_ITEM, MediaSourceItem), TYPE_CHECKERBOARD_ITEM, CheckerboardItem));
#line 2394 "Thumbnail.c"
}


static void thumbnail_real_unexposed (CheckerboardItem* base) {
	Thumbnail * self;
#line 374 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_THUMBNAIL, Thumbnail);
#line 375 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	self->priv->exposure = FALSE;
#line 377 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	thumbnail_paint_empty (self);
#line 379 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	CHECKERBOARD_ITEM_CLASS (thumbnail_parent_class)->unexposed (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE_ITEM, MediaSourceItem), TYPE_CHECKERBOARD_ITEM, CheckerboardItem));
#line 2408 "Thumbnail.c"
}


static GdkPixbuf* thumbnail_real_get_top_right_trinket (CheckerboardItem* base, gint scale) {
	Thumbnail * self;
	GdkPixbuf* result = NULL;
	Flaggable* flaggable = NULL;
	MediaSource* _tmp0_;
	Flaggable* _tmp1_;
	GdkPixbuf* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	Flaggable* _tmp4_;
#line 382 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_THUMBNAIL, Thumbnail);
#line 383 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp0_ = self->priv->media;
#line 383 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, TYPE_FLAGGABLE) ? ((Flaggable*) _tmp0_) : NULL);
#line 383 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	flaggable = _tmp1_;
#line 385 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp4_ = flaggable;
#line 385 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (_tmp4_ != NULL) {
#line 2433 "Thumbnail.c"
		Flaggable* _tmp5_;
		gboolean _tmp6_;
#line 385 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp5_ = flaggable;
#line 385 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp6_ = flaggable_is_flagged (_tmp5_);
#line 385 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp3_ = _tmp6_;
#line 2442 "Thumbnail.c"
	} else {
#line 385 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp3_ = FALSE;
#line 2446 "Thumbnail.c"
	}
#line 385 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (_tmp3_) {
#line 2450 "Thumbnail.c"
		GdkPixbuf* _tmp7_;
#line 386 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp7_ = resources_get_icon (RESOURCES_ICON_FLAGGED_TRINKET, RESOURCES_DEFAULT_ICON_SCALE);
#line 386 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_g_object_unref0 (_tmp2_);
#line 386 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp2_ = _tmp7_;
#line 2458 "Thumbnail.c"
	} else {
#line 386 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_g_object_unref0 (_tmp2_);
#line 386 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp2_ = NULL;
#line 2464 "Thumbnail.c"
	}
#line 385 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	result = _tmp2_;
#line 385 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_g_object_unref0 (flaggable);
#line 385 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	return result;
#line 2472 "Thumbnail.c"
}


static void _vala_GValue_free (GValue* self) {
#line 391 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_value_unset (self);
#line 391 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_free (self);
#line 2481 "Thumbnail.c"
}


static GdkPixbuf* thumbnail_real_get_bottom_left_trinket (CheckerboardItem* base, gint scale) {
	Thumbnail * self;
	GdkPixbuf* result = NULL;
	Rating rating = 0;
	MediaSource* _tmp0_;
	Rating _tmp1_;
	gboolean show_ratings = FALSE;
	GValue* _tmp2_ = NULL;
	GValue _tmp3_ = {0};
	gboolean _tmp4_;
	GdkPixbuf* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	Rating _tmp7_;
#line 389 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_THUMBNAIL, Thumbnail);
#line 390 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp0_ = self->priv->media;
#line 390 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp1_ = media_source_get_rating (_tmp0_);
#line 390 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	rating = _tmp1_;
#line 391 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp2_ = g_new0 (GValue, 1);
#line 391 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_value_init (_tmp2_, G_TYPE_BOOLEAN);
#line 391 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_value_set_boolean (_tmp2_, FALSE);
#line 391 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	data_object_get_collection_property (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), THUMBNAIL_PROP_SHOW_RATINGS, _tmp2_, &_tmp3_);
#line 391 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp4_ = g_value_get_boolean (&_tmp3_);
#line 391 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	__vala_GValue_free0 (_tmp2_);
#line 391 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	show_ratings = _tmp4_;
#line 393 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp7_ = rating;
#line 393 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (_tmp7_ != RATING_UNRATED) {
#line 2524 "Thumbnail.c"
		gboolean _tmp8_;
#line 393 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp8_ = show_ratings;
#line 393 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp6_ = _tmp8_;
#line 2530 "Thumbnail.c"
	} else {
#line 393 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp6_ = FALSE;
#line 2534 "Thumbnail.c"
	}
#line 393 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (_tmp6_) {
#line 2538 "Thumbnail.c"
		Rating _tmp9_;
		gint _tmp10_;
		GdkPixbuf* _tmp11_;
#line 394 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp9_ = rating;
#line 394 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp10_ = scale;
#line 394 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp11_ = resources_get_rating_trinket (_tmp9_, _tmp10_);
#line 394 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_g_object_unref0 (_tmp5_);
#line 394 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp5_ = _tmp11_;
#line 2552 "Thumbnail.c"
	} else {
#line 394 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_g_object_unref0 (_tmp5_);
#line 394 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp5_ = NULL;
#line 2558 "Thumbnail.c"
	}
#line 393 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	result = _tmp5_;
#line 393 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	return result;
#line 2564 "Thumbnail.c"
}


gint thumbnail_get_MIN_SCALE (void) {
	gint result;
#line 18 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	result = 72;
#line 18 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	return result;
#line 2574 "Thumbnail.c"
}


gint thumbnail_get_MAX_SCALE (void) {
	gint result;
	gint _tmp0_;
#line 23 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp0_ = thumbnail_cache_size_get_scale (THUMBNAIL_CACHE_SIZE_LARGEST);
#line 23 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	result = _tmp0_;
#line 23 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	return result;
#line 2587 "Thumbnail.c"
}


gint thumbnail_get_DEFAULT_SCALE (void) {
	gint result;
	gint _tmp0_;
#line 28 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp0_ = thumbnail_cache_size_get_scale (THUMBNAIL_CACHE_SIZE_MEDIUM);
#line 28 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	result = _tmp0_;
#line 28 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	return result;
#line 2600 "Thumbnail.c"
}


static void thumbnail_class_init (ThumbnailClass * klass) {
#line 7 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	thumbnail_parent_class = g_type_class_peek_parent (klass);
#line 7 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_type_class_add_private (klass, sizeof (ThumbnailPrivate));
#line 7 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	((DataObjectClass *) klass)->notify_altered = (void (*) (DataObject *, Alteration*)) thumbnail_real_notify_altered;
#line 7 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	((ThumbnailViewClass *) klass)->thumbnail_altered = (void (*) (ThumbnailView *)) thumbnail_real_thumbnail_altered;
#line 7 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	((DataObjectClass *) klass)->notify_collection_property_set = (void (*) (DataObject *, const gchar*, GValue*, GValue*)) thumbnail_real_notify_collection_property_set;
#line 7 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	((CheckerboardItemClass *) klass)->exposed = (void (*) (CheckerboardItem *)) thumbnail_real_exposed;
#line 7 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	((CheckerboardItemClass *) klass)->unexposed = (void (*) (CheckerboardItem *)) thumbnail_real_unexposed;
#line 7 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	((CheckerboardItemClass *) klass)->get_top_right_trinket = (GdkPixbuf* (*) (CheckerboardItem *, gint)) thumbnail_real_get_top_right_trinket;
#line 7 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	((CheckerboardItemClass *) klass)->get_bottom_left_trinket = (GdkPixbuf* (*) (CheckerboardItem *, gint)) thumbnail_real_get_bottom_left_trinket;
#line 7 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_thumbnail_get_property;
#line 7 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	G_OBJECT_CLASS (klass)->finalize = thumbnail_finalize;
#line 2627 "Thumbnail.c"
}


static void thumbnail_instance_init (Thumbnail * self) {
#line 7 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	self->priv = THUMBNAIL_GET_PRIVATE (self);
#line 41 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	self->priv->unscaled_pixbuf = NULL;
#line 42 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	self->priv->cancellable = NULL;
#line 43 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	self->priv->hq_scheduled = FALSE;
#line 44 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	self->priv->hq_reschedule = FALSE;
#line 47 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	self->priv->exposure = FALSE;
#line 2644 "Thumbnail.c"
}


static void thumbnail_finalize (GObject * obj) {
	Thumbnail * self;
	GCancellable* _tmp0_;
	TagSourceCollection* _tmp2_;
	guint _tmp3_;
	TagSourceCollection* _tmp4_;
	guint _tmp5_;
#line 7 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_THUMBNAIL, Thumbnail);
#line 73 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp0_ = self->priv->cancellable;
#line 73 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (_tmp0_ != NULL) {
#line 2661 "Thumbnail.c"
		GCancellable* _tmp1_;
#line 74 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp1_ = self->priv->cancellable;
#line 74 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		g_cancellable_cancel (_tmp1_);
#line 2667 "Thumbnail.c"
	}
#line 76 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp2_ = tag_global;
#line 76 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_signal_parse_name ("container-contents-altered", TYPE_CONTAINER_SOURCE_COLLECTION, &_tmp3_, NULL, FALSE);
#line 76 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollection), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _thumbnail_on_tag_contents_altered_container_source_collection_container_contents_altered, self);
#line 77 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp4_ = tag_global;
#line 77 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_signal_parse_name ("items-altered", TYPE_DATA_COLLECTION, &_tmp5_, NULL, FALSE);
#line 77 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_DATA_COLLECTION, DataCollection), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) _thumbnail_on_tags_altered_data_collection_items_altered, self);
#line 37 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_g_object_unref0 (self->priv->media);
#line 41 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_g_object_unref0 (self->priv->unscaled_pixbuf);
#line 42 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_g_object_unref0 (self->priv->cancellable);
#line 7 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	G_OBJECT_CLASS (thumbnail_parent_class)->finalize (obj);
#line 2689 "Thumbnail.c"
}


GType thumbnail_get_type (void) {
	static volatile gsize thumbnail_type_id__volatile = 0;
	if (g_once_init_enter (&thumbnail_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ThumbnailClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) thumbnail_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Thumbnail), 0, (GInstanceInitFunc) thumbnail_instance_init, NULL };
		GType thumbnail_type_id;
		thumbnail_type_id = g_type_register_static (TYPE_MEDIA_SOURCE_ITEM, "Thumbnail", &g_define_type_info, 0);
		g_once_init_leave (&thumbnail_type_id__volatile, thumbnail_type_id);
	}
	return thumbnail_type_id__volatile;
}


static void _vala_thumbnail_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	Thumbnail * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_THUMBNAIL, Thumbnail);
#line 7 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	switch (property_id) {
#line 2710 "Thumbnail.c"
		default:
#line 7 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 7 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		break;
#line 2716 "Thumbnail.c"
	}
}



