RabbitMQ `3.10.25` is a maintenance release in the `3.10.x` [release series](https://www.rabbitmq.com/versions.html).

This series [**reaches its end of community support** on July 31st, 2023](https://rabbitmq.com/versions.html).

Please refer to the upgrade section from [v3.10.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.10.0)
if upgrading from a version prior to 3.10.0.

This release **requires Erlang 24.3** and supports Erlang 25.
[RabbitMQ and Erlang/OTP Compatibility Matrix](https://www.rabbitmq.com/which-erlang.html) has more details on
Erlang version requirements for RabbitMQ.


### Minimum Supported Erlang Version

Erlang versions older than 24.3 have reached [end of support](https://www.rabbitmq.com/which-erlang.html).

This release of RabbitMQ [requires Erlang 24.3.4.8](https://github.com/rabbitmq/rabbitmq-packaging/pull/35)
or later versions. Nodes **will fail to start** on older Erlang releases.

Erlang 25.3 is recommended: it offers much improved performance on ARM64 architectures, [profiling with flame graphs](https://blog.rabbitmq.com/posts/2022/05/flame-graphs/)
across all architectures, and the most recent TLS 1.3 implementation.


## Changes Worth Mentioning

Release notes can be found on GitHub at [rabbitmq-server/release-notes](https://github.com/rabbitmq/rabbitmq-server/tree/v3.10.x/release-notes).


### Core Server

#### Bug Fixes

 * Declaration of a classic queue could run into an exception.

   GitHub issue: [#8629](https://github.com/rabbitmq/rabbitmq-server/pull/8629)


### Stream Plugin

#### Bug Fixes

 * Stream client connections that authenticated using x.509 certificates
   failed.

   GitHub issue: [#8488](https://github.com/rabbitmq/rabbitmq-server/pull/8488)


### Management Plugin

#### Bug Fixes

 * It was not possible to close a table column selection pane on
   screens that had little vertical space.

   Contributed by @Antsthebul.

   GitHub issue: [#8701](https://github.com/rabbitmq/rabbitmq-server/pull/8701)


### OAuth 2 Plugin

#### Enhancements

 * `oauth2` is now an accepted alias for the OAuth 2 authentication and authorization backend:

   ```
   auth_backends.1 = oauth2
   ```

   Previously the only option for OAuth 2 was using a full module name,
   `rabbit_auth_backend_oauth2`.

   GitHub issue: [#8513](https://github.com/rabbitmq/rabbitmq-server/pull/8513)


## Dependency Upgrades

None in this release.


## Source Code Archives

To obtain source code of the entire distribution, please download the archive named `rabbitmq-server-3.10.25.tar.xz`
instead of the source tarball produced by GitHub.
