#ifndef INCLUDE_DRIVER_BACKLIGHT_PMU_H
#define INCLUDE_DRIVER_BACKLIGHT_PMU_H
/**
 * @brief Low level backlight driver for PMU backlight controller.
 *
 * This file contains some definitions and the prototypes for the
 * PMU backlight driver.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * version 2 as published by the Free Software Foundation
 * (http://www.gnu.org/licenses/gpl.html)
 *
 * @file    src/driver_backlight_pmu.h
 * @author  Matthias Grimm <matthias.grimm@users.sourceforge.net>
 */

#include <pbbtaglist.h>

/**
 * @brief Maximum brightness level of PMU controlled backlight
 *
 * This value is lent from asm/backlight.h and limited by the
 * kernel driver.
 */
#define PMUBRIGHTNESSMAX		15

#ifndef PMU_IOC_GRAB_BACKLIGHT
#define PMU_IOC_GRAB_BACKLIGHT	_IOR('B', 6, 0)
#endif

/* public prototypes driver PMU backlight */	
struct driver_backlight *driver_backlight_pmu_init ();

#endif    /* INCLUDE_DRIVER_BACKLIGHT_PMU_H */
