/*
 * Copyright 2015 Google Inc.
 *
 * Use of this source code is governed by a BSD-style license that can be
 * found in the LICENSE file.
 */

#include "SkBitmap.h"
#include "SkForceLinking.h"
#include "SkImageDecoder.h"
#include "Test.h"

// A valid 1x1 indexed PNG.
unsigned char gPngData[] = {
  0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a, 0x00, 0x00, 0x00, 0x0d,
  0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01,
  0x08, 0x03, 0x00, 0x00, 0x00, 0x28, 0xcb, 0x34, 0xbb, 0x00, 0x00, 0x00,
  0x09, 0x70, 0x48, 0x59, 0x73, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x00, 0x00,
  0x1c, 0x00, 0x0f, 0x01, 0xb9, 0x8f, 0x00, 0x00, 0x00, 0x06, 0x50, 0x4c,
  0x54, 0x45, 0xff, 0x00, 0x00, 0x00, 0xff, 0x00, 0xd2, 0x87, 0xef, 0x71,
  0x00, 0x00, 0x00, 0x13, 0x49, 0x44, 0x41, 0x54, 0x78, 0xda, 0xed, 0xfd,
  0x81, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xf8, 0xaf, 0x16, 0x46, 0x00,
  0x02, 0x00, 0x01, 0x32, 0x60, 0xf7, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x49,
  0x45, 0x4e, 0x44, 0xae, 0x42, 0x60, 0x82
};

// Attempt to decode an invalid PNG that has a palette. Mostly we're looking to
// make sure we don't leak memory since libpng uses setjmp for error handling so
// it's very easy to accidentally skip destructors when a failure happens.
// As a result, we do not have any REPORTER_ASSERT statements
DEF_TEST(InvalidIndexedPng, reporter) {
    SkBitmap image;
    SkForceLinking(false);
    // Make our PNG invalid by changing a byte.
    gPngData[sizeof(gPngData) - 1] = 1;

    SkImageDecoder::DecodeMemory(gPngData, sizeof(gPngData), &image);
}
