# Copyright 2014 The Chromium Authors. All rights reserved.
# Use of this source code is governed by a BSD-style license that can be
# found in the LICENSE file.

{
  'variables': {
    'nacl_untrusted_build%': 0,
  },
  'sources': [
    '<(libjingle_source)/talk/base/asyncfile.cc',
    '<(libjingle_source)/talk/base/asyncfile.h',
    '<(libjingle_source)/talk/base/asynchttprequest.cc',
    '<(libjingle_source)/talk/base/asynchttprequest.h',
    '<(libjingle_source)/talk/base/asyncpacketsocket.h',
    '<(libjingle_source)/talk/base/asyncsocket.cc',
    '<(libjingle_source)/talk/base/asyncsocket.h',
    '<(libjingle_source)/talk/base/asynctcpsocket.cc',
    '<(libjingle_source)/talk/base/asynctcpsocket.h',
    '<(libjingle_source)/talk/base/asyncudpsocket.cc',
    '<(libjingle_source)/talk/base/asyncudpsocket.h',
    '<(libjingle_source)/talk/base/autodetectproxy.cc',
    '<(libjingle_source)/talk/base/autodetectproxy.h',
    '<(libjingle_source)/talk/base/base64.cc',
    '<(libjingle_source)/talk/base/base64.h',
    '<(libjingle_source)/talk/base/basicdefs.h',
    '<(libjingle_source)/talk/base/bytebuffer.cc',
    '<(libjingle_source)/talk/base/bytebuffer.h',
    '<(libjingle_source)/talk/base/byteorder.h',
    '<(libjingle_source)/talk/base/checks.cc',
    '<(libjingle_source)/talk/base/checks.h',
    '<(libjingle_source)/talk/base/common.cc',
    '<(libjingle_source)/talk/base/common.h',
    '<(libjingle_source)/talk/base/compile_assert.h',
    '<(libjingle_source)/talk/base/cpumonitor.cc',
    '<(libjingle_source)/talk/base/cpumonitor.h',
    '<(libjingle_source)/talk/base/crc32.cc',
    '<(libjingle_source)/talk/base/crc32.h',
    '<(libjingle_source)/talk/base/criticalsection.h',
    '<(libjingle_source)/talk/base/cryptstring.h',
    '<(libjingle_source)/talk/base/diskcache.cc',
    '<(libjingle_source)/talk/base/diskcache.h',
    '<(libjingle_source)/talk/base/dscp.h',
    '<(libjingle_source)/talk/base/event.cc',
    '<(libjingle_source)/talk/base/event.h',
    '<(libjingle_source)/talk/base/fileutils.cc',
    '<(libjingle_source)/talk/base/fileutils.h',
    '<(libjingle_source)/talk/base/firewallsocketserver.cc',
    '<(libjingle_source)/talk/base/firewallsocketserver.h',
    '<(libjingle_source)/talk/base/flags.cc',
    '<(libjingle_source)/talk/base/flags.h',
    '<(libjingle_source)/talk/base/helpers.cc',
    '<(libjingle_source)/talk/base/helpers.h',
    '<(libjingle_source)/talk/base/httpbase.cc',
    '<(libjingle_source)/talk/base/httpbase.h',
    '<(libjingle_source)/talk/base/httpclient.cc',
    '<(libjingle_source)/talk/base/httpclient.h',
    '<(libjingle_source)/talk/base/httpcommon-inl.h',
    '<(libjingle_source)/talk/base/httpcommon.cc',
    '<(libjingle_source)/talk/base/httpcommon.h',
    '<(libjingle_source)/talk/base/httprequest.cc',
    '<(libjingle_source)/talk/base/httprequest.h',
    '<(libjingle_source)/talk/base/ifaddrs-android.cc',
    '<(libjingle_source)/talk/base/ifaddrs-android.h',
    '<(libjingle_source)/talk/base/ipaddress.cc',
    '<(libjingle_source)/talk/base/ipaddress.h',
    '<(libjingle_source)/talk/base/latebindingsymboltable.cc',
    '<(libjingle_source)/talk/base/latebindingsymboltable.h',
    '<(libjingle_source)/talk/base/linked_ptr.h',
    '<(libjingle_source)/talk/base/linux.cc',
    '<(libjingle_source)/talk/base/linux.h',
    '<(libjingle_source)/talk/base/logging.cc',
    '<(libjingle_source)/talk/base/logging.h',
    '<(libjingle_source)/talk/base/maccocoathreadhelper.h',
    '<(libjingle_source)/talk/base/maccocoathreadhelper.mm',
    '<(libjingle_source)/talk/base/macconversion.cc',
    '<(libjingle_source)/talk/base/macconversion.h',
    '<(libjingle_source)/talk/base/macutils.cc',
    '<(libjingle_source)/talk/base/macutils.h',
    '<(libjingle_source)/talk/base/md5.cc',
    '<(libjingle_source)/talk/base/md5.h',
    '<(libjingle_source)/talk/base/md5digest.h',
    '<(libjingle_source)/talk/base/messagedigest.cc',
    '<(libjingle_source)/talk/base/messagedigest.h',
    '<(libjingle_source)/talk/base/messagehandler.cc',
    '<(libjingle_source)/talk/base/messagehandler.h',
    '<(libjingle_source)/talk/base/messagequeue.cc',
    '<(libjingle_source)/talk/base/messagequeue.h',
    '<(libjingle_source)/talk/base/move.h',
    '<(libjingle_source)/talk/base/nethelpers.cc',
    '<(libjingle_source)/talk/base/nethelpers.h',
    '<(libjingle_source)/talk/base/network.cc',
    '<(libjingle_source)/talk/base/network.h',
    '<(libjingle_source)/talk/base/nssidentity.cc',
    '<(libjingle_source)/talk/base/nssidentity.h',
    '<(libjingle_source)/talk/base/nssstreamadapter.cc',
    '<(libjingle_source)/talk/base/nssstreamadapter.h',
    '<(libjingle_source)/talk/base/nullsocketserver.h',
    '<(libjingle_source)/talk/base/openssladapter.cc',
    '<(libjingle_source)/talk/base/openssldigest.cc',
    '<(libjingle_source)/talk/base/opensslidentity.cc',
    '<(libjingle_source)/talk/base/opensslstreamadapter.cc',
    '<(libjingle_source)/talk/base/pathutils.cc',
    '<(libjingle_source)/talk/base/pathutils.h',
    '<(libjingle_source)/talk/base/physicalsocketserver.cc',
    '<(libjingle_source)/talk/base/physicalsocketserver.h',
    '<(libjingle_source)/talk/base/proxydetect.cc',
    '<(libjingle_source)/talk/base/proxydetect.h',
    '<(libjingle_source)/talk/base/proxyinfo.cc',
    '<(libjingle_source)/talk/base/proxyinfo.h',
    '<(libjingle_source)/talk/base/ratelimiter.cc',
    '<(libjingle_source)/talk/base/ratelimiter.h',
    '<(libjingle_source)/talk/base/ratetracker.cc',
    '<(libjingle_source)/talk/base/ratetracker.h',
    '<(libjingle_source)/talk/base/schanneladapter.cc',
    '<(libjingle_source)/talk/base/schanneladapter.h',
    '<(libjingle_source)/talk/base/scoped_autorelease_pool.h',
    '<(libjingle_source)/talk/base/scoped_autorelease_pool.mm',
    '<(libjingle_source)/talk/base/scoped_ptr.h',
    '<(libjingle_source)/talk/base/sec_buffer.h',
    '<(libjingle_source)/talk/base/sha1.cc',
    '<(libjingle_source)/talk/base/sha1.h',
    '<(libjingle_source)/talk/base/sha1digest.h',
    '<(libjingle_source)/talk/base/signalthread.cc',
    '<(libjingle_source)/talk/base/signalthread.h',
    '<(libjingle_source)/talk/base/sigslot.h',
    '<(libjingle_source)/talk/base/sigslotrepeater.h',
    '<(libjingle_source)/talk/base/socket.h',
    '<(libjingle_source)/talk/base/socketadapters.cc',
    '<(libjingle_source)/talk/base/socketadapters.h',
    '<(libjingle_source)/talk/base/socketaddress.cc',
    '<(libjingle_source)/talk/base/socketaddress.h',
    '<(libjingle_source)/talk/base/socketaddresspair.cc',
    '<(libjingle_source)/talk/base/socketaddresspair.h',
    '<(libjingle_source)/talk/base/socketfactory.h',
    '<(libjingle_source)/talk/base/socketpool.cc',
    '<(libjingle_source)/talk/base/socketpool.h',
    '<(libjingle_source)/talk/base/socketserver.h',
    '<(libjingle_source)/talk/base/socketstream.cc',
    '<(libjingle_source)/talk/base/socketstream.h',
    '<(libjingle_source)/talk/base/ssladapter.cc',
    '<(libjingle_source)/talk/base/ssladapter.h',
    '<(libjingle_source)/talk/base/sslfingerprint.cc',
    '<(libjingle_source)/talk/base/sslfingerprint.h',
    '<(libjingle_source)/talk/base/sslidentity.cc',
    '<(libjingle_source)/talk/base/sslidentity.h',
    '<(libjingle_source)/talk/base/sslsocketfactory.cc',
    '<(libjingle_source)/talk/base/sslsocketfactory.h',
    '<(libjingle_source)/talk/base/sslstreamadapter.cc',
    '<(libjingle_source)/talk/base/sslstreamadapter.h',
    '<(libjingle_source)/talk/base/sslstreamadapterhelper.cc',
    '<(libjingle_source)/talk/base/sslstreamadapterhelper.h',
    '<(libjingle_source)/talk/base/stream.cc',
    '<(libjingle_source)/talk/base/stream.h',
    '<(libjingle_source)/talk/base/stringencode.cc',
    '<(libjingle_source)/talk/base/stringencode.h',
    '<(libjingle_source)/talk/base/stringutils.cc',
    '<(libjingle_source)/talk/base/stringutils.h',
    '<(libjingle_source)/talk/base/systeminfo.cc',
    '<(libjingle_source)/talk/base/systeminfo.h',
    '<(libjingle_source)/talk/base/task.cc',
    '<(libjingle_source)/talk/base/task.h',
    '<(libjingle_source)/talk/base/taskparent.cc',
    '<(libjingle_source)/talk/base/taskparent.h',
    '<(libjingle_source)/talk/base/taskrunner.cc',
    '<(libjingle_source)/talk/base/taskrunner.h',
    '<(libjingle_source)/talk/base/template_util.h',
    '<(libjingle_source)/talk/base/thread.cc',
    '<(libjingle_source)/talk/base/thread.h',
    '<(libjingle_source)/talk/base/timeutils.cc',
    '<(libjingle_source)/talk/base/timeutils.h',
    '<(libjingle_source)/talk/base/timing.cc',
    '<(libjingle_source)/talk/base/timing.h',
    '<(libjingle_source)/talk/base/unixfilesystem.cc',
    '<(libjingle_source)/talk/base/unixfilesystem.h',
    '<(libjingle_source)/talk/base/urlencode.cc',
    '<(libjingle_source)/talk/base/urlencode.h',
    '<(libjingle_source)/talk/base/win32.cc',
    '<(libjingle_source)/talk/base/win32.h',
    '<(libjingle_source)/talk/base/win32filesystem.cc',
    '<(libjingle_source)/talk/base/win32filesystem.h',
    '<(libjingle_source)/talk/base/win32securityerrors.cc',
    '<(libjingle_source)/talk/base/win32window.cc',
    '<(libjingle_source)/talk/base/win32window.h',
    '<(libjingle_source)/talk/base/winfirewall.cc',
    '<(libjingle_source)/talk/base/winfirewall.h',
    '<(libjingle_source)/talk/base/winping.cc',
    '<(libjingle_source)/talk/base/winping.h',
    '<(libjingle_source)/talk/base/worker.cc',
    '<(libjingle_source)/talk/base/worker.h',
    '<(libjingle_source)/talk/p2p/base/asyncstuntcpsocket.cc',
    '<(libjingle_source)/talk/p2p/base/asyncstuntcpsocket.h',
    '<(libjingle_source)/talk/p2p/base/basicpacketsocketfactory.cc',
    '<(libjingle_source)/talk/p2p/base/basicpacketsocketfactory.h',
    '<(libjingle_source)/talk/p2p/base/candidate.h',
    '<(libjingle_source)/talk/p2p/base/common.h',
    '<(libjingle_source)/talk/p2p/base/constants.cc',
    '<(libjingle_source)/talk/p2p/base/constants.h',
    '<(libjingle_source)/talk/p2p/base/dtlstransport.h',
    '<(libjingle_source)/talk/p2p/base/dtlstransportchannel.cc',
    '<(libjingle_source)/talk/p2p/base/dtlstransportchannel.h',
    '<(libjingle_source)/talk/p2p/base/p2ptransport.cc',
    '<(libjingle_source)/talk/p2p/base/p2ptransport.h',
    '<(libjingle_source)/talk/p2p/base/p2ptransportchannel.cc',
    '<(libjingle_source)/talk/p2p/base/p2ptransportchannel.h',
    '<(libjingle_source)/talk/p2p/base/parsing.cc',
    '<(libjingle_source)/talk/p2p/base/parsing.h',
    '<(libjingle_source)/talk/p2p/base/port.cc',
    '<(libjingle_source)/talk/p2p/base/port.h',
    '<(libjingle_source)/talk/p2p/base/portallocator.cc',
    '<(libjingle_source)/talk/p2p/base/portallocator.h',
    '<(libjingle_source)/talk/p2p/base/portallocatorsessionproxy.cc',
    '<(libjingle_source)/talk/p2p/base/portallocatorsessionproxy.h',
    '<(libjingle_source)/talk/p2p/base/portproxy.cc',
    '<(libjingle_source)/talk/p2p/base/portproxy.h',
    '<(libjingle_source)/talk/p2p/base/pseudotcp.cc',
    '<(libjingle_source)/talk/p2p/base/pseudotcp.h',
    '<(libjingle_source)/talk/p2p/base/rawtransport.cc',
    '<(libjingle_source)/talk/p2p/base/rawtransport.h',
    '<(libjingle_source)/talk/p2p/base/rawtransportchannel.cc',
    '<(libjingle_source)/talk/p2p/base/rawtransportchannel.h',
    '<(libjingle_source)/talk/p2p/base/relayport.cc',
    '<(libjingle_source)/talk/p2p/base/relayport.h',
    '<(libjingle_source)/talk/p2p/base/session.cc',
    '<(libjingle_source)/talk/p2p/base/session.h',
    '<(libjingle_source)/talk/p2p/base/sessionclient.h',
    '<(libjingle_source)/talk/p2p/base/sessiondescription.cc',
    '<(libjingle_source)/talk/p2p/base/sessiondescription.h',
    '<(libjingle_source)/talk/p2p/base/sessionid.h',
    '<(libjingle_source)/talk/p2p/base/sessionmanager.cc',
    '<(libjingle_source)/talk/p2p/base/sessionmanager.h',
    '<(libjingle_source)/talk/p2p/base/sessionmessages.cc',
    '<(libjingle_source)/talk/p2p/base/sessionmessages.h',
    '<(libjingle_source)/talk/p2p/base/stun.cc',
    '<(libjingle_source)/talk/p2p/base/stun.h',
    '<(libjingle_source)/talk/p2p/base/stunport.cc',
    '<(libjingle_source)/talk/p2p/base/stunport.h',
    '<(libjingle_source)/talk/p2p/base/stunrequest.cc',
    '<(libjingle_source)/talk/p2p/base/stunrequest.h',
    '<(libjingle_source)/talk/p2p/base/tcpport.cc',
    '<(libjingle_source)/talk/p2p/base/tcpport.h',
    '<(libjingle_source)/talk/p2p/base/transport.cc',
    '<(libjingle_source)/talk/p2p/base/transport.h',
    '<(libjingle_source)/talk/p2p/base/transportchannel.cc',
    '<(libjingle_source)/talk/p2p/base/transportchannel.h',
    '<(libjingle_source)/talk/p2p/base/transportchannelimpl.h',
    '<(libjingle_source)/talk/p2p/base/transportchannelproxy.cc',
    '<(libjingle_source)/talk/p2p/base/transportchannelproxy.h',
    '<(libjingle_source)/talk/p2p/base/transportdescription.cc',
    '<(libjingle_source)/talk/p2p/base/transportdescription.h',
    '<(libjingle_source)/talk/p2p/base/transportdescriptionfactory.cc',
    '<(libjingle_source)/talk/p2p/base/transportdescriptionfactory.h',
    '<(libjingle_source)/talk/p2p/base/turnport.cc',
    '<(libjingle_source)/talk/p2p/base/turnport.h',
    '<(libjingle_source)/talk/p2p/client/basicportallocator.cc',
    '<(libjingle_source)/talk/p2p/client/basicportallocator.h',
    '<(libjingle_source)/talk/p2p/client/httpportallocator.cc',
    '<(libjingle_source)/talk/p2p/client/httpportallocator.h',
    '<(libjingle_source)/talk/p2p/client/sessionmanagertask.h',
    '<(libjingle_source)/talk/p2p/client/sessionsendtask.h',
    '<(libjingle_source)/talk/p2p/client/socketmonitor.cc',
    '<(libjingle_source)/talk/p2p/client/socketmonitor.h',
    '<(libjingle_source)/talk/xmllite/qname.cc',
    '<(libjingle_source)/talk/xmllite/qname.h',
    '<(libjingle_source)/talk/xmllite/xmlbuilder.cc',
    '<(libjingle_source)/talk/xmllite/xmlbuilder.h',
    '<(libjingle_source)/talk/xmllite/xmlconstants.cc',
    '<(libjingle_source)/talk/xmllite/xmlconstants.h',
    '<(libjingle_source)/talk/xmllite/xmlelement.cc',
    '<(libjingle_source)/talk/xmllite/xmlelement.h',
    '<(libjingle_source)/talk/xmllite/xmlnsstack.cc',
    '<(libjingle_source)/talk/xmllite/xmlnsstack.h',
    '<(libjingle_source)/talk/xmllite/xmlparser.cc',
    '<(libjingle_source)/talk/xmllite/xmlparser.h',
    '<(libjingle_source)/talk/xmllite/xmlprinter.cc',
    '<(libjingle_source)/talk/xmllite/xmlprinter.h',
    '<(libjingle_source)/talk/xmpp/asyncsocket.h',
    '<(libjingle_source)/talk/xmpp/constants.cc',
    '<(libjingle_source)/talk/xmpp/constants.h',
    '<(libjingle_source)/talk/xmpp/jid.cc',
    '<(libjingle_source)/talk/xmpp/jid.h',
    '<(libjingle_source)/talk/xmpp/plainsaslhandler.h',
    '<(libjingle_source)/talk/xmpp/prexmppauth.h',
    '<(libjingle_source)/talk/xmpp/saslcookiemechanism.h',
    '<(libjingle_source)/talk/xmpp/saslhandler.h',
    '<(libjingle_source)/talk/xmpp/saslmechanism.cc',
    '<(libjingle_source)/talk/xmpp/saslmechanism.h',
    '<(libjingle_source)/talk/xmpp/saslplainmechanism.h',
    '<(libjingle_source)/talk/xmpp/xmppclient.cc',
    '<(libjingle_source)/talk/xmpp/xmppclient.h',
    '<(libjingle_source)/talk/xmpp/xmppclientsettings.h',
    '<(libjingle_source)/talk/xmpp/xmppengine.h',
    '<(libjingle_source)/talk/xmpp/xmppengineimpl.cc',
    '<(libjingle_source)/talk/xmpp/xmppengineimpl.h',
    '<(libjingle_source)/talk/xmpp/xmppengineimpl_iq.cc',
    '<(libjingle_source)/talk/xmpp/xmpplogintask.cc',
    '<(libjingle_source)/talk/xmpp/xmpplogintask.h',
    '<(libjingle_source)/talk/xmpp/xmppstanzaparser.cc',
    '<(libjingle_source)/talk/xmpp/xmppstanzaparser.h',
    '<(libjingle_source)/talk/xmpp/xmpptask.cc',
    '<(libjingle_source)/talk/xmpp/xmpptask.h',
  ],
  'conditions': [
    ['OS=="win" and nacl_untrusted_build==0', {
      # Suppress warnings about WIN32_LEAN_AND_MEAN.
      'msvs_disabled_warnings': [ 4005, 4267 ],
    }, {
      'sources/': [
        ['exclude', '/win[a-z0-9]+\\.(h|cc)$'],
        ['exclude', '/schanneladapter\\.(h|cc)$'],
      ],
    }],
    ['os_posix!=1 and nacl_untrusted_build==0', {
      'sources/': [
        ['exclude', '/unix[a-z]+\\.(h|cc)$'],
      ],
    }],
    ['OS!="linux" or nacl_untrusted_build==1', {
      'sources!': [
        '<(libjingle_source)/talk/base/latebindingsymboltable.cc',
        '<(libjingle_source)/talk/base/latebindingsymboltable.h',
      ],
    }],
    ['(OS!="linux" and OS!="android") or nacl_untrusted_build==1', {
      'sources!': [
        '<(libjingle_source)/talk/base/linux.cc',
        '<(libjingle_source)/talk/base/linux.h',
      ],
    }],
    ['(OS!="mac" and OS!="ios") or nacl_untrusted_build==1', {
      'sources/': [
        ['exclude', '/mac[a-z]+\\.(h|cc)$'],
        ['exclude', '/scoped_autorelease_pool\\.(h|mm)$'],
      ],
    }],
    ['OS!="android" or nacl_untrusted_build==1', {
      'sources!': [
        '<(libjingle_source)/talk/base/ifaddrs-android.cc',
        '<(libjingle_source)/talk/base/ifaddrs-android.h',
      ],
    }],
    ['use_openssl!=1', {
      'sources/': [
        ['exclude', '/openssl[a-z]+\\.(h|cc)$'],
      ],
    }],
    ['nacl_untrusted_build==1', {
      'sources!': [
        '<(libjingle_source)/talk/base/systeminfo.cc',
        '<(libjingle_source)/talk/base/systeminfo.h',
      ],
    }],
  ],
}
