// Licensed under the Apache License, Version 2.0
// <LICENSE-APACHE or http://www.apache.org/licenses/LICENSE-2.0> or the MIT license
// <LICENSE-MIT or http://opensource.org/licenses/MIT>, at your option.
// All files in the project carrying such notice may not be copied, modified, or distributed
// except according to those terms
//! Common header file for all USB IOCTLs defined for
//! the core stack. We define them in this single header file
//! so that we can maintain backward compatibilty with older
//! versions of the stack.
use shared::guiddef::GUID;
use shared::minwindef::ULONG;
use um::winioctl::{FILE_ANY_ACCESS, FILE_DEVICE_UNKNOWN, METHOD_BUFFERED, METHOD_NEITHER};
use um::winnt::PVOID;
pub const USB_SUBMIT_URB: ULONG = 0;
pub const USB_RESET_PORT: ULONG = 1;
pub const USB_GET_ROOTHUB_PDO: ULONG = 3;
pub const USB_GET_PORT_STATUS: ULONG = 4;
pub const USB_ENABLE_PORT: ULONG = 5;
pub const USB_GET_HUB_COUNT: ULONG = 6;
pub const USB_CYCLE_PORT: ULONG = 7;
pub const USB_GET_HUB_NAME: ULONG = 8;
pub const USB_IDLE_NOTIFICATION: ULONG = 9;
pub const USB_RECORD_FAILURE: ULONG = 10;
pub const USB_GET_BUS_INFO: ULONG = 264;
pub const USB_GET_CONTROLLER_NAME: ULONG = 265;
pub const USB_GET_BUSGUID_INFO: ULONG = 266;
pub const USB_GET_PARENT_HUB_INFO: ULONG = 267;
pub const USB_GET_DEVICE_HANDLE: ULONG = 268;
pub const USB_GET_DEVICE_HANDLE_EX: ULONG = 269;
pub const USB_GET_TT_DEVICE_HANDLE: ULONG = 270;
pub const USB_GET_TOPOLOGY_ADDRESS: ULONG = 271;
pub const USB_IDLE_NOTIFICATION_EX: ULONG = 272;
pub const USB_REQ_GLOBAL_SUSPEND: ULONG = 273;
pub const USB_REQ_GLOBAL_RESUME: ULONG = 274;
pub const USB_GET_HUB_CONFIG_INFO: ULONG = 275;
pub const USB_FAIL_GET_STATUS: ULONG = 280;
pub const USB_REGISTER_COMPOSITE_DEVICE: ULONG = 0;
pub const USB_UNREGISTER_COMPOSITE_DEVICE: ULONG = 1;
pub const USB_REQUEST_REMOTE_WAKE_NOTIFICATION: ULONG = 2;
pub const HCD_GET_STATS_1: ULONG = 255;
pub const HCD_DIAGNOSTIC_MODE_ON: ULONG = 256;
pub const HCD_DIAGNOSTIC_MODE_OFF: ULONG = 257;
pub const HCD_GET_ROOT_HUB_NAME: ULONG = 258;
pub const HCD_GET_DRIVERKEY_NAME: ULONG = 265;
pub const HCD_GET_STATS_2: ULONG = 266;
pub const HCD_DISABLE_PORT: ULONG = 268;
pub const HCD_ENABLE_PORT: ULONG = 269;
pub const HCD_USER_REQUEST: ULONG = 270;
pub const HCD_TRACE_READ_REQUEST: ULONG = 275;
pub const USB_GET_NODE_INFORMATION: ULONG = 258;
pub const USB_GET_NODE_CONNECTION_INFORMATION: ULONG = 259;
pub const USB_GET_DESCRIPTOR_FROM_NODE_CONNECTION: ULONG = 260;
pub const USB_GET_NODE_CONNECTION_NAME: ULONG = 261;
pub const USB_DIAG_IGNORE_HUBS_ON: ULONG = 262;
pub const USB_DIAG_IGNORE_HUBS_OFF: ULONG = 263;
pub const USB_GET_NODE_CONNECTION_DRIVERKEY_NAME: ULONG = 264;
pub const USB_GET_HUB_CAPABILITIES: ULONG = 271;
pub const USB_GET_NODE_CONNECTION_ATTRIBUTES: ULONG = 272;
pub const USB_HUB_CYCLE_PORT: ULONG = 273;
pub const USB_GET_NODE_CONNECTION_INFORMATION_EX: ULONG = 274;
pub const USB_RESET_HUB: ULONG = 275;
pub const USB_GET_HUB_CAPABILITIES_EX: ULONG = 276;
pub const USB_GET_HUB_INFORMATION_EX: ULONG = 277;
pub const USB_GET_PORT_CONNECTOR_PROPERTIES: ULONG = 278;
pub const USB_GET_NODE_CONNECTION_INFORMATION_EX_V2: ULONG = 279;
DEFINE_GUID!{GUID_DEVINTERFACE_USB_HUB,
    0xf18a0e88, 0xc30c, 0x11d0, 0x88, 0x15, 0x00, 0xa0, 0xc9, 0x06, 0xbe, 0xd8}
DEFINE_GUID!{GUID_DEVINTERFACE_USB_DEVICE,
    0xA5DCBF10, 0x6530, 0x11D2, 0x90, 0x1F, 0x00, 0xC0, 0x4F, 0xB9, 0x51, 0xED}
DEFINE_GUID!{GUID_DEVINTERFACE_USB_HOST_CONTROLLER,
    0x3abf6f2d, 0x71c4, 0x462a, 0x8a, 0x92, 0x1e, 0x68, 0x61, 0xe6, 0xaf, 0x27}
DEFINE_GUID!{GUID_USB_WMI_STD_DATA,
    0x4E623B20, 0xCB14, 0x11D1, 0xB3, 0x31, 0x00, 0xA0, 0xC9, 0x59, 0xBB, 0xD2}
DEFINE_GUID!{GUID_USB_WMI_STD_NOTIFICATION,
    0x4E623B20, 0xCB14, 0x11D1, 0xB3, 0x31, 0x00, 0xA0, 0xC9, 0x59, 0xBB, 0xD2}
DEFINE_GUID!{GUID_USB_WMI_DEVICE_PERF_INFO,
    0x66c1aa3c, 0x499f, 0x49a0, 0xa9, 0xa5, 0x61, 0xe2, 0x35, 0x9f, 0x64, 0x7}
DEFINE_GUID!{GUID_USB_WMI_NODE_INFO,
    0x9c179357, 0xdc7a, 0x4f41, 0xb6, 0x6b, 0x32, 0x3b, 0x9d, 0xdc, 0xb5, 0xb1}
DEFINE_GUID!{GUID_USB_WMI_TRACING,
    0x3a61881b, 0xb4e6, 0x4bf9, 0xae, 0xf, 0x3c, 0xd8, 0xf3, 0x94, 0xe5, 0x2f}
DEFINE_GUID!{GUID_USB_TRANSFER_TRACING,
    0x681eb8aa, 0x403d, 0x452c, 0x9f, 0x8a, 0xf0, 0x61, 0x6f, 0xac, 0x95, 0x40}
DEFINE_GUID!{GUID_USB_PERFORMANCE_TRACING,
    0xd5de77a6, 0x6ae9, 0x425c, 0xb1, 0xe2, 0xf5, 0x61, 0x5f, 0xd3, 0x48, 0xa9}
DEFINE_GUID!{GUID_USB_WMI_SURPRISE_REMOVAL_NOTIFICATION,
    0x9bbbf831, 0xa2f2, 0x43b4, 0x96, 0xd1, 0x86, 0x94, 0x4b, 0x59, 0x14, 0xb3}
pub const GUID_CLASS_USBHUB: GUID = GUID_DEVINTERFACE_USB_HUB;
pub const GUID_CLASS_USB_DEVICE: GUID = GUID_DEVINTERFACE_USB_DEVICE;
pub const GUID_CLASS_USB_HOST_CONTROLLER: GUID = GUID_DEVINTERFACE_USB_HOST_CONTROLLER;
pub const FILE_DEVICE_USB: ULONG = FILE_DEVICE_UNKNOWN;
#[inline]
pub fn USB_CTL(id: ULONG) -> ULONG {
    CTL_CODE!(FILE_DEVICE_USB, id, METHOD_BUFFERED, FILE_ANY_ACCESS)
}
#[inline]
pub fn USB_KERNEL_CTL(id: ULONG) -> ULONG {
    CTL_CODE!(FILE_DEVICE_USB, id, METHOD_NEITHER, FILE_ANY_ACCESS)
}
#[inline]
pub fn USB_KERNEL_CTL_BUFFERED(id: ULONG) -> ULONG {
    CTL_CODE!(FILE_DEVICE_USB, id, METHOD_BUFFERED, FILE_ANY_ACCESS)
}
// No calling convention was specified in the code
FN!{stdcall USB_IDLE_CALLBACK(
    Context: PVOID,
) -> ()}
STRUCT!{struct USB_IDLE_CALLBACK_INFO {
    IdleCallback: USB_IDLE_CALLBACK,
    IdleContext: PVOID,
}}
pub type PUSB_IDLE_CALLBACK_INFO = *mut USB_IDLE_CALLBACK_INFO;
