/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns.impl;

import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jmdns.JmDNS;
import javax.jmdns.JmmDNS;
import javax.jmdns.NetworkTopologyDiscovery;
import javax.jmdns.NetworkTopologyEvent;
import javax.jmdns.NetworkTopologyListener;
import javax.jmdns.ServiceInfo;
import javax.jmdns.ServiceListener;
import javax.jmdns.ServiceTypeListener;
import javax.jmdns.impl.JmDNSImpl;
import javax.jmdns.impl.NetworkTopologyEventImpl;
import javax.jmdns.impl.ServiceInfoImpl;

public class JmmDNSImpl
implements JmmDNS,
NetworkTopologyListener,
ServiceInfoImpl.Delegate {
    private static Logger logger = Logger.getLogger(JmmDNSImpl.class.getName());
    private final Set<NetworkTopologyListener> _networkListeners = Collections.synchronizedSet(new HashSet());
    private final ConcurrentMap<InetAddress, JmDNS> _knownMDNS = new ConcurrentHashMap<InetAddress, JmDNS>();
    private final ConcurrentMap<String, ServiceInfo> _services = new ConcurrentHashMap<String, ServiceInfo>(20);
    private final ExecutorService _ListenerExecutor = Executors.newSingleThreadExecutor();
    private final ExecutorService _jmDNSExecutor = Executors.newCachedThreadPool();
    private final Timer _timer = new Timer("Multihommed mDNS.Timer", true);

    public JmmDNSImpl() {
        new NetworkChecker(this, NetworkTopologyDiscovery.Factory.getInstance()).start(this._timer);
    }

    @Override
    public void close() throws IOException {
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Cancelling JmmDNS: " + this);
        }
        this._timer.cancel();
        this._ListenerExecutor.shutdown();
        ExecutorService executor = Executors.newCachedThreadPool();
        for (final JmDNS mDNS : this._knownMDNS.values()) {
            executor.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        mDNS.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            });
        }
        executor.shutdown();
        try {
            executor.awaitTermination(5000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException exception) {
            logger.log(Level.WARNING, "Exception ", exception);
        }
        this._knownMDNS.clear();
    }

    @Override
    public String[] getNames() {
        HashSet<String> result = new HashSet<String>();
        for (JmDNS mDNS : this._knownMDNS.values()) {
            result.add(mDNS.getName());
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public String[] getHostNames() {
        HashSet<String> result = new HashSet<String>();
        for (JmDNS mDNS : this._knownMDNS.values()) {
            result.add(mDNS.getHostName());
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public InetAddress[] getInterfaces() throws IOException {
        HashSet<InetAddress> result = new HashSet<InetAddress>();
        for (JmDNS mDNS : this._knownMDNS.values()) {
            result.add(mDNS.getInterface());
        }
        return result.toArray(new InetAddress[result.size()]);
    }

    @Override
    public ServiceInfo[] getServiceInfos(String type, String name) {
        return this.getServiceInfos(type, name, false, 6000L);
    }

    @Override
    public ServiceInfo[] getServiceInfos(String type, String name, long timeout) {
        return this.getServiceInfos(type, name, false, timeout);
    }

    @Override
    public ServiceInfo[] getServiceInfos(String type, String name, boolean persistent) {
        return this.getServiceInfos(type, name, persistent, 6000L);
    }

    @Override
    public ServiceInfo[] getServiceInfos(final String type, final String name, final boolean persistent, final long timeout) {
        final Set result = Collections.synchronizedSet(new HashSet(this._knownMDNS.size()));
        ExecutorService executor = Executors.newCachedThreadPool();
        for (final JmDNS mDNS : this._knownMDNS.values()) {
            executor.submit(new Runnable(){

                @Override
                public void run() {
                    result.add(mDNS.getServiceInfo(type, name, persistent, timeout));
                }
            });
        }
        executor.shutdown();
        try {
            executor.awaitTermination(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException exception) {
            logger.log(Level.WARNING, "Exception ", exception);
        }
        return result.toArray(new ServiceInfo[result.size()]);
    }

    @Override
    public void requestServiceInfo(String type, String name) {
        this.requestServiceInfo(type, name, false, 6000L);
    }

    @Override
    public void requestServiceInfo(String type, String name, boolean persistent) {
        this.requestServiceInfo(type, name, persistent, 6000L);
    }

    @Override
    public void requestServiceInfo(String type, String name, long timeout) {
        this.requestServiceInfo(type, name, false, timeout);
    }

    @Override
    public void requestServiceInfo(final String type, final String name, final boolean persistent, final long timeout) {
        for (final JmDNS mDNS : this._knownMDNS.values()) {
            this._jmDNSExecutor.submit(new Runnable(){

                @Override
                public void run() {
                    mDNS.requestServiceInfo(type, name, persistent, timeout);
                }
            });
        }
    }

    @Override
    public void addServiceTypeListener(ServiceTypeListener listener) throws IOException {
        for (JmDNS mDNS : this._knownMDNS.values()) {
            mDNS.addServiceTypeListener(listener);
        }
    }

    @Override
    public void removeServiceTypeListener(ServiceTypeListener listener) {
        for (JmDNS mDNS : this._knownMDNS.values()) {
            mDNS.removeServiceTypeListener(listener);
        }
    }

    @Override
    public void addServiceListener(String type, ServiceListener listener) {
        for (JmDNS mDNS : this._knownMDNS.values()) {
            mDNS.addServiceListener(type, listener);
        }
    }

    @Override
    public void removeServiceListener(String type, ServiceListener listener) {
        for (JmDNS mDNS : this._knownMDNS.values()) {
            mDNS.removeServiceListener(type, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void textValueUpdated(ServiceInfo target, byte[] value) {
        ConcurrentMap<String, ServiceInfo> concurrentMap = this._services;
        synchronized (concurrentMap) {
            for (JmDNS mDNS : this._knownMDNS.values()) {
                ServiceInfo info = ((JmDNSImpl)mDNS).getServices().get(target.getQualifiedName());
                if (info != null) {
                    info.setText(value);
                    continue;
                }
                logger.warning("We have a mDNS that does not know about the service info being updated.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerService(ServiceInfo info) throws IOException {
        ConcurrentMap<String, ServiceInfo> concurrentMap = this._services;
        synchronized (concurrentMap) {
            for (JmDNS mDNS : this._knownMDNS.values()) {
                mDNS.registerService(info.clone());
            }
            ((ServiceInfoImpl)info).setDelegate(this);
            this._services.put(info.getQualifiedName(), info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterService(ServiceInfo info) {
        ConcurrentMap<String, ServiceInfo> concurrentMap = this._services;
        synchronized (concurrentMap) {
            for (JmDNS mDNS : this._knownMDNS.values()) {
                mDNS.unregisterService(info);
            }
            ((ServiceInfoImpl)info).setDelegate(null);
            this._services.remove(info.getQualifiedName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterAllServices() {
        ConcurrentMap<String, ServiceInfo> concurrentMap = this._services;
        synchronized (concurrentMap) {
            for (JmDNS mDNS : this._knownMDNS.values()) {
                mDNS.unregisterAllServices();
            }
            this._services.clear();
        }
    }

    @Override
    public void registerServiceType(String type) {
        for (JmDNS mDNS : this._knownMDNS.values()) {
            mDNS.registerServiceType(type);
        }
    }

    @Override
    public ServiceInfo[] list(String type) {
        return this.list(type, 6000L);
    }

    @Override
    public ServiceInfo[] list(final String type, final long timeout) {
        final Set result = Collections.synchronizedSet(new HashSet(this._knownMDNS.size() * 5));
        ExecutorService executor = Executors.newCachedThreadPool();
        for (final JmDNS mDNS : this._knownMDNS.values()) {
            executor.submit(new Runnable(){

                @Override
                public void run() {
                    result.addAll(Arrays.asList(mDNS.list(type, timeout)));
                }
            });
        }
        executor.shutdown();
        try {
            executor.awaitTermination(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException exception) {
            logger.log(Level.WARNING, "Exception ", exception);
        }
        return result.toArray(new ServiceInfo[result.size()]);
    }

    @Override
    public Map<String, ServiceInfo[]> listBySubtype(String type) {
        return this.listBySubtype(type, 6000L);
    }

    @Override
    public Map<String, ServiceInfo[]> listBySubtype(String type, long timeout) {
        HashMap map = new HashMap(5);
        for (ServiceInfo info : this.list(type, timeout)) {
            String subtype = info.getSubtype();
            if (!map.containsKey(subtype)) {
                map.put(subtype, new ArrayList(10));
            }
            ((List)map.get(subtype)).add(info);
        }
        HashMap<String, ServiceInfo[]> result = new HashMap<String, ServiceInfo[]>(map.size());
        for (String subtype : map.keySet()) {
            List infoForSubType = (List)map.get(subtype);
            result.put(subtype, infoForSubType.toArray(new ServiceInfo[infoForSubType.size()]));
        }
        return result;
    }

    @Override
    public void addNetworkTopologyListener(NetworkTopologyListener listener) {
        this._networkListeners.add(listener);
    }

    @Override
    public void removeNetworkTopologyListener(NetworkTopologyListener listener) {
        this._networkListeners.remove(listener);
    }

    @Override
    public NetworkTopologyListener[] networkListeners() {
        return this._networkListeners.toArray(new NetworkTopologyListener[this._networkListeners.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void inetAddressAdded(NetworkTopologyEvent event) {
        InetAddress address = event.getInetAddress();
        try {
            JmmDNSImpl jmmDNSImpl = this;
            synchronized (jmmDNSImpl) {
                if (!this._knownMDNS.containsKey(address)) {
                    this._knownMDNS.put(address, JmDNS.create(address));
                    final NetworkTopologyEventImpl jmdnsEvent = new NetworkTopologyEventImpl((JmDNS)this._knownMDNS.get(address), address);
                    for (final NetworkTopologyListener listener : this.networkListeners()) {
                        this._ListenerExecutor.submit(new Runnable(){

                            @Override
                            public void run() {
                                listener.inetAddressAdded(jmdnsEvent);
                            }
                        });
                    }
                }
            }
        }
        catch (Exception e) {
            logger.warning("Unexpected unhandled exception: " + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void inetAddressRemoved(NetworkTopologyEvent event) {
        InetAddress address = event.getInetAddress();
        try {
            JmmDNSImpl jmmDNSImpl = this;
            synchronized (jmmDNSImpl) {
                if (this._knownMDNS.containsKey(address)) {
                    JmDNS mDNS = (JmDNS)this._knownMDNS.remove(address);
                    mDNS.close();
                    final NetworkTopologyEventImpl jmdnsEvent = new NetworkTopologyEventImpl(mDNS, address);
                    for (final NetworkTopologyListener listener : this.networkListeners()) {
                        this._ListenerExecutor.submit(new Runnable(){

                            @Override
                            public void run() {
                                listener.inetAddressRemoved(jmdnsEvent);
                            }
                        });
                    }
                }
            }
        }
        catch (Exception e) {
            logger.warning("Unexpected unhandled exception: " + e);
        }
    }

    static class NetworkChecker
    extends TimerTask {
        private static Logger logger1 = Logger.getLogger(NetworkChecker.class.getName());
        private final NetworkTopologyListener _mmDNS;
        private final NetworkTopologyDiscovery _topology;
        private Set<InetAddress> _knownAddresses;

        public NetworkChecker(NetworkTopologyListener mmDNS, NetworkTopologyDiscovery topology) {
            this._mmDNS = mmDNS;
            this._topology = topology;
            this._knownAddresses = Collections.synchronizedSet(new HashSet());
        }

        public void start(Timer timer) {
            timer.schedule((TimerTask)this, 0L, 10000L);
        }

        @Override
        public void run() {
            try {
                InetAddress[] curentAddresses = this._topology.getInetAddresses();
                HashSet<InetAddress> current = new HashSet<InetAddress>(curentAddresses.length);
                for (InetAddress address : curentAddresses) {
                    current.add(address);
                    if (this._knownAddresses.contains(address)) continue;
                    NetworkTopologyEventImpl event = new NetworkTopologyEventImpl(this._mmDNS, address);
                    this._mmDNS.inetAddressAdded(event);
                }
                for (InetAddress address : this._knownAddresses) {
                    if (current.contains(address)) continue;
                    NetworkTopologyEventImpl event = new NetworkTopologyEventImpl(this._mmDNS, address);
                    this._mmDNS.inetAddressRemoved(event);
                }
                this._knownAddresses = current;
            }
            catch (Exception e) {
                logger1.warning("Unexpected unhandled exception: " + e);
            }
        }
    }
}

