/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.standard;

import java.util.Hashtable;
import org.jhotdraw.framework.DrawingEditor;
import org.jhotdraw.framework.DrawingView;
import org.jhotdraw.framework.Figure;
import org.jhotdraw.framework.FigureAttributeConstant;
import org.jhotdraw.framework.FigureEnumeration;
import org.jhotdraw.standard.AbstractCommand;
import org.jhotdraw.util.Undoable;
import org.jhotdraw.util.UndoableAdapter;

public class ChangeAttributeCommand
extends AbstractCommand {
    private FigureAttributeConstant fAttribute;
    private Object fValue;

    public ChangeAttributeCommand(String string, FigureAttributeConstant figureAttributeConstant, Object object, DrawingEditor drawingEditor) {
        super(string, drawingEditor);
        this.fAttribute = figureAttributeConstant;
        this.fValue = object;
    }

    public void execute() {
        super.execute();
        this.setUndoActivity(this.createUndoActivity());
        this.getUndoActivity().setAffectedFigures(this.view().selection());
        FigureEnumeration figureEnumeration = this.getUndoActivity().getAffectedFigures();
        while (figureEnumeration.hasNextFigure()) {
            figureEnumeration.nextFigure().setAttribute(this.fAttribute, this.fValue);
        }
        this.view().checkDamage();
    }

    public boolean isExecutableWithView() {
        return this.view().selectionCount() > 0;
    }

    protected Undoable createUndoActivity() {
        return new UndoActivity(this.view(), this.fAttribute, this.fValue);
    }

    public static class UndoActivity
    extends UndoableAdapter {
        private FigureAttributeConstant myUndoAttribute;
        private Hashtable myOriginalValues = new Hashtable();
        private Object myUndoValue;

        public UndoActivity(DrawingView drawingView, FigureAttributeConstant figureAttributeConstant, Object object) {
            super(drawingView);
            this.setAttribute(figureAttributeConstant);
            this.setBackupValue(object);
            this.setUndoable(true);
            this.setRedoable(true);
        }

        public boolean undo() {
            if (!super.undo()) {
                return false;
            }
            FigureEnumeration figureEnumeration = this.getAffectedFigures();
            while (figureEnumeration.hasNextFigure()) {
                Figure figure = figureEnumeration.nextFigure();
                if (this.getOriginalValue(figure) == null) continue;
                figure.setAttribute(this.getAttribute(), this.getOriginalValue(figure));
            }
            return true;
        }

        public boolean redo() {
            if (!this.isRedoable()) {
                return false;
            }
            FigureEnumeration figureEnumeration = this.getAffectedFigures();
            while (figureEnumeration.hasNextFigure()) {
                Figure figure = figureEnumeration.nextFigure();
                if (this.getBackupValue() == null) continue;
                figure.setAttribute(this.getAttribute(), this.getBackupValue());
            }
            return true;
        }

        protected void addOriginalValue(Figure figure, Object object) {
            this.myOriginalValues.put(figure, object);
        }

        protected Object getOriginalValue(Figure figure) {
            return this.myOriginalValues.get(figure);
        }

        protected void setAttribute(FigureAttributeConstant figureAttributeConstant) {
            this.myUndoAttribute = figureAttributeConstant;
        }

        public FigureAttributeConstant getAttribute() {
            return this.myUndoAttribute;
        }

        protected void setBackupValue(Object object) {
            this.myUndoValue = object;
        }

        public Object getBackupValue() {
            return this.myUndoValue;
        }

        public void release() {
            super.release();
            this.myOriginalValues = null;
        }

        public void setAffectedFigures(FigureEnumeration figureEnumeration) {
            super.setAffectedFigures(figureEnumeration);
            FigureEnumeration figureEnumeration2 = this.getAffectedFigures();
            while (figureEnumeration2.hasNextFigure()) {
                Figure figure = figureEnumeration2.nextFigure();
                Object object = figure.getAttribute(this.getAttribute());
                if (object == null) continue;
                this.addOriginalValue(figure, object);
            }
        }
    }
}

