/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.svg.figures;

import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jhotdraw.draw.AbstractHandle;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.HandleAttributeKeys;
import org.jhotdraw.samples.svg.SVGAttributeKeys;
import org.jhotdraw.util.ResourceBundleUtil;

public class LinkHandle
extends AbstractHandle {
    public LinkHandle(Figure figure) {
        super(figure);
    }

    @Override
    public boolean contains(Point point) {
        return false;
    }

    @Override
    public void draw(Graphics2D graphics2D) {
        Figure figure = this.getOwner();
        if (figure.get(SVGAttributeKeys.LINK) != null && figure.get(SVGAttributeKeys.LINK).trim().length() > 0) {
            graphics2D.setColor(this.getEditor().getHandleAttribute(HandleAttributeKeys.OVERFLOW_HANDLE_STROKE_COLOR));
            Rectangle rectangle = this.basicGetBounds();
            graphics2D.drawLine(rectangle.x + rectangle.width / 2 - 1, rectangle.y, rectangle.x, rectangle.y);
            graphics2D.drawLine(rectangle.x, rectangle.y, rectangle.x, rectangle.y + rectangle.height - 1);
            graphics2D.drawLine(rectangle.x, rectangle.y + rectangle.height - 1, rectangle.x + rectangle.width / 2 - 1, rectangle.y + rectangle.height - 1);
            graphics2D.drawLine(rectangle.x + rectangle.width / 3, rectangle.y + rectangle.height / 2, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height / 2);
            graphics2D.drawLine(rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height / 2, (int)((double)rectangle.x + (double)rectangle.width * 0.75 - 1.0), (int)((double)rectangle.y + (double)rectangle.height * 0.25));
            graphics2D.drawLine(rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height / 2, (int)((double)rectangle.x + (double)rectangle.width * 0.75 - 1.0), (int)((double)rectangle.y + (double)rectangle.height * 0.75));
        }
    }

    @Override
    protected Rectangle basicGetBounds() {
        Figure figure = this.getOwner();
        Rectangle2D.Double double_ = figure.getBounds();
        Point2D.Double double_2 = new Point2D.Double(double_.x + double_.width, double_.y + double_.height);
        if (figure.get(SVGAttributeKeys.TRANSFORM) != null) {
            ((AffineTransform)figure.get(SVGAttributeKeys.TRANSFORM)).transform(double_2, double_2);
        }
        Rectangle rectangle = new Rectangle(this.view.drawingToView(double_2));
        int n = this.getHandlesize();
        rectangle.x -= n * 4;
        rectangle.y -= n;
        rectangle.width = n * 2;
        rectangle.height = n;
        return rectangle;
    }

    @Override
    public void trackStart(Point point, int n) {
    }

    @Override
    public void trackStep(Point point, Point point2, int n) {
    }

    @Override
    public void trackEnd(Point point, Point point2, int n) {
    }

    @Override
    public String getToolTipText(Point point) {
        return this.getOwner().get(SVGAttributeKeys.LINK) != null ? ResourceBundleUtil.getBundle("org.jhotdraw.samples.svg.Labels").getString("handle.link.toolTipText") : null;
    }
}

