/*
 * AUTOGENERATED - DO NOT EDIT
 *
 * This file is generated from input-method-unstable-v2.xml
 * To regenerate, run the “refresh-wayland-wrapper” target.
 */

#include "input-method-unstable-v2_wrapper.h"

#include <boost/throw_exception.hpp>
#include <boost/exception/diagnostic_information.hpp>

#include <wayland-server-core.h>

#include "mir/log.h"

namespace mir
{
namespace wayland
{
extern struct wl_interface const wl_seat_interface_data;
extern struct wl_interface const wl_surface_interface_data;
extern struct wl_interface const zwp_input_method_keyboard_grab_v2_interface_data;
extern struct wl_interface const zwp_input_method_manager_v2_interface_data;
extern struct wl_interface const zwp_input_method_v2_interface_data;
extern struct wl_interface const zwp_input_popup_surface_v2_interface_data;
}
}

namespace mw = mir::wayland;

namespace
{
struct wl_interface const* all_null_types [] {
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr};
}

// InputMethodV2

struct mw::InputMethodV2::Thunks
{
    static int const supported_version;

    static void commit_string_thunk(struct wl_client* client, struct wl_resource* resource, char const* text)
    {
        try
        {
            auto me = static_cast<InputMethodV2*>(wl_resource_get_user_data(resource));
            me->commit_string(text);
        }
        catch(ProtocolError const& err)
        {
            wl_resource_post_error(err.resource(), err.code(), "%s", err.message());
        }
        catch(...)
        {
            internal_error_processing_request(client, "InputMethodV2::commit_string()");
        }
    }

    static void set_preedit_string_thunk(struct wl_client* client, struct wl_resource* resource, char const* text, int32_t cursor_begin, int32_t cursor_end)
    {
        try
        {
            auto me = static_cast<InputMethodV2*>(wl_resource_get_user_data(resource));
            me->set_preedit_string(text, cursor_begin, cursor_end);
        }
        catch(ProtocolError const& err)
        {
            wl_resource_post_error(err.resource(), err.code(), "%s", err.message());
        }
        catch(...)
        {
            internal_error_processing_request(client, "InputMethodV2::set_preedit_string()");
        }
    }

    static void delete_surrounding_text_thunk(struct wl_client* client, struct wl_resource* resource, uint32_t before_length, uint32_t after_length)
    {
        try
        {
            auto me = static_cast<InputMethodV2*>(wl_resource_get_user_data(resource));
            me->delete_surrounding_text(before_length, after_length);
        }
        catch(ProtocolError const& err)
        {
            wl_resource_post_error(err.resource(), err.code(), "%s", err.message());
        }
        catch(...)
        {
            internal_error_processing_request(client, "InputMethodV2::delete_surrounding_text()");
        }
    }

    static void commit_thunk(struct wl_client* client, struct wl_resource* resource, uint32_t serial)
    {
        try
        {
            auto me = static_cast<InputMethodV2*>(wl_resource_get_user_data(resource));
            me->commit(serial);
        }
        catch(ProtocolError const& err)
        {
            wl_resource_post_error(err.resource(), err.code(), "%s", err.message());
        }
        catch(...)
        {
            internal_error_processing_request(client, "InputMethodV2::commit()");
        }
    }

    static void get_input_popup_surface_thunk(struct wl_client* client, struct wl_resource* resource, uint32_t id, struct wl_resource* surface)
    {
        wl_resource* id_resolved{
            wl_resource_create(client, &zwp_input_popup_surface_v2_interface_data, wl_resource_get_version(resource), id)};
        if (id_resolved == nullptr)
        {
            wl_client_post_no_memory(client);
            BOOST_THROW_EXCEPTION((std::bad_alloc{}));
        }
        try
        {
            auto me = static_cast<InputMethodV2*>(wl_resource_get_user_data(resource));
            me->get_input_popup_surface(id_resolved, surface);
        }
        catch(ProtocolError const& err)
        {
            wl_resource_post_error(err.resource(), err.code(), "%s", err.message());
        }
        catch(...)
        {
            internal_error_processing_request(client, "InputMethodV2::get_input_popup_surface()");
        }
    }

    static void grab_keyboard_thunk(struct wl_client* client, struct wl_resource* resource, uint32_t keyboard)
    {
        wl_resource* keyboard_resolved{
            wl_resource_create(client, &zwp_input_method_keyboard_grab_v2_interface_data, wl_resource_get_version(resource), keyboard)};
        if (keyboard_resolved == nullptr)
        {
            wl_client_post_no_memory(client);
            BOOST_THROW_EXCEPTION((std::bad_alloc{}));
        }
        try
        {
            auto me = static_cast<InputMethodV2*>(wl_resource_get_user_data(resource));
            me->grab_keyboard(keyboard_resolved);
        }
        catch(ProtocolError const& err)
        {
            wl_resource_post_error(err.resource(), err.code(), "%s", err.message());
        }
        catch(...)
        {
            internal_error_processing_request(client, "InputMethodV2::grab_keyboard()");
        }
    }

    static void destroy_thunk(struct wl_client* client, struct wl_resource* resource)
    {
        try
        {
            wl_resource_destroy(resource);
        }
        catch(ProtocolError const& err)
        {
            wl_resource_post_error(err.resource(), err.code(), "%s", err.message());
        }
        catch(...)
        {
            internal_error_processing_request(client, "InputMethodV2::destroy()");
        }
    }

    static void resource_destroyed_thunk(wl_resource* resource)
    {
        delete static_cast<InputMethodV2*>(wl_resource_get_user_data(resource));
    }

    static struct wl_interface const* get_input_popup_surface_types[];
    static struct wl_interface const* grab_keyboard_types[];
    static struct wl_message const request_messages[];
    static struct wl_message const event_messages[];
    static void const* request_vtable[];
};

int const mw::InputMethodV2::Thunks::supported_version = 1;

mw::InputMethodV2::InputMethodV2(struct wl_resource* resource, Version<1>)
    : client{wl_resource_get_client(resource)},
      resource{resource}
{
    if (resource == nullptr)
    {
        BOOST_THROW_EXCEPTION((std::bad_alloc{}));
    }
    wl_resource_set_implementation(resource, Thunks::request_vtable, this, &Thunks::resource_destroyed_thunk);
}

mw::InputMethodV2::~InputMethodV2()
{
    wl_resource_set_implementation(resource, nullptr, nullptr, nullptr);
}

void mw::InputMethodV2::send_activate_event() const
{
    wl_resource_post_event(resource, Opcode::activate);
}

void mw::InputMethodV2::send_deactivate_event() const
{
    wl_resource_post_event(resource, Opcode::deactivate);
}

void mw::InputMethodV2::send_surrounding_text_event(std::string const& text, uint32_t cursor, uint32_t anchor) const
{
    const char* text_resolved = text.c_str();
    wl_resource_post_event(resource, Opcode::surrounding_text, text_resolved, cursor, anchor);
}

void mw::InputMethodV2::send_text_change_cause_event(uint32_t cause) const
{
    wl_resource_post_event(resource, Opcode::text_change_cause, cause);
}

void mw::InputMethodV2::send_content_type_event(uint32_t hint, uint32_t purpose) const
{
    wl_resource_post_event(resource, Opcode::content_type, hint, purpose);
}

void mw::InputMethodV2::send_done_event() const
{
    wl_resource_post_event(resource, Opcode::done);
}

void mw::InputMethodV2::send_unavailable_event() const
{
    wl_resource_post_event(resource, Opcode::unavailable);
}

bool mw::InputMethodV2::is_instance(wl_resource* resource)
{
    return wl_resource_instance_of(resource, &zwp_input_method_v2_interface_data, Thunks::request_vtable);
}

struct wl_interface const* mw::InputMethodV2::Thunks::get_input_popup_surface_types[] {
    &zwp_input_popup_surface_v2_interface_data,
    &wl_surface_interface_data};

struct wl_interface const* mw::InputMethodV2::Thunks::grab_keyboard_types[] {
    &zwp_input_method_keyboard_grab_v2_interface_data};

struct wl_message const mw::InputMethodV2::Thunks::request_messages[] {
    {"commit_string", "s", all_null_types},
    {"set_preedit_string", "sii", all_null_types},
    {"delete_surrounding_text", "uu", all_null_types},
    {"commit", "u", all_null_types},
    {"get_input_popup_surface", "no", get_input_popup_surface_types},
    {"grab_keyboard", "n", grab_keyboard_types},
    {"destroy", "", all_null_types}};

struct wl_message const mw::InputMethodV2::Thunks::event_messages[] {
    {"activate", "", all_null_types},
    {"deactivate", "", all_null_types},
    {"surrounding_text", "suu", all_null_types},
    {"text_change_cause", "u", all_null_types},
    {"content_type", "uu", all_null_types},
    {"done", "", all_null_types},
    {"unavailable", "", all_null_types}};

void const* mw::InputMethodV2::Thunks::request_vtable[] {
    (void*)Thunks::commit_string_thunk,
    (void*)Thunks::set_preedit_string_thunk,
    (void*)Thunks::delete_surrounding_text_thunk,
    (void*)Thunks::commit_thunk,
    (void*)Thunks::get_input_popup_surface_thunk,
    (void*)Thunks::grab_keyboard_thunk,
    (void*)Thunks::destroy_thunk};

mw::InputMethodV2* mw::InputMethodV2::from(struct wl_resource* resource)
{
    if (wl_resource_instance_of(resource, &zwp_input_method_v2_interface_data, InputMethodV2::Thunks::request_vtable))
    {
        return static_cast<InputMethodV2*>(wl_resource_get_user_data(resource));
    }
    return nullptr;
}

// InputPopupSurfaceV2

struct mw::InputPopupSurfaceV2::Thunks
{
    static int const supported_version;

    static void destroy_thunk(struct wl_client* client, struct wl_resource* resource)
    {
        try
        {
            wl_resource_destroy(resource);
        }
        catch(ProtocolError const& err)
        {
            wl_resource_post_error(err.resource(), err.code(), "%s", err.message());
        }
        catch(...)
        {
            internal_error_processing_request(client, "InputPopupSurfaceV2::destroy()");
        }
    }

    static void resource_destroyed_thunk(wl_resource* resource)
    {
        delete static_cast<InputPopupSurfaceV2*>(wl_resource_get_user_data(resource));
    }

    static struct wl_message const request_messages[];
    static struct wl_message const event_messages[];
    static void const* request_vtable[];
};

int const mw::InputPopupSurfaceV2::Thunks::supported_version = 1;

mw::InputPopupSurfaceV2::InputPopupSurfaceV2(struct wl_resource* resource, Version<1>)
    : client{wl_resource_get_client(resource)},
      resource{resource}
{
    if (resource == nullptr)
    {
        BOOST_THROW_EXCEPTION((std::bad_alloc{}));
    }
    wl_resource_set_implementation(resource, Thunks::request_vtable, this, &Thunks::resource_destroyed_thunk);
}

mw::InputPopupSurfaceV2::~InputPopupSurfaceV2()
{
    wl_resource_set_implementation(resource, nullptr, nullptr, nullptr);
}

void mw::InputPopupSurfaceV2::send_text_input_rectangle_event(int32_t x, int32_t y, int32_t width, int32_t height) const
{
    wl_resource_post_event(resource, Opcode::text_input_rectangle, x, y, width, height);
}

bool mw::InputPopupSurfaceV2::is_instance(wl_resource* resource)
{
    return wl_resource_instance_of(resource, &zwp_input_popup_surface_v2_interface_data, Thunks::request_vtable);
}

struct wl_message const mw::InputPopupSurfaceV2::Thunks::request_messages[] {
    {"destroy", "", all_null_types}};

struct wl_message const mw::InputPopupSurfaceV2::Thunks::event_messages[] {
    {"text_input_rectangle", "iiii", all_null_types}};

void const* mw::InputPopupSurfaceV2::Thunks::request_vtable[] {
    (void*)Thunks::destroy_thunk};

mw::InputPopupSurfaceV2* mw::InputPopupSurfaceV2::from(struct wl_resource* resource)
{
    if (wl_resource_instance_of(resource, &zwp_input_popup_surface_v2_interface_data, InputPopupSurfaceV2::Thunks::request_vtable))
    {
        return static_cast<InputPopupSurfaceV2*>(wl_resource_get_user_data(resource));
    }
    return nullptr;
}

// InputMethodKeyboardGrabV2

struct mw::InputMethodKeyboardGrabV2::Thunks
{
    static int const supported_version;

    static void release_thunk(struct wl_client* client, struct wl_resource* resource)
    {
        try
        {
            wl_resource_destroy(resource);
        }
        catch(ProtocolError const& err)
        {
            wl_resource_post_error(err.resource(), err.code(), "%s", err.message());
        }
        catch(...)
        {
            internal_error_processing_request(client, "InputMethodKeyboardGrabV2::release()");
        }
    }

    static void resource_destroyed_thunk(wl_resource* resource)
    {
        delete static_cast<InputMethodKeyboardGrabV2*>(wl_resource_get_user_data(resource));
    }

    static struct wl_message const request_messages[];
    static struct wl_message const event_messages[];
    static void const* request_vtable[];
};

int const mw::InputMethodKeyboardGrabV2::Thunks::supported_version = 1;

mw::InputMethodKeyboardGrabV2::InputMethodKeyboardGrabV2(struct wl_resource* resource, Version<1>)
    : client{wl_resource_get_client(resource)},
      resource{resource}
{
    if (resource == nullptr)
    {
        BOOST_THROW_EXCEPTION((std::bad_alloc{}));
    }
    wl_resource_set_implementation(resource, Thunks::request_vtable, this, &Thunks::resource_destroyed_thunk);
}

mw::InputMethodKeyboardGrabV2::~InputMethodKeyboardGrabV2()
{
    wl_resource_set_implementation(resource, nullptr, nullptr, nullptr);
}

void mw::InputMethodKeyboardGrabV2::send_keymap_event(uint32_t format, mir::Fd fd, uint32_t size) const
{
    int32_t fd_resolved{fd};
    wl_resource_post_event(resource, Opcode::keymap, format, fd_resolved, size);
}

void mw::InputMethodKeyboardGrabV2::send_key_event(uint32_t serial, uint32_t time, uint32_t key, uint32_t state) const
{
    wl_resource_post_event(resource, Opcode::key, serial, time, key, state);
}

void mw::InputMethodKeyboardGrabV2::send_modifiers_event(uint32_t serial, uint32_t mods_depressed, uint32_t mods_latched, uint32_t mods_locked, uint32_t group) const
{
    wl_resource_post_event(resource, Opcode::modifiers, serial, mods_depressed, mods_latched, mods_locked, group);
}

void mw::InputMethodKeyboardGrabV2::send_repeat_info_event(int32_t rate, int32_t delay) const
{
    wl_resource_post_event(resource, Opcode::repeat_info, rate, delay);
}

bool mw::InputMethodKeyboardGrabV2::is_instance(wl_resource* resource)
{
    return wl_resource_instance_of(resource, &zwp_input_method_keyboard_grab_v2_interface_data, Thunks::request_vtable);
}

struct wl_message const mw::InputMethodKeyboardGrabV2::Thunks::request_messages[] {
    {"release", "", all_null_types}};

struct wl_message const mw::InputMethodKeyboardGrabV2::Thunks::event_messages[] {
    {"keymap", "uhu", all_null_types},
    {"key", "uuuu", all_null_types},
    {"modifiers", "uuuuu", all_null_types},
    {"repeat_info", "ii", all_null_types}};

void const* mw::InputMethodKeyboardGrabV2::Thunks::request_vtable[] {
    (void*)Thunks::release_thunk};

mw::InputMethodKeyboardGrabV2* mw::InputMethodKeyboardGrabV2::from(struct wl_resource* resource)
{
    if (wl_resource_instance_of(resource, &zwp_input_method_keyboard_grab_v2_interface_data, InputMethodKeyboardGrabV2::Thunks::request_vtable))
    {
        return static_cast<InputMethodKeyboardGrabV2*>(wl_resource_get_user_data(resource));
    }
    return nullptr;
}

// InputMethodManagerV2

struct mw::InputMethodManagerV2::Thunks
{
    static int const supported_version;

    static void get_input_method_thunk(struct wl_client* client, struct wl_resource* resource, struct wl_resource* seat, uint32_t input_method)
    {
        wl_resource* input_method_resolved{
            wl_resource_create(client, &zwp_input_method_v2_interface_data, wl_resource_get_version(resource), input_method)};
        if (input_method_resolved == nullptr)
        {
            wl_client_post_no_memory(client);
            BOOST_THROW_EXCEPTION((std::bad_alloc{}));
        }
        try
        {
            auto me = static_cast<InputMethodManagerV2*>(wl_resource_get_user_data(resource));
            me->get_input_method(seat, input_method_resolved);
        }
        catch(ProtocolError const& err)
        {
            wl_resource_post_error(err.resource(), err.code(), "%s", err.message());
        }
        catch(...)
        {
            internal_error_processing_request(client, "InputMethodManagerV2::get_input_method()");
        }
    }

    static void destroy_thunk(struct wl_client* client, struct wl_resource* resource)
    {
        try
        {
            wl_resource_destroy(resource);
        }
        catch(ProtocolError const& err)
        {
            wl_resource_post_error(err.resource(), err.code(), "%s", err.message());
        }
        catch(...)
        {
            internal_error_processing_request(client, "InputMethodManagerV2::destroy()");
        }
    }

    static void resource_destroyed_thunk(wl_resource* resource)
    {
        delete static_cast<InputMethodManagerV2*>(wl_resource_get_user_data(resource));
    }

    static void bind_thunk(struct wl_client* client, void* data, uint32_t version, uint32_t id)
    {
        auto me = static_cast<InputMethodManagerV2::Global*>(data);
        auto resource = wl_resource_create(
            client,
            &zwp_input_method_manager_v2_interface_data,
            std::min((int)version, Thunks::supported_version),
            id);
        if (resource == nullptr)
        {
            wl_client_post_no_memory(client);
            BOOST_THROW_EXCEPTION((std::bad_alloc{}));
        }
        try
        {
            me->bind(resource);
        }
        catch(...)
        {
            internal_error_processing_request(client, "InputMethodManagerV2 global bind");
        }
    }

    static struct wl_interface const* get_input_method_types[];
    static struct wl_message const request_messages[];
    static void const* request_vtable[];
};

int const mw::InputMethodManagerV2::Thunks::supported_version = 1;

mw::InputMethodManagerV2::InputMethodManagerV2(struct wl_resource* resource, Version<1>)
    : client{wl_resource_get_client(resource)},
      resource{resource}
{
    if (resource == nullptr)
    {
        BOOST_THROW_EXCEPTION((std::bad_alloc{}));
    }
    wl_resource_set_implementation(resource, Thunks::request_vtable, this, &Thunks::resource_destroyed_thunk);
}

mw::InputMethodManagerV2::~InputMethodManagerV2()
{
    wl_resource_set_implementation(resource, nullptr, nullptr, nullptr);
}

bool mw::InputMethodManagerV2::is_instance(wl_resource* resource)
{
    return wl_resource_instance_of(resource, &zwp_input_method_manager_v2_interface_data, Thunks::request_vtable);
}

mw::InputMethodManagerV2::Global::Global(wl_display* display, Version<1>)
    : wayland::Global{
          wl_global_create(
              display,
              &zwp_input_method_manager_v2_interface_data,
              Thunks::supported_version,
              this,
              &Thunks::bind_thunk)}
{
}

auto mw::InputMethodManagerV2::Global::interface_name() const -> char const*
{
    return InputMethodManagerV2::interface_name;
}

struct wl_interface const* mw::InputMethodManagerV2::Thunks::get_input_method_types[] {
    &wl_seat_interface_data,
    &zwp_input_method_v2_interface_data};

struct wl_message const mw::InputMethodManagerV2::Thunks::request_messages[] {
    {"get_input_method", "on", get_input_method_types},
    {"destroy", "", all_null_types}};

void const* mw::InputMethodManagerV2::Thunks::request_vtable[] {
    (void*)Thunks::get_input_method_thunk,
    (void*)Thunks::destroy_thunk};

mw::InputMethodManagerV2* mw::InputMethodManagerV2::from(struct wl_resource* resource)
{
    if (wl_resource_instance_of(resource, &zwp_input_method_manager_v2_interface_data, InputMethodManagerV2::Thunks::request_vtable))
    {
        return static_cast<InputMethodManagerV2*>(wl_resource_get_user_data(resource));
    }
    return nullptr;
}

namespace mir
{
namespace wayland
{

struct wl_interface const zwp_input_method_v2_interface_data {
    mw::InputMethodV2::interface_name,
    mw::InputMethodV2::Thunks::supported_version,
    7, mw::InputMethodV2::Thunks::request_messages,
    7, mw::InputMethodV2::Thunks::event_messages};

struct wl_interface const zwp_input_popup_surface_v2_interface_data {
    mw::InputPopupSurfaceV2::interface_name,
    mw::InputPopupSurfaceV2::Thunks::supported_version,
    1, mw::InputPopupSurfaceV2::Thunks::request_messages,
    1, mw::InputPopupSurfaceV2::Thunks::event_messages};

struct wl_interface const zwp_input_method_keyboard_grab_v2_interface_data {
    mw::InputMethodKeyboardGrabV2::interface_name,
    mw::InputMethodKeyboardGrabV2::Thunks::supported_version,
    1, mw::InputMethodKeyboardGrabV2::Thunks::request_messages,
    4, mw::InputMethodKeyboardGrabV2::Thunks::event_messages};

struct wl_interface const zwp_input_method_manager_v2_interface_data {
    mw::InputMethodManagerV2::interface_name,
    mw::InputMethodManagerV2::Thunks::supported_version,
    2, mw::InputMethodManagerV2::Thunks::request_messages,
    0, nullptr};

}
}
