/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * unity-webapps-window-tracker.h
 * Copyright (C) Canonical LTD 2011
 * 
 * Author: Robert Carr <racarr@canonical.com>
 * 
unity-webapps is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * unity-webapps is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.";
 */


#ifndef __UNITY_WEBAPPS_WINDOW_TRACKER_H
#define __UNITY_WEBAPPS_WINDOW_TRACKER_H


#define UNITY_WEBAPPS_TYPE_WINDOW_TRACKER              (unity_webapps_window_tracker_get_type())
#define UNITY_WEBAPPS_WINDOW_TRACKER(obj)              (G_TYPE_CHECK_INSTANCE_CAST((obj), UNITY_WEBAPPS_TYPE_WINDOW_TRACKER, UnityWebappsWindowTracker))
#define UNITY_WEBAPPS_WINDOW_TRACKER_CLASS(klass)      (G_TYPE_CHECK_CLASS_CAST((klass), UNITY_WEBAPPS_TYPE_WINDOW_TRACKER, UnityWebappsWindowTrackerClass))
#define UNITY_WEBAPPS_IS_WINDOW_TRACKER(obj)           (G_TYPE_CHECK_INSTANCE_TYPE((obj), UNITY_WEBAPPS_TYPE_WINDOW_TRACKER))
#define UNITY_WEBAPPS_IS_WINDOW_TRACKER_CLASS(klass)   (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_WEBAPPS_TYPE_WINDOW_TRACKER))
#define UNITY_WEBAPPS_WINDOW_TRACKER_GET_CLASS(obj)    (G_TYPE_INSTANCE_GET_CLASS((obj), UNITY_WEBAPPS_TYPE_WINDOW_TRACKER, UnityWebappsWindowTrackerClass))

typedef struct _UnityWebappsWindowTrackerPrivate UnityWebappsWindowTrackerPrivate;

typedef struct _UnityWebappsWindowTracker UnityWebappsWindowTracker;


struct _UnityWebappsWindowTracker {
	GObject object;
	
	
};

typedef struct _UnityWebappsWindowTrackerClass UnityWebappsWindowTrackerClass;

struct _UnityWebappsWindowTrackerClass
{
	GObjectClass parent_class;
	
	guint64 (*get_active_window_id) (UnityWebappsWindowTracker *self);
};

GType unity_webapps_window_tracker_get_type (void) G_GNUC_CONST;

UnityWebappsWindowTracker *unity_webapps_window_tracker_new ();
UnityWebappsWindowTracker *unity_webapps_window_tracker_get_default ();

#if defined(ENABLE_TESTS)
UnityWebappsWindowTracker *unity_webapps_window_tracker_get_dbus_controllable (GDBusConnection *connection);
#endif

guint64 unity_webapps_window_tracker_get_active_window_id (UnityWebappsWindowTracker *tracker);



#endif
