/*
 * Decompiled with CFR 0.152.
 */
package org.iso_relax.verifier.jaxp.validation;

import javax.xml.validation.TypeInfoProvider;
import javax.xml.validation.ValidatorHandler;
import org.iso_relax.verifier.Verifier;
import org.iso_relax.verifier.VerifierHandler;
import org.iso_relax.verifier.impl.ForkContentHandler;
import org.iso_relax.verifier.jaxp.validation.EntityResolverImpl;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

class ValidatorHandlerImpl
extends ValidatorHandler {
    private final Verifier verifier;
    private final VerifierHandler verifierHandler;
    private ContentHandler receiver;
    private ContentHandler userHandler;
    private ErrorHandler errorHandler;
    private LSResourceResolver resourceResolver;

    ValidatorHandlerImpl(Verifier verifier) throws SAXException {
        this.verifier = verifier;
        this.verifierHandler = verifier.getVerifierHandler();
    }

    public void setContentHandler(ContentHandler userHandler) {
        this.userHandler = userHandler;
        this.receiver = userHandler == null ? this.verifierHandler : new ForkContentHandler(this.verifierHandler, userHandler);
    }

    public ContentHandler getContentHandler() {
        return this.userHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.verifier.setErrorHandler(errorHandler);
        this.errorHandler = errorHandler;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setResourceResolver(LSResourceResolver resourceResolver) {
        this.verifier.setEntityResolver(new EntityResolverImpl(resourceResolver));
        this.resourceResolver = resourceResolver;
    }

    public LSResourceResolver getResourceResolver() {
        return this.resourceResolver;
    }

    public TypeInfoProvider getTypeInfoProvider() {
        return null;
    }

    public void setDocumentLocator(Locator locator) {
        this.receiver.setDocumentLocator(locator);
    }

    public void startDocument() throws SAXException {
        this.receiver.startDocument();
    }

    public void endDocument() throws SAXException {
        this.receiver.endDocument();
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.receiver.startPrefixMapping(prefix, uri);
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        this.receiver.endPrefixMapping(prefix);
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        this.receiver.startElement(uri, localName, qName, atts);
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.receiver.endElement(uri, localName, qName);
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.receiver.characters(ch, start, length);
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.receiver.ignorableWhitespace(ch, start, length);
    }

    public void processingInstruction(String target, String data) throws SAXException {
        this.receiver.processingInstruction(target, data);
    }

    public void skippedEntity(String name) throws SAXException {
        this.receiver.skippedEntity(name);
    }
}

