/*
 * Decompiled with CFR 0.152.
 */
package org.xmlopen.zipspy;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.xmlopen.zipspy.Utils;
import org.xmlopen.zipspy.ZipCentralRecord;
import org.xmlopen.zipspy.ZipLocalHeader;

public class ZipArchive {
    static Logger logger = Logger.getLogger(ZipArchive.class);
    public static final int ZIP_LOCAL_SIGNATURE = 67324752;
    public static final int ZIP_DATA_SIGNATURE = 134695760;
    public static final int ZIP_CENTRAL_SIGNATURE = 33639248;
    public static final int ZIP_CENTRAL_END_SIGNATURE = 101010256;
    private ArrayList<ZipLocalHeader> localHeaders = new ArrayList();
    private ArrayList<ZipCentralRecord> centralRecords = new ArrayList();
    boolean usesDataDescriptors;
    private InputStream is;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZipArchive(URL url) {
        try {
            URLConnection conn = url.openConnection();
            conn.connect();
            this.is = conn.getInputStream();
            this.process();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            Utils.streamClose(this.is);
        }
    }

    public ZipArchive(InputStream is) {
        this.is = is;
        this.process();
    }

    private void process() {
        try {
            int sig = -1;
            do {
                if ((sig = this.skipData(this.is)) == 67324752) {
                    logger.debug("Reading local header");
                    ZipLocalHeader zlh = new ZipLocalHeader(this.is);
                    this.localHeaders.add(zlh);
                    logger.debug("Read header for entry: " + zlh.getFilename());
                    if (this.usesDataDescriptors || (zlh.general & 8) == 0) continue;
                    this.usesDataDescriptors = true;
                    logger.info("Archive uses data descriptors");
                    continue;
                }
                if (sig == 33639248) {
                    logger.debug("Reading central directory header");
                    ZipCentralRecord zcr = new ZipCentralRecord(this.is);
                    this.centralRecords.add(zcr);
                    logger.debug("Read central record for entry: " + zcr.getFilename());
                    continue;
                }
                if (sig == 134695760) {
                    this.usesDataDescriptors = true;
                    continue;
                }
                if (sig != 101010256) continue;
                logger.debug("Central dir end");
            } while (sig != -1);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public ZipLocalHeader getLocalHeader(int n) {
        return this.localHeaders.get(n);
    }

    public ZipCentralRecord getCentralRecord(int n) {
        return this.centralRecords.get(n);
    }

    public int getLocalHeaderCount() {
        return this.localHeaders.size();
    }

    public int getCentralRecordCount() {
        return this.centralRecords.size();
    }

    public String asXmlString() {
        int i;
        logger.debug("Creating XML representation of ZIP");
        StringBuffer sb = new StringBuffer();
        sb.append("<?xml version='1.0' standalone='yes'?><zip-archive><local-headers>");
        for (i = 0; i < this.localHeaders.size(); ++i) {
            sb.append(this.getLocalHeader(i).asXmlString());
        }
        sb.append("</local-headers><central-directory>");
        for (i = 0; i < this.centralRecords.size(); ++i) {
            sb.append(this.getCentralRecord(i).asXmlString());
        }
        sb.append("</central-directory></zip-archive>");
        return sb.toString();
    }

    public boolean usesDataDescriptors() {
        return this.usesDataDescriptors;
    }

    private int skipData(InputStream is) throws IOException {
        byte[] tmp = new byte[4];
        is.read(tmp);
        boolean bFound = false;
        boolean bEOS = false;
        int sig = -1;
        byte[] b = new byte[1];
        do {
            int value;
            boolean bl = bFound = (value = Utils.readIntLittle(tmp)) == 33639248 || value == 134695760 || value == 67324752 || value == 101010256;
            if (bFound) {
                sig = value;
                continue;
            }
            bEOS = is.read(b) < 0;
            byte[] shift = new byte[4];
            System.arraycopy(tmp, 1, shift, 0, 3);
            shift[3] = b[0];
            tmp = shift;
        } while (!bEOS && !bFound);
        return sig;
    }
}

